/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.xodus;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import net.ripe.rpki.validator3.storage.Bytes;
import net.ripe.rpki.validator3.storage.IxBase;
import net.ripe.rpki.validator3.storage.IxMap;
import net.ripe.rpki.validator3.storage.OnDeleteRestrictException;
import net.ripe.rpki.validator3.storage.Tx;
import net.ripe.rpki.validator3.storage.data.Key;
import net.ripe.rpki.validator3.storage.encoding.Coder;
import net.ripe.rpki.validator3.storage.xodus.Xodus;
import net.ripe.rpki.validator3.storage.xodus.XodusIxBase;
import net.ripe.rpki.validator3.storage.xodus.XodusIxMap;
import org.apache.commons.lang3.tuple.Pair;

/*
 * Exception performing whole class analysis ignored.
 */
public class XodusIxMap<T extends Serializable>
extends XodusIxBase<T>
implements IxMap<T> {
    private final Map<String, Store> indexes;
    private final Map<String, Function<T, Set<Key>>> indexFunctions;
    private final List<BiConsumer<Tx.Write, Key>> onDeleteTriggers = new ArrayList();

    public XodusIxMap(Xodus xodus, String name, Coder<T> coder, Map<String, Function<T, Set<Key>>> indexFunctions) {
        super(xodus, name, coder);
        this.indexFunctions = indexFunctions;
        Pair p = xodus.createIndexes(name, indexFunctions, StoreConfig.WITH_DUPLICATES_WITH_PREFIXING);
        this.indexes = (Map)p.getLeft();
        boolean reindex = (Boolean)p.getRight();
        if (reindex) {
            this.reindex();
        }
    }

    private void reindex() {
        this.env.executeInExclusiveTransaction(txn -> {
            this.indexes.forEach((name, idx) -> this.env.truncateStore(idx.getName(), txn));
            try (Cursor ci = this.getMainDb().openCursor(txn);){
                while (ci.getNext()) {
                    ByteIterable pk = ci.getKey();
                    Serializable value = this.getValue(new Key(pk), Bytes.toBytes((ByteIterable)ci.getValue()));
                    this.indexFunctions.forEach((n, idxFun) -> {
                        Store idx = this.getIdx(n);
                        ((Set)idxFun.apply(value)).forEach(ik -> idx.put(txn, ik.toByteIterable(), pk));
                    });
                }
            }
        });
    }

    private Store getIdx(String name) {
        this.checkEnv();
        return (Store)this.indexes.get(name);
    }

    private void dropIndexes(Tx.Write tx) {
        this.indexes.forEach((name, db) -> XodusIxMap.truncate((Tx.Write)tx, (Store)db));
    }

    protected StoreConfig getStoreConfig() {
        return StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING;
    }

    public Optional<T> get(Key primaryKey) {
        return this.get(this.readTx(), primaryKey);
    }

    public Optional<T> get(Tx.Read tx, Key primaryKey) {
        this.verifyKey(primaryKey);
        ByteIterable bi = this.getMainDb().get(XodusIxMap.castTxn((Tx.Read)tx), primaryKey.toByteIterable());
        if (bi == null) {
            return Optional.empty();
        }
        return Optional.of(this.getValue(primaryKey, Bytes.toBytes((ByteIterable)bi)));
    }

    public List<T> get(Tx.Read txn, Set<Key> primaryKeys) {
        return primaryKeys.stream().map(pk -> this.get(txn, pk)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public Optional<T> put(Tx.Write tx, Key primaryKey, T value) {
        this.checkKeyAndValue(primaryKey, value);
        Transaction txn = XodusIxMap.castTxn((Tx.Read)tx);
        ByteIterable pkBuf = primaryKey.toByteIterable();
        ByteIterable newVal = this.valueWithChecksum(value);
        ByteIterable oldVal = this.getMainDb().get(txn, pkBuf);
        if (newVal.equals(oldVal)) {
            return Optional.of(value);
        }
        this.getMainDb().put(txn, pkBuf, newVal);
        if (oldVal != null) {
            Serializable oldValue = this.getValue(primaryKey, Bytes.toBytes((ByteIterable)oldVal));
            this.indexFunctions.forEach((idxName, idxFun) -> {
                Set oldIndexKeys = (Set)idxFun.apply(oldValue);
                Set indexKeys = ((Set)idxFun.apply(value)).stream().filter(Objects::nonNull).collect(Collectors.toSet());
                Store index = this.getIdx(idxName);
                oldIndexKeys.stream().filter(oik -> !indexKeys.contains(oik)).forEach(oik -> {
                    try (Cursor c = index.openCursor(txn);){
                        if (c.getSearchBoth(oik.toByteIterable(), pkBuf)) {
                            c.deleteCurrent();
                        }
                    }
                });
                indexKeys.stream().filter(ik -> !oldIndexKeys.contains(ik)).forEach(ik -> index.put(txn, ik.toByteIterable(), pkBuf));
            });
            return Optional.of(oldValue);
        }
        this.indexFunctions.forEach((idxName, idxFun) -> {
            Set<Key> indexKeys = ((Set)idxFun.apply(value)).stream().filter(Objects::nonNull).collect(Collectors.toSet());
            indexKeys.forEach(ik -> this.getIdx(idxName).put(txn, ik.toByteIterable(), pkBuf));
        });
        return Optional.empty();
    }

    public boolean modify(Tx.Write tx, Key primaryKey, Consumer<T> modifyValue) {
        Optional t = this.get((Tx.Read)tx, primaryKey);
        t.ifPresent(v -> {
            modifyValue.accept(v);
            this.put(tx, primaryKey, v);
        });
        return t.isPresent();
    }

    public void delete(Tx.Write tx, Key primaryKey) {
        XodusIxMap.checkNotNull((Object)primaryKey, (String)"Key is null");
        Transaction txn = XodusIxMap.castTxn((Tx.Read)tx);
        Store mainDb = this.getMainDb();
        ByteIterable pkBuf = primaryKey.toByteIterable();
        if (this.indexFunctions.isEmpty()) {
            mainDb.delete(txn, pkBuf);
        } else {
            ByteIterable bb = mainDb.get(txn, pkBuf);
            if (bb != null) {
                Serializable value = this.getValue(primaryKey, Bytes.toBytes((ByteIterable)bb));
                mainDb.delete(txn, pkBuf);
                this.indexFunctions.forEach((idxName, idxFun) -> ((Set)idxFun.apply(value)).forEach(ix -> {
                    try (Cursor c = this.getIdx(idxName).openCursor(txn);){
                        if (c.getSearchBoth(ix.toByteIterable(), pkBuf)) {
                            c.deleteCurrent();
                        }
                    }
                }));
            }
        }
        try {
            this.onDeleteTriggers.forEach(bf -> bf.accept(tx, primaryKey));
        }
        catch (OnDeleteRestrictException o) {
            tx.abort();
        }
    }

    public Map<Key, T> getByIndex(String indexName, Tx.Read tx, Key indexKey) {
        return this.values(tx, this.getPkByIndex(indexName, tx, indexKey));
    }

    public Map<Key, T> values(Tx.Read tx, Set<Key> pks) {
        HashMap m = new HashMap();
        pks.forEach(pk -> this.get(tx, pk).ifPresent(v -> m.put(pk, v)));
        return m;
    }

    public Set<Key> getPkByIndex(String indexName, Tx.Read tx, Key indexKey) {
        XodusIxMap.checkNotNull((Object)indexKey, (String)"Index key is null");
        ByteIterable idxKey = indexKey.toByteIterable();
        return this.getPkByIndexKeyRange(indexName, tx, idxKey, idxKey);
    }

    public Map<Key, T> getByIndexLessThan(String indexName, Tx.Read tx, Key indexKey) {
        return this.values(tx, this.getPkByIndexLessThan(indexName, tx, indexKey));
    }

    public Map<Key, T> getByIndexNotLessThan(String indexName, Tx.Read tx, Key indexKey) {
        return this.values(tx, this.getPkByIndexGreaterThan(indexName, tx, indexKey));
    }

    public Set<Key> getPkByIndexLessThan(String indexName, Tx.Read tx, Key indexKey) {
        XodusIxMap.checkNotNull((Object)indexKey, (String)"Index key is null");
        ByteIterable idxKey = indexKey.toByteIterable();
        return this.getPkByIndexKeyRange(indexName, tx, null, idxKey);
    }

    public Set<Key> getPkByIndexGreaterThan(String indexName, Tx.Read tx, Key indexKey) {
        XodusIxMap.checkNotNull((Object)indexKey, (String)"Index key is null");
        ByteIterable idxKey = indexKey.toByteIterable();
        return this.getPkByIndexKeyRange(indexName, tx, idxKey, null);
    }

    public Map<Key, T> getByIdxDescendingWhere(String indexName, Tx.Read tx, Predicate<T> p) {
        return this.getOrderedMapWhere(indexName, tx, false, p);
    }

    public Map<Key, T> getByIdxAscendingWhere(String indexName, Tx.Read tx, Predicate<T> p) {
        return this.getOrderedMapWhere(indexName, tx, true, p);
    }

    private Map<Key, T> getOrderedMapWhere(String indexName, Tx.Read tx, boolean ascending, Predicate<T> predicate) {
        Function<Cursor, Boolean> getStart = c -> ascending ? c.getNext() : c.getLast();
        Function<Cursor, Boolean> getNextValue = c -> ascending ? c.getNextDup() : c.getPrevDup();
        Function<Cursor, Boolean> getNextIndex = c -> ascending ? c.getNext() : c.getPrev();
        Store index = this.getIdx(indexName);
        HashMap<Key, Serializable> m = new HashMap<Key, Serializable>();
        if (index != null) {
            Store mainDb = this.getMainDb();
            Transaction txn = XodusIxMap.castTxn((Tx.Read)tx);
            try (Cursor cursor = index.openCursor(txn);){
                boolean hasNextIndexKey = getStart.apply(cursor);
                boolean foundResult = false;
                while (hasNextIndexKey) {
                    Serializable value;
                    ByteIterable pk = cursor.getValue();
                    ByteIterable bi = mainDb.get(txn, pk);
                    if (bi != null && predicate.test(value = this.toValue(bi))) {
                        foundResult = true;
                        m.put(new Key(pk), value);
                    }
                    if (foundResult) {
                        hasNextIndexKey = getNextValue.apply(cursor);
                        continue;
                    }
                    hasNextIndexKey = getNextIndex.apply(cursor);
                }
            }
        }
        return m;
    }

    public void onDelete(BiConsumer<Tx.Write, Key> bf) {
        this.onDeleteTriggers.add(bf);
    }

    public void clear(Tx.Write tx) {
        XodusIxMap.truncate((Tx.Write)tx, (Store)this.getMainDb());
        this.dropIndexes(tx);
    }

    public T toValue(byte[] bb) {
        return (T)this.getValue(null, bb);
    }

    private Set<Key> getPkByIndexKeyRange(String indexName, Tx.Read tx, ByteIterable start, ByteIterable stop) {
        Store index = this.getIdx(indexName);
        if (index == null) {
            return Collections.emptySet();
        }
        Transaction txn = XodusIxMap.castTxn((Tx.Read)tx);
        HashSet<Key> pks = new HashSet<Key>();
        try (Cursor cursor = index.openCursor(txn);){
            ByteIterable startKey;
            if (start == null) {
                if (stop == null) {
                    while (cursor.getNext()) {
                        pks.add(new Key(cursor.getValue()));
                    }
                } else {
                    while (cursor.getNext() && cursor.getKey().compareTo((Object)stop) < 0) {
                        pks.add(new Key(cursor.getValue()));
                    }
                }
            } else if (stop == null) {
                startKey = cursor.getSearchKeyRange(start);
                if (startKey != null) {
                    pks.add(new Key(cursor.getValue()));
                    while (cursor.getNext()) {
                        pks.add(new Key(cursor.getValue()));
                    }
                }
            } else if (start.equals(stop)) {
                startKey = cursor.getSearchKey(start);
                if (startKey != null) {
                    pks.add(new Key(cursor.getValue()));
                    while (cursor.getNextDup()) {
                        pks.add(new Key(cursor.getValue()));
                    }
                }
            } else {
                startKey = cursor.getSearchKeyRange(start);
                if (startKey != null) {
                    pks.add(new Key(cursor.getValue()));
                    while (cursor.getNext() && cursor.getKey().compareTo((Object)stop) < 0) {
                        pks.add(new Key(cursor.getValue()));
                    }
                }
            }
        }
        return pks;
    }

    public IxBase.Sizes sizeInfo(Tx.Read tx) {
        IxBase.Sizes sizes = super.sizeInfo(tx);
        HashMap indexSizes = new HashMap();
        this.indexes.forEach((name, ignore) -> {
            Store idx = this.getIdx(name);
            AtomicInteger count = new AtomicInteger();
            AtomicInteger size = new AtomicInteger();
            indexSizes.put(name, new IxBase.Sizes(count.get(), (long)size.get()));
        });
        return new Sizes(sizes.getCount(), sizes.getKeysAndValuesBytes(), indexSizes);
    }
}

