/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.stores.impl;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.ripe.rpki.validator3.api.trustanchors.TaStatus;
import net.ripe.rpki.validator3.api.util.Dates;
import net.ripe.rpki.validator3.api.util.InstantWithoutNanos;
import net.ripe.rpki.validator3.storage.IxMap;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.Tx;
import net.ripe.rpki.validator3.storage.data.Key;
import net.ripe.rpki.validator3.storage.data.TrustAnchor;
import net.ripe.rpki.validator3.storage.data.validation.ValidationCheck;
import net.ripe.rpki.validator3.storage.data.validation.ValidationRun;
import net.ripe.rpki.validator3.storage.stores.GenericStoreImpl;
import net.ripe.rpki.validator3.storage.stores.TrustAnchors;
import net.ripe.rpki.validator3.storage.stores.ValidationRuns;
import net.ripe.rpki.validator3.storage.stores.impl.SequencesStore;
import net.ripe.rpki.validator3.util.Time;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class TrustAnchorStore
extends GenericStoreImpl<TrustAnchor>
implements TrustAnchors {
    private final IxMap<TrustAnchor> ixMap;
    private final SequencesStore sequences;
    private final ValidationRuns validationRuns;

    @Autowired
    public TrustAnchorStore(Storage storage, SequencesStore sequences, @Lazy ValidationRuns validationRuns) {
        this.ixMap = storage.createIxMap("trust-anchors", (Map)ImmutableMap.of(), TrustAnchor.class);
        this.sequences = sequences;
        this.validationRuns = validationRuns;
    }

    public TrustAnchor add(Tx.Write tx, TrustAnchor trustAnchor) {
        trustAnchor.setId(Key.of((long)this.sequences.next(tx, "trust-anchors:pk")));
        this.ixMap.put(tx, trustAnchor.key(), (Serializable)trustAnchor);
        return trustAnchor;
    }

    public void update(Tx.Write tx, TrustAnchor trustAnchor) {
        trustAnchor.setUpdatedAt(InstantWithoutNanos.now());
        this.ixMap.put(tx, trustAnchor.key(), (Serializable)trustAnchor);
    }

    public void remove(Tx.Write tx, TrustAnchor trustAnchor) {
        this.ixMap.delete(tx, trustAnchor.key());
    }

    public Optional<TrustAnchor> get(Tx.Read tx, Key id) {
        return this.ixMap.get(tx, id);
    }

    public List<TrustAnchor> findAll(Tx.Read tx) {
        return this.ixMap.values(tx);
    }

    public Collection<TrustAnchor> findByName(Tx.Read tx, String name) {
        return this.findAll(tx).stream().filter(ta -> ta.getName().equals(name)).collect(Collectors.toList());
    }

    public Optional<TrustAnchor> findBySubjectPublicKeyInfo(Tx.Read tx, String subjectPublicKeyInfo) {
        return this.findAll(tx).stream().filter(ta -> ta.getSubjectPublicKeyInfo().equals(subjectPublicKeyInfo)).findFirst();
    }

    public boolean allInitialCertificateTreeValidationRunsCompleted(Tx.Read tx) {
        return this.findAll(tx).stream().allMatch(TrustAnchor::isInitialCertificateTreeValidationRunCompleted);
    }

    public List<TaStatus> getStatuses(Tx.Read tx) {
        return this.findAll(tx).stream().map(ta -> this.validationRuns.findLatestCompletedCaTreeValidationRun(tx, ta).map(vr -> {
            Pair objectCount = Time.timed(() -> this.validationRuns.getObjectCount(tx, (ValidationRun)vr));
            int warnings = vr.countChecks(ValidationCheck.Status.WARNING);
            int errors = vr.countChecks(ValidationCheck.Status.ERROR);
            return TaStatus.of((String)String.valueOf(ta.key().asLong()), (String)ta.getName(), (int)errors, (int)warnings, (int)((Integer)objectCount.getLeft()), (String)(vr.getCompletedAt() == null ? null : Dates.formatUTC((TemporalAccessor)vr.getCompletedAt())), (String)(vr.getEarliestObjectExpiration() == null ? null : Dates.formatUTC((TemporalAccessor)vr.getEarliestObjectExpiration())), (boolean)ta.isInitialCertificateTreeValidationRunCompleted());
        }).orElse(TaStatus.of((String)String.valueOf(ta.key().asLong()), (String)ta.getName(), (int)0, (int)1, (int)0, null, null, (boolean)false))).sorted(Comparator.comparing(ta -> ta.getTaName().toLowerCase())).collect(Collectors.toList());
    }

    protected IxMap<TrustAnchor> ixMap() {
        return this.ixMap;
    }
}

