/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.config;

import net.ripe.rpki.commons.validation.ValidationOptions;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(value="rpki.validator")
public class ValidationConfig {
    private boolean strictValidation;
    private boolean earlyWarningValidation = false;
    private boolean rsyncOnly;

    public ValidationOptions validationOptions() {
        if (this.earlyWarningValidation) {
            return ValidationOptions.paranoidTestValidations();
        }
        if (this.strictValidation) {
            return ValidationOptions.strictValidation();
        }
        return ValidationOptions.backCompatibleRipeNccValidator();
    }

    public boolean isStrictValidation() {
        return this.strictValidation;
    }

    public void setStrictValidation(boolean strictValidation) {
        this.strictValidation = strictValidation;
    }

    public boolean isEarlyWarningValidation() {
        return this.earlyWarningValidation;
    }

    public void setEarlyWarningValidation(boolean earlyWarningValidation) {
        this.earlyWarningValidation = earlyWarningValidation;
    }

    public boolean isRsyncOnly() {
        return this.rsyncOnly;
    }

    public void setRsyncOnly(boolean rsyncOnly) {
        this.rsyncOnly = rsyncOnly;
    }
}

