/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.bgp;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import net.ripe.ipresource.IpAddress;
import net.ripe.ipresource.IpRange;
import net.ripe.ipresource.IpResourceType;
import net.ripe.ipresource.Ipv4Address;
import net.ripe.ipresource.Ipv6Address;

/*
 * Exception performing whole class analysis ignored.
 */
public class PackedIpRange {
    private byte[] content;

    public PackedIpRange(IpRange ipRange) {
        if (ipRange.getType() == IpResourceType.IPv4) {
            long start = ipRange.getStart().getValue().longValue();
            long end = ipRange.getEnd().getValue().longValue();
            this.content = new byte[8];
            PackedIpRange.toBytes((long)start, (int)0, (byte[])this.content);
            PackedIpRange.toBytes((long)end, (int)4, (byte[])this.content);
        } else if (ipRange.getType() == IpResourceType.IPv6) {
            byte[] end;
            byte[] start = ipRange.getStart().getValue().toByteArray();
            int wholeLen = start.length + (end = ipRange.getEnd().getValue().toByteArray()).length + 2;
            if (wholeLen == 8) {
                ++wholeLen;
            }
            this.content = ByteBuffer.allocate(wholeLen).put((byte)start.length).put(start).put((byte)end.length).put(end).array();
        } else {
            throw new IllegalArgumentException("Asn is not supported here");
        }
    }

    IpRange toIpRange() {
        return PackedIpRange.of((byte[])this.content);
    }

    public static IpRange of(byte[] content) {
        if (content.length == 8) {
            long s = PackedIpRange.fromBytes((byte[])content, (int)0);
            long e = PackedIpRange.fromBytes((byte[])content, (int)4);
            return IpRange.range((IpAddress)new Ipv4Address(s), (IpAddress)new Ipv4Address(e));
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(content);
        byte sLen = byteBuffer.get();
        byte[] tmp = new byte[sLen];
        byteBuffer.get(tmp, 0, sLen);
        BigInteger start = new BigInteger(tmp);
        byte eLen = byteBuffer.get();
        tmp = new byte[eLen];
        byteBuffer.get(tmp, 0, eLen);
        BigInteger end = new BigInteger(tmp);
        return IpRange.range((IpAddress)new Ipv6Address(start), (IpAddress)new Ipv6Address(end));
    }

    private static long fromBytes(byte[] b, int offset) {
        long s = 0L;
        for (int i = 0; i < 3; i = (int)((short)(i + 1))) {
            s |= (long)(b[i + offset] & 0xFF);
            s <<= 8;
        }
        return s |= (long)(b[3 + offset] & 0xFF);
    }

    private static void toBytes(long s, int offset, byte[] b) {
        b[offset] = (byte)(s >>> 24);
        b[offset + 1] = (byte)(s >>> 16);
        b[offset + 2] = (byte)(s >>> 8);
        b[offset + 3] = (byte)s;
    }

    public byte[] getContent() {
        return this.content;
    }
}

