/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.encoding.custom.validation;

import java.util.Collection;
import java.util.Map;
import net.ripe.rpki.validator3.storage.data.Base;
import net.ripe.rpki.validator3.storage.data.validation.ValidationRun;
import net.ripe.rpki.validator3.storage.encoding.custom.BaseCoder;
import net.ripe.rpki.validator3.storage.encoding.custom.Coders;
import net.ripe.rpki.validator3.storage.encoding.custom.Encoded;
import net.ripe.rpki.validator3.storage.encoding.custom.Tags;
import net.ripe.rpki.validator3.storage.encoding.custom.validation.ValidationCheckCoder;

public class ValidationRunCoder {
    private static final short COMPLETED_AT_TAG = Tags.unique((int)121);
    private static final short VALIDATION_CHECKS_TAG = Tags.unique((int)122);
    private static final short STATUS_TAG = Tags.unique((int)123);
    private static final ValidationCheckCoder vcCoder = new ValidationCheckCoder();

    public static void toBytes(ValidationRun validationRun, Encoded encoded) {
        BaseCoder.toBytes((Base)validationRun, (Encoded)encoded);
        encoded.appendNotNull(STATUS_TAG, (Object)validationRun.getStatus(), s -> Coders.toBytes((String)s.name()));
        encoded.appendNotNull(COMPLETED_AT_TAG, (Object)validationRun.getCompletedAt(), Coders::toBytes);
        if (validationRun.getValidationChecks() != null && !validationRun.getValidationChecks().isEmpty()) {
            encoded.append(VALIDATION_CHECKS_TAG, Coders.toBytes((Collection)validationRun.getValidationChecks(), arg_0 -> ((ValidationCheckCoder)vcCoder).toBytes(arg_0)));
        }
    }

    public static void fromBytes(Map<Short, byte[]> content, ValidationRun validationRun) {
        BaseCoder.fromBytes(content, (Base)validationRun);
        Encoded.field(content, (short)STATUS_TAG).ifPresent(b -> validationRun.setStatus(Coders.toString((byte[])b)));
        Encoded.field(content, (short)COMPLETED_AT_TAG).ifPresent(b -> validationRun.setCompletedAt(Coders.toInstant((byte[])b)));
        Encoded.field(content, (short)VALIDATION_CHECKS_TAG).ifPresent(b -> validationRun.setValidationChecks(Coders.fromBytes((byte[])b, arg_0 -> ((ValidationCheckCoder)vcCoder).fromBytes(arg_0))));
    }
}

