/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.domain.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import net.ripe.rpki.validator3.domain.metrics.HttpClientMetricsService;
import net.ripe.rpki.validator3.util.HttpStreaming;
import org.jooq.lambda.tuple.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HttpClientMetricsService {
    private static final Logger log = LoggerFactory.getLogger(HttpClientMetricsService.class);
    public static final int HISTOGRAM_HOURS = 6;
    @Autowired
    private MeterRegistry registry;
    private ConcurrentHashMap<Tuple2<String, String>, HttpStatusMetric> httpMetrics = new ConcurrentHashMap();

    public void update(URI uri, String statusDescription, long durationMs) {
        if (uri == null || statusDescription == null) {
            log.info("null url or statusdescription provided to HttpClientMetricsService, uri: '{}', status: '{}', durationMs: {}", new Object[]{uri, statusDescription, durationMs});
            return;
        }
        String rootURL = uri.resolve("/").toASCIIString();
        this.httpMetrics.computeIfAbsent(new Tuple2((Object)rootURL, (Object)statusDescription), key -> new HttpStatusMetric(this.registry, rootURL, statusDescription)).update(durationMs);
    }

    public void update(String uri, String statusDescription, long durationMs) {
        if (uri == null) {
            log.info("null uri provided to HttpClientMetricsService with statusDescription: '{}', durationMs: {}", (Object)statusDescription, (Object)durationMs);
            return;
        }
        this.update(URI.create(uri), statusDescription, durationMs);
    }

    public static String unwrapExceptionString(Throwable cause) {
        if (cause == null) {
            return "null";
        }
        if (cause instanceof HttpStreaming.HttpStatusException) {
            return String.valueOf(((HttpStreaming.HttpStatusException)cause).getCode());
        }
        if (cause instanceof HttpStreaming.HttpFailureException) {
            Throwable rootCause = cause.getCause();
            if (rootCause != null) {
                if (rootCause instanceof EOFException) {
                    return "eof";
                }
                if (rootCause instanceof TimeoutException) {
                    return "timeout";
                }
                if (rootCause instanceof SocketTimeoutException) {
                    return "connect_timeout";
                }
                if (rootCause instanceof IOException && rootCause.getMessage() != null && rootCause.getMessage().contains("Could not connect")) {
                    return "could_not_connect";
                }
                return rootCause.toString();
            }
            return "null";
        }
        return cause.getClass().getName();
    }
}

