/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.config;

import com.fasterxml.classmate.TypeResolver;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.ripe.rpki.validator3.api.InternalApiCall;
import net.ripe.rpki.validator3.api.PublicApiCall;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.hateoas.Links;
import springfox.bean.validators.configuration.BeanValidatorPluginsConfiguration;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.AlternateTypeRule;
import springfox.documentation.schema.AlternateTypeRules;
import springfox.documentation.schema.WildcardType;
import springfox.documentation.service.Tag;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
@Import(value={BeanValidatorPluginsConfiguration.class})
public class SwaggerConfig {
    private Docket docketBuilder() {
        TypeResolver typeResolver = new TypeResolver();
        return new Docket(DocumentationType.SWAGGER_2).alternateTypeRules(new AlternateTypeRule[]{AlternateTypeRules.newRule((Type)typeResolver.resolve(Optional.class, new Type[]{URI.class}), String.class, (int)-2147482648)}).alternateTypeRules(new AlternateTypeRule[]{AlternateTypeRules.newRule((Type)typeResolver.resolve(Stream.class, new Type[]{WildcardType.class}), (Type)typeResolver.resolve(List.class, new Type[]{WildcardType.class}), (int)-2147482646)}).directModelSubstitute(URI.class, String.class).directModelSubstitute(Links.class, Object.class).genericModelSubstitutes(new Class[]{Optional.class});
    }

    @Bean
    public Docket mainApi() {
        return this.docketBuilder().tags(new Tag("BGP preview", "Previews the likely RPKI validity of BGP announcements"), new Tag[]{new Tag("Ignore filters", "Ignore filters (filters that exclude ROAs)"), new Tag("Input validation", "Validate that objects are valid inputs"), new Tag("RPKI repositories", "RPKI repositories"), new Tag("RPKI objects", "All valid RPKI objects"), new Tag("SLURM", "Simplified Local Internet Number Resource Management with the RPKI"), new Tag("Trust Anchors", "Trust Anchors"), new Tag("Validated objects", "Validated objects (rpki-rtr-server API)"), new Tag("Validation runs", "Validation runs"), new Tag("VRP export", "Validated ROA Payload export"), new Tag("Whitelist", "Whitelist entries")}).groupName("Public APIs").select().apis(RequestHandlerSelectors.withClassAnnotation(PublicApiCall.class)).paths(PathSelectors.any()).build();
    }

    @Bean
    public Docket internalApi() {
        return this.docketBuilder().groupName("Status and health check APIs").select().apis(RequestHandlerSelectors.withClassAnnotation(InternalApiCall.class)).paths(PathSelectors.any()).build();
    }
}

