/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.stores.impl;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import net.ripe.rpki.validator3.storage.IxMap;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.Tx;
import net.ripe.rpki.validator3.storage.data.Key;
import net.ripe.rpki.validator3.storage.encoding.Coder;
import net.ripe.rpki.validator3.storage.stores.GenericStoreImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SequencesStore
extends GenericStoreImpl<Long> {
    private final String SEQUENCES = "sequences";
    private final IxMap<Long> ixMap;

    @Autowired
    public SequencesStore(Storage storage) {
        this.ixMap = storage.createIxMap("sequences", (Map)ImmutableMap.of(), (Coder)new /* Unavailable Anonymous Inner Class!! */);
    }

    public long next(Tx.Write tx, String name) {
        Key key = Key.of((String)name);
        Optional seqValue = this.ixMap.get((Tx.Read)tx, key);
        if (seqValue.isPresent()) {
            long nextValue = (Long)seqValue.get() + 1L;
            this.ixMap.put(tx, key, (Serializable)Long.valueOf(nextValue));
            return nextValue;
        }
        this.ixMap.put(tx, key, (Serializable)Long.valueOf(1L));
        return 1L;
    }

    protected IxMap<Long> ixMap() {
        return this.ixMap;
    }
}

