/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.background;

import com.google.common.base.Preconditions;
import java.time.Duration;
import net.ripe.rpki.validator3.background.RrdpRepositoryValidationJob;
import net.ripe.rpki.validator3.background.Throttled;
import net.ripe.rpki.validator3.background.TrustAnchorValidationJob;
import net.ripe.rpki.validator3.domain.validation.CertificateTreeValidationService;
import net.ripe.rpki.validator3.storage.data.RpkiRepository;
import net.ripe.rpki.validator3.storage.data.TrustAnchor;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Component;

@Component
public class ValidationScheduler {
    private static final Logger log = LoggerFactory.getLogger(ValidationScheduler.class);
    private final Scheduler scheduler;
    private final Duration rsyncRepositoryDownloadInterval;
    private final Duration rrpdRepositoryDownloadInterval;
    private final Throttled<String> throttledTreeValidation;
    private boolean enabled = true;
    private final CertificateTreeValidationService validationService;

    @Autowired
    public ValidationScheduler(Scheduler scheduler, @Value(value="${rpki.validator.rsync.repository.download.interval:PT10M}") String rsyncRepositoryDownloadInterval, @Value(value="${rpki.validator.rrdp.repository.download.interval:PT2M}") String rrpdRepositoryDownloadInterval, @Lazy CertificateTreeValidationService validationService) {
        this.scheduler = scheduler;
        this.rsyncRepositoryDownloadInterval = Duration.parse(rsyncRepositoryDownloadInterval);
        this.rrpdRepositoryDownloadInterval = Duration.parse(rrpdRepositoryDownloadInterval);
        this.validationService = validationService;
        long minIntervalBetweenTreeValidationsInSeconds = Math.max(60L, Math.min(this.rsyncRepositoryDownloadInterval.getSeconds(), this.rrpdRepositoryDownloadInterval.getSeconds()));
        this.throttledTreeValidation = new Throttled(minIntervalBetweenTreeValidationsInSeconds);
    }

    public void addTrustAnchor(TrustAnchor trustAnchor) {
        if (!this.enabled) {
            return;
        }
        Preconditions.checkArgument((trustAnchor.key().asLong() >= 1L ? 1 : 0) != 0, (String)"trustAnchor id %s is not valid", (Object)trustAnchor.key());
        try {
            this.scheduler.scheduleJob(TrustAnchorValidationJob.buildJob((TrustAnchor)trustAnchor), TriggerBuilder.newTrigger().startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatSecondlyForever((int)((int)this.rsyncRepositoryDownloadInterval.getSeconds()))).build());
        }
        catch (SchedulerException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean scheduledTrustAnchor(TrustAnchor trustAnchor) {
        if (!this.enabled) {
            return false;
        }
        try {
            return this.scheduler.checkExists(TrustAnchorValidationJob.getJobKey((TrustAnchor)trustAnchor));
        }
        catch (SchedulerException e) {
            return false;
        }
    }

    public synchronized void addRrdpRpkiRepository(RpkiRepository rpkiRepository) {
        if (!this.enabled) {
            return;
        }
        Preconditions.checkArgument((rpkiRepository.getType() == RpkiRepository.Type.RRDP ? 1 : 0) != 0);
        Preconditions.checkArgument((rpkiRepository.key().asLong() >= 1L ? 1 : 0) != 0, (String)"rpkiRepository id %s is not valid", (Object)rpkiRepository.key());
        try {
            if (!this.scheduler.checkExists(RrdpRepositoryValidationJob.getJobKey((RpkiRepository)rpkiRepository))) {
                log.info("Adding repository to the scheduler {}", (Object)rpkiRepository);
                this.scheduler.scheduleJob(RrdpRepositoryValidationJob.buildJob((RpkiRepository)rpkiRepository), TriggerBuilder.newTrigger().startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatSecondlyForever((int)((int)this.rrpdRepositoryDownloadInterval.getSeconds()))).build());
            }
        }
        catch (SchedulerException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void removeRpkiRepository(RpkiRepository repository) {
        if (!this.enabled) {
            return;
        }
        try {
            boolean jobDeleted = this.scheduler.deleteJob(RrdpRepositoryValidationJob.getJobKey((RpkiRepository)repository));
            if (!jobDeleted) {
                throw new EmptyResultDataAccessException("validation job for RPKI repository not found", 1);
            }
        }
        catch (SchedulerException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void triggerCertificateTreeValidation(TrustAnchor trustAnchor) {
        if (!this.enabled) {
            return;
        }
        this.throttledTreeValidation.trigger((Object)trustAnchor.getName(), () -> {
            log.debug("Re-validating the CA tree for TA {}", (Object)trustAnchor.getName());
            this.validationService.validate(trustAnchor.getId().asLong());
        });
    }

    public void disable() {
        this.enabled = false;
    }

    public Duration getRsyncRepositoryDownloadInterval() {
        return this.rsyncRepositoryDownloadInterval;
    }

    public Duration getRrpdRepositoryDownloadInterval() {
        return this.rrpdRepositoryDownloadInterval;
    }
}

