/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.domain.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import java.io.EOFException;
import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import net.ripe.rpki.validator3.domain.metrics.HttpClientMetricsService;
import net.ripe.rpki.validator3.util.Http;
import org.jooq.lambda.tuple.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HttpClientMetricsService {
    private static final Logger log = LoggerFactory.getLogger(HttpClientMetricsService.class);
    @Autowired
    private MeterRegistry registry;
    private ConcurrentHashMap<Tuple2<String, String>, HttpStatusMetric> httpMetrics = new ConcurrentHashMap();

    public void update(String uri, String statusDescription, long durationMs) {
        String relativeURL = URI.create(uri).resolve("/").toString();
        this.httpMetrics.computeIfAbsent(new Tuple2((Object)relativeURL, (Object)statusDescription), key -> new HttpStatusMetric(this.registry, relativeURL, statusDescription)).update(durationMs);
    }

    public static String unwrapExceptionString(Throwable cause) {
        if (cause instanceof Http.Failure) {
            Throwable rootCause = cause.getCause();
            if (rootCause instanceof EOFException) {
                return rootCause.getClass().getName();
            }
            return rootCause.toString();
        }
        if (cause instanceof Http.HttpStatusException) {
            return String.valueOf(((Http.HttpStatusException)cause).getCode());
        }
        return "exception";
    }
}

