/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.encoding.custom;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class Encoded {
    private final Map<Short, byte[]> content = new HashMap();

    public void append(short fieldTag, byte[] bytes) {
        if (bytes != null) {
            this.content.put(fieldTag, bytes);
        }
    }

    public <T> void appendNotNull(short fieldTag, T value, Function<T, byte[]> f) {
        if (value != null) {
            this.content.put(fieldTag, f.apply(value));
        }
    }

    public void appendNotNull(short fieldTag, byte[] bytes) {
        if (bytes != null) {
            this.content.put(fieldTag, bytes);
        }
    }

    public byte[] toByteArray() {
        int totalSize = 4 + this.content.values().stream().map(b -> 6 + ((byte[])b).length).reduce(0, Integer::sum);
        byte[] array = new byte[totalSize];
        ByteBuffer bb = ByteBuffer.wrap(array);
        int entryCount = this.content.size();
        bb.putInt(entryCount);
        int currentOffset = 4 + entryCount * 6;
        byte[][] bbytes = new byte[entryCount][];
        int i = 0;
        for (Map.Entry e : this.content.entrySet()) {
            byte[] bytes = (byte[])e.getValue();
            bb.putShort((Short)e.getKey());
            bb.putInt(currentOffset);
            currentOffset += bytes.length;
            bbytes[i++] = bytes;
        }
        for (int k = 0; k < entryCount; ++k) {
            bb.put(bbytes[k]);
        }
        return array;
    }

    public static Encoded fromByteArray(byte[] array) {
        ByteBuffer bb = ByteBuffer.wrap(array);
        int entryCount = bb.getInt();
        Encoded encoded = new Encoded();
        if (entryCount != 0) {
            int i;
            short[] tags = new short[entryCount];
            int[] offsets = new int[entryCount];
            for (i = 0; i < entryCount; ++i) {
                tags[i] = bb.getShort();
                offsets[i] = bb.getInt();
            }
            for (i = 0; i < entryCount - 1; ++i) {
                byte[] bytes = new byte[offsets[i + 1] - offsets[i]];
                bb.get(bytes);
                encoded.append(tags[i], bytes);
            }
            byte[] bytes = new byte[bb.remaining()];
            bb.get(bytes);
            encoded.append(tags[entryCount - 1], bytes);
        }
        return encoded;
    }

    public static Optional<byte[]> field(Map<Short, byte[]> c, short tag) {
        return Optional.ofNullable(c.get(tag));
    }

    public Map<Short, byte[]> getContent() {
        return this.content;
    }

    public String toString() {
        return "Encoded(content=" + this.getContent() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Encoded)) {
            return false;
        }
        Encoded other = (Encoded)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Map this$content = this.getContent();
        Map other$content = other.getContent();
        return !(this$content == null ? other$content != null : !((Object)this$content).equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Encoded;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        return result;
    }
}

