/*
 * =======================================================================================
 *
 *      Filename:  perfmon_skylakeX_counters.h
 *
 *      Description:  Counter Header File of perfmon module for Intel Skylake X.
 *
 *      Version:   5.4.0
 *      Released:  15.11.2024
 *
 *      Author:   Jan Treibig (jt), jan.treibig@gmail.com
 *                Thomas Gruber (tr), thomas.roehl@googlemail.com
 *      Project:  likwid
 *
 *      Copyright (C) 2024 RRZE, University Erlangen-Nuremberg
 *
 *      This program is free software: you can redistribute it and/or modify it under
 *      the terms of the GNU General Public License as published by the Free Software
 *      Foundation, either version 3 of the License, or (at your option) any later
 *      version.
 *
 *      This program is distributed in the hope that it will be useful, but WITHOUT ANY
 *      WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 *      PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License along with
 *      this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * =======================================================================================
 */

#define NUM_COUNTERS_SKYLAKEX 337
#define NUM_COUNTERS_CORE_SKYLAKEX 13
#define NUM_COUNTERS_UNCORE_SKYLAKEX 324

#define SKX_VALID_OPTIONS_FIXED EVENT_OPTION_ANYTHREAD_MASK|EVENT_OPTION_COUNT_KERNEL_MASK
#define SKX_VALID_OPTIONS_PMC EVENT_OPTION_EDGE_MASK|EVENT_OPTION_COUNT_KERNEL_MASK| \
            EVENT_OPTION_INVERT_MASK|EVENT_OPTION_ANYTHREAD_MASK| \
            EVENT_OPTION_IN_TRANS_MASK|EVENT_OPTION_THRESHOLD_MASK
#define SKX_VALID_OPTIONS_CBOX EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|\
            EVENT_OPTION_THRESHOLD_MASK|EVENT_OPTION_TID_MASK| \
            EVENT_OPTION_MATCH0_MASK|EVENT_OPTION_MATCH1_MASK| \
            EVENT_OPTION_OPCODE_MASK|EVENT_OPTION_STATE_MASK
#define SKX_VALID_OPTIONS_UBOX EVENT_OPTION_THRESHOLD_MASK|EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK
#define SKX_VALID_OPTIONS_MBOX EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|EVENT_OPTION_THRESHOLD_MASK
#define SKX_VALID_OPTIONS_WBOX EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|EVENT_OPTION_THRESHOLD_MASK|EVENT_OPTION_OCCUPANCY_MASK|EVENT_OPTION_OCCUPANCY_FILTER_MASK|EVENT_OPTION_OCCUPANCY_EDGE_MASK|EVENT_OPTION_OCCUPANCY_INVERT_MASK
#define SKX_VALID_OPTIONS_BBOX EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|EVENT_OPTION_THRESHOLD_MASK
#define SKX_VALID_OPTIONS_RBOX EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|EVENT_OPTION_THRESHOLD_MASK
#define SKX_VALID_OPTIONS_IBOX EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|EVENT_OPTION_THRESHOLD_MASK|EVENT_OPTION_MASK0_MASK|EVENT_OPTION_MASK1_MASK
#define SKX_VALID_OPTIONS_IRP EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|EVENT_OPTION_THRESHOLD_MASK
#define SKX_VALID_OPTIONS_SBOX EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|EVENT_OPTION_THRESHOLD_MASK|EVENT_OPTION_MATCH0_MASK|EVENT_OPTION_MATCH1_MASK|EVENT_OPTION_MASK0_MASK|EVENT_OPTION_MASK1_MASK|EVENT_OPTION_OPCODE_MASK


/* SKX CHA */
#define SKX_CHA_MSR_PMON_BOX_FILTER_TID		(0x1ffULL << 0)
#define SKX_CHA_MSR_PMON_BOX_FILTER_LINK	(0xfULL << 9)
#define SKX_CHA_MSR_PMON_BOX_FILTER_STATE	(0x3ffULL << 17)
#define SKX_CHA_MSR_PMON_BOX_FILTER_REM		(0x1ULL << 32)
#define SKX_CHA_MSR_PMON_BOX_FILTER_LOC		(0x1ULL << 33)
#define SKX_CHA_MSR_PMON_BOX_FILTER_ALL_OPC	(0x1ULL << 35)
#define SKX_CHA_MSR_PMON_BOX_FILTER_NM		(0x1ULL << 36)
#define SKX_CHA_MSR_PMON_BOX_FILTER_NOT_NM	(0x1ULL << 37)
#define SKX_CHA_MSR_PMON_BOX_FILTER_OPC0	(0x3ffULL << 41)
#define SKX_CHA_MSR_PMON_BOX_FILTER_OPC1	(0x3ffULL << 51)
#define SKX_CHA_MSR_PMON_BOX_FILTER_C6		(0x1ULL << 61)
#define SKX_CHA_MSR_PMON_BOX_FILTER_NC		(0x1ULL << 62)
#define SKX_CHA_MSR_PMON_BOX_FILTER_ISOC	(0x1ULL << 63)

#define SKX_PMON_CTL_TRESH_MASK		(0xff << 24)
#define SKX_PMON_CTL_TRESH_MASK_EXT	(0xf)
#define SKX_PMON_CTL_CH_MASK		(0xff << 4)
#define SKX_PMON_CTL_FC_MASK	(0x7 << 12)

#define SKX_PMON_CTL_UMASK_EXT		0xff


static RegisterMap skylakeX_counter_map[NUM_COUNTERS_SKYLAKEX] = {
    /* Fixed Counters: instructions retired, cycles unhalted core */
    {"FIXC0", PMC0, FIXED, MSR_PERF_FIXED_CTR_CTRL, MSR_PERF_FIXED_CTR0, 0, 0, SKX_VALID_OPTIONS_FIXED},
    {"FIXC1", PMC1, FIXED, MSR_PERF_FIXED_CTR_CTRL, MSR_PERF_FIXED_CTR1, 0, 0, SKX_VALID_OPTIONS_FIXED},
    {"FIXC2", PMC2, FIXED, MSR_PERF_FIXED_CTR_CTRL, MSR_PERF_FIXED_CTR2, 0, 0, SKX_VALID_OPTIONS_FIXED},
    /* PMC Counters: 4 48bit wide */
    {"PMC0", PMC3, PMC, MSR_PERFEVTSEL0, MSR_PMC0, 0, 0, SKX_VALID_OPTIONS_PMC},
    {"PMC1", PMC4, PMC, MSR_PERFEVTSEL1, MSR_PMC1, 0, 0, SKX_VALID_OPTIONS_PMC},
    {"PMC2", PMC5, PMC, MSR_PERFEVTSEL2, MSR_PMC2, 0, 0, SKX_VALID_OPTIONS_PMC|EVENT_OPTION_IN_TRANS_ABORT_MASK},
    {"PMC3", PMC6, PMC, MSR_PERFEVTSEL3, MSR_PMC3, 0, 0, SKX_VALID_OPTIONS_PMC},
    /* Additional PMC Counters if HyperThreading is not active: 4 48bit wide */
    {"PMC4", PMC7, PMC, MSR_PERFEVTSEL4, MSR_PMC4, 0, 0, SKX_VALID_OPTIONS_PMC},
    {"PMC5", PMC8, PMC, MSR_PERFEVTSEL5, MSR_PMC5, 0, 0, SKX_VALID_OPTIONS_PMC},
    {"PMC6", PMC9, PMC, MSR_PERFEVTSEL6, MSR_PMC6, 0, 0, SKX_VALID_OPTIONS_PMC|EVENT_OPTION_IN_TRANS_ABORT_MASK},
    {"PMC7", PMC10, PMC, MSR_PERFEVTSEL7, MSR_PMC7, 0, 0, SKX_VALID_OPTIONS_PMC},
    /* Temperature Sensor*/
    {"TMP0", PMC11, THERMAL, 0, IA32_THERM_STATUS, 0, 0, EVENT_OPTION_NONE_MASK},
    /* Vcore Status*/
    {"VTG0", PMC12, VOLTAGE, 0, MSR_PERF_STATUS, 0, 0, EVENT_OPTION_NONE_MASK},
    /* RAPL counters */
    {"PWR0", PMC13, POWER, 0, MSR_PKG_ENERGY_STATUS, 0, 0, EVENT_OPTION_NONE_MASK},
    {"PWR1", PMC14, POWER, 0, MSR_PP0_ENERGY_STATUS, 0, 0, EVENT_OPTION_NONE_MASK},
    {"PWR2", PMC15, POWER, 0, MSR_PP1_ENERGY_STATUS,  0, 0, EVENT_OPTION_NONE_MASK},
    {"PWR3", PMC16, POWER, 0, MSR_DRAM_ENERGY_STATUS,  0, 0, EVENT_OPTION_NONE_MASK},
    //{"PWR4", PMC16, POWER, 0, MSR_PLATFORM_ENERGY_STATUS,  0, 0, EVENT_OPTION_NONE_MASK},
    /* Uncore */
    {"UBOX0", PMC17, UBOX, MSR_UNC_V3_U_PMON_CTL0, MSR_UNC_V3_U_PMON_CTR0,  0, 0, SKX_VALID_OPTIONS_UBOX},
    {"UBOX1", PMC18, UBOX, MSR_UNC_V3_U_PMON_CTL1, MSR_UNC_V3_U_PMON_CTR1,  0, 0, SKX_VALID_OPTIONS_UBOX},
    {"UBOXFIX", PMC19, UBOXFIX, MSR_UNC_V3_U_UCLK_FIXED_CTL, MSR_UNC_V3_U_UCLK_FIXED_CTR, 0, 0, EVENT_OPTION_NONE_MASK},
    {"CBOX0C0", PMC20, CBOX0, MSR_UNC_V3_C0_PMON_CTL0, MSR_UNC_V3_C0_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX0C1", PMC21, CBOX0, MSR_UNC_V3_C0_PMON_CTL1, MSR_UNC_V3_C0_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX0C2", PMC22, CBOX0, MSR_UNC_V3_C0_PMON_CTL2, MSR_UNC_V3_C0_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX0C3", PMC23, CBOX0, MSR_UNC_V3_C0_PMON_CTL3, MSR_UNC_V3_C0_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX1C0", PMC24, CBOX1, MSR_UNC_V3_C1_PMON_CTL0, MSR_UNC_V3_C1_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX1C1", PMC25, CBOX1, MSR_UNC_V3_C1_PMON_CTL1, MSR_UNC_V3_C1_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX1C2", PMC26, CBOX1, MSR_UNC_V3_C1_PMON_CTL2, MSR_UNC_V3_C1_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX1C3", PMC27, CBOX1, MSR_UNC_V3_C1_PMON_CTL3, MSR_UNC_V3_C1_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX2C0", PMC28, CBOX2, MSR_UNC_V3_C2_PMON_CTL0, MSR_UNC_V3_C2_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX2C1", PMC29, CBOX2, MSR_UNC_V3_C2_PMON_CTL1, MSR_UNC_V3_C2_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX2C2", PMC30, CBOX2, MSR_UNC_V3_C2_PMON_CTL2, MSR_UNC_V3_C2_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX2C3", PMC31, CBOX2, MSR_UNC_V3_C2_PMON_CTL3, MSR_UNC_V3_C2_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX3C0", PMC32, CBOX3, MSR_UNC_V3_C3_PMON_CTL0, MSR_UNC_V3_C3_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX3C1", PMC33, CBOX3, MSR_UNC_V3_C3_PMON_CTL1, MSR_UNC_V3_C3_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX3C2", PMC34, CBOX3, MSR_UNC_V3_C3_PMON_CTL2, MSR_UNC_V3_C3_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX3C3", PMC35, CBOX3, MSR_UNC_V3_C3_PMON_CTL3, MSR_UNC_V3_C3_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX4C0", PMC36, CBOX4, MSR_UNC_V3_C4_PMON_CTL0, MSR_UNC_V3_C4_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX4C1", PMC37, CBOX4, MSR_UNC_V3_C4_PMON_CTL1, MSR_UNC_V3_C4_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX4C2", PMC38, CBOX4, MSR_UNC_V3_C4_PMON_CTL2, MSR_UNC_V3_C4_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX4C3", PMC39, CBOX4, MSR_UNC_V3_C4_PMON_CTL3, MSR_UNC_V3_C4_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX5C0", PMC40, CBOX5, MSR_UNC_V3_C5_PMON_CTL0, MSR_UNC_V3_C5_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX5C1", PMC41, CBOX5, MSR_UNC_V3_C5_PMON_CTL1, MSR_UNC_V3_C5_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX5C2", PMC42, CBOX5, MSR_UNC_V3_C5_PMON_CTL2, MSR_UNC_V3_C5_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX5C3", PMC43, CBOX5, MSR_UNC_V3_C5_PMON_CTL3, MSR_UNC_V3_C5_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX6C0", PMC44, CBOX6, MSR_UNC_V3_C6_PMON_CTL0, MSR_UNC_V3_C6_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX6C1", PMC45, CBOX6, MSR_UNC_V3_C6_PMON_CTL1, MSR_UNC_V3_C6_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX6C2", PMC46, CBOX6, MSR_UNC_V3_C6_PMON_CTL2, MSR_UNC_V3_C6_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX6C3", PMC47, CBOX6, MSR_UNC_V3_C6_PMON_CTL3, MSR_UNC_V3_C6_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX7C0", PMC48, CBOX7, MSR_UNC_V3_C7_PMON_CTL0, MSR_UNC_V3_C7_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX7C1", PMC49, CBOX7, MSR_UNC_V3_C7_PMON_CTL1, MSR_UNC_V3_C7_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX7C2", PMC50, CBOX7, MSR_UNC_V3_C7_PMON_CTL2, MSR_UNC_V3_C7_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX7C3", PMC51, CBOX7, MSR_UNC_V3_C7_PMON_CTL3, MSR_UNC_V3_C7_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX8C0", PMC52, CBOX8, MSR_UNC_V3_C8_PMON_CTL0, MSR_UNC_V3_C8_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX8C1", PMC53, CBOX8, MSR_UNC_V3_C8_PMON_CTL1, MSR_UNC_V3_C8_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX8C2", PMC54, CBOX8, MSR_UNC_V3_C8_PMON_CTL2, MSR_UNC_V3_C8_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX8C3", PMC55, CBOX8, MSR_UNC_V3_C8_PMON_CTL3, MSR_UNC_V3_C8_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX9C0", PMC56, CBOX9, MSR_UNC_V3_C9_PMON_CTL0, MSR_UNC_V3_C9_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX9C1", PMC57, CBOX9, MSR_UNC_V3_C9_PMON_CTL1, MSR_UNC_V3_C9_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX9C2", PMC58, CBOX9, MSR_UNC_V3_C9_PMON_CTL2, MSR_UNC_V3_C9_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX9C3", PMC59, CBOX9, MSR_UNC_V3_C9_PMON_CTL3, MSR_UNC_V3_C9_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX10C0", PMC60, CBOX10, MSR_UNC_V3_C10_PMON_CTL0, MSR_UNC_V3_C10_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX10C1", PMC61, CBOX10, MSR_UNC_V3_C10_PMON_CTL1, MSR_UNC_V3_C10_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX10C2", PMC62, CBOX10, MSR_UNC_V3_C10_PMON_CTL2, MSR_UNC_V3_C10_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX10C3", PMC63, CBOX10, MSR_UNC_V3_C10_PMON_CTL3, MSR_UNC_V3_C10_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX11C0", PMC64, CBOX11, MSR_UNC_V3_C11_PMON_CTL0, MSR_UNC_V3_C11_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX11C1", PMC65, CBOX11, MSR_UNC_V3_C11_PMON_CTL1, MSR_UNC_V3_C11_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX11C2", PMC66, CBOX11, MSR_UNC_V3_C11_PMON_CTL2, MSR_UNC_V3_C11_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX11C3", PMC67, CBOX11, MSR_UNC_V3_C11_PMON_CTL3, MSR_UNC_V3_C11_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX12C0", PMC68, CBOX12, MSR_UNC_V3_C12_PMON_CTL0, MSR_UNC_V3_C12_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX12C1", PMC69, CBOX12, MSR_UNC_V3_C12_PMON_CTL1, MSR_UNC_V3_C12_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX12C2", PMC70, CBOX12, MSR_UNC_V3_C12_PMON_CTL2, MSR_UNC_V3_C12_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX12C3", PMC71, CBOX12, MSR_UNC_V3_C12_PMON_CTL3, MSR_UNC_V3_C12_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX13C0", PMC72, CBOX13, MSR_UNC_V3_C13_PMON_CTL0, MSR_UNC_V3_C13_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX13C1", PMC73, CBOX13, MSR_UNC_V3_C13_PMON_CTL1, MSR_UNC_V3_C13_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX13C2", PMC74, CBOX13, MSR_UNC_V3_C13_PMON_CTL2, MSR_UNC_V3_C13_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX13C3", PMC75, CBOX13, MSR_UNC_V3_C13_PMON_CTL3, MSR_UNC_V3_C13_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX14C0", PMC76, CBOX14, MSR_UNC_V3_C14_PMON_CTL0, MSR_UNC_V3_C14_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX14C1", PMC77, CBOX14, MSR_UNC_V3_C14_PMON_CTL1, MSR_UNC_V3_C14_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX14C2", PMC78, CBOX14, MSR_UNC_V3_C14_PMON_CTL2, MSR_UNC_V3_C14_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX14C3", PMC79, CBOX14, MSR_UNC_V3_C14_PMON_CTL3, MSR_UNC_V3_C14_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX15C0", PMC80, CBOX15, MSR_UNC_V3_C15_PMON_CTL0, MSR_UNC_V3_C15_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX15C1", PMC81, CBOX15, MSR_UNC_V3_C15_PMON_CTL1, MSR_UNC_V3_C15_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX15C2", PMC82, CBOX15, MSR_UNC_V3_C15_PMON_CTL2, MSR_UNC_V3_C15_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX15C3", PMC83, CBOX15, MSR_UNC_V3_C15_PMON_CTL3, MSR_UNC_V3_C15_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX16C0", PMC84, CBOX16, MSR_UNC_V3_C16_PMON_CTL0, MSR_UNC_V3_C16_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX16C1", PMC85, CBOX16, MSR_UNC_V3_C16_PMON_CTL1, MSR_UNC_V3_C16_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX16C2", PMC86, CBOX16, MSR_UNC_V3_C16_PMON_CTL2, MSR_UNC_V3_C16_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX16C3", PMC87, CBOX16, MSR_UNC_V3_C16_PMON_CTL3, MSR_UNC_V3_C16_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX17C0", PMC88, CBOX17, MSR_UNC_V3_C17_PMON_CTL0, MSR_UNC_V3_C17_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX17C1", PMC89, CBOX17, MSR_UNC_V3_C17_PMON_CTL1, MSR_UNC_V3_C17_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX17C2", PMC90, CBOX17, MSR_UNC_V3_C17_PMON_CTL2, MSR_UNC_V3_C17_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX17C3", PMC91, CBOX17, MSR_UNC_V3_C17_PMON_CTL3, MSR_UNC_V3_C17_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX18C0", PMC92, CBOX18, MSR_UNC_V3_C18_PMON_CTL0, MSR_UNC_V3_C18_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX18C1", PMC93, CBOX18, MSR_UNC_V3_C18_PMON_CTL1, MSR_UNC_V3_C18_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX18C2", PMC94, CBOX18, MSR_UNC_V3_C18_PMON_CTL2, MSR_UNC_V3_C18_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX18C3", PMC95, CBOX18, MSR_UNC_V3_C18_PMON_CTL3, MSR_UNC_V3_C18_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX19C0", PMC96, CBOX19, MSR_UNC_V3_C19_PMON_CTL0, MSR_UNC_V3_C19_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX19C1", PMC97, CBOX19, MSR_UNC_V3_C19_PMON_CTL1, MSR_UNC_V3_C19_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX19C2", PMC98, CBOX19, MSR_UNC_V3_C19_PMON_CTL2, MSR_UNC_V3_C19_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX19C3", PMC99, CBOX19, MSR_UNC_V3_C19_PMON_CTL3, MSR_UNC_V3_C19_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX20C0", PMC100, CBOX20, MSR_UNC_V3_C20_PMON_CTL0, MSR_UNC_V3_C20_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX20C1", PMC101, CBOX20, MSR_UNC_V3_C20_PMON_CTL1, MSR_UNC_V3_C20_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX20C2", PMC102, CBOX20, MSR_UNC_V3_C20_PMON_CTL2, MSR_UNC_V3_C20_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX20C3", PMC103, CBOX20, MSR_UNC_V3_C20_PMON_CTL3, MSR_UNC_V3_C20_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX21C0", PMC104, CBOX21, MSR_UNC_V3_C21_PMON_CTL0, MSR_UNC_V3_C21_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX21C1", PMC105, CBOX21, MSR_UNC_V3_C21_PMON_CTL1, MSR_UNC_V3_C21_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX21C2", PMC106, CBOX21, MSR_UNC_V3_C21_PMON_CTL2, MSR_UNC_V3_C21_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX21C3", PMC107, CBOX21, MSR_UNC_V3_C21_PMON_CTL3, MSR_UNC_V3_C21_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX22C0", PMC108, CBOX22, MSR_UNC_V3_C22_PMON_CTL0, MSR_UNC_V3_C22_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX22C1", PMC109, CBOX22, MSR_UNC_V3_C22_PMON_CTL1, MSR_UNC_V3_C22_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX22C2", PMC110, CBOX22, MSR_UNC_V3_C22_PMON_CTL2, MSR_UNC_V3_C22_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX22C3", PMC111, CBOX22, MSR_UNC_V3_C22_PMON_CTL3, MSR_UNC_V3_C22_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX23C0", PMC112, CBOX23, MSR_UNC_V3_C23_PMON_CTL0, MSR_UNC_V3_C23_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX23C1", PMC113, CBOX23, MSR_UNC_V3_C23_PMON_CTL1, MSR_UNC_V3_C23_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX23C2", PMC114, CBOX23, MSR_UNC_V3_C23_PMON_CTL2, MSR_UNC_V3_C23_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX23C3", PMC115, CBOX23, MSR_UNC_V3_C23_PMON_CTL3, MSR_UNC_V3_C23_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX24C0", PMC116, CBOX24, MSR_UNC_V3_C24_PMON_CTL0, MSR_UNC_V3_C24_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX24C1", PMC117, CBOX24, MSR_UNC_V3_C24_PMON_CTL1, MSR_UNC_V3_C24_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX24C2", PMC118, CBOX24, MSR_UNC_V3_C24_PMON_CTL2, MSR_UNC_V3_C24_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX24C3", PMC119, CBOX24, MSR_UNC_V3_C24_PMON_CTL3, MSR_UNC_V3_C24_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX25C0", PMC120, CBOX25, MSR_UNC_V3_C25_PMON_CTL0, MSR_UNC_V3_C25_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX25C1", PMC121, CBOX25, MSR_UNC_V3_C25_PMON_CTL1, MSR_UNC_V3_C25_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX25C2", PMC122, CBOX25, MSR_UNC_V3_C25_PMON_CTL2, MSR_UNC_V3_C25_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX25C3", PMC123, CBOX25, MSR_UNC_V3_C25_PMON_CTL3, MSR_UNC_V3_C25_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX26C0", PMC124, CBOX26, MSR_UNC_V3_C26_PMON_CTL0, MSR_UNC_V3_C26_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX26C1", PMC125, CBOX26, MSR_UNC_V3_C26_PMON_CTL1, MSR_UNC_V3_C26_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX26C2", PMC126, CBOX26, MSR_UNC_V3_C26_PMON_CTL2, MSR_UNC_V3_C26_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX26C3", PMC127, CBOX26, MSR_UNC_V3_C26_PMON_CTL3, MSR_UNC_V3_C26_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX27C0", PMC128, CBOX27, MSR_UNC_V3_C27_PMON_CTL0, MSR_UNC_V3_C27_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX27C1", PMC129, CBOX27, MSR_UNC_V3_C27_PMON_CTL1, MSR_UNC_V3_C27_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX27C2", PMC130, CBOX27, MSR_UNC_V3_C27_PMON_CTL2, MSR_UNC_V3_C27_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"CBOX27C3", PMC131, CBOX27, MSR_UNC_V3_C27_PMON_CTL3, MSR_UNC_V3_C27_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_CBOX},
    {"WBOX0", PMC132, WBOX, MSR_UNC_V3_PCU_PMON_CTL0, MSR_UNC_V3_PCU_PMON_CTR0, 0, 0, SKX_VALID_OPTIONS_WBOX},
    {"WBOX1", PMC133, WBOX, MSR_UNC_V3_PCU_PMON_CTL1, MSR_UNC_V3_PCU_PMON_CTR1, 0, 0, SKX_VALID_OPTIONS_WBOX},
    {"WBOX2", PMC134, WBOX, MSR_UNC_V3_PCU_PMON_CTL2, MSR_UNC_V3_PCU_PMON_CTR2, 0, 0, SKX_VALID_OPTIONS_WBOX},
    {"WBOX3", PMC135, WBOX, MSR_UNC_V3_PCU_PMON_CTL3, MSR_UNC_V3_PCU_PMON_CTR3, 0, 0, SKX_VALID_OPTIONS_WBOX},
    {"WBOX0FIX", PMC136, WBOX0FIX, 0, MSR_UNC_V3_PCU_CC3_CTR, 0, 0, EVENT_OPTION_NONE_MASK},
    {"WBOX1FIX", PMC137, WBOX0FIX, 0, MSR_UNC_V3_PCU_CC6_CTR, 0, 0, EVENT_OPTION_NONE_MASK},
    {"WBOX2FIX", PMC138, WBOX0FIX, 0, MSR_UNC_V3_PCU_PC3_CTR, 0, 0, EVENT_OPTION_NONE_MASK},
    {"WBOX3FIX", PMC139, WBOX0FIX, 0, MSR_UNC_V3_PCU_PC6_CTR, 0, 0, EVENT_OPTION_NONE_MASK},
    {"M2M0C0", PMC140, BBOX0, MSR_UNC_SKX_M2M_PMON_CTL0, MSR_UNC_SKX_M2M_PMON_CTR0, 0, PCI_HA_DEVICE_0, SKX_VALID_OPTIONS_BBOX},
    {"M2M0C1", PMC141, BBOX0, MSR_UNC_SKX_M2M_PMON_CTL1, MSR_UNC_SKX_M2M_PMON_CTR1, 0, PCI_HA_DEVICE_0, SKX_VALID_OPTIONS_BBOX},
    {"M2M0C2", PMC142, BBOX0, MSR_UNC_SKX_M2M_PMON_CTL2, MSR_UNC_SKX_M2M_PMON_CTR2, 0, PCI_HA_DEVICE_0, SKX_VALID_OPTIONS_BBOX},
    {"M2M0C3", PMC143, BBOX0, MSR_UNC_SKX_M2M_PMON_CTL3, MSR_UNC_SKX_M2M_PMON_CTR3, 0, PCI_HA_DEVICE_0, SKX_VALID_OPTIONS_BBOX},
    {"M2M1C0", PMC144, BBOX1, MSR_UNC_SKX_M2M_PMON_CTL0, MSR_UNC_SKX_M2M_PMON_CTR0, 0, PCI_HA_DEVICE_1, SKX_VALID_OPTIONS_BBOX},
    {"M2M1C1", PMC145, BBOX1, MSR_UNC_SKX_M2M_PMON_CTL1, MSR_UNC_SKX_M2M_PMON_CTR1, 0, PCI_HA_DEVICE_1, SKX_VALID_OPTIONS_BBOX},
    {"M2M1C2", PMC146, BBOX1, MSR_UNC_SKX_M2M_PMON_CTL2, MSR_UNC_SKX_M2M_PMON_CTR2, 0, PCI_HA_DEVICE_1, SKX_VALID_OPTIONS_BBOX},
    {"M2M1C3", PMC147, BBOX1, MSR_UNC_SKX_M2M_PMON_CTL3, MSR_UNC_SKX_M2M_PMON_CTR2, 0, PCI_HA_DEVICE_1, SKX_VALID_OPTIONS_BBOX},
    {"MBOX0C0", PMC148, MBOX0, PCI_UNC_SKX_MC_PMON_CTL0, PCI_UNC_SKX_MC_PMON_CTR0, 0, PCI_IMC_DEVICE_0_CH_0, SKX_VALID_OPTIONS_MBOX},
    {"MBOX0C1", PMC149, MBOX0, PCI_UNC_SKX_MC_PMON_CTL1, PCI_UNC_SKX_MC_PMON_CTR1, 0, PCI_IMC_DEVICE_0_CH_0, SKX_VALID_OPTIONS_MBOX},
    {"MBOX0C2", PMC150, MBOX0, PCI_UNC_SKX_MC_PMON_CTL2, PCI_UNC_SKX_MC_PMON_CTR2, 0, PCI_IMC_DEVICE_0_CH_0, SKX_VALID_OPTIONS_MBOX},
    {"MBOX0C3", PMC151, MBOX0, PCI_UNC_SKX_MC_PMON_CTL3, PCI_UNC_SKX_MC_PMON_CTR3, 0, PCI_IMC_DEVICE_0_CH_0, SKX_VALID_OPTIONS_MBOX},
    {"MBOX0FIX", PMC152, MBOX0FIX, PCI_UNC_SKX_MC_PMON_FIXED_CTL, PCI_UNC_SKX_MC_PMON_FIXED_CTR, 0, PCI_IMC_DEVICE_0_CH_0, EVENT_OPTION_INVERT_MASK},
    {"MBOX1C0", PMC153, MBOX1, PCI_UNC_SKX_MC_PMON_CTL0, PCI_UNC_SKX_MC_PMON_CTR0, 0, PCI_IMC_DEVICE_0_CH_1, SKX_VALID_OPTIONS_MBOX},
    {"MBOX1C1", PMC154, MBOX1, PCI_UNC_SKX_MC_PMON_CTL1, PCI_UNC_SKX_MC_PMON_CTR1, 0, PCI_IMC_DEVICE_0_CH_1, SKX_VALID_OPTIONS_MBOX},
    {"MBOX1C2", PMC155, MBOX1, PCI_UNC_SKX_MC_PMON_CTL2, PCI_UNC_SKX_MC_PMON_CTR2, 0, PCI_IMC_DEVICE_0_CH_1, SKX_VALID_OPTIONS_MBOX},
    {"MBOX1C3", PMC156, MBOX1, PCI_UNC_SKX_MC_PMON_CTL3, PCI_UNC_SKX_MC_PMON_CTR3, 0, PCI_IMC_DEVICE_0_CH_1, SKX_VALID_OPTIONS_MBOX},
    {"MBOX1FIX", PMC157, MBOX1FIX, PCI_UNC_SKX_MC_PMON_FIXED_CTL, PCI_UNC_SKX_MC_PMON_FIXED_CTR, 0, PCI_IMC_DEVICE_0_CH_1, EVENT_OPTION_INVERT_MASK},
    {"MBOX2C0", PMC158, MBOX2, PCI_UNC_SKX_MC_PMON_CTL0, PCI_UNC_SKX_MC_PMON_CTR0, 0, PCI_IMC_DEVICE_0_CH_2, SKX_VALID_OPTIONS_MBOX},
    {"MBOX2C1", PMC159, MBOX2, PCI_UNC_SKX_MC_PMON_CTL1, PCI_UNC_SKX_MC_PMON_CTR1, 0, PCI_IMC_DEVICE_0_CH_2, SKX_VALID_OPTIONS_MBOX},
    {"MBOX2C2", PMC160, MBOX2, PCI_UNC_SKX_MC_PMON_CTL2, PCI_UNC_SKX_MC_PMON_CTR2, 0, PCI_IMC_DEVICE_0_CH_2, SKX_VALID_OPTIONS_MBOX},
    {"MBOX2C3", PMC161, MBOX2, PCI_UNC_SKX_MC_PMON_CTL3, PCI_UNC_SKX_MC_PMON_CTR3, 0, PCI_IMC_DEVICE_0_CH_2, SKX_VALID_OPTIONS_MBOX},
    {"MBOX2FIX", PMC162, MBOX2FIX, PCI_UNC_SKX_MC_PMON_FIXED_CTL, PCI_UNC_SKX_MC_PMON_FIXED_CTR, 0, PCI_IMC_DEVICE_0_CH_2, EVENT_OPTION_INVERT_MASK},
    {"MBOX3C0", PMC163, MBOX3, PCI_UNC_SKX_MC_PMON_CTL0, PCI_UNC_SKX_MC_PMON_CTR0, 0, PCI_IMC_DEVICE_1_CH_0, SKX_VALID_OPTIONS_MBOX},
    {"MBOX3C1", PMC164, MBOX3, PCI_UNC_SKX_MC_PMON_CTL1, PCI_UNC_SKX_MC_PMON_CTR1, 0, PCI_IMC_DEVICE_1_CH_0, SKX_VALID_OPTIONS_MBOX},
    {"MBOX3C2", PMC165, MBOX3, PCI_UNC_SKX_MC_PMON_CTL2, PCI_UNC_SKX_MC_PMON_CTR2, 0, PCI_IMC_DEVICE_1_CH_0, SKX_VALID_OPTIONS_MBOX},
    {"MBOX3C3", PMC166, MBOX3, PCI_UNC_SKX_MC_PMON_CTL3, PCI_UNC_SKX_MC_PMON_CTR3, 0, PCI_IMC_DEVICE_1_CH_0, SKX_VALID_OPTIONS_MBOX},
    {"MBOX3FIX", PMC167, MBOX3FIX, PCI_UNC_SKX_MC_PMON_FIXED_CTL, PCI_UNC_SKX_MC_PMON_FIXED_CTR, 0, PCI_IMC_DEVICE_1_CH_0, EVENT_OPTION_INVERT_MASK},
    {"MBOX4C0", PMC168, MBOX4, PCI_UNC_SKX_MC_PMON_CTL0, PCI_UNC_SKX_MC_PMON_CTR0, 0, PCI_IMC_DEVICE_1_CH_1, SKX_VALID_OPTIONS_MBOX},
    {"MBOX4C1", PMC169, MBOX4, PCI_UNC_SKX_MC_PMON_CTL1, PCI_UNC_SKX_MC_PMON_CTR1, 0, PCI_IMC_DEVICE_1_CH_1, SKX_VALID_OPTIONS_MBOX},
    {"MBOX4C2", PMC170, MBOX4, PCI_UNC_SKX_MC_PMON_CTL2, PCI_UNC_SKX_MC_PMON_CTR2, 0, PCI_IMC_DEVICE_1_CH_1, SKX_VALID_OPTIONS_MBOX},
    {"MBOX4C3", PMC171, MBOX4, PCI_UNC_SKX_MC_PMON_CTL3, PCI_UNC_SKX_MC_PMON_CTR3, 0, PCI_IMC_DEVICE_1_CH_1, SKX_VALID_OPTIONS_MBOX},
    {"MBOX4FIX", PMC172, MBOX4FIX, PCI_UNC_SKX_MC_PMON_FIXED_CTL, PCI_UNC_SKX_MC_PMON_FIXED_CTR, 0, PCI_IMC_DEVICE_1_CH_1, EVENT_OPTION_INVERT_MASK},
    {"MBOX5C0", PMC173, MBOX5, PCI_UNC_SKX_MC_PMON_CTL0, PCI_UNC_SKX_MC_PMON_CTR0, 0, PCI_IMC_DEVICE_1_CH_2, SKX_VALID_OPTIONS_MBOX},
    {"MBOX5C1", PMC174, MBOX5, PCI_UNC_SKX_MC_PMON_CTL1, PCI_UNC_SKX_MC_PMON_CTR1, 0, PCI_IMC_DEVICE_1_CH_2, SKX_VALID_OPTIONS_MBOX},
    {"MBOX5C2", PMC175, MBOX5, PCI_UNC_SKX_MC_PMON_CTL2, PCI_UNC_SKX_MC_PMON_CTR2, 0, PCI_IMC_DEVICE_1_CH_2, SKX_VALID_OPTIONS_MBOX},
    {"MBOX5C3", PMC176, MBOX5, PCI_UNC_SKX_MC_PMON_CTL3, PCI_UNC_SKX_MC_PMON_CTR3, 0, PCI_IMC_DEVICE_1_CH_2, SKX_VALID_OPTIONS_MBOX},
    {"MBOX5FIX", PMC177, MBOX5FIX, PCI_UNC_SKX_MC_PMON_FIXED_CTL, PCI_UNC_SKX_MC_PMON_FIXED_CTR, 0, PCI_IMC_DEVICE_1_CH_2, EVENT_OPTION_INVERT_MASK},
    {"SBOX0C0", PMC178, SBOX0, MSR_UNC_SKX_UPI_PMON_CTL0, MSR_UNC_SKX_UPI_PMON_CTR0, 0, PCI_QPI_DEVICE_PORT_0, SKX_VALID_OPTIONS_SBOX},
    {"SBOX0C1", PMC179, SBOX0, MSR_UNC_SKX_UPI_PMON_CTL1, MSR_UNC_SKX_UPI_PMON_CTR1, 0, PCI_QPI_DEVICE_PORT_0, SKX_VALID_OPTIONS_SBOX},
    {"SBOX0C2", PMC180, SBOX0, MSR_UNC_SKX_UPI_PMON_CTL2, MSR_UNC_SKX_UPI_PMON_CTR2, 0, PCI_QPI_DEVICE_PORT_0, SKX_VALID_OPTIONS_SBOX},
    {"SBOX0C3", PMC181, SBOX0, MSR_UNC_SKX_UPI_PMON_CTL3, MSR_UNC_SKX_UPI_PMON_CTR3, 0, PCI_QPI_DEVICE_PORT_0, SKX_VALID_OPTIONS_SBOX},
    {"SBOX1C0", PMC182, SBOX1, MSR_UNC_SKX_UPI_PMON_CTL0, MSR_UNC_SKX_UPI_PMON_CTR0, 0, PCI_QPI_DEVICE_PORT_1, SKX_VALID_OPTIONS_SBOX},
    {"SBOX1C1", PMC183, SBOX1, MSR_UNC_SKX_UPI_PMON_CTL1, MSR_UNC_SKX_UPI_PMON_CTR1, 0, PCI_QPI_DEVICE_PORT_1, SKX_VALID_OPTIONS_SBOX},
    {"SBOX1C2", PMC184, SBOX1, MSR_UNC_SKX_UPI_PMON_CTL2, MSR_UNC_SKX_UPI_PMON_CTR2, 0, PCI_QPI_DEVICE_PORT_1, SKX_VALID_OPTIONS_SBOX},
    {"SBOX1C3", PMC185, SBOX1, MSR_UNC_SKX_UPI_PMON_CTL3, MSR_UNC_SKX_UPI_PMON_CTR3, 0, PCI_QPI_DEVICE_PORT_1, SKX_VALID_OPTIONS_SBOX},
    {"SBOX2C0", PMC186, SBOX2, MSR_UNC_SKX_UPI_PMON_CTL0, MSR_UNC_SKX_UPI_PMON_CTR0, 0, PCI_QPI_DEVICE_PORT_2, SKX_VALID_OPTIONS_SBOX},
    {"SBOX2C1", PMC187, SBOX2, MSR_UNC_SKX_UPI_PMON_CTL1, MSR_UNC_SKX_UPI_PMON_CTR1, 0, PCI_QPI_DEVICE_PORT_2, SKX_VALID_OPTIONS_SBOX},
    {"SBOX2C2", PMC188, SBOX2, MSR_UNC_SKX_UPI_PMON_CTL2, MSR_UNC_SKX_UPI_PMON_CTR2, 0, PCI_QPI_DEVICE_PORT_2, SKX_VALID_OPTIONS_SBOX},
    {"SBOX2C3", PMC189, SBOX2, MSR_UNC_SKX_UPI_PMON_CTL3, MSR_UNC_SKX_UPI_PMON_CTR3, 0, PCI_QPI_DEVICE_PORT_2, SKX_VALID_OPTIONS_SBOX},
    {"RBOX0C0", PMC190, RBOX0, MSR_UNC_SKX_M3UPI_PMON_CTL0, MSR_UNC_SKX_M3UPI_PMON_CTR0, 0, PCI_R3QPI_DEVICE_LINK_0, SKX_VALID_OPTIONS_RBOX},
    {"RBOX0C1", PMC191, RBOX0, MSR_UNC_SKX_M3UPI_PMON_CTL1, MSR_UNC_SKX_M3UPI_PMON_CTR1, 0, PCI_R3QPI_DEVICE_LINK_0, SKX_VALID_OPTIONS_RBOX},
    {"RBOX0C2", PMC192, RBOX0, MSR_UNC_SKX_M3UPI_PMON_CTL2, MSR_UNC_SKX_M3UPI_PMON_CTR2, 0, PCI_R3QPI_DEVICE_LINK_0, SKX_VALID_OPTIONS_RBOX},
    {"RBOX1C0", PMC193, RBOX1, MSR_UNC_SKX_M3UPI_PMON_CTL0, MSR_UNC_SKX_M3UPI_PMON_CTR0, 0, PCI_R3QPI_DEVICE_LINK_1, SKX_VALID_OPTIONS_RBOX},
    {"RBOX1C1", PMC194, RBOX1, MSR_UNC_SKX_M3UPI_PMON_CTL1, MSR_UNC_SKX_M3UPI_PMON_CTR1, 0, PCI_R3QPI_DEVICE_LINK_1, SKX_VALID_OPTIONS_RBOX},
    {"RBOX1C2", PMC195, RBOX1, MSR_UNC_SKX_M3UPI_PMON_CTL2, MSR_UNC_SKX_M3UPI_PMON_CTR2, 0, PCI_R3QPI_DEVICE_LINK_1, SKX_VALID_OPTIONS_RBOX},
    {"RBOX2C0", PMC196, RBOX2, MSR_UNC_SKX_M3UPI_PMON_CTL0, MSR_UNC_SKX_M3UPI_PMON_CTR0, 0, PCI_R3QPI_DEVICE_LINK_2, SKX_VALID_OPTIONS_RBOX},
    {"RBOX2C1", PMC197, RBOX2, MSR_UNC_SKX_M3UPI_PMON_CTL1, MSR_UNC_SKX_M3UPI_PMON_CTR1, 0, PCI_R3QPI_DEVICE_LINK_2, SKX_VALID_OPTIONS_RBOX},
    {"RBOX2C2", PMC198, RBOX2, MSR_UNC_SKX_M3UPI_PMON_CTL2, MSR_UNC_SKX_M3UPI_PMON_CTR2, 0, PCI_R3QPI_DEVICE_LINK_2, SKX_VALID_OPTIONS_RBOX},
    {"IBOX0C0", PMC199, IBOX0, MSR_UNC_SKX_II0_CBDMA_CTL0, MSR_UNC_SKX_II0_CBDMA_CTR0, 0, 0, SKX_VALID_OPTIONS_IBOX},
    {"IBOX0C1", PMC200, IBOX0, MSR_UNC_SKX_II0_CBDMA_CTL1, MSR_UNC_SKX_II0_CBDMA_CTR1, 0, 0, SKX_VALID_OPTIONS_IBOX},
    {"IBOX0C2", PMC201, IBOX0, MSR_UNC_SKX_II0_CBDMA_CTL2, MSR_UNC_SKX_II0_CBDMA_CTR2, 0, 0, SKX_VALID_OPTIONS_IBOX},
    {"IBOX0C3", PMC202, IBOX0, MSR_UNC_SKX_II0_CBDMA_CTL3, MSR_UNC_SKX_II0_CBDMA_CTR3, 0, 0, SKX_VALID_OPTIONS_IBOX},
    {"IBOX0CLK", PMC203, IBOX0FIX, 0, MSR_UNC_SKX_II0_CBDMA_CLOCK, 0, 0, 0},
    {"IBAND0PI0", PMC204, IBOX0FIX, 0, MSR_UNC_SKX_II0_CBDMA_BAND_PORT0_IN, 0, 0, 0},
    {"IBAND0PI1", PMC205, IBOX0FIX, 0, MSR_UNC_SKX_II0_CBDMA_BAND_PORT1_IN, 0, 0, 0},
    {"IBAND0PI2", PMC206, IBOX0FIX, 0, MSR_UNC_SKX_II0_CBDMA_BAND_PORT2_IN, 0, 0, 0},
    {"IBAND0PI3", PMC207, IBOX0FIX, 0, MSR_UNC_SKX_II0_CBDMA_BAND_PORT3_IN, 0, 0, 0},
    {"IBAND0PO0", PMC208, IBOX0FIX, 0, MSR_UNC_SKX_II0_CBDMA_BAND_PORT0_OUT, 0, 0, 0},
    {"IBAND0PO1", PMC209, IBOX0FIX, 0, MSR_UNC_SKX_II0_CBDMA_BAND_PORT1_OUT, 0, 0, 0},
    {"IBAND0PO2", PMC210, IBOX0FIX, 0, MSR_UNC_SKX_II0_CBDMA_BAND_PORT2_OUT, 0, 0, 0},
    {"IBAND0PO3", PMC211, IBOX0FIX, 0, MSR_UNC_SKX_II0_CBDMA_BAND_PORT3_OUT, 0, 0, 0},
    {"IUTIL0PI0", PMC212, IBOX0FIX, 0, MSR_UNC_SKX_II0_CBDMA_UTIL_PORT0_IN, 0, 0, 0},
    {"IUTIL0PI1", PMC213, IBOX0FIX, 0, MSR_UNC_SKX_II0_CBDMA_UTIL_PORT1_IN, 0, 0, 0},
    {"IUTIL0PI2", PMC214, IBOX0FIX, 0, MSR_UNC_SKX_II0_CBDMA_UTIL_PORT2_IN, 0, 0, 0},
    {"IUTIL0PI3", PMC215, IBOX0FIX, 0, MSR_UNC_SKX_II0_CBDMA_UTIL_PORT3_IN, 0, 0, 0},
    {"IUTIL0PO0", PMC216, IBOX0FIX, 0, MSR_UNC_SKX_II0_CBDMA_UTIL_PORT0_OUT, 0, 0, 0},
    {"IUTIL0PO1", PMC217, IBOX0FIX, 0, MSR_UNC_SKX_II0_CBDMA_UTIL_PORT1_OUT, 0, 0, 0},
    {"IUTIL0PO2", PMC218, IBOX0FIX, 0, MSR_UNC_SKX_II0_CBDMA_UTIL_PORT2_OUT, 0, 0, 0},
    {"IUTIL0PO3", PMC219, IBOX0FIX, 0, MSR_UNC_SKX_II0_CBDMA_UTIL_PORT3_OUT, 0, 0, 0},
    {"IBOX1C0", PMC220, IBOX1, MSR_UNC_SKX_II0_PCIE0_CTL0, MSR_UNC_SKX_II0_PCIE0_CTR0, 0, 0, SKX_VALID_OPTIONS_IBOX},
    {"IBOX1C1", PMC221, IBOX1, MSR_UNC_SKX_II0_PCIE0_CTL1, MSR_UNC_SKX_II0_PCIE0_CTR1, 0, 0, SKX_VALID_OPTIONS_IBOX},
    {"IBOX1C2", PMC222, IBOX1, MSR_UNC_SKX_II0_PCIE0_CTL2, MSR_UNC_SKX_II0_PCIE0_CTR2, 0, 0, SKX_VALID_OPTIONS_IBOX},
    {"IBOX1C3", PMC223, IBOX1, MSR_UNC_SKX_II0_PCIE0_CTL3, MSR_UNC_SKX_II0_PCIE0_CTR3, 0, 0, SKX_VALID_OPTIONS_IBOX},
    {"IBOX1CLK", PMC224, IBOX1FIX, 0, MSR_UNC_SKX_II0_PCIE0_CLOCK, 0, 0, 0},
    {"IBAND1PI0", PMC225, IBOX1FIX, 0, MSR_UNC_SKX_II0_PCIE0_BAND_PORT0_IN, 0, 0, 0},
    {"IBAND1PI1", PMC226, IBOX1FIX, 0, MSR_UNC_SKX_II0_PCIE0_BAND_PORT1_IN, 0, 0, 0},
    {"IBAND1PI2", PMC227, IBOX1FIX, 0, MSR_UNC_SKX_II0_PCIE0_BAND_PORT2_IN, 0, 0, 0},
    {"IBAND1PI3", PMC228, IBOX1FIX, 0, MSR_UNC_SKX_II0_PCIE0_BAND_PORT3_IN, 0, 0, 0},
    {"IBAND1PO0", PMC229, IBOX1FIX, 0, MSR_UNC_SKX_II0_PCIE0_BAND_PORT0_OUT, 0, 0, 0},
    {"IBAND1PO1", PMC230, IBOX1FIX, 0, MSR_UNC_SKX_II0_PCIE0_BAND_PORT1_OUT, 0, 0, 0},
    {"IBAND1PO2", PMC231, IBOX1FIX, 0, MSR_UNC_SKX_II0_PCIE0_BAND_PORT2_OUT, 0, 0, 0},
    {"IBAND1PO3", PMC232, IBOX1FIX, 0, MSR_UNC_SKX_II0_PCIE0_BAND_PORT3_OUT, 0, 0, 0},
    {"IUTIL1PI0", PMC233, IBOX1FIX, 0, MSR_UNC_SKX_II0_PCIE0_UTIL_PORT0_IN, 0, 0, 0},
    {"IUTIL1PI1", PMC234, IBOX1FIX, 0, MSR_UNC_SKX_II0_PCIE0_UTIL_PORT1_IN, 0, 0, 0},
    {"IUTIL1PI2", PMC235, IBOX1FIX, 0, MSR_UNC_SKX_II0_PCIE0_UTIL_PORT2_IN, 0, 0, 0},
    {"IUTIL1PI3", PMC236, IBOX1FIX, 0, MSR_UNC_SKX_II0_PCIE0_UTIL_PORT3_IN, 0, 0, 0},
    {"IUTIL1PO0", PMC237, IBOX1FIX, 0, MSR_UNC_SKX_II0_PCIE0_UTIL_PORT0_OUT, 0, 0, 0},
    {"IUTIL1PO1", PMC238, IBOX1FIX, 0, MSR_UNC_SKX_II0_PCIE0_UTIL_PORT1_OUT, 0, 0, 0},
    {"IUTIL1PO2", PMC239, IBOX1FIX, 0, MSR_UNC_SKX_II0_PCIE0_UTIL_PORT2_OUT, 0, 0, 0},
    {"IUTIL1PO3", PMC240, IBOX1FIX, 0, MSR_UNC_SKX_II0_PCIE0_UTIL_PORT3_OUT, 0, 0, 0},
    {"IBOX2C0", PMC241,IBOX2, MSR_UNC_SKX_II0_PCIE1_CTL0, MSR_UNC_SKX_II0_PCIE1_CTR0, 0, 0, SKX_VALID_OPTIONS_IBOX},
    {"IBOX2C1", PMC242, IBOX2, MSR_UNC_SKX_II0_PCIE1_CTL1, MSR_UNC_SKX_II0_PCIE1_CTR1, 0, 0, SKX_VALID_OPTIONS_IBOX},
    {"IBOX2C2", PMC243, IBOX2, MSR_UNC_SKX_II0_PCIE1_CTL2, MSR_UNC_SKX_II0_PCIE1_CTR2, 0, 0, SKX_VALID_OPTIONS_IBOX},
    {"IBOX2C3", PMC244, IBOX2, MSR_UNC_SKX_II0_PCIE1_CTL3, MSR_UNC_SKX_II0_PCIE1_CTR3, 0, 0, SKX_VALID_OPTIONS_IBOX},
    {"IBOX2CLK", PMC245, IBOX2FIX, 0, MSR_UNC_SKX_II0_PCIE1_CLOCK, 0, 0, 0},
    {"IBAND2PI0", PMC246, IBOX2FIX, 0, MSR_UNC_SKX_II0_PCIE1_BAND_PORT0_IN, 0, 0, 0},
    {"IBAND2PI1", PMC247, IBOX2FIX, 0, MSR_UNC_SKX_II0_PCIE1_BAND_PORT1_IN, 0, 0, 0},
    {"IBAND2PI2", PMC248, IBOX2FIX, 0, MSR_UNC_SKX_II0_PCIE1_BAND_PORT2_IN, 0, 0, 0},
    {"IBAND2PI3", PMC249, IBOX2FIX, 0, MSR_UNC_SKX_II0_PCIE1_BAND_PORT3_IN, 0, 0, 0},
    {"IBAND2PO0", PMC250, IBOX2FIX, 0, MSR_UNC_SKX_II0_PCIE1_BAND_PORT0_OUT, 0, 0, 0},
    {"IBAND2PO1", PMC251, IBOX2FIX, 0, MSR_UNC_SKX_II0_PCIE1_BAND_PORT1_OUT, 0, 0, 0},
    {"IBAND2PO2", PMC252, IBOX2FIX, 0, MSR_UNC_SKX_II0_PCIE1_BAND_PORT2_OUT, 0, 0, 0},
    {"IBAND2PO3", PMC253, IBOX2FIX, 0, MSR_UNC_SKX_II0_PCIE1_BAND_PORT3_OUT, 0, 0, 0},
    {"IUTIL2PI0", PMC254, IBOX2FIX, 0, MSR_UNC_SKX_II0_PCIE1_UTIL_PORT0_IN, 0, 0, 0},
    {"IUTIL2PI1", PMC255, IBOX2FIX, 0, MSR_UNC_SKX_II0_PCIE1_UTIL_PORT1_IN, 0, 0, 0},
    {"IUTIL2PI2", PMC256, IBOX2FIX, 0, MSR_UNC_SKX_II0_PCIE1_UTIL_PORT2_IN, 0, 0, 0},
    {"IUTIL2PI3", PMC257, IBOX2FIX, 0, MSR_UNC_SKX_II0_PCIE1_UTIL_PORT3_IN, 0, 0, 0},
    {"IUTIL2PO0", PMC258, IBOX2FIX, 0, MSR_UNC_SKX_II0_PCIE1_UTIL_PORT0_OUT, 0, 0, 0},
    {"IUTIL2PO1", PMC259, IBOX2FIX, 0, MSR_UNC_SKX_II0_PCIE1_UTIL_PORT1_OUT, 0, 0, 0},
    {"IUTIL2PO2", PMC260, IBOX2FIX, 0, MSR_UNC_SKX_II0_PCIE1_UTIL_PORT2_OUT, 0, 0, 0},
    {"IUTIL2PO3", PMC261, IBOX2FIX, 0, MSR_UNC_SKX_II0_PCIE1_UTIL_PORT3_OUT, 0, 0, 0},
    {"IBOX3C0", PMC262, IBOX3, MSR_UNC_SKX_II0_PCIE2_CTL0, MSR_UNC_SKX_II0_PCIE2_CTR0, 0, 0, SKX_VALID_OPTIONS_IBOX},
    {"IBOX3C1", PMC263, IBOX3, MSR_UNC_SKX_II0_PCIE2_CTL1, MSR_UNC_SKX_II0_PCIE2_CTR1, 0, 0, SKX_VALID_OPTIONS_IBOX},
    {"IBOX3C2", PMC264, IBOX3, MSR_UNC_SKX_II0_PCIE2_CTL2, MSR_UNC_SKX_II0_PCIE2_CTR2, 0, 0, SKX_VALID_OPTIONS_IBOX},
    {"IBOX3C3", PMC265, IBOX3, MSR_UNC_SKX_II0_PCIE2_CTL3, MSR_UNC_SKX_II0_PCIE2_CTR3, 0, 0, SKX_VALID_OPTIONS_IBOX},
    {"IBOX3CLK", PMC266, IBOX3FIX, 0, MSR_UNC_SKX_II0_PCIE2_CLOCK, 0, 0, 0},
    {"IBAND3PI0", PMC267, IBOX3FIX, 0, MSR_UNC_SKX_II0_PCIE2_BAND_PORT0_IN, 0, 0, 0},
    {"IBAND3PI1", PMC268, IBOX3FIX, 0, MSR_UNC_SKX_II0_PCIE2_BAND_PORT1_IN, 0, 0, 0},
    {"IBAND3PI2", PMC269, IBOX3FIX, 0, MSR_UNC_SKX_II0_PCIE2_BAND_PORT2_IN, 0, 0, 0},
    {"IBAND3PI3", PMC270, IBOX3FIX, 0, MSR_UNC_SKX_II0_PCIE2_BAND_PORT3_IN, 0, 0, 0},
    {"IBAND3PO0", PMC271, IBOX3FIX, 0, MSR_UNC_SKX_II0_PCIE2_BAND_PORT0_OUT, 0, 0, 0},
    {"IBAND3PO1", PMC272, IBOX3FIX, 0, MSR_UNC_SKX_II0_PCIE2_BAND_PORT1_OUT, 0, 0, 0},
    {"IBAND3PO2", PMC273, IBOX3FIX, 0, MSR_UNC_SKX_II0_PCIE2_BAND_PORT2_OUT, 0, 0, 0},
    {"IBAND3PO3", PMC274, IBOX3FIX, 0, MSR_UNC_SKX_II0_PCIE2_BAND_PORT3_OUT, 0, 0, 0},
    {"IUTIL3PI0", PMC275, IBOX3FIX, 0, MSR_UNC_SKX_II0_PCIE2_UTIL_PORT0_IN, 0, 0, 0},
    {"IUTIL3PI1", PMC276, IBOX3FIX, 0, MSR_UNC_SKX_II0_PCIE2_UTIL_PORT1_IN, 0, 0, 0},
    {"IUTIL3PI2", PMC277, IBOX3FIX, 0, MSR_UNC_SKX_II0_PCIE2_UTIL_PORT2_IN, 0, 0, 0},
    {"IUTIL3PI3", PMC278, IBOX3FIX, 0, MSR_UNC_SKX_II0_PCIE2_UTIL_PORT3_IN, 0, 0, 0},
    {"IUTIL3PO0", PMC279, IBOX3FIX, 0, MSR_UNC_SKX_II0_PCIE2_UTIL_PORT0_OUT, 0, 0, 0},
    {"IUTIL3PO1", PMC280, IBOX3FIX, 0, MSR_UNC_SKX_II0_PCIE2_UTIL_PORT1_OUT, 0, 0, 0},
    {"IUTIL3PO2", PMC281, IBOX3FIX, 0, MSR_UNC_SKX_II0_PCIE2_UTIL_PORT2_OUT, 0, 0, 0},
    {"IUTIL3PO3", PMC282, IBOX3FIX, 0, MSR_UNC_SKX_II0_PCIE2_UTIL_PORT3_OUT, 0, 0, 0},
    {"IBOX4C0", PMC283, IBOX4, MSR_UNC_SKX_II0_MCP0_CTL0, MSR_UNC_SKX_II0_MCP0_CTR0, 0, 0, SKX_VALID_OPTIONS_IBOX},
    {"IBOX4C1", PMC284, IBOX4, MSR_UNC_SKX_II0_MCP0_CTL1, MSR_UNC_SKX_II0_MCP0_CTR1, 0, 0, SKX_VALID_OPTIONS_IBOX},
    {"IBOX4C2", PMC285, IBOX4, MSR_UNC_SKX_II0_MCP0_CTL2, MSR_UNC_SKX_II0_MCP0_CTR2, 0, 0, SKX_VALID_OPTIONS_IBOX},
    {"IBOX4C3", PMC286, IBOX4, MSR_UNC_SKX_II0_MCP0_CTL3, MSR_UNC_SKX_II0_MCP0_CTR3, 0, 0, SKX_VALID_OPTIONS_IBOX},
    {"IBOX4CLK", PMC287, IBOX4FIX, 0, MSR_UNC_SKX_II0_MCP0_CLOCK, 0, 0, 0},
    {"IBAND4PI0", PMC288, IBOX4FIX, 0, MSR_UNC_SKX_II0_MCP0_BAND_PORT0_IN, 0, 0, 0},
    {"IBAND4PI1", PMC289, IBOX4FIX, 0, MSR_UNC_SKX_II0_MCP0_BAND_PORT1_IN, 0, 0, 0},
    {"IBAND4PI2", PMC290, IBOX4FIX, 0, MSR_UNC_SKX_II0_MCP0_BAND_PORT2_IN, 0, 0, 0},
    {"IBAND4PI3", PMC291, IBOX4FIX, 0, MSR_UNC_SKX_II0_MCP0_BAND_PORT3_IN, 0, 0, 0},
    {"IBAND4PO0", PMC292, IBOX4FIX, 0, MSR_UNC_SKX_II0_MCP0_BAND_PORT0_OUT, 0, 0, 0},
    {"IBAND4PO1", PMC293, IBOX4FIX, 0, MSR_UNC_SKX_II0_MCP0_BAND_PORT1_OUT, 0, 0, 0},
    {"IBAND4PO2", PMC294, IBOX4FIX, 0, MSR_UNC_SKX_II0_MCP0_BAND_PORT2_OUT, 0, 0, 0},
    {"IBAND4PO3", PMC295, IBOX4FIX, 0, MSR_UNC_SKX_II0_MCP0_BAND_PORT3_OUT, 0, 0, 0},
    {"IUTIL4PI0", PMC296, IBOX4FIX, 0, MSR_UNC_SKX_II0_MCP0_UTIL_PORT0_IN, 0, 0, 0},
    {"IUTIL4PI1", PMC297, IBOX4FIX, 0, MSR_UNC_SKX_II0_MCP0_UTIL_PORT1_IN, 0, 0, 0},
    {"IUTIL4PI2", PMC298, IBOX4FIX, 0, MSR_UNC_SKX_II0_MCP0_UTIL_PORT2_IN, 0, 0, 0},
    {"IUTIL4PI3", PMC299, IBOX4FIX, 0, MSR_UNC_SKX_II0_MCP0_UTIL_PORT3_IN, 0, 0, 0},
    {"IUTIL4PO0", PMC300, IBOX4FIX, 0, MSR_UNC_SKX_II0_MCP0_UTIL_PORT0_OUT, 0, 0, 0},
    {"IUTIL4PO1", PMC301, IBOX4FIX, 0, MSR_UNC_SKX_II0_MCP0_UTIL_PORT1_OUT, 0, 0, 0},
    {"IUTIL4PO2", PMC302, IBOX4FIX, 0, MSR_UNC_SKX_II0_MCP0_UTIL_PORT2_OUT, 0, 0, 0},
    {"IUTIL4PO3", PMC303, IBOX4FIX, 0, MSR_UNC_SKX_II0_MCP0_UTIL_PORT3_OUT, 0, 0, 0},
    {"IBOX5C0", PMC304, IBOX5, MSR_UNC_SKX_II0_MCP1_CTL0, MSR_UNC_SKX_II0_MCP1_CTR0, 0, 0, SKX_VALID_OPTIONS_IBOX},
    {"IBOX5C1", PMC305, IBOX5, MSR_UNC_SKX_II0_MCP1_CTL1, MSR_UNC_SKX_II0_MCP1_CTR1, 0, 0, SKX_VALID_OPTIONS_IBOX},
    {"IBOX5C2", PMC306, IBOX5, MSR_UNC_SKX_II0_MCP1_CTL2, MSR_UNC_SKX_II0_MCP1_CTR2, 0, 0, SKX_VALID_OPTIONS_IBOX},
    {"IBOX5C3", PMC307, IBOX5, MSR_UNC_SKX_II0_MCP1_CTL3, MSR_UNC_SKX_II0_MCP1_CTR3, 0, 0, SKX_VALID_OPTIONS_IBOX},
    {"IBOX5CLK", PMC308, IBOX5FIX, 0, MSR_UNC_SKX_II0_MCP1_CLOCK, 0, 0, 0},
    {"IBAND5PI0", PMC309, IBOX5FIX, 0, MSR_UNC_SKX_II0_MCP1_BAND_PORT0_IN, 0, 0, 0},
    {"IBAND5PI1", PMC310, IBOX5FIX, 0, MSR_UNC_SKX_II0_MCP1_BAND_PORT1_IN, 0, 0, 0},
    {"IBAND5PI2", PMC311, IBOX5FIX, 0, MSR_UNC_SKX_II0_MCP1_BAND_PORT2_IN, 0, 0, 0},
    {"IBAND5PI3", PMC312, IBOX5FIX, 0, MSR_UNC_SKX_II0_MCP1_BAND_PORT3_IN, 0, 0, 0},
    {"IBAND5PO0", PMC313, IBOX5FIX, 0, MSR_UNC_SKX_II0_MCP1_BAND_PORT0_OUT, 0, 0, 0},
    {"IBAND5PO1", PMC314, IBOX5FIX, 0, MSR_UNC_SKX_II0_MCP1_BAND_PORT1_OUT, 0, 0, 0},
    {"IBAND5PO2", PMC315, IBOX5FIX, 0, MSR_UNC_SKX_II0_MCP1_BAND_PORT2_OUT, 0, 0, 0},
    {"IBAND5PO3", PMC316, IBOX5FIX, 0, MSR_UNC_SKX_II0_MCP1_BAND_PORT3_OUT, 0, 0, 0},
    {"IUTIL5PI0", PMC317, IBOX5FIX, 0, MSR_UNC_SKX_II0_MCP1_UTIL_PORT0_IN, 0, 0, 0},
    {"IUTIL5PI1", PMC318, IBOX5FIX, 0, MSR_UNC_SKX_II0_MCP1_UTIL_PORT1_IN, 0, 0, 0},
    {"IUTIL5PI2", PMC319, IBOX5FIX, 0, MSR_UNC_SKX_II0_MCP1_UTIL_PORT2_IN, 0, 0, 0},
    {"IUTIL5PI3", PMC320, IBOX5FIX, 0, MSR_UNC_SKX_II0_MCP1_UTIL_PORT3_IN, 0, 0, 0},
    {"IUTIL5PO0", PMC321, IBOX5FIX, 0, MSR_UNC_SKX_II0_MCP1_UTIL_PORT0_OUT, 0, 0, 0},
    {"IUTIL5PO1", PMC322, IBOX5FIX, 0, MSR_UNC_SKX_II0_MCP1_UTIL_PORT1_OUT, 0, 0, 0},
    {"IUTIL5PO2", PMC323, IBOX5FIX, 0, MSR_UNC_SKX_II0_MCP1_UTIL_PORT2_OUT, 0, 0, 0},
    {"IUTIL5PO3", PMC324, IBOX5FIX, 0, MSR_UNC_SKX_II0_MCP1_UTIL_PORT3_OUT, 0, 0, 0},
    {"IRP0C0", PMC325, EUBOX0, MSR_UNC_SKX_IRP_CBDMA_CTL0, MSR_UNC_SKX_IRP_CBDMA_CTR0, 0, 0, SKX_VALID_OPTIONS_IRP},
    {"IRP0C1", PMC326, EUBOX0, MSR_UNC_SKX_IRP_CBDMA_CTL1, MSR_UNC_SKX_IRP_CBDMA_CTR1, 0, 0, SKX_VALID_OPTIONS_IRP},
    {"IRP1C0", PMC327, EUBOX1, MSR_UNC_SKX_IRP_PCIE0_CTL0, MSR_UNC_SKX_IRP_PCIE0_CTR0, 0, 0, SKX_VALID_OPTIONS_IRP},
    {"IRP1C1", PMC328, EUBOX1, MSR_UNC_SKX_IRP_PCIE0_CTL1, MSR_UNC_SKX_IRP_PCIE0_CTR1, 0, 0, SKX_VALID_OPTIONS_IRP},
    {"IRP2C0", PMC329, EUBOX2, MSR_UNC_SKX_IRP_PCIE1_CTL0, MSR_UNC_SKX_IRP_PCIE1_CTR0, 0, 0, SKX_VALID_OPTIONS_IRP},
    {"IRP2C1", PMC330, EUBOX2, MSR_UNC_SKX_IRP_PCIE1_CTL1, MSR_UNC_SKX_IRP_PCIE1_CTR1, 0, 0, SKX_VALID_OPTIONS_IRP},
    {"IRP3C0", PMC331, EUBOX3, MSR_UNC_SKX_IRP_PCIE2_CTL0, MSR_UNC_SKX_IRP_PCIE2_CTR0, 0, 0, SKX_VALID_OPTIONS_IRP},
    {"IRP3C1", PMC332, EUBOX3, MSR_UNC_SKX_IRP_PCIE2_CTL1, MSR_UNC_SKX_IRP_PCIE2_CTR1, 0, 0, SKX_VALID_OPTIONS_IRP},
    {"IRP4C0", PMC333, EUBOX4, MSR_UNC_SKX_IRP_MCP0_CTL0, MSR_UNC_SKX_IRP_MCP0_CTR0, 0, 0, SKX_VALID_OPTIONS_IRP},
    {"IRP4C1", PMC334, EUBOX4, MSR_UNC_SKX_IRP_MCP0_CTL1, MSR_UNC_SKX_IRP_MCP0_CTR1, 0, 0, SKX_VALID_OPTIONS_IRP},
    {"IRP5C0", PMC335, EUBOX5, MSR_UNC_SKX_IRP_MCP1_CTL0, MSR_UNC_SKX_IRP_MCP1_CTR0, 0, 0, SKX_VALID_OPTIONS_IRP},
    {"IRP5C1", PMC336, EUBOX5, MSR_UNC_SKX_IRP_MCP1_CTL1, MSR_UNC_SKX_IRP_MCP1_CTR1, 0, 0, SKX_VALID_OPTIONS_IRP},
};


static BoxMap skylakeX_box_map[NUM_UNITS] = {
    [PMC] = {MSR_PERF_GLOBAL_CTRL, MSR_V4_PERF_GLOBAL_STATUS, MSR_V4_PERF_GLOBAL_STATUS_RESET, 0, 0, 0, 48, MSR_PEBS_LD_LAT},
    [THERMAL] = {0, 0, 0, 0, 0, 0, 8},
    [VOLTAGE] = {0, 0, 0, 0, 0, 0, 16},
    [FIXED] =  {MSR_PERF_GLOBAL_CTRL, MSR_V4_PERF_GLOBAL_STATUS, MSR_V4_PERF_GLOBAL_STATUS_RESET, 0, 0, 0, 48},
    [POWER] = {0, 0, 0, 0, 0, 0, 32},
    [UBOX] = {0, MSR_UNC_V3_U_PMON_BOX_STATUS, MSR_UNC_V3_U_PMON_BOX_STATUS, 1, 0, 0, 48},
    [UBOXFIX] = {0, MSR_UNC_V3_U_PMON_BOX_STATUS, MSR_UNC_V3_U_PMON_BOX_STATUS, 0, 0, 0, 48},
    [MBOX0] = {PCI_UNC_SKX_MC_PMON_BOX_CTL, PCI_UNC_SKX_MC_PMON_BOX_STATUS, PCI_UNC_SKX_MC_PMON_BOX_STATUS, 39, 1, PCI_IMC_DEVICE_0_CH_0, 48},
    [MBOX1] = {PCI_UNC_SKX_MC_PMON_BOX_CTL, PCI_UNC_SKX_MC_PMON_BOX_STATUS, PCI_UNC_SKX_MC_PMON_BOX_STATUS, 39, 1, PCI_IMC_DEVICE_0_CH_1, 48},
    [MBOX2] = {PCI_UNC_SKX_MC_PMON_BOX_CTL, PCI_UNC_SKX_MC_PMON_BOX_STATUS, PCI_UNC_SKX_MC_PMON_BOX_STATUS, 39, 1, PCI_IMC_DEVICE_0_CH_2, 48},
    [MBOX3] = {PCI_UNC_SKX_MC_PMON_BOX_CTL, PCI_UNC_SKX_MC_PMON_BOX_STATUS, PCI_UNC_SKX_MC_PMON_BOX_STATUS, 40, 1, PCI_IMC_DEVICE_1_CH_0, 48},
    [MBOX4] = {PCI_UNC_SKX_MC_PMON_BOX_CTL, PCI_UNC_SKX_MC_PMON_BOX_STATUS, PCI_UNC_SKX_MC_PMON_BOX_STATUS, 40, 1, PCI_IMC_DEVICE_1_CH_1, 48},
    [MBOX5] = {PCI_UNC_SKX_MC_PMON_BOX_CTL, PCI_UNC_SKX_MC_PMON_BOX_STATUS, PCI_UNC_SKX_MC_PMON_BOX_STATUS, 40, 1, PCI_IMC_DEVICE_1_CH_2, 48},
    [SBOX0] = {MSR_UNC_SKX_UPI_PMON_BOX_CTL, MSR_UNC_SKX_UPI_PMON_BOX_STATUS, MSR_UNC_SKX_UPI_PMON_BOX_STATUS, 41, 1, PCI_QPI_DEVICE_PORT_0, 48},
    [SBOX1] = {MSR_UNC_SKX_UPI_PMON_BOX_CTL, MSR_UNC_SKX_UPI_PMON_BOX_STATUS, MSR_UNC_SKX_UPI_PMON_BOX_STATUS, 42, 1, PCI_QPI_DEVICE_PORT_1, 48},
    [SBOX2] = {MSR_UNC_SKX_UPI_PMON_BOX_CTL, MSR_UNC_SKX_UPI_PMON_BOX_STATUS, MSR_UNC_SKX_UPI_PMON_BOX_STATUS, 43, 1, PCI_QPI_DEVICE_PORT_2, 48},
    [RBOX0] = {MSR_UNC_SKX_M3UPI_PMON_BOX_CTL, MSR_UNC_SKX_M3UPI_PMON_BOX_STATUS, MSR_UNC_SKX_M3UPI_PMON_BOX_STATUS, 46, 1, PCI_R3QPI_DEVICE_LINK_0, 48},
    [RBOX1] = {MSR_UNC_SKX_M3UPI_PMON_BOX_CTL, MSR_UNC_SKX_M3UPI_PMON_BOX_STATUS, MSR_UNC_SKX_M3UPI_PMON_BOX_STATUS, 47, 1, PCI_R3QPI_DEVICE_LINK_1, 48},
    [RBOX2] = {MSR_UNC_SKX_M3UPI_PMON_BOX_CTL, MSR_UNC_SKX_M3UPI_PMON_BOX_STATUS, MSR_UNC_SKX_M3UPI_PMON_BOX_STATUS, 0, 1, PCI_R3QPI_DEVICE_LINK_2, 48},
    [BBOX0] = {MSR_UNC_SKX_M2M_PMON_BOX_CTL, MSR_UNC_SKX_M2M_PMON_BOX_STATUS, MSR_UNC_SKX_M2M_PMON_BOX_STATUS, 62, 1, PCI_HA_DEVICE_0, 48},
    [BBOX1] = {MSR_UNC_SKX_M2M_PMON_BOX_CTL, MSR_UNC_SKX_M2M_PMON_BOX_STATUS, MSR_UNC_SKX_M2M_PMON_BOX_STATUS, 63, 1, PCI_HA_DEVICE_1, 48},
    [WBOX] = {MSR_UNC_V3_PCU_PMON_BOX_CTL, MSR_UNC_V3_PCU_PMON_BOX_STATUS,MSR_UNC_V3_PCU_PMON_BOX_STATUS, 2, 0, 0, 48, MSR_UNC_V3_PCU_PMON_BOX_FILTER},
    [WBOX0FIX] = {0,0,0,-1,0,0,64},
    [CBOX0] = {MSR_UNC_V3_C0_PMON_BOX_CTL, MSR_UNC_V3_C0_PMON_BOX_STATUS, MSR_UNC_V3_C0_PMON_BOX_STATUS, 3, 0, 0, 48, MSR_UNC_V3_C0_PMON_BOX_FILTER0, MSR_UNC_V3_C0_PMON_BOX_FILTER1},
    [CBOX1] = {MSR_UNC_V3_C1_PMON_BOX_CTL, MSR_UNC_V3_C1_PMON_BOX_STATUS, MSR_UNC_V3_C1_PMON_BOX_STATUS, 4, 0, 0, 48, MSR_UNC_V3_C1_PMON_BOX_FILTER0, MSR_UNC_V3_C1_PMON_BOX_FILTER1},
    [CBOX2] = {MSR_UNC_V3_C2_PMON_BOX_CTL, MSR_UNC_V3_C2_PMON_BOX_STATUS, MSR_UNC_V3_C2_PMON_BOX_STATUS, 5, 0, 0, 48, MSR_UNC_V3_C2_PMON_BOX_FILTER0, MSR_UNC_V3_C2_PMON_BOX_FILTER1},
    [CBOX3] = {MSR_UNC_V3_C3_PMON_BOX_CTL, MSR_UNC_V3_C3_PMON_BOX_STATUS, MSR_UNC_V3_C3_PMON_BOX_STATUS, 6, 0, 0, 48, MSR_UNC_V3_C3_PMON_BOX_FILTER0, MSR_UNC_V3_C3_PMON_BOX_FILTER1},
    [CBOX4] = {MSR_UNC_V3_C4_PMON_BOX_CTL, MSR_UNC_V3_C4_PMON_BOX_STATUS, MSR_UNC_V3_C4_PMON_BOX_STATUS, 7, 0, 0, 48, MSR_UNC_V3_C4_PMON_BOX_FILTER0, MSR_UNC_V3_C4_PMON_BOX_FILTER1},
    [CBOX5] = {MSR_UNC_V3_C5_PMON_BOX_CTL, MSR_UNC_V3_C5_PMON_BOX_STATUS, MSR_UNC_V3_C5_PMON_BOX_STATUS, 8, 0, 0, 48, MSR_UNC_V3_C5_PMON_BOX_FILTER0, MSR_UNC_V3_C5_PMON_BOX_FILTER1},
    [CBOX6] = {MSR_UNC_V3_C6_PMON_BOX_CTL, MSR_UNC_V3_C6_PMON_BOX_STATUS, MSR_UNC_V3_C6_PMON_BOX_STATUS, 9, 0, 0, 48, MSR_UNC_V3_C6_PMON_BOX_FILTER0, MSR_UNC_V3_C6_PMON_BOX_FILTER1},
    [CBOX7] = {MSR_UNC_V3_C7_PMON_BOX_CTL, MSR_UNC_V3_C7_PMON_BOX_STATUS, MSR_UNC_V3_C7_PMON_BOX_STATUS, 10, 0, 0, 48, MSR_UNC_V3_C7_PMON_BOX_FILTER0, MSR_UNC_V3_C7_PMON_BOX_FILTER1},
    [CBOX8] = {MSR_UNC_V3_C8_PMON_BOX_CTL, MSR_UNC_V3_C8_PMON_BOX_STATUS, MSR_UNC_V3_C8_PMON_BOX_STATUS, 11, 0, 0, 48, MSR_UNC_V3_C8_PMON_BOX_FILTER0, MSR_UNC_V3_C8_PMON_BOX_FILTER1},
    [CBOX9] = {MSR_UNC_V3_C9_PMON_BOX_CTL, MSR_UNC_V3_C9_PMON_BOX_STATUS, MSR_UNC_V3_C9_PMON_BOX_STATUS, 12, 0, 0, 48, MSR_UNC_V3_C9_PMON_BOX_FILTER0, MSR_UNC_V3_C9_PMON_BOX_FILTER1},
    [CBOX10] = {MSR_UNC_V3_C10_PMON_BOX_CTL, MSR_UNC_V3_C10_PMON_BOX_STATUS, MSR_UNC_V3_C10_PMON_BOX_STATUS, 13, 0, 0, 48, MSR_UNC_V3_C10_PMON_BOX_FILTER0, MSR_UNC_V3_C10_PMON_BOX_FILTER1},
    [CBOX11] = {MSR_UNC_V3_C11_PMON_BOX_CTL, MSR_UNC_V3_C11_PMON_BOX_STATUS, MSR_UNC_V3_C11_PMON_BOX_STATUS, 14, 0, 0, 48, MSR_UNC_V3_C11_PMON_BOX_FILTER0, MSR_UNC_V3_C11_PMON_BOX_FILTER1},
    [CBOX12] = {MSR_UNC_V3_C12_PMON_BOX_CTL, MSR_UNC_V3_C12_PMON_BOX_STATUS, MSR_UNC_V3_C12_PMON_BOX_STATUS, 15, 0, 0, 48, MSR_UNC_V3_C12_PMON_BOX_FILTER0, MSR_UNC_V3_C12_PMON_BOX_FILTER1},
    [CBOX13] = {MSR_UNC_V3_C13_PMON_BOX_CTL, MSR_UNC_V3_C13_PMON_BOX_STATUS, MSR_UNC_V3_C13_PMON_BOX_STATUS, 16, 0, 0, 48, MSR_UNC_V3_C13_PMON_BOX_FILTER0, MSR_UNC_V3_C13_PMON_BOX_FILTER1},
    [CBOX14] = {MSR_UNC_V3_C14_PMON_BOX_CTL, MSR_UNC_V3_C14_PMON_BOX_STATUS, MSR_UNC_V3_C14_PMON_BOX_STATUS, 17, 0, 0, 48, MSR_UNC_V3_C14_PMON_BOX_FILTER0, MSR_UNC_V3_C14_PMON_BOX_FILTER1},
    [CBOX15] = {MSR_UNC_V3_C15_PMON_BOX_CTL, MSR_UNC_V3_C15_PMON_BOX_STATUS, MSR_UNC_V3_C15_PMON_BOX_STATUS, 18, 0, 0, 48, MSR_UNC_V3_C15_PMON_BOX_FILTER0, MSR_UNC_V3_C15_PMON_BOX_FILTER1},
    [CBOX16] = {MSR_UNC_V3_C16_PMON_BOX_CTL, MSR_UNC_V3_C16_PMON_BOX_STATUS, MSR_UNC_V3_C16_PMON_BOX_STATUS, 19, 0, 0, 48, MSR_UNC_V3_C16_PMON_BOX_FILTER0, MSR_UNC_V3_C16_PMON_BOX_FILTER1},
    [CBOX17] = {MSR_UNC_V3_C17_PMON_BOX_CTL, MSR_UNC_V3_C17_PMON_BOX_STATUS, MSR_UNC_V3_C17_PMON_BOX_STATUS, 20, 0, 0, 48, MSR_UNC_V3_C17_PMON_BOX_FILTER0, MSR_UNC_V3_C17_PMON_BOX_FILTER1},
    [CBOX18] = {MSR_UNC_V3_C18_PMON_BOX_CTL, MSR_UNC_V3_C18_PMON_BOX_STATUS, MSR_UNC_V3_C18_PMON_BOX_STATUS, 21, 0, 0, 48, MSR_UNC_V3_C18_PMON_BOX_FILTER0, MSR_UNC_V3_C18_PMON_BOX_FILTER1},
    [CBOX19] = {MSR_UNC_V3_C19_PMON_BOX_CTL, MSR_UNC_V3_C19_PMON_BOX_STATUS, MSR_UNC_V3_C19_PMON_BOX_STATUS, 22, 0, 0, 48, MSR_UNC_V3_C19_PMON_BOX_FILTER0, MSR_UNC_V3_C19_PMON_BOX_FILTER1},
    [CBOX20] = {MSR_UNC_V3_C20_PMON_BOX_CTL, MSR_UNC_V3_C20_PMON_BOX_STATUS, MSR_UNC_V3_C20_PMON_BOX_STATUS, 23, 0, 0, 48, MSR_UNC_V3_C20_PMON_BOX_FILTER0, MSR_UNC_V3_C20_PMON_BOX_FILTER1},
    [CBOX21] = {MSR_UNC_V3_C21_PMON_BOX_CTL, MSR_UNC_V3_C21_PMON_BOX_STATUS, MSR_UNC_V3_C21_PMON_BOX_STATUS, 24, 0, 0, 48, MSR_UNC_V3_C21_PMON_BOX_FILTER0, MSR_UNC_V3_C21_PMON_BOX_FILTER1},
    [CBOX22] = {MSR_UNC_V3_C22_PMON_BOX_CTL, MSR_UNC_V3_C22_PMON_BOX_STATUS, MSR_UNC_V3_C22_PMON_BOX_STATUS, 25, 0, 0, 48, MSR_UNC_V3_C22_PMON_BOX_FILTER0, MSR_UNC_V3_C22_PMON_BOX_FILTER1},
    [CBOX23] = {MSR_UNC_V3_C23_PMON_BOX_CTL, MSR_UNC_V3_C23_PMON_BOX_STATUS, MSR_UNC_V3_C23_PMON_BOX_STATUS, 26, 0, 0, 48, MSR_UNC_V3_C23_PMON_BOX_FILTER0, MSR_UNC_V3_C23_PMON_BOX_FILTER1},
    [CBOX24] = {MSR_UNC_V3_C24_PMON_BOX_CTL, MSR_UNC_V3_C24_PMON_BOX_STATUS, MSR_UNC_V3_C24_PMON_BOX_STATUS, 27, 0, 0, 48, MSR_UNC_V3_C24_PMON_BOX_FILTER0, MSR_UNC_V3_C24_PMON_BOX_FILTER1},
    [CBOX25] = {MSR_UNC_V3_C25_PMON_BOX_CTL, MSR_UNC_V3_C25_PMON_BOX_STATUS, MSR_UNC_V3_C25_PMON_BOX_STATUS, 28, 0, 0, 48, MSR_UNC_V3_C25_PMON_BOX_FILTER0, MSR_UNC_V3_C25_PMON_BOX_FILTER1},
    [CBOX26] = {MSR_UNC_V3_C26_PMON_BOX_CTL, MSR_UNC_V3_C26_PMON_BOX_STATUS, MSR_UNC_V3_C26_PMON_BOX_STATUS, 29, 0, 0, 48, MSR_UNC_V3_C26_PMON_BOX_FILTER0, MSR_UNC_V3_C26_PMON_BOX_FILTER1},
    [CBOX27] = {MSR_UNC_V3_C27_PMON_BOX_CTL, MSR_UNC_V3_C27_PMON_BOX_STATUS, MSR_UNC_V3_C27_PMON_BOX_STATUS, 30, 0, 0, 48, MSR_UNC_V3_C27_PMON_BOX_FILTER0, MSR_UNC_V3_C27_PMON_BOX_FILTER1},
    [IBOX0] = {MSR_UNC_SKX_II0_CBDMA_BOX_CTL, MSR_UNC_SKX_II0_CBDMA_BOX_STATUS, MSR_UNC_SKX_II0_CBDMA_BOX_STATUS, 56, 0, 0, 48},
    [IBOX1] = {MSR_UNC_SKX_II0_PCIE0_BOX_CTL, MSR_UNC_SKX_II0_PCIE0_BOX_STATUS, MSR_UNC_SKX_II0_PCIE0_BOX_STATUS, 57, 0, 0, 48},
    [IBOX2] = {MSR_UNC_SKX_II0_PCIE1_BOX_CTL, MSR_UNC_SKX_II0_PCIE1_BOX_STATUS, MSR_UNC_SKX_II0_PCIE1_BOX_STATUS, 58, 0, 0, 48},
    [IBOX3] = {MSR_UNC_SKX_II0_PCIE2_BOX_CTL, MSR_UNC_SKX_II0_PCIE2_BOX_STATUS, MSR_UNC_SKX_II0_PCIE2_BOX_STATUS, 59, 0, 0, 48},
    [IBOX4] = {MSR_UNC_SKX_II0_MCP0_BOX_CTL, MSR_UNC_SKX_II0_MCP0_BOX_STATUS, MSR_UNC_SKX_II0_MCP0_BOX_STATUS, 60, 0, 0, 48},
    [IBOX5] = {MSR_UNC_SKX_II0_MCP1_BOX_CTL, MSR_UNC_SKX_II0_MCP1_BOX_STATUS, MSR_UNC_SKX_II0_MCP1_BOX_STATUS, -1, 0, 0, 48},
    [IBOX0FIX] = {0, 0, 0, -1, 0, 0, 36},
    [IBOX1FIX] = {0, 0, 0, -1, 0, 0, 36},
    [IBOX2FIX] = {0, 0, 0, -1, 0, 0, 36},
    [IBOX3FIX] = {0, 0, 0, -1, 0, 0, 36},
    [IBOX4FIX] = {0, 0, 0, -1, 0, 0, 36},
    [IBOX5FIX] = {0, 0, 0, -1, 0, 0, 36},
    [EUBOX0] = {MSR_UNC_SKX_IRP_CBDMA_BOX_CTL, MSR_UNC_SKX_IRP_CBDMA_BOX_STATUS, MSR_UNC_SKX_IRP_CBDMA_BOX_STATUS, 56, 0, 0, 48},
    [EUBOX1] = {MSR_UNC_SKX_IRP_PCIE0_BOX_CTL, MSR_UNC_SKX_IRP_PCIE0_BOX_STATUS, MSR_UNC_SKX_IRP_PCIE0_BOX_STATUS, 57, 0, 0, 48},
    [EUBOX2] = {MSR_UNC_SKX_IRP_PCIE1_BOX_CTL, MSR_UNC_SKX_IRP_PCIE1_BOX_STATUS, MSR_UNC_SKX_IRP_PCIE1_BOX_STATUS, 58, 0, 0, 48},
    [EUBOX3] = {MSR_UNC_SKX_IRP_PCIE2_BOX_CTL, MSR_UNC_SKX_IRP_PCIE2_BOX_STATUS, MSR_UNC_SKX_IRP_PCIE2_BOX_STATUS, 59, 0, 0, 48},
    [EUBOX4] = {MSR_UNC_SKX_IRP_MCP0_BOX_CTL, MSR_UNC_SKX_IRP_MCP0_BOX_STATUS, MSR_UNC_SKX_IRP_MCP0_BOX_STATUS, 60, 0, 0, 48},
    [EUBOX5] = {MSR_UNC_SKX_IRP_MCP1_BOX_CTL, MSR_UNC_SKX_IRP_MCP1_BOX_STATUS, MSR_UNC_SKX_IRP_MCP1_BOX_STATUS, 56, 0, 0, 48},
};

static PciDevice skylakeX_pci_devices[MAX_NUM_PCI_DEVICES] = {
 [MSR_DEV] = {NODEVTYPE, "", "", ""},
 [PCI_IMC_DEVICE_0_CH_0] = {IMC, "0a.2", "PCI_IMC_DEVICE_CH_0", "MBOX0", 0x2042},
 [PCI_IMC_DEVICE_0_CH_1] = {IMC, "0a.6", "PCI_IMC_DEVICE_CH_1", "MBOX1", 0x2046},
 [PCI_IMC_DEVICE_0_CH_2] = {IMC, "0b.2", "PCI_IMC_DEVICE_CH_2", "MBOX2", 0x204a},
 [PCI_IMC_DEVICE_1_CH_0] = {IMC, "0c.2", "PCI_IMC_DEVICE_CH_0", "MBOX3", 0x2042},
 [PCI_IMC_DEVICE_1_CH_1] = {IMC, "0c.6", "PCI_IMC_DEVICE_CH_1", "MBOX4", 0x2046},
 [PCI_IMC_DEVICE_1_CH_2] = {IMC, "0d.2", "PCI_IMC_DEVICE_CH_2", "MBOX5", 0x204a},
 [PCI_QPI_DEVICE_PORT_0] = {QPI, "0e.0", "PCI_QPI_DEVICE_PORT_0", "SBOX0", 0x2058},
 [PCI_QPI_DEVICE_PORT_1] = {QPI, "0f.0", "PCI_QPI_DEVICE_PORT_1", "SBOX1", 0x2058},
 [PCI_QPI_DEVICE_PORT_2] = {QPI, "10.0", "PCI_QPI_DEVICE_PORT_2", "SBOX1", 0x2058},
 [PCI_R3QPI_DEVICE_LINK_0] = {R3QPI, "12.0", "PCI_R3QPI_DEVICE_LINK_0", "RBOX0", 0x204c},
 [PCI_R3QPI_DEVICE_LINK_1] = {R3QPI, "12.1", "PCI_R3QPI_DEVICE_LINK_1", "RBOX1", 0x204d},
 [PCI_R3QPI_DEVICE_LINK_2] = {R3QPI, "12.4", "PCI_R3QPI_DEVICE_LINK_2", "RBOX2", 0x204c},
 [PCI_HA_DEVICE_0] = {HA, "08.0", "PCI_M2M_DEVICE_0", "BBOX0", 0x2066},
 [PCI_HA_DEVICE_1] = {HA, "09.0", "PCI_M2M_DEVICE_1", "BBOX1", 0x2066},
};

static char* skylakeX_translate_types[NUM_UNITS] = {
    [FIXED] = "/sys/bus/event_source/devices/cpu",
    [PMC] = "/sys/bus/event_source/devices/cpu",
    [POWER] = "/sys/bus/event_source/devices/power",
    [MBOX0] = "/sys/bus/event_source/devices/uncore_imc_0",
    [MBOX1] = "/sys/bus/event_source/devices/uncore_imc_1",
    [MBOX2] = "/sys/bus/event_source/devices/uncore_imc_2",
    [MBOX3] = "/sys/bus/event_source/devices/uncore_imc_3",
    [MBOX4] = "/sys/bus/event_source/devices/uncore_imc_4",
    [MBOX5] = "/sys/bus/event_source/devices/uncore_imc_5",
    [MBOX6] = "/sys/bus/event_source/devices/uncore_imc_6",
    [MBOX7] = "/sys/bus/event_source/devices/uncore_imc_7",
    [CBOX0] = "/sys/bus/event_source/devices/uncore_cha_0",
    [CBOX1] = "/sys/bus/event_source/devices/uncore_cha_1",
    [CBOX2] = "/sys/bus/event_source/devices/uncore_cha_2",
    [CBOX3] = "/sys/bus/event_source/devices/uncore_cha_3",
    [CBOX4] = "/sys/bus/event_source/devices/uncore_cha_4",
    [CBOX5] = "/sys/bus/event_source/devices/uncore_cha_5",
    [CBOX6] = "/sys/bus/event_source/devices/uncore_cha_6",
    [CBOX7] = "/sys/bus/event_source/devices/uncore_cha_7",
    [CBOX8] = "/sys/bus/event_source/devices/uncore_cha_8",
    [CBOX9] = "/sys/bus/event_source/devices/uncore_cha_9",
    [CBOX10] = "/sys/bus/event_source/devices/uncore_cha_10",
    [CBOX11] = "/sys/bus/event_source/devices/uncore_cha_11",
    [CBOX12] = "/sys/bus/event_source/devices/uncore_cha_12",
    [CBOX13] = "/sys/bus/event_source/devices/uncore_cha_13",
    [CBOX14] = "/sys/bus/event_source/devices/uncore_cha_14",
    [CBOX15] = "/sys/bus/event_source/devices/uncore_cha_15",
    [CBOX16] = "/sys/bus/event_source/devices/uncore_cha_16",
    [CBOX17] = "/sys/bus/event_source/devices/uncore_cha_17",
    [CBOX18] = "/sys/bus/event_source/devices/uncore_cha_18",
    [CBOX19] = "/sys/bus/event_source/devices/uncore_cha_19",
    [CBOX20] = "/sys/bus/event_source/devices/uncore_cha_20",
    [CBOX21] = "/sys/bus/event_source/devices/uncore_cha_21",
    [CBOX22] = "/sys/bus/event_source/devices/uncore_cha_22",
    [CBOX23] = "/sys/bus/event_source/devices/uncore_cha_23",
    [CBOX24] = "/sys/bus/event_source/devices/uncore_cha_24",
    [CBOX25] = "/sys/bus/event_source/devices/uncore_cha_25",
    [CBOX26] = "/sys/bus/event_source/devices/uncore_cha_26",
    [CBOX27] = "/sys/bus/event_source/devices/uncore_cha_27",
    [BBOX0] = "/sys/bus/event_source/devices/uncore_m2m_0",
    [BBOX1] = "/sys/bus/event_source/devices/uncore_m2m_1",
    [WBOX] = "/sys/bus/event_source/devices/uncore_pcu",
    [SBOX0] = "/sys/bus/event_source/devices/uncore_upi_0",
    [SBOX1] = "/sys/bus/event_source/devices/uncore_upi_1",
    [SBOX2] = "/sys/bus/event_source/devices/uncore_upi_2",
    [RBOX0] = "/sys/bus/event_source/devices/uncore_m3upi_0",
    [RBOX1] = "/sys/bus/event_source/devices/uncore_m3upi_1",
    [RBOX2] = "/sys/bus/event_source/devices/uncore_m3upi_2",
    [UBOX] = "/sys/bus/event_source/devices/uncore_ubox",
    [UBOXFIX] = "/sys/bus/event_source/devices/uncore_ubox",
};
