/*************************************************************************
 Persistance of Vision Raytracer V3.5 World definition file.

           RANDOM 3D GENERATOR MACRO FOR POV-Ray 3.5
      Places any number of objects randomly in a 3D space
      
 Created by: Thomas de Groot (the Netherlands)
             Freely based upon snow-3.pov by Paul T. Dawson (1999)
     e-mail: t.degroot@inter.nl.net
         On: 25 December 2000;
    updated: 06 January 2001, July 2003, December 2004
  Copyright: May be freely used and modified.
             Acknowledgement of authors is appreciated.
 *************************************************************************/

#include "rand.inc"
global_settings {
  noise_generator 2
}

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
//
// Run the macro as standalone. Else, in your scene, declare Standalone as false before including and calling the macro.

#ifndef (Standalone)     #declare Standalone = true;          #end

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
//
// Macro definion.
/*
Goal       = true: cubical space; false: spherical space
GoalArea   = true: draws the boundary cube
SpaLi      = boundary limits
Number     = number of objects
SeedNumber = a number for the random generator 
MaxRot     = maximum and minimum rotation in x- and z-directions (y=360)
MinScale   = minimum scaling of the object
MaxScale   = maximum scaling of the object
Moray      = true: if you want to use the macro in Moray
Trans      = a final, vector translation of the group
*/

#macro RandObject (Goal, GoalArea, SpaLi, Number, SeedNumber, MaxRot, MinScale, MaxScale, Moray, Trans)
////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
//
// These cylinders outline the "goal" area.

#if (GoalArea=true)
  #local Space =
      union {
        
        cylinder { < -SpaLi, -SpaLi, -SpaLi > <  SpaLi, -SpaLi, -SpaLi >, SpaLi/100 }
        cylinder { < -SpaLi,  SpaLi, -SpaLi > <  SpaLi,  SpaLi, -SpaLi >, SpaLi/100 }
        cylinder { < -SpaLi, -SpaLi,  SpaLi > <  SpaLi, -SpaLi,  SpaLi >, SpaLi/100 }
        cylinder { < -SpaLi,  SpaLi,  SpaLi > <  SpaLi,  SpaLi,  SpaLi >, SpaLi/100 }

        cylinder { < -SpaLi, -SpaLi, -SpaLi > < -SpaLi, -SpaLi,  SpaLi >, SpaLi/100 }
        cylinder { < -SpaLi,  SpaLi, -SpaLi > < -SpaLi,  SpaLi,  SpaLi >, SpaLi/100 }
        cylinder { <  SpaLi, -SpaLi, -SpaLi > <  SpaLi, -SpaLi,  SpaLi >, SpaLi/100 }
        cylinder { <  SpaLi,  SpaLi, -SpaLi > <  SpaLi,  SpaLi,  SpaLi >, SpaLi/100 }

        cylinder { < -SpaLi, -SpaLi, -SpaLi > < -SpaLi,  SpaLi, -SpaLi >, SpaLi/100 }
        cylinder { <  SpaLi, -SpaLi, -SpaLi > <  SpaLi,  SpaLi, -SpaLi >, SpaLi/100 }
        cylinder { < -SpaLi, -SpaLi,  SpaLi > < -SpaLi,  SpaLi,  SpaLi >, SpaLi/100 }
        cylinder { <  SpaLi, -SpaLi,  SpaLi > <  SpaLi,  SpaLi,  SpaLi >, SpaLi/100 }

        pigment { rgb <1,0,0> }
      }
#end

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
//
// Call the gull macro here.

#declare Standalone = false;
#include "Thomas de Groot\MicksGull\Tdg_FlyingGull_mcr2.inc"

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
//
// Start the main loop here. We put all of the
// objects into one big union object.

#local R = seed (SeedNumber);
#local R2 = seed (SeedNumber);
#local Group = 
union {
#local LOOP = 1; 
 #while (LOOP <= Number)

   #local Internal = int(RRand(0,748392493,R2));
   FlyingGull(FeatherTex, false, Internal)
   object {Gull
     scale RRand(MinScale,MaxScale,R)
     rotate <RRand(-MaxRot, MaxRot, R), rand(R)*360, RRand(-MaxRot, MaxRot, R)>
     #if (Goal)
       translate VRand_In_Box(<-SpaLi, -SpaLi, -SpaLi>, <SpaLi, SpaLi, SpaLi>, R)
     #else
       translate VRand_In_Sphere(R)*SpaLi
     #end
   }

   #local LOOP = LOOP + 1;

 #end // End the loop.

} // End of union.

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
//
// Show the "goal" area.

#if (GoalArea=true) 
 #declare RandomGroup =
  union {
   object {Group}
   object {Space} 
  }
#else
 #declare RandomGroup = object {Group}
#end

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
//
// Transform for Moray.

#if (Moray)
 #declare RandomGroup =
   object {RandomGroup
     scale <1,1,-1>
     rotate <90,0,0>
   }
#end

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
//
// Final translate.

#declare RandomGroup =
  object {RandomGroup
    translate Trans
  }


#end // end of the macro

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
//
// Definitions:
/*
Goal       = true: cubical space; false: spherical space
GoalArea   = true: draws the boundary cube
SpaLi      = boundary limits
Number     = number of objects
SeedNumber = a number for the random generator 
MaxRot     = maximum and minimum rotation in x- and z-directions (y=360)
MinScale   = minimum scaling of the object
MaxScale   = maximum scaling of the object
Moray      = true: if you want to use the macro in Moray
Trans      = a final, vector translation of the group
*/

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
//
// Now display the group.

#if (Standalone)
#include "colors.inc"
#include "textures.inc"
background { Gray50 }
camera {
 location <-210, 0, -290> 
 look_at <0, 0, 0> 
 right x*image_width/image_height
 angle 50
}
#default { finish { Luminous } }
// create a regular point light source
light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1>    // light's color
  translate <-200, 200, -200>
}

// Note: original wingspan about 5 POV units.

// usage:
// RandObject (Goal, GoalArea, SpaLi, Number, SeedNumber, MaxRot, MinScale, MaxScale, Moray, Trans)
RandObject (true, true, 100, 20, 56473, 30, 0.5, 1.5, false, <0,0,0>)

object { RandomGroup }

#end // end of Standalone

// That's all there is to it!

// Bye!

