//  Persistence of Vision Raytracer V3.5
//  World definition file.
//
//  Contains 1 lights, 3 materials and 16 primitives.
//
//  This file was generated for POV-Ray V3.5 by
//  Moray V3.5 For Windows Copyright (c) 1993-2003 Lutz + Kretzschmar
//

//  Date : 10/10/2006    (10.10.2006)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

//
// ********  MATERIALS  *******
//

#declare DMFWood4 = 
   material {   
      texture {      
         pigment {
            wood
            color_map {
               [ 0.0     rgbft <0.888, 0.6, 0.3, 0.0, 0.0>*0.1 ]
               [ 0.1     rgbft <0.888, 0.6, 0.3, 0.0, 0.0>*0.1 ]
               [ 0.9     rgbft <0.6, 0.4, 0.2, 0.0, 0.0>*0.1 ]
               [ 1.0     rgbft <0.6, 0.4, 0.2, 0.0, 0.0>*0.1 ]
            }
            turbulence 0.04
            octaves 3
            ramp_wave
            scale  <0.05, 0.05, 1.0>
         }
         normal {
           wood, 1
           scale <0.005, 0.05, 1.0>
         }
      }
   }

#declare TdG_Rusty_Iron = 
   material {   
      texture {      
         pigment {
            granite
            color_map {
               [ 0.0     rgbft <0.42, 0.2, 0.2, 0.0, 0.0>*0.1 ]
               [ 0.3879  rgbft <0.593733, 0.302067, 0.02, 0.0, 0.0>*0.1 ]
               [ 0.508897  rgbft <0.5104, 0.2, 0.2, 0.0, 0.0>*0.1 ]
               [ 0.654804  rgbft <0.3, 0.2, 0.2, 0.0, 0.0>*0.1 ]
               [ 1.0     rgbft <0.3, 0.2, 0.2, 0.0, 0.0>*0.1 ]
            }
         }      
         normal {
            granite , 1.0
            bump_size 0.5
            scale  <0.08, 0.07, 0.06>
         }      
      }
   }

//
// ********  OBJECTS  *******
//

#declare P_AnkerHand1 = intersection {
  cylinder { // Cylndr079
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <1.0, 1.0, 0.2>
    translate  0.5*y
  }
  cylinder { // Cylndr080
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <1.0, 1.0, 0.2>
    translate  -0.5*y
  }
  box { // Cube064
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*x
    photons {
      collect off
    }
    scale <0.5, 0.5, 0.05>
  }
  bounded_by { // Bound00007
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      photons {
        collect off
      }
      scale <1.034667, 1.534667, 0.134667>
      translate  0.0*x
    }
  }
  photons {
    collect off
  }
  rotate -33.099998*y
  translate  <0.878, 0.0, 0.43>
}
#declare P_AnkerHand2 = intersection {
  cylinder { // Cylndr085
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <1.0, 1.0, 0.2>
    translate  0.5*y
  }
  cylinder { // Cylndr086
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <1.0, 1.0, 0.2>
    translate  -0.5*y
  }
  box { // Cube065
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*x
    photons {
      collect off
    }
    scale <0.5, 0.5, 0.05>
  }
  bounded_by { // Bound00008
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      photons {
        collect off
      }
      scale <1.034667, 1.534667, 0.134667>
      translate  0.0*x
    }
  }
  photons {
    collect off
  }
  rotate <0.0, -33.099998, -180.0>
  translate  <-0.878, 0.0, 0.43>
}
#declare P_AnkerArm3 = prism {
  conic_sweep
  linear_spline
  1.0,0.5
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  translate  -1.0*z
  photons {
    collect off
  }
  scale <0.15, 0.15, 2.1>
  rotate <-0.0, -124.865036, -0.0>
  translate  <0.845724, 0.0, 0.365416>
}
#declare P_AnkerArm4 = prism {
  conic_sweep
  linear_spline
  1.0,0.5
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  translate  -1.0*z
  photons {
    collect off
  }
  scale <0.15, 0.15, 2.1>
  rotate <-0.0, -125.127228, -180.0>
  translate  <-0.849967, -0.0, 0.373423>
}
#declare P_AnkerStok1 = prism {
  conic_sweep
  linear_spline
  0.1,0.2
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  rotate <-0.0, -0.0, 0.0>
  photons {
    collect off
  }
  scale <1.0, 1.0, 23.0>
  rotate <-90.0, -90.0, 0.0>
  translate  <0.0, -4.6, 4.0>
  material {
    DMFWood4
    // Transform to world space
    translate  <0.145255, 0.0, -1.870214>
    rotate 156.232727*z rotate -67.157219*y rotate 154.927719*x
  }
}
#declare P_AnkerStok2 = prism {
  conic_sweep
  linear_spline
  0.1,0.2
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  rotate <-0.0, -0.0, 0.0>
  photons {
    collect off
  }
  scale <1.0, 1.0, 23.0>
  rotate <90.0, -0.0, -0.0>
  translate  <0.0, 4.6, 4.0>
  material {
    DMFWood4
    // Transform to world space
    translate  <0.145255, 0.0, -1.870214>
    rotate 156.232727*z rotate -67.157219*y rotate 154.927719*x
  }
}

#declare PlechtAnker =
union { // PlechtAnker
  box { // P_AnkerSchacht
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.15, 2.2>
  }
  torus { // P_AnkerRing
    0.2, 0.05  rotate -x*90
    photons {
      collect off
    }
    rotate -90.0*x
    translate  4.55*z
  }
  object { P_AnkerHand1 }
  box { // P_AnkerArm1
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.48, 0.15, 0.15>
    rotate -14.6*y
  }
  box { // P_AnkerArm2
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.48, 0.15, 0.15>
    rotate <0.0, -14.6, -180.0>
  }
  object { P_AnkerHand2 }
  object { P_AnkerArm3 }
  object { P_AnkerArm4 }
  object { P_AnkerStok1 }
  object { P_AnkerStok2 }
  torus { // P_AnkerKabelRing
    0.4, 0.05  rotate -x*90
    translate  -0.4*y
    photons {
      collect off
    }
    // Scaling fixed
    // Rot X limited (-180.0 to     10.0)
    // Translation fixed
    rotate <-79.700684, -0.0, -90.0>
    translate  <-0.0023, 0.0, 4.599751>
  }
  photons {
    collect off
  }
  rotate <-154.927719, 67.157219, -156.232727>
  translate  <-0.145255, 0.0, 1.870214>
  material {
    TdG_Rusty_Iron
    // Transform to world space
  }
  scale <1,1,-1>
  rotate <90,0,0>
}


