
#version 3.6;

#include "colors.inc"
#include "functions.inc"
#include "textures.inc"
#include "woods.inc"
#include "metals.inc"
#include "transforms.inc"

global_settings {
  assumed_gamma 1.0
}


#version 3.6;

#declare Radiosity=on;
#declare HighQuality=on;

global_settings {
  assumed_gamma 1.0
  //max_trace_level 25
  #if (Radiosity)
    radiosity {
      pretrace_start 0.08           // start pretrace at this size
      pretrace_end   0.04           // end pretrace at this size
      nearest_count 6               // higher -> higher quality (1..10) [5]
      recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
      low_error_factor .5           // reduce error_bound during last pretrace step
      gray_threshold 0.0            // increase for weakening colors (0..1) [0]
      minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
      brightness 1                  // brightness of radiosity effects (0..1) [1]
      adc_bailout 0.01/2
      max_sample 0.5
      
      
      #if (HighQuality)
        count 100                      // higher -> higher quality (1..1600) [35]
        error_bound 0.8               // higher -> smoother, less accurate [1.8]
        brightness 1.2                  // brightness of radiosity effects (0..1) [1]
      #else
        count 40                      // higher -> higher quality (1..1600) [35]
        error_bound 1.8               // higher -> smoother, less accurate [1.8]
      #end 
    }
  #end
}

#default {
  texture {
    pigment {rgb 1}
    #if (Radiosity)
      finish {
        ambient 0.0
        diffuse 0.6
        specular 0.3
      }
    #else
      finish {
        ambient 0.1
        diffuse 0.6
        specular 0.3
      }
    #end
  }
}
   

camera {
  location  <-4.1, 2.4, -4.0>
  look_at   <-1.1, 1.2,  0.0>
}

// **************** Lights ********************


light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <.5, .5, .6>  // light's color
  translate <-8, 7, -8>
}

light_source {
  0*x                 // light's position (translated below)
  color rgb <1,1,.9>       // light's color
  area_light
  <0, 0, 0> <10, 10, 0> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  orient              // orient light
  translate <0, 8, -10>   // <x y z> position of light
} 


// **************** Sky Sphere ********************
 

                  #if (Radiosity)
      sphere {<0,0,0>, 1000
        pigment {
            gradient y
            color_map {
              [0.0 rgb <0.6,0.7,1.0>]
              [0.7 rgb <0.0,0.1,0.8>]
            }
          }
        finish { ambient 1 diffuse 0 }
        no_shadow
    }
    #else
      sky_sphere {
          pigment {
                gradient y
                color_map { [0.0 color rgb <0.7,0.7,1.0>] [1.0 color blue 0.5] }
                }
        }
    #end 

// **************** Macro to place water droplets on bottle ********************

#macro MakeDrops(Obj,Particles,Size,Thickness,MinHeight,MaxHeight,Direction)
    #ifndef (T_Drop)
        #local T_Drop=texture{
            pigment{rgbt <1,1,1,1>}
            finish{reflection .9 phong .3}
        }
    #end
    #ifndef (rd)
        #local rd=seed(2003);
    #end
    #local Obj2=object{Obj Reorient_Trans(-y,<-Direction.x,Direction.y,-Direction.z>)}
    #local Min=min_extent(Obj2);
    #local Max=max_extent(Obj2);
    blob{
        threshold 0.6
        #local i=0;
        #while (i<Particles*2/3) // second layer of smaller particles
            #local Start=<Min.x+rand(rd)*(Max.x-Min.x),(MinHeight+rand(rd)*(MaxHeight-MinHeight))*Max.y,Min.z+rand(rd)*(Max.z-Min.z)>;
            #local Norm=<0,0,0>;
            #local Inter= trace (Obj2, Start, -y, Norm );
            #if (vlength(Norm)!=0)
                #local Angle=pow((180-abs(degrees(acos(min(1,vdot(vnormalize(Norm),y))))))/180,2);
                #local FlakeSize=Angle*<1+rand(rd)*1.3,(Angle*0.5+rand(rd))*Thickness,1+rand(rd)*1.3>;
                sphere{0,Size*2,1 scale FlakeSize*0.25 Reorient_Trans(y,Norm) translate Inter}
                #if (mod(i,1000)=0) 
                    #debug concat(str(i,0,0),"\n")
                #end
                #local i=i+1;
            #end
        #end 
        texture{T_Drop}
        interior {
                 ior 1.33
            }
        Reorient_Trans(<-Direction.x,Direction.y,-Direction.z>,-y)
    }
#end

// **************** Tablecloth ********************


#declare Cloth = texture {
  uv_mapping 
  pigment{checker color rgb <.6, .5, 0>,color rgb <0.4, .3, 0>}
  // texture component
  normal { 
          // pattern for use in texture/pigment/normal/density
        // creates a pattern like a quilt
          quilted 0.8 // amount
          control0 -1 // lower curvature (-1...1)
          control1 1  // upper curvature (-1...1)
          scale .05
  }
  finish {
        roughness .9
  }
  scale<1,.5,1>   
}
#declare fn_pattern=
function {
   pattern { bumps scale <5,1,1> scale .4 rotate y*-45 }
}


  isosurface {
    function {y + fn_pattern(x,y,z)/4 * max((y*y-1),(x*x-1),(z*z-1))/10 }
    max_gradient 5
    contained_by { box {<-5,-1,-5>,<4,1,4>} }
    texture{Cloth}
    
  }     


// **************** Bowl ********************

#declare bowlouter = sphere {<0,0,0> 2 scale y*.5}
 
#declare bowlinner = sphere {<0,0,0> 1.82 scale y*.3}

#declare bowl = difference{
        object {bowlouter}
        object {bowlinner}
        torus {2,.08 translate <0,.05,0> }
        box {<-2,0,-2> <2,2,2>}
        box {<-2,-4,-2> <2,-.6,2>}
        texture {T_Wood15 finish {phong .1 reflection .1 roughness .5}}
}


// **************** Can ********************


#declare CanTexture = texture {pigment {color rgb <1,0,0>}
                                 finish {
                                        phong .4
                                        reflection .5
                                       }
                              }
#declare DrinkCan = union {

cylinder {
  0*x,  3*y,  1.01
  texture {
        pigment {
                // create a texture that lays an image's colors onto a surface
                // image maps into X-Y plane from <0,0,0> to <1,1,0>
                image_map {
                  png "canpic.png" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
                  map_type 2        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                  interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
                            // for no repetitive tiling
                }
               scale 3
               
       }
       
       finish {phong .5 reflection .2}
  }
}

torus {
  0.9,
  0.101  
  texture {pigment {color rgb <.6,0,0>}
         finish {
                phong .5
                reflection .5
         }
  }
  translate y*3
}

torus {
  0.9,
  0.101  
  texture {T_Chrome_2A}
}

torus {
  0.96,
  0.02  
  texture {T_Chrome_2A}
  translate y*3.1
}

}

// **************** Tube ********************

#declare CardTex = texture {
        pigment { rgb .5}
        finish {crand .05 phong .8}
}

#declare CardTexInner = texture {
        
        pigment { rgb <.6,.6,.5>}
        finish {crand .09 }       
}


#declare TubeInner = difference {
        cylinder {<0,0,0><0,1,0> .098}
        cylinder {<0,-.1,0><0,1.1,0> .096}
        texture {CardTexInner}
}

#declare TubeOuter = difference {
        cylinder {<0,0,0><0,1,0> .1}
        cylinder {<0,-.1,0><0,1.1,0> .098}
        isosurface {
                function { f_helix1(x,y,z,1,4,0.012,0.108,1,0,0) } 
                max_gradient 5               
                scale <1,.5,1>
                translate y*.5              
        }
        texture {CardTex}
}

#declare Tube = union {
                object {TubeOuter}
                object {TubeInner}
}


// **************** Banana ********************

#declare BananaTex = texture {
    pigment {
        granite             
                color_map {
                        [0.1 rgb<.8,.6,.1> ]
                        [0.6  rgb<.05,0,.1>]
                        }
         
        }
    finish {phong .2 specular .4}
}
     
     
     #declare banana_pattern=
function {
   pattern { bumps scale <6,1,1> }
}

#declare BananaSkin =
  isosurface {
    function {y + banana_pattern(x,y,z) }
    max_gradient 5
    contained_by { box {<-2.7,-.52,-1.7>,<1.5,1,1.5>} }   
  }     

#declare FullBanana = union {            
       object {difference {
                       object {BananaSkin}
                       box {<-3,-2,-2><.9,0,2>}
                       rotate z*90 
                       translate <1,-2,0>
              }
       }
       
       object {difference {
                       object {BananaSkin}
                       box {<-3,-2,-2><0,0,2>}
              }
       }
            
       object {difference {
                        object {BananaSkin}
                        box {<0,-2,-2><3,0,2>}
                   }
                   rotate z*-87.8
                   translate <.5,-.5,0>
                   
       }
       
       texture{BananaTex}
}          


// **************** Apple ********************

#declare CoreTex = texture {
    pigment {
        granite             
                color_map {
                        [0.1 rgb<.2,.1,.1> ]
                        [0.6  rgb<.3,.2,.1>]
                        }
         
        }
   scale .4
}

#declare AppleSkinTex = texture {
    pigment{ granite
        color_map {[0.0 color rgb<0,.8,.1>]  
                   [0.5 color rgb<0,.7,.1>]
                   [1.0 color rgb<0,.8,.1>]}
                  }
         
   finish {phong .3 }
   normal { bumps .6}
}

#declare AppleInnerTex = texture {
    pigment {
        granite             
        color_map {
                [0.1 rgb<.8,.8,.2> ]
                [0.6  rgb<.8,.6,.4>]
                }   
        }
        finish { specular .3 crand .05}
     
   scale 15
}



#declare CoreF=function{pigment{
  bumps 
  turbulence 0.2
  color_map { [0 rgb 1] [1 rgb 0] }
  scale 0.5
  }
}

#declare  T = function {f_torus(x,y,z,1.6,0.6)}
#declare CoreSurface =
isosurface {
        function { x*x + y*y +z*z -1
        - CoreF(x,y,z).grey*0.8 
        - T(x,y*2,z) *1.5 
        + T(x,y*2,z) *1.5
        }
        max_gradient 5
        contained_by{sphere{0,2}}
        
}


#declare apple_pattern=
function {
   pattern { bumps scale .6 }
}        

#declare F=function{pigment{
  bumps 
  turbulence 0.1
  color_map { [0 rgb 1] [1 rgb 0] }
  scale 0.5
  }
}  

#declare MainAppleShape = function {f_torus(x,y/2,z,1,.8)}
#declare EatenApple = function {f_torus(x,y/2,z,1.9,.9) + F(x,y,z).grey*.55}

#declare MainAppleSurface =
isosurface {
        function {MainAppleShape(x,y,z)}
        max_gradient 5
        contained_by{sphere{0,2}}
       
}

#declare AppleSurface =
isosurface {
        function {max(MainAppleShape(x,y,z), - EatenApple(x,y,z))}
        max_gradient 5
        contained_by{sphere{0,2}}       
}

#declare AppleSkin = difference {object{AppleSurface}
                                 object{MainAppleSurface} scale .98
                                }
                           

#declare core = object {CoreSurface texture {CoreTex}}

#declare Apple = union {
        object {AppleSurface texture{AppleInnerTex}}
        object {AppleSkin texture{AppleSkinTex} translate y*.02 scale 1.02}
        object {core scale <.04,1,.05> rotate x*10 translate y*1.2}
}  


// **************** Bottle ********************

#declare BottleTex =  texture {
        pigment{ rgbf <1.0, 1.0, 1.0, 0.95> }
        finish { reflection {0.08} phong .4 }
        }
                        
#declare  TB = function {f_torus(x,y,z,1.6,0.6)}

#declare BottleBaseSolid =
isosurface {
        function { x*x + y*y +z*z -1
        + TB(x,y*2,z)
        }
        max_gradient 10
        contained_by{box{-2,<2,0,2>}}
        
}

#declare BottleSection1 = difference {
        cylinder {<0,0,0> <0,.5,0> 1}
        cylinder {<0,-.1,0> <0,.55,0> .98}
}

#declare BottleSection2 = difference {
        cylinder {<0,.5,0> <0,.6,0> .95}
        cylinder {<0,.4,0> <0,.65,0> .9}
}

#declare BottleTop = union {

        sor {
            7,
            <0.21, 0.0>
            <0.62, 0.54>
            <0.24, 0.82>
            <0.26, 0.95>
            <0.26 ,1.1>
            <0.25, 1.12>
            <0.28, 1.3>
            open
        }
        
        
        isosurface {
                function { f_helix1(x,y,z,1,10,0.05,0.5,1,1,45) }
                max_gradient 5
                scale <.5,.07,.5>
                translate y*1.02                
        }
}

#declare BottleSection = union {
        object {BottleSection1}
        object {BottleSection2}
}

#declare BottleBase = difference {
        object {BottleBaseSolid}
        object {BottleBaseSolid scale .9 translate y*-.1}
}

#declare Bottle = union {
        object {BottleBase}
        object {BottleSection}
        object {BottleSection translate y*.601}
        object {BottleSection translate y*1.201}
        object {BottleSection translate y*1.801}
        object {BottleSection translate y*2.401}
        object {BottleSection translate y*3.001}
        object {BottleTop scale <1.51,2,1.51> translate y*2.53}
}

#declare BottleDrops = union {
        object{MakeDrops(Bottle,300,.2,.2,0,3,<0,1,.3>)}
        object{Bottle 
                texture {BottleTex} 
                interior {
                    ior 1.31              // index of refraction
                    fade_power 1001       // values larger than 1000 give realistic exponential attenuation
                    fade_distance 3       // distance where light reaches half intensity
                  }           
              }
}                                         

// **************** Paper ********************

#declare ScruF=function{pigment{
  crackle 
  turbulence 0.1
  color_map { [0 rgb 1] [1 rgb 0] }
  scale 0.5
  }
}

#declare Scrunch = isosurface {
        function { x*x + y*y +z*z -1
           + ScruF(x,y,z).grey*0.55 }
        max_gradient 3.5
        contained_by{sphere{0,1}}
        pigment {rgb .9}
}


// **************** Sandwich Wrapper ********************

#declare TexCrumbs = texture {
        pigment {
                        granite
                        color_map {
                                [.4 rgb <.5,0.05,0>]
                                [.7 rgb <.55,.1,.1>]
                        }
                }
}

#declare TexClear = texture {
        pigment { rgbt<1,1,1,.85>}
        normal {
                bumps .6
              }
      finish {
         reflection {0.3}
         phong .4
      }
}

#declare SandBoxTex = texture {
        granite
        texture_map {
                [.7 TexClear]
                [.8 TexCrumbs]

        }
                             
  }

#declare CrumF=function{pigment{
  crackle 
  turbulence 0.8
  color_map { [0 rgb 1] [1 rgb 0] }
  scale .1
  }
}

#declare Crumbs = isosurface {
        function {
           y - CrumF(x*5,y*5,z*5).grey*.05}
        max_gradient 4
        contained_by{box{<0.01,0.01,0.01>,<.099,.1,.199>}}
}

#declare SandBoxLid = bicubic_patch {
          type 1 // patch_type (0..1)
          flatness 0.08 // flatness value
          u_steps 4
          v_steps 4
          <0, 0, 0> <2, 0, -1.6> <4, 0, -2.1>   <6, 0, -2.8>
          <0, 1, 0> <2, 1, -1.5> <4, 1, -2.0> <6, 1, -2.6>
          <0, 2, 0> <2, 2, -1.5> <4, 2, -1.9>   <6, 2, -2.3>
          <0, 3, 0> <2, 3, -1.3> <4, 3, -1.6>   <6, 3, -2>
          
          texture {SandBoxTex}
          interior {
                ior 1.02
          }          
          rotate x*90
          rotate y*90
          scale .17
          translate y*1
        }
                
#declare SandBox = difference {
               
              box {<0,0,0><1,1,1>}
              box {<0,0,0><1,1,1> scale .99 translate <0,.01,.01>}
              box {<-.1,0,0><1,1,2> scale 1.2 rotate x*45 translate y*1}
              scale x*.5
              texture {SandBoxTex scale .3}
                             
              interior {
                 ior 1.02
              }
              
        }

#declare SandBoxAll = union { 
        object {SandBox}
        object {SandBoxLid}
        object {
                Crumbs
                pigment {
                        rgb <.5,.05,0>     
                }
                scale <5,1,4.9>               
       }
}

// **************** Sweet Wrapper ********************

#declare P = function {pow(x,2) + y-1}
#declare SN = function { pattern { waves scale <.15,.1,.1> warp {turbulence .2}} }

#declare WrapperBase = isosurface {
            function {abs(P(x,y,z) + SN(x,y,z)) - .01}
            max_gradient 20
            contained_by { box {0,1} }  
}
      
#declare Wrapper = object {
        WrapperBase 

        texture
        {   
            pigment {rgb <1,.1,.1>}
            finish {reflection .8}
        }
       }
       

// **************** Fly ********************

#declare Eye = sphere {<0,0,0> 1
                       scale <1,.6,1>
                       texture {
                        pigment{ color <.1,0,0>}
                        finish {
                                phong .3
                        }
                       }
                      }
                      
#declare BodyBit = sphere {<0,0,0> 1
                       scale <1,1,1.2>
                       texture {
                        pigment{ color <0,0,0>}
                        finish {
                                phong .7
                        }
                       }
                      }

#declare LegBit = sphere {<0,0,0> 1
                       scale <.05,.05,3>
                       texture {
                        pigment{ color <0,0,0>}
                       }
                       rotate x*-30
                      }
 

#declare Wing = sphere {<0,0,0> 1
                       scale <1.6,.05,4>
                       texture {
                        pigment{ color rgbt <.5,.5,.5,.8>}
                        finish {phong.8 reflection .8}
                        normal {bumps .3}
                       }
                       rotate x*-20
                      }
#declare fly = union {                     
         object {Eye}
         object {Eye translate <1,0,0>}                                            
         object {BodyBit scale <1.5,1,1> translate <.5,-.1,.5> }
         object {BodyBit scale <1.5,1,1.5> translate <.5,-.6,3> }
         object {BodyBit scale <2,1,2> translate <.5,-1,4> }
         object {LegBit translate <-1,-1,0>}
         object {LegBit translate <1,-1,0>}                              
         object {LegBit  rotate y*45 translate <-2,-1,2>}
         object {LegBit  rotate y*-45 translate <2,-1,2>}                              
         object {LegBit  rotate y*80 translate <-2,-1,5>}
         object {LegBit  rotate y*-80 translate <2,-1,5>}
         object {Wing translate <-1,1,5>}
         object {Wing translate <1,1,5>}                                                              
 } 

// **************** Carton *********************


#declare CartonLidTex = texture {
        pigment{rgb <1,.2,0>}
        normal {bumps .5 scale .2}
        finish {specular .8}
        }



#declare B = function { max((y*y-1),(x*x-1),(z*z-1)) }
#declare SN1 = function { pattern { bumps scale <.2,.3,3> warp {turbulence .2}} }


#declare CartonBase1 = isosurface {
            function {B(x,y,z) + (SN1(x,y,z) * .4)*(1 - x*x)}
            max_gradient 5
            max_trace 3
            contained_by { box {-1,1} }  
}


#declare CartonMain = difference {      
        object {CartonBase1}
        object {CartonBase1 scale <.98,.97,.97> translate x*.021}
        texture {CartonLidTex}
}
       

#declare Flange1 = object {
        bicubic_patch {
          type 1
          flatness 0.05            
          u_steps 3
          v_steps 3
          <0, 0, 0> <.3, 0, 0> <.6, 0, 0> <1, 0, 0>
          <0, .2, 0> <.3, .2, 0> <.6, .2, .05> <1, .2,  .1>
          <0, .4, 0> <.3, .4, .05> <.6, .4, .1> <1, .4,  .2>
          <0, .6, 0> <.3, .6, .1> <.6, .6, .2> <1, .6, .3>
        }
}

#declare Flange2 = 
prism {                                
  linear_sweep 
  linear_spline
  0, 0.02, 3,
  < 0.0, -.1>, <0.5,  0.0>, < 0.0, 0.5>
}

#declare Flange3 = 
prism {                                
   linear_spline
  0, 0.02, 3,
  <0.0, 0.0>, <0.7, 0.0>, <.44, 0.58>
} 

#declare CartonLid = union {


object {Flange1
        rotate y*-90
        rotate -z*161
        translate<.6,.6,-.51>
        scale z*1.16       
        }
        
object {Flange1
        scale <1,-1,1>
        rotate y*-90
        rotate z*160
        translate<.6,-.6,-.51>
        scale z*1.16
        }

object {Flange2
        rotate x*-120
        rotate y*-62
        translate<.4,0.1,.6>
        }        

object {Flange2
        rotate x*120
        rotate y*-62
        translate<.4,-0.2,.6>
        }
              
object {Flange3
        rotate x*29
        rotate z*-42 
        translate<.53,.6,.48>
        scale z*1.1
        }                        

object {Flange3
        rotate x*-20
        rotate z*42
        translate<.53,-.64,.48>
        scale z*1.1
        }                        

}

#declare Carton = union {
       object {CartonMain 
        texture {
         pigment {
                image_map {
                  png "cartonpic2.png" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
                  map_type 0        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                  interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
                            // for no repetitive tiling
                }
         }
         rotate z*-90
         scale <2,-2,2>
         translate <1,.9,0>
        }
        finish {specular .5}
        scale .6
        translate <0,0,0>}
        
                
        object {CartonLid texture {CartonLidTex}}
}




// **************** Objects ********************


object {fly 
        rotate <10,120,10>
        scale .02
        translate <.85,1.4,-1.05>}
 
object {SandBoxAll
        scale 1.5
        rotate <0,0,92>
        rotate <0,-85,0>
        rotate <0,0,5>
        translate <-2.3,-0,.1>
        }

object {BottleDrops                       
       scale <.6,.75,.6>
        translate <-1.8,0.01,2.05>
       }
        

object {Apple 
           scale .27
           rotate <-40,10,0>
          translate <1,.8,-1>
       }
  
object {FullBanana
           rotate <-70,2,90>
           scale .38
           translate <-.6,.025,-1.83>    
       }          
        
object {Tube
        scale 2.5
        rotate y*140
        rotate z*70
        translate <.6,.8,0>    
}

object {bowl
           translate <.2,.6,.2>    
       }          
  

object {DrinkCan
           scale .45
           rotate <60, -30, 0>
           translate <-.7 ,.4,-.2>    
       }          


object {Scrunch 
         pigment {
                image_map {
                  png "News.png" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
                  map_type 2        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                  interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
                            // for no repetitive tiling
                }
               scale 3
               rotate x*50
               
       }
       scale .7
       translate <.8,1.3,-.1>
}

object {Wrapper
        rotate z*45
        scale <.6,.2,.6>
        rotate x*-15
        translate <.8,-.14,-2.4>
  }
  
object {Carton
        scale .8
        rotate y*190
        rotate z*-30
        translate <-.4,.9,-.9>
  }

// **************** Walls ********************

#declare TiletexBlue = texture
    {
        pigment
        {
            color rgb <0,0,.1>
        }
        normal {bumps .2 scale 10}
        finish {reflection .2 phong .7}
    }

#declare TiletexWhite = texture
    {
        pigment
        {
            color White
        }
        normal {bumps .2}
        finish {reflection .1 phong .4  roughness .1}
    }
    
#declare Tile =superellipsoid
{
    <0.1, 0.25>
    rotate 90*x
    scale <.98,.1,.98>
 
}

#declare TileRow = union {

object {Tile
        rotate x*-90
        translate <-20,0,5.95>
        texture {TiletexBlue}
        }

object {Tile
        rotate x*-90
        translate <-18,0,5.95>
        texture {TiletexBlue}
        }

object {Tile
        rotate x*-90
        translate <-16,0,5.95>
        texture {TiletexBlue}
        }

object {Tile
        rotate x*-90
        translate <-14,0,5.95>
        texture {TiletexBlue}
        }

object {Tile
        rotate x*-90
        translate <-12,0,5.95>
        texture {TiletexBlue}
        }
        
object {Tile
        rotate x*-90
        translate <-10,0,5.95>
        texture {TiletexBlue}
        }

object {Tile
        rotate x*-90
        translate <-8,0,5.95>
        texture {TiletexBlue}
        }

object {Tile
        rotate x*-90
        translate <-6,0,5.95>
        texture {TiletexBlue}
        }
        
object {Tile
        rotate x*-90
        translate <-4,0,5.95>
        texture {TiletexBlue}
        }

object {Tile
        rotate x*-90
        translate <-2,0,5.95>
        texture {TiletexBlue}
        }

object {Tile
        rotate x*-90
        translate <0,0,5.95>
        texture {TiletexBlue}
        }

object {Tile
        rotate x*-90
        translate <2,0,5.95>
        texture {TiletexBlue}
        }

object {Tile
        rotate x*-90
        translate <4,0,5.95>
        texture {TiletexBlue}
        }
        
object {Tile
        rotate x*-90
        translate <6,0,5.95>
        texture {TiletexBlue}
        }
object {Tile
        rotate x*-90
        translate <8,0,5.95>
        texture {TiletexBlue}
        }                                
}

object {Tile
        rotate x*-90
        translate <10,0,5.95>
        texture {TiletexBlue}
        }

object {TileRow translate <.88,-2,0>}
object {TileRow translate <.88,0,0>}
object {TileRow translate <.88,2,0>}
object {TileRow translate <.88,4,0>}
object {TileRow translate <.88,6,0>}

object {TileRow rotate y*90 translate <0,-2,.88>}
object {TileRow rotate y*90 translate <0,0,.88>}
object {TileRow rotate y*90 translate <0,2,.88>}
object {TileRow rotate y*90 translate <0,4,.88>}
object {TileRow rotate y*90 translate <0,6,.88>}

plane {z,5.89  
          texture {
                pigment {color rgb <.8,.8,.8>}
                finish {crand .5}
          }
      }

plane {x,5.89   
          texture {
                  pigment {color rgb <.8,.8,.8>}
                finish {crand .5}
          }
      }
        
// **************** Reflected window and walls ********************
      
difference {
        box {-1,1 scale 15}
        box {-1,1 scale 14.9}
        box {-2,2 translate <-14,5,0>}
        pigment {color rgb .4}
}