// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.6
// Desc: Basic TTF font Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.6;


#include "colors.inc"

global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  location  <0.0, 2.0, -6.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 color red 0.6]
      [1.0 color rgb 1]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------


text {
  ttf "courbd.ttf", "MattCoke",
  .1, // depth
  <-.2,0,0>  // spacing
  pigment {color rgb<1,1,1>}
  rotate <0, -20, 0>
  translate <-1.3, .5, -3>
}

text {
  ttf "cour.ttf", "Matt Milton",
  .1, // depth
  0.  // spacing
  scale <1, 2, 1> // stretch it taller
  pigment {color rgb<1,1,1>}
  rotate <0, -30, 0>
  translate <-3, 0, 3>
}


plane { y, 0 pigment {color rgb <1,0,0> }}

