global_settings{
  //radiosity{}
  }

#include "functions.inc"
#include "rand.inc"
#include "block_macro.inc"
#include "wall_macro.inc"

light_source{ <50,120,-130> color rgb 1.7*<1,.96,.92> }
light_source{ <-50,-120,-130> color rgb .2 }

background{ color rgb .6 }

camera{
  right 1.6*x
  up y
  location <-5,5,-80>
  look_at <0,20,0>
  }


///////////////////////////
// Set initial variables //
///////////////////////////

#declare size_min_w = 3; //min width of random bricks
#declare size_max_w = 8; //max width of random bricks
#declare size_min_h = 4; //min height of random bricks
#declare size_max_h = 7; //max height of random bricks
#declare size_d = 7; //min depth of random bricks


#declare wall_scale = 20/90; //factor to scale wall by. Should be actual size (pov units) over # rows or # columns
#declare wall_width = 120;
#declare wall_height = 90;
#declare block_qual1 = 1;
#declare block_qual3 = 3;
#declare S2 = seed(4364);

#declare wall1_trans =
  transform{
    scale wall_scale
    translate <-69,-3,-15>
    rotate -55*y
    
    //translate <-20,0,-60>
    
    }

#declare brick_mortar1 = function { 
  pigment{
    image_map{ png "mortar_hf_2.png" interpolate 2 }
    scale <wall_width,wall_height,wall_height>
    rotate 90*x
    }
}

#declare brick_mortar2 = function { 
  pigment{
    image_map{ gif "brick_check_hf2.gif" interpolate 2 }
    scale <wall_width*2,wall_height,wall_height>
    rotate 90*x
    }
}

#declare mortar1 =
isosurface {
          function {
             y
             - brick_mortar1(x,y,z).grey*3
             +  f_agate(x/4-50, y/4+60, z/4)*0.12
 
             }
          max_gradient 4
          contained_by{ box{ <0,0,0>,<wall_width-1,10,wall_height-1> } }
          texture{ mortar_tex scale 20 }
  rotate -90*x
  scale <1,1,1.95>
  translate 2.78*z
}

#declare mortar2 =
isosurface {
          function {
             y
             - brick_mortar2(x,y,z).grey*3
             +  f_agate(x/4-50, y/4+60, z/4)*0.12
 
             }
          max_gradient 5
          contained_by{ box{ <0,0,0>,<wall_width*2-1,10,wall_height-1> } }
          texture{ mortar_tex scale 20 }
  rotate -90*x
  scale <1,1,1.95>
  translate 2.78*z
}


union{

  brick_wall(
    wall_width,
    wall_height,
    "brick_check_hf.gif",
    size_min_w,
    size_max_w,
    size_min_h,
    size_max_h,
    size_d,
    seed(2893),
    200,   //200
    500,   //500
    block_qual1     
    )
    
    object{ mortar1 }
    
    union{
      brick_wall(
      wall_width*2,
      wall_height,
      "brick_check_hf2.gif",
      size_min_w,
      size_max_w,
      size_min_h,
      size_max_h,
      size_d,
      seed(5182),
      200,   //200
      500,   //500
      block_qual1     
      )
      
      object{ mortar2 }
      
      translate -wall_width*2*x
      rotate 90*y
      translate <120,0,6>
    }
    
    block(<77,58.7,0>,22,3.5,size_d+1,block_qual3,S2,sand_stone_tex)
    block(<34,58.7,0>,22,3.5,size_d+1,block_qual3,seed(838),sand_stone_tex)
    
    block(<114,5,0>,12,7.3,size_d+1,block_qual3,S2,sand_stone_tex)
    block(<114,5+12*1,0>,12,7.3,size_d+.1,block_qual3,S2,sand_stone_tex)
    block(<114,5+12*2,0>,12,7.3,size_d+1,block_qual3,S2,sand_stone_tex)
    block(<114,5+12*3,0>,12,7.3,size_d+1,block_qual3,S2,sand_stone_tex)
    block(<114,5+12*4,0>,12,7.3,size_d+1,block_qual3,S2,sand_stone_tex)
    block(<114,5+12*5,0>,12,7.3,size_d+1,block_qual3,S2,sand_stone_tex)
    block(<114,5+12*6,0>,12,7.3,size_d+1,block_qual3,S2,sand_stone_tex)
    
    block(<114+5.7,-1,0>,6,7.3,size_d+1,block_qual3,S2,sand_stone_tex)
    block(<114+5.7,-1+12*1,0>,6,7.3,size_d+1,block_qual3,S2,sand_stone_tex)
    block(<114+5.7,-1+12*2,0>,6,7.3,size_d+1,block_qual3,S2,sand_stone_tex)
    block(<114+5.7,-1+12*3,0>,6,7.3,size_d+1,block_qual3,S2,sand_stone_tex)
    block(<114+5.7,-1+12*4,0>,6,7.3,size_d+1,block_qual3,S2,sand_stone_tex)
    block(<114+5.7,-1+12*5,0>,6,7.3,size_d+1,block_qual3,S2,sand_stone_tex)
    block(<114+5.7,-1+12*6,0>,6,7.3,size_d+1,block_qual3,S2,sand_stone_tex)
    
    transform{ wall1_trans }
  
  }



  
  
          


    
  
  

      
    
    
 


  