#macro brick_wall(w_width,w_height,w_hf,bw_min,bw_max,bh_min,bh_max,bd,S,num_bricks1,num_bricks2,qual)

        #if ( qual != 0 )
          #local qual1 = 1;
          #local qual2 = 2;
          #local qual3 = 3;
        #else
          #local qual1 = 0;
          #local qual2 = 0;
          #local qual3 = 0;
        #end          
          

        //////////////////////////////////////
        //declare array for all brick cells //
        //////////////////////////////////////
        
        //create initial array. Array will store all available brick locations in rows/columns.
        //0 in the array will signify that the cell is unoccupied. 1, occupied.
        
        #local index = array[w_width][w_height]; 
        
        #local brick_check = //declare heighfield object to mask bricks for
          height_field {
            gif w_hf
            water_level .001
            smooth
            pigment { color rgb 1 }
            scale <w_width,100,w_height>
          }
        
        //compare array to heightfield with trace. Where heightfield does not exist, set array 
        //to 1. set to 0 everywhere the heightfield does exist. Allows shaping of brick wall.
        
        #local xindex = 0;
        #local yindex = 0;
          #while( xindex < w_width )
            #while( yindex < w_height )
              #local norm = <0,0,0>;
              #local pos = trace ( brick_check, <xindex,30,yindex>, <0,-1,0>, norm );
              #if ( norm.y != 0 )
                #local index[xindex][yindex]=0;
              #else
                #local index[xindex][yindex]=1;
              #end
              #local yindex = yindex + 1;
            #end
            #local yindex = 0;
            #local xindex = xindex + 1;
          #end
        
        /////////////////////////////////////////////////////////////////////////////////
        ///////////////// Start calculation of random wall bricks ///////////////////////
        /////////////////////////////////////////////////////////////////////////////////
        
        #local num_bricks = 0;
        
        //set max iterations to run testing for an open spot in wall
        
        #while ( num_bricks < num_bricks1 )
        
        //////////////////////////////////
        //randomly locate brick on wall //
        //////////////////////////////////
        
        #local skip_brick = 0; //bailout variable if brick doesn't work
        
        //create random height, width, and depth of new brick within min/max constraints
        
        #local brick_width = floor(RRand(bw_min,bw_max,S));
        #local brick_height = floor(RRand(bh_min,bh_max,S));
        
        //If brick is taller than it is wide, flip width and height
        
        #if ( brick_width < brick_height )
          #local temp = brick_height;
          #local brick_height = brick_width;
          #local brick_width = brick_height;
        #end
        
        //get a random position withing the width and height of the wall
        //omit positions that place the brick outside of the wall width and height
        
        #local brick_xy = <ceil(RRand(0,w_width-brick_width,S)),ceil(RRand(0,w_height-brick_height,S))>;
        
        ///////////////////////////
        //test area for collision//
        ///////////////////////////
        
          #local x_pos = brick_xy.u;
          #local y_pos = brick_xy.v;
          #local test = 0;
          
          #while ( x_pos < brick_xy.u + brick_width ) //iterate through brick area checking for indices already set to 1
             #while ( y_pos < brick_xy.v + brick_height )
               #ifdef ( index[x_pos][y_pos] )  
                 #local test = test + index[x_pos][y_pos];
                 #local y_pos = y_pos + 1;
               #end
             #end
             #local y_pos = brick_xy.v;
             #local x_pos = x_pos + 1;
          #end
        
        ///////////////////////////////////////////////////////
        // create brick and set indices to 1 if no collision //
        ///////////////////////////////////////////////////////
          
          #if ( test = 0 & skip_brick = 0 )
            
            block(<brick_xy.u,brick_xy.v,0>,brick_width,brick_height,bd,qual2,S,stone_tex)
        
              
            #local x_pos = brick_xy.u;
            #local y_pos = brick_xy.v;
            
            #while ( x_pos < brick_xy.u + brick_width )
               #while ( y_pos < brick_xy.v + brick_height )
                 #local index[x_pos][y_pos] = 1;          
                 #local y_pos = y_pos + 1;
               #end
               #local y_pos = brick_xy.v;
               #local x_pos = x_pos + 1;
            #end      
          
          #end
              
            
          #local num_bricks = num_bricks + 1;
          
        #end
        
        

        /////////////////////////////////////////////////////////////////////////////////
        ///////////////// Small bricks to fill in left over areas ///////////////////////
        ///////////////// Start calculation of random wall bricks ///////////////////////
        /////////////////////////////////////////////////////////////////////////////////        
        
        
        
        #local num_bricks = 0;
        
        //set max iterations to run testing for an open spot in wall
        
        #while ( num_bricks < num_bricks2 )
        
        //////////////////////////////////
        //randomly locate brick on wall //
        //////////////////////////////////
        
        #local skip_brick = 0; //bailout variable if brick doesn't work
        
        //create random height, width, and depth of new brick within min/max constraints
        
        #local brick_width = floor(RRand(4,8,S));
        #local brick_height = floor(RRand(1,3,S));
        
        //get a random position withing the width and height of the wall
        //omit positions that place the brick outside of the wall width and height
        
        #local brick_xy = <ceil(RRand(0,w_width-brick_width,S)),ceil(RRand(0,w_height-brick_height,S))>;
        
        ///////////////////////////
        //test area for collision//
        ///////////////////////////
        
          #local x_pos = brick_xy.u;
          #local y_pos = brick_xy.v;
          #local test = 0;
          
          #while ( x_pos < brick_xy.u + brick_width ) //iterate through brick area checking for indices already set to 1
             #while ( y_pos < brick_xy.v + brick_height )
               #ifdef ( index[x_pos][y_pos] )  
                 #local test = test + index[x_pos][y_pos];
                 #local y_pos = y_pos + 1;
               #end
             #end
             #local y_pos = brick_xy.v;
             #local x_pos = x_pos + 1;
          #end
        
        ///////////////////////////////////////////////////////
        // create brick and set indices to 1 if no collision //
        ///////////////////////////////////////////////////////
          
          #if ( test = 0 & skip_brick = 0 )
            
            block(<brick_xy.u,brick_xy.v,0>,brick_width,brick_height,bd,qual2,S,stone_tex)
        
              
            #local x_pos = brick_xy.u;
            #local y_pos = brick_xy.v;
            
            #while ( x_pos < brick_xy.u + brick_width )
               #while ( y_pos < brick_xy.v + brick_height )
                 #local index[x_pos][y_pos] = 1;          
                 #local y_pos = y_pos + 1;
               #end
               #local y_pos = brick_xy.v;
               #local x_pos = x_pos + 1;
            #end      
          
          #end
              
            
          #local num_bricks = num_bricks + 1;
          
        #end

        
        /////////////////////////////////////////////////////////////////
        ///////////////// Small non-random bricks ///////////////////////
        /////////////////////////////////////////////////////////////////        
        
        #local x_pos = 0;
        #local y_pos = 0;
        
        #while ( y_pos < w_height )
          #while ( x_pos < w_width )
        
        //////////////////////////////////
        //randomly locate brick on wall //
        //////////////////////////////////
        
        #local skip_brick = 0; //bailout variable if brick doesn't work
        
        //create random height, width, and depth of new brick within min/max constraints
        
        #local brick_width = floor(RRand(2,4,S));
        #local brick_height = 1;
        
        //get a random position withing the width and height of the wall
        //omit positions that place the brick outside of the wall width and height
        
        #local brick_xy = <x_pos,y_pos>;
        
        #if ( brick_xy.u + brick_width > w_width )
          #local skip_brick = 1;
        #end
        
        ///////////////////////////
        //test area for collision//
        ///////////////////////////
        
          #local x_pos = brick_xy.u;
          #local y_pos = brick_xy.v;
          #local test = 0;
          
          #while ( x_pos < brick_xy.u + brick_width & skip_brick = 0 ) //iterate through brick area checking for indices already set to 1
            #ifdef ( index[x_pos][y_pos] )  
              #local test = test + index[x_pos][y_pos];
              #local x_pos = x_pos + 1;
            #end
          #end
        
        ///////////////////////////////////////////////////////
        // create brick and set indices to 1 if no collision //
        ///////////////////////////////////////////////////////
        
        #if ( qual = 1) #local qual = 2; #end
          
          #if ( test = 0 & skip_brick = 0 )
            
            block(<brick_xy.u,brick_xy.v,0>,brick_width,brick_height,bd,qual1,S,stone_tex)
        
              
            #local x_pos = brick_xy.u;
            #local y_pos = brick_xy.v;
            
            #while ( x_pos < brick_xy.u + brick_width )
               #while ( y_pos < brick_xy.v + brick_height )
                 #local index[x_pos][y_pos] = 1;          
                 #local y_pos = y_pos + 1;
               #end
               #local y_pos = brick_xy.v;
               #local x_pos = x_pos + 1;
            #end      
          
          #end
                     
          #local x_pos = x_pos + .2;
          
          #end
          
          #local y_pos = y_pos + 1;
          #local x_pos = 0;
          
        #end        
        
        
        


#end