

/////////////////
// power lines //
/////////////////

#declare power_lines =
object{ 
  lines(900,100,6,seed(566))
  rotate -50*y
  translate <-270,5,80>
  }


//////////
// skip //
//////////

  
#declare skip_wheel =
union{
  box{ <-.6,-.7,0> <.6,.7,-.1> }
  cylinder{ <0,0,0> <0,0,-.7>, .15 }
  lathe{
  	cubic_spline
  	13,
  	<0.006805,0.996935>,
  	<0.051038,1.000337>,
  	<0.581829,0.993532>,
  	<0.738344,0.966312>,
  	<0.782577,0.775772>,
  	<0.802992,0.486558>,
  	<0.840419,0.176930>,
  	<1.010545,0.088465>,
  	<0.996935,0.017013>,
  	<0.428716,0.003403>,
  	<0.156515,0.064648>,
  	<0.054440,0.081660>,
  	<0.006805,0.102075>
  	rotate -90*x
  	scale <.6,.6,.4>
  	translate -.2*z
  }
  
  object{ rivet_rows(1.2,.15,.06) translate <-.6,-.55,-.1> texture{ rusted_metal_tex6 scale 1 } }
  object{ rivet_rows(1.2,.15,.06) translate <-.6,.55,-.1> texture{ rusted_metal_tex6 scale 1 } }
  
} 

#declare hinge_pt =
union{
  box{ <-.6,-.7,0> <.6,.7,-.1> }
  cylinder{ <0,0,0> <0,0,-.7>, .15 }
  cylinder{ <0,0,0> <0,0,-.2>, .4 }
  cylinder{ <.2,0,-.6> <-.2,0,-.6>, .03 rotate 30*z } 
  object{ rivet_rows(1.2,.15,.06) translate <-.6,-.55,-.1> texture{ rusted_metal_tex6 scale 1 } }
  object{ rivet_rows(1.2,.15,.06) translate <-.6,.55,-.1> texture{ rusted_metal_tex6 scale 1 } }
  
}

#declare skip_side =
union{
  prism{
    1.95,1.97,6
    <0,0> <11,0> <11,1.3> <8.4,4> <0,4> <0,0>
    rotate -90*x
    texture{ rusted_metal_tex6 scale 3 }
    }
  prism{
    1.97,2,6
    <0,0> <11,0> <11,1.3> <8.4,4> <0,4> <0,0>
    rotate -90*x
    texture{ rusted_metal_tex6 scale 3 translate 20 }
    }
  box{ <0,0,-2> <5,.5,-2.1> texture{ rusted_metal_tex6 scale 1 } }  
  box{ <0,3.5,-2> <5,4,-2.1> texture{ rusted_metal_tex6 scale 1 } }
  box{ <0,.51,-2> <.5,3.49,-2.05> texture{ rusted_metal_tex6 scale 1 } }
  box{ <5,0,-2> <11,.5,-2.05> texture{ rusted_metal_tex6 scale 1 } }
  box{ <5,3.5,-2> <8,4,-2.05> texture{ rusted_metal_tex6 scale 1 } }
  box{ <4.5,.51,-2> <5,3.49,-2.05> texture{ rusted_metal_tex6 scale 1 } }
  
  object{ rivet_rows(5,.25,.06) translate <0,3.75,-2.1> texture{ rusted_metal_tex6 scale 1 } }
  object{ rivet_rows(5,.25,.06) translate <0,.25,-2.1> texture{ rusted_metal_tex6 scale 1 } }

  object{ rivet_rows(6,.25,.06) translate <5,.25,-2.05> texture{ rusted_metal_tex6 scale 1 } }
  object{ rivet_rows(3,.25,.06) translate <5,3.75,-2.05> texture{ rusted_metal_tex6 scale 1 } }
  
  object{ rivet_rows(3,.25,.06) rotate 90*z translate <.25,.5,-2.05> texture{ rusted_metal_tex6 scale 1 } }
  object{ rivet_rows(3,.25,.06) rotate 90*z translate <4.75,.5,-2.05> texture{ rusted_metal_tex6 scale 1 } }
  
  object{ skip_wheel translate <1.3,1.3,-2> texture{ rusted_metal_tex6 scale 1 } }
  object{ skip_wheel translate <8,1.3,-2> texture{ rusted_metal_tex6 scale 1 } }
  
  object{ hinge_pt translate <6,2.7,-2> texture{ rusted_metal_tex6 scale 1 } }

  intersection{
    prism{
      0,2.6,7
      <11,0> <11,1.3> <7.5,5> <6.5,5> <10.5,1.0> <10.5,0> <11,0>
      rotate -90*x
      }
    difference{
      union{
        box{ <6,0,-2.1> <12,4.1-.2,0> }
        box{ <6,0,-2.1+.2> <12,4.1,0> }
        cylinder{ <6,4.1-.2,-2.1+.2> <12,4.1-.2,-2.1+.2>, .2 }
        }  
      box{ <6,0,.1> <12,3.9,-2> }
      } 
      texture{ rusted_metal_tex6 scale 1 }
  }
  
  object{ rivet_rows(1.5,.25,.06) rotate 90*z translate <10.75,0,-2.1> texture{ rusted_metal_tex6 scale 1 } }
  object{ rivet_rows(3.8,.25,.06) scale <1,-1,1> rotate 135*z translate <10.65,1.3,-2.1> texture{ rusted_metal_tex6 scale 1 } }
  
  object{ rivet_rows(1.5,.25,.06) rotate 90*z translate <10.75,0,-1.95> texture{ rusted_metal_tex6 scale 1 } }
  object{ rivet_rows(3.8,.25,.06) scale <1,-1,1> rotate 135*z translate <10.65,1.3,-1.95> texture{ rusted_metal_tex6 scale 1 } }
  
  box{ <0,3.9,-2.1> <5,4.05,-1.5> texture{ rusted_metal_tex6 scale 1 } }
  box{ <5,3.9,-2.05> <8,4.0,-1.5> texture{ rusted_metal_tex6 scale 1 } }
  
  object{ rivet_rows(5,.25,.06) rotate 90*x translate <0,4.05,-1.75> texture{ rusted_metal_tex6 scale 1 } }
  object{ rivet_rows(3.1,.25,.06) rotate 90*x translate <5,4.0,-1.75> texture{ rusted_metal_tex6 scale 1 } }
  
  }
  
#declare skip_center =
union{
  box{ <0,0,-2> <11,.1,2> texture{ rusted_metal_tex6 scale 3 } }
  box{ <0,3.8,-2> <8.3,3.9,2> texture{ rusted_metal_tex6 scale 3 } }
  box{ <0,0,-2> <.1,3.9,2> texture{ rusted_metal_tex6 scale 3 } }

  box{ <0,3.9,-1.5> <.5,4.03,1.5> texture{ rusted_metal_tex6 scale 1 } }
  box{ <4.5,3.9,-1.5> <5,4.03,1.5> texture{ rusted_metal_tex6 scale 1 } }
  
  object{ rivet_rows(3,.25,.06) rotate -90*y rotate 90*z translate <.25,4.03,-1.5> texture{ rusted_metal_tex6 scale 1 } }
  object{ rivet_rows(3,.25,.06) rotate -90*y rotate 90*z translate <4.75,4.03,-1.5> texture{ rusted_metal_tex6 scale 1 } }
  
  object{ rivet_rows(3.8,.35,.06) rotate -90*y rotate 90*z translate <7.9,4.1,-1.95> texture{ rusted_metal_tex6 scale 1 } }
  
  object{ rivet_rows(3.8,.25,.06) rotate -90*y rotate 90*z translate <10.75,.11,-1.95> texture{ rusted_metal_tex6 scale 1 } }
  
  }  
  
#declare skip =
union{
  object{ skip_side }
  object{ skip_side scale <1,1,-1> }
  object{ skip_center }
  }
  
/////////////////
///// Wheel /////
/////////////////

#declare spoke =
prism{
  linear_spline
  -.1,.1,5
  <-.4,.2> <-.2,5.7> <.2,5.7> <.4,.2> <-.4,.2>
  }

#declare pulley_wheel =  
union{
  lathe {
    linear_spline
    13,
    <5.5,-.4> <6,-.4> <6,-.3> <5.8,-.3> <5.8,.3> <6,.3> <6,.4> <5.5,.4> <5.5,.1> <5.3,.1> <5.3,-.1> <5.5,-.1> <5.5,-.4>
  }
  
  #declare counter = 0;
  #while ( counter < 6 )
  
    object{ spoke rotate counter*60*y }
    object{ spoke rotate 90*z rotate counter*60*y }
    
    #declare counter = counter + 1;
    
  #end 
  
  difference{
    cylinder{ <0,-.4,0> <0,.4,0>, 1 }
    cylinder{ <0,-.6,0> <0,.6,0>, .2 }
    } 
  
  scale .5
  texture{ rusted_metal_tex6 }
  }

/////////////////
///// Train /////
/////////////////  
 
#declare spring =
union{
  torus{ 2/12, .04 rotate 11*z translate -2*.1*y }
  torus{ 2/12, .04 rotate 11*z translate -.1*y }
  torus{ 2/12, .04 rotate 11*z }
  torus{ 2/12, .04 rotate 11*z translate .1*y }
  torus{ 2/12, .04 rotate 11*z translate 2*.1*y }
  torus{ 2/12, .04 rotate 11*z translate 3*.1*y }
  torus{ 2/12, .04 rotate 11*z translate 4*.1*y }
  torus{ 2/12, .04 rotate 11*z translate 5*.1*y }
  }

#declare hub =
union{
  intersection{
    cylinder{ <0,.6,1> <0,.6,-1>, 1.2 }
    box{ <-.8,-1,0> <.8,-.25,-.7> }
    }
  difference{
    union{
      cylinder{ <0,0,0> <0,0,-.7>, .3 }  
      box{ <-.3,-.3,0> <.3,0,-.7> }
      }
    cylinder{ <0,0,.5> <0,0,-1>, .25 }
    }
  }

#declare center_left =
union{
  prism{
    linear_spline
    .6,.9,9
    <0,-.4> <-.5,-.4> <-1.1,.6> <-2.8,.6> <-2.6,.9> <-1.1,.9> <-.3,-.2> <0,-.2> <0,-.4>  
    rotate -90*x
    }
  box{ <0,.6,-.6> <-1,.9,-.9> }
  }

#declare cart_wheel =
union{
  lathe{
  	cubic_spline
  	13,
  	<0.006805,0.996935>,
  	<0.051038,1.000337>,
  	<0.581829,0.993532>,
  	<0.738344,0.966312>,
  	<0.782577,0.775772>,
  	<0.802992,0.486558>,
  	<0.840419,0.176930>,
  	<.850545,0.088465>,
  	<0.856935,0.017013>,
  	<0.428716,0.003403>,
  	<0.156515,0.064648>,
  	<0.054440,0.081660>,
  	<0.006805,0.102075>
  	rotate -90*x
  	scale <1.4,1.4,.2>
  }
  object{ spring translate <.6,0,-.7> }
  object{ spring translate <-.6,0,-.7> }
  cylinder{ <0,0,0> <0,0,-.6> .2 }
  object{ hub }
  }


#declare cart_wheels =
union{
  object{ cart_wheel translate 2*x }
  object{ cart_wheel translate -2*x }
  object{ center_left }
  object{ center_left translate .9*z }
  object{ center_left scale <-1,1,1> }
  object{ center_left translate .9*z scale <-1,1,1> }
  }
  
#declare train_wheel_assy =
union{
  object{ cart_wheels translate -1.5*z }
  object{ cart_wheels rotate 180*y translate 1.5*z } 
  }

#declare train_chain_link =
torus{ .1,.02 scale <1.95,1,1> }

#declare top =
union{
  difference{
    box{ <0,1.1,-3> <17,2,3> }
    union{
      box{ <.6,1,-3.1> <16.4,1.8,-2.9> }
    }
  }
  box{ <-.25,2,-.25> <.25,5,.25> translate <.25,0,-2.75> }
  box{ <-.25,2,-.25> <.25,5,.25> translate <.25,0,2.75> }
  box{ <-.25,2,-.25> <.25,5,.25> translate <16.75,0,-2.75> }
  box{ <-.25,2,-.25> <.25,5,.25> translate <16.75,0,2.75> }
  wire(train_chain_link, <.25,4.8,-2.85>, <16.75,4.8,-2.85>, 1.03, 1.4, .2)
  wire(train_chain_link, <.25,4.8,2.85>, <16.75,4.8,2.85>, 1.03, 1.4, .2)
    
  translate -3*x
    
}
 
#declare train =
union{
  object{ train_wheel_assy }
  object{ train_wheel_assy translate 11*x }  
  object{ top }
  texture{ rusted_metal_tex6 }
  }

/////////////////
///// Hawk  /////
/////////////////  
  
#declare hawk =
box{
  <-2,-2,-.01> <2,2,.01>
  texture{ hawk_mask }
  rotate -70*x
  scale .7
  }
  
/////////////////////////
///// Rocks on Cars /////
/////////////////////////   
  

#declare target_obj = 
box{ <-3,1.1,-3> <14,2,3> }
  

#declare old_poor_rock1 =
union{ 
  gravel_patch(15,4.5,<5.5,0,0>,30,.2,3,target_obj,181,poor_rock_tex2,0)
  }
  
#declare old_poor_rock2 =
union{ 
  gravel_patch(15,4.5,<5.5,0,0>,30,.2,3,target_obj,812,poor_rock_tex2,0)
  }