
#declare C_Cloud=0.53*<1,1,1.1>;
#declare C_Scattering=C_Cloud*0.002;
#declare C_Absorption=(1-C_Cloud)*0.0035;


#declare Cloud4 =
box{-0.5,0.5
    texture{pigment{Clear}finish{ambient 0 diffuse 0}}
    hollow
    interior{
        media{
            scattering{1,3.5*C_Scattering extinction 0.3}
            absorption 3.5*C_Absorption
            intervals cloud_intervals
            density{
                density_file df3 "cloud2.df3"
                turbulence 0.6 // mostly useful for MakeCloud2 clouds, which are not created turbulent
                lambda 2.1
                omega 0.8
                interpolate 1
                translate -0.5
                scale <1,-1,1>
            }
        }
    }
    rotate 130*y
    scale <15000,50,8000>
    translate <2000,3600,4000>
    rotate 5*x
}

#declare Cloud5 =
box{-0.5,0.5
    texture{pigment{Clear}finish{ambient 0 diffuse 0}}
    hollow
    interior{
        media{
            scattering{1,1.4*C_Scattering extinction 0.3}
            absorption 1.4*C_Absorption
            intervals cloud_intervals
            density{
                density_file df3 "cloud2.df3"
                turbulence 0.6 // mostly useful for MakeCloud2 clouds, which are not created turbulent
                lambda 2.1
                omega 0.8
                interpolate 1
                translate -0.5
                scale <1,-1,1>
            }
        }
    }
    rotate 80*y
    scale <25000,50,20000>
    translate <2000,3900,15000>
    rotate 5*x
}
