global_settings{
    radiosity {
      pretrace_start 0.1
      pretrace_end   0.002 //0.002
      count 100 //100
      always_sample off
           
      nearest_count 3
      error_bound .6
      recursion_limit 1

      low_error_factor .01
      gray_threshold 0.0
      minimum_reuse 0.015
      brightness .85

      adc_bailout 0.01/2
      
      normal on
     
      
  }
  max_trace_level 10
  ambient_light 0
}

/////////////////////////////
// Essential Include Files //
/////////////////////////////

#include "colors.inc"
#include "functions.inc"
#include "rand.inc"
#include "tex.inc"
#include "catenary.inc"
#include "macro_tools.inc"

/////////////////////////////////////
// Switches for parsing/visibility //
/////////////////////////////////////

#declare Rockhouse_s    = 1;
#declare Cablesupport_s = 1;
#declare Hoisthouse_s   = 1;  #declare hoisthouse_simple = 0;
#declare Groundnear_s   = 1;
#declare Groundfar_s    = 1;
#declare Poorrock_s     = 1;
#declare Plants_s       = 1;
#declare Bushes_s       = 1;
#declare Litter_s       = 1;
#declare Clouds_s       = 1;  #declare cloud_intervals = 4;

/////////////////////////////////////////
////////// Cameras and Lights ///////////
/////////////////////////////////////////

light_source{ 
   <15000,25000,-9000> 
   color rgb 4*<255/255,237/255,207/255> 
   parallel 
   point_at <0,0,0>
  }

#declare final_cam =
camera{
  right 1.6*x
  up y
  location <-5,6.5,-55>
  look_at <40,100,250>
  aperture 0.12
  focal_point <0,10,200>
  blur_samples 250
  }

camera{
  final_cam
  } 

sky_sphere{ pigment{sky_color} }

fog {
  distance 4700
  color rgb <221,228,233>/255
  fog_type 2
  fog_offset 100
  fog_alt 20
}



///////////////////////////////////////////
////////// Ground Heightfields ////////////
///////////////////////////////////////////

#if ( Groundfar_s = 1 )

  #declare ground_far = 
    height_field{
      png "land_hf.png"
      water_level .001
      translate <-.5,.5,0>
      scale <500,16,500>
      rotate -51*y
      translate <195,-12.5,-90>
      texture{ dirt_far_tex scale 1 }
      }

  object{ ground_far }

#end   

#if ( Groundnear_s = 1 )

  #declare ground_near =
    height_field{
      tga "ground_near.tga"
      translate <-.5,0,-.5>
      scale <70,5,50>
      rotate 0*y
      rotate 3*x
      translate <-7,-3,-15>
      texture{ dirt_tex scale 1 }
      }

  object{ ground_near }
  
#else

  #declare Gravel_s = 0;
  
#end

/////////////////////////////////
////////// Rockhouse ////////////
/////////////////////////////////

#if ( Rockhouse_s = 1 )

  #include "rockhouse.inc"
  
  union{
    object{ rockhouse_main }
    object{ rockhouse_extras }
    object{ windows }
    object{ rear_frame translate 148.5*x }  
    rotate 50*y
    translate <-90,1,260> 
    }
  
#end

/////////////////////////////////////
////////// Cable Support ////////////
/////////////////////////////////////

#if ( Cablesupport_s = 1 )

  #include "cable_support.inc"
  
  object{ 
    cable_support 
    translate -5*y
    rotate 50*y
    translate <-90,3,260> 
    }
  
  
  
#end

///////////////////////////////////
////////// Hoist House ////////////
///////////////////////////////////
    
#if ( Hoisthouse_s = 1 )

  #include "wall_macro.inc"
  #include "block_macro.inc"
  #include "old_hoist_house.inc"
  
  union{
    object{  old_hh_walls }
    object{ old_hh_roof translate 21*y }
    object{ side_wall_int texture{ pigment{ color 0 } } }
    box{ <0,0,0> <53.5,21,1> translate <0,0,41.5> texture{ pigment{ color 0 } } }
    translate <195,0,-28>
    rotate 50*y
    translate <-90,-7,260>
  }
  
#end

//////////////////////////////////////
////////// Poor Rock Pile ////////////
//////////////////////////////////////
  
#if ( Poorrock_s = 1 )

  #include "poor_rock_mesh.inc"
  
  #declare poor_rock =
  object{
    poor_rock_mesh
    scale .2*150
    texture{poor_rock_tex1}
    } 
  
  union{
    gravel_patch(150,30,<0,0,0>,1000,2,3,poor_rock,seed(2383),poor_rock_tex1,0)  
    gravel_patch(150,150,<0,0,0>,2000,1,2,poor_rock,seed(2383),poor_rock_tex1,0)
    object{ poor_rock }
    scale 2
    rotate 90*y
    translate <500,-5,650>
    }
    
#end

//////////////////////////////
////////// Bushes ////////////
//////////////////////////////

#if ( Bushes_s = 1 )

  #include "bush1.inc"

  bush_patch(200,200,<-50,0,100>,50,4,6,ground_far,5181)
  bush_patch(100,100,<-50,0,150>,30,4,6,ground_far,5181)
  
#end

///////////////////////////////
////////// Grasses ////////////
///////////////////////////////

#if ( Plants_s = 1 )

  #include "timothy_grass.inc"
  #include "wild_bergamot.inc"
  #include "queen_annes_lace.inc"
  #include "birch.inc"
  #include "elm.inc"

  #declare near_pig_trans = 
  transform{
    translate -.5
    rotate 90*x
    scale <50,1,80>
    rotate 0*y
    rotate 3*x
    translate <-3,0,-35>
    }

  #declare far_pig_trans = 
  transform{
    rotate 90*x
    translate <-.5,0,0>
    scale <500,16,500>
    rotate -51*y
    translate <195,-12.5,-90>
    }
          
  #declare tree_trans = 
  transform{        
    rotate 90*x
    translate <-.5,0,0>
    scale <600,5,600>
    rotate -51*y
    translate <250,-10,70>
    }

  #declare tree_hf = 
    height_field{
      png "tree_hf.png"
      water_level .001
      translate <-.5,.5,0>
      scale <600,5,600>
      rotate -51*y
      translate <250,-3,70>
      texture{ dirt_far_tex scale 1 }
      }
    
  #declare tim_pig_near =
  pigment{
    image_map{
      gif "tim_pig_near.gif"
      interpolate 2
    }
    transform{ near_pig_trans }
  }
  
  #declare berg_pig_near =
  pigment{
    image_map{
      gif "berg_pig_near.gif"
      interpolate 2
    }
    transform{ near_pig_trans }
  }

  #declare qal_pig_near =
  pigment{
    image_map{
      gif "qal_pig_near.gif"
      interpolate 2
    }
    transform{ near_pig_trans }
  }

  #declare flower_pig_far =
  pigment{
    image_map{
      gif "flower_pig_far.gif"
      interpolate 2
    }
    transform{ far_pig_trans }
  }

  #declare tree_pig_near =
  pigment{
    image_map{
      gif "tree_pig_near.gif"
      interpolate 2
    }
    transform{ far_pig_trans }
  }

  #declare tree_pig =
  pigment{
    image_map{
      gif "tree_pig.gif"
      interpolate 2
    }
    transform{ tree_trans }
  }

  #declare full_pig =
  pigment{
    color rgb 1
    }
  
  //////////////////////////////////////
  //Plants located on near heightfield//
  //////////////////////////////////////
  
  #declare plant_ratio = 1;
    
  plant_patch(50,80,<-3,0,-35>,10000*plant_ratio,2,4,ground_near,timothy_grass_bunch,tim_pig_near,157)
  
  #debug "created near timothy grass\n"
  
  plant_patch(50,80,<-3,0,-35>,200*plant_ratio,2,4,ground_near,wild_bergamot,berg_pig_near,158)
  
  #debug "created near wild bergamot\n"
  
  plant_patch(50,80,<-3,0,-35>,60*plant_ratio,2.5,4,ground_near,queen_annes_lace,qal_pig_near,159)
  
  #debug "created near qal\n"
  
  /////////////////////////////////////
  //Plants located on far heightfield//
  /////////////////////////////////////  
  
  plant_patch(450,390,<40,0,180>,18000*plant_ratio,3,5,ground_far,timothy_grass_bunch,full_pig,812)
  
  #debug "created first pass far timothy grass\n"
    
  plant_patch(450,390,<40,0,180>,18000*plant_ratio,3,5,ground_far,timothy_grass_bunch,full_pig,438)
  
  #debug "created second pass far timothy grass\n"
  
  plant_patch(450,390,<40,0,180>,18000*plant_ratio,3,5,ground_far,timothy_grass_bunch,full_pig,186)
  
  #debug "created third pass far timothy grass\n"
  
  plant_patch(300,200,<20,0,110>,2300*plant_ratio,4,5.5,ground_far,wild_bergamot,flower_pig_far,918)
  
  #debug "created far wild bergamot\n"
  
  plant_patch(300,200,<20,0,110>,900*plant_ratio,4.5,5.5,ground_far,queen_annes_lace,flower_pig_far,518)
  
  #debug "created far qal\n"
  
  plant_patch(470,450,<40,0,180>,10*plant_ratio,20,60,ground_far,birch,tree_pig_near,81673)
  
  #debug "created near birch\n"
  

  //////////////////////////////////////
  //Plants located on tree heightfield//
  //////////////////////////////////////
  
  plant_patch(700,500,<50,0,450>,90*plant_ratio,30,62,tree_hf,birch,tree_pig,8615)
  plant_patch(700,500,<50,0,450>,4*plant_ratio,50,70,tree_hf,birch,tree_pig,484)
  
  #debug "created far birch\n"
  
  plant_patch(700,500,<50,0,450>,140*plant_ratio,40,60,tree_hf,elm,tree_pig,819)
  plant_patch(700,500,<50,0,450>,4*plant_ratio,60,70,tree_hf,elm,tree_pig,468)
  
  #debug "created far elm\n"  
  
  object{ 
    birch 
    rotate 120*y scale 30 translate <-65,-3.5,65> 
    }
   
#end


//////////////////////////////
////////// Litter ////////////
////////////////////////////// 

#if ( Litter_s = 1 )

  #include "extras.inc"  
  object{ power_lines }
  object{ 
    skip 
    rotate 8*x
    rotate -4*z 
    rotate 120*y
    rotate 2*z 
    translate <-9,2,-18> 
    }
  object{ 
    pulley_wheel
    rotate 18*y
    rotate -90*x
    scale 1.5
    translate -3*1.5*y
    rotate 10*x
    rotate -90*y
    translate <54.3,14.8,5>
    translate <195,0,-28>
    rotate 50*y
    translate <-90,-10,260>
    }
  object{ 
    pulley_wheel
    rotate 8*y
    rotate -90*x
    scale 1
    translate -3*.7*y
    rotate 18*x
    rotate -85*y
    translate <57,9.8,3>
    translate <195,0,-28>
    rotate 50*y
    translate <-90,-10,260>
    }
  object{
    train
    rotate 7*x
    rotate -90*y
    translate <127.5,4.3,-80>
    rotate 50*y
    translate <-90,0,260>
    }
  object{
    train
    rotate -6*x
    rotate <5,-90,3>
    translate <127.5,4.1,-100>
    rotate 50*y
    translate <-90,0,260>
    }
  object{
    old_poor_rock1
    rotate 7*x
    rotate -90*y
    translate <127.5,4.3,-80>
    rotate 50*y
    translate <-90,0,260>
    }    
  object{
    old_poor_rock2    
    rotate -6*x
    rotate <5,-90,3>
    translate <127.5,4.1,-100>
    rotate 50*y
    translate <-90,0,260>
    }    
    
  object{ hawk rotate 5*x rotate -50*y translate <-70,80,50> }
    
#end 

//////////////////////////////
////////// Clouds ////////////
//////////////////////////////

#if ( Clouds_s = 1 )

  #include "clouds.inc"
    
  object{ Cloud4 } //cirrus
  object{ Cloud5 } //cirrus

#end


sphere{ <-5,2,-55>, 3 pigment{ color rgb <1,0,0> } }
sphere{ <400,20,330>, 3 pigment{ color rgb <1,0,0> } }
sphere{ <-270,20,400>, 3 pigment{ color rgb <1,0,0> } }






                                                                       

  



                                     