// Just Pick It Up!
// Alexandre Dorion August 2006

#version unofficial megapov 1.21;

global_settings
{
	assumed_gamma 1.0
	radiosity { pretrace_start 0.08 pretrace_end   0.04 count 35  nearest_count 5 error_bound 1.8 recursion_limit 3
	low_error_factor .5 gray_threshold 0.1 minimum_reuse 0.015 brightness 1 adc_bailout 0.01/2}
}

#include "colors.inc"
#include "textures.inc"
#include "functions.inc"

// CAMERA

camera
{
        location  <.4,.5,-1> right x*image_width/image_height look_at <1.5,.5,1>
        focal_point <1.1,.15,2> aperture .05  blur_samples 50  variance 1/10000
}

// LIGHTS

light_source
{
        <-100,50,0> color White*1.5+Yellow*.25
        area_light <8, 0, 0> <0, 0, 8>  4, 4  adaptive 0  jitter  circular   orient 
}

light_source
{
        <.4,50,-1> color White*.5
        area_light <5, 0, 0> <0, 0, 5>  3, 3  adaptive 0  jitter  circular   orient 
}

// TEXTURES

#declare s1 = texture
{
        pigment { image_map { jpeg "concrete2.jpg" map_type 7 } }
        normal { bumps .25 scale .1 } 
        finish { ambient 0 diffuse .6 phong .2 }
}

#declare s3 = texture
{
        pigment { image_map { jpeg "tinybricks.jpg" map_type 0 } }
        normal { bumps .4 scale .1}        
        finish { ambient 0 diffuse .6 phong .2}
}

#declare s2 = texture
{
        pigment { image_map { jpeg "concrete2.jpg" map_type 7 } }
        normal { bumps .6 scale .2 }
        finish { ambient 0 diffuse .6 phong .2 reflection .1 }
}

// FLOOR

#declare stone = isosurface
{
        function  { f_rounded_box (x,y,z,0.08,1.4,0.9,0.9) - (f_noise3d(4*x,4*y,4*z))*.01  }
        contained_by { box { <-2,-1,-1>, <2,1,1> }  }
} 

#declare square = object
{
        stone
        rotate y*90
        scale .25
        translate <0,-.2,0>
}  

#declare it = seed(12341234); 

#declare string1 = union
{
        #declare nz=-3;
        #while (nz<=20)
	        object
	        {
	                square
	                texture
	                {
	                        s2
	                        translate -1.5+3*rand(it)
	                }
	                translate <0,-.05*rand(it),nz>
	        }
	        #declare nz=nz+.71;
        #end
}

#declare top_level = union{
#declare nz=0;
#while (nz<=10)
	object {string1 translate <.5+.45*nz,0,2*rand(it)>}
	#declare nz=nz+1;
#end
}

object {top_level}
object {top_level rotate y*-90 translate <2,0,19>}
object {top_level rotate y*-90 translate <2,0,23.5>}
object {top_level translate <-.5,-.5,0> }
object {top_level translate <-.5,-.5,0> rotate y*-90 translate <.15,0,19>}
object {top_level translate <-5,-1,0> }
object {top_level translate <-5,-1,0> rotate y*-90 translate <0,0,19>}

                                                                            
// PILLARS

#declare pillar =
union
{
	torus { 0.875, 0.125 translate <0,.125,0>}
	#declare a1 = 
	union
	{
		cylinder { 0, .5*y, .75 }
		cylinder { 0, .3125*y, .875 }
	}
	difference
	{
	    	object {a1}
                torus {.8125, .11 translate <0,.370,0>}
                torus {.82, .11 translate <0,.370,0>}
	}
	torus { 0.75, 0.1 translate <0,.6,0>} 
	difference
	{
	        cylinder {0, .2*y, .75 translate <0,.7,0>}
	        torus { 0.75, 0.1 translate <0,.85,0>}
	        cylinder {0, .2*y, 1 translate <0,.85,0>}
	}
	#declare hole = union
	{
	        sphere {0,.075 translate <-.65,.925,0>}
	        cylinder {0,10*y, .075 translate <-.65,.925,0>}
	}
	#declare circles = union
	{
	        #declare n=0;
	        #while (n<20)
	                object {hole rotate y*-18*n}
	                #declare n=n+1;
	        #end
        }
        difference
	{
	        cylinder {0, 10*y, .65 translate <0,.85,0>}
                object{ circles }
	}
}

#declare column = object {pillar texture {s1 translate z*-1.5+3*rand(it) scale .05} scale <1.4,1,1.4> translate <1.4,0,.55>}  

#declare row = union {
#declare nz=0;
#while (nz<=6)
	object {column translate <1,0,3.5*nz>}
	#declare nz=nz+1;
#end
}

object {row translate y*-.03}
object {row rotate y*-90 translate <-.5,-.03,19.25>}
object {row translate <-10,-.03,4>}

// BRICKWALL

#declare brickwall = box {0,1 scale 100 translate <-50,0,28>}
object {brickwall texture {s3 scale 15}}

// CAN                                                                  

#declare alum = material { texture
{
	pigment { color rgb .5 }
	finish { diffuse 0.4 ambient .1 reflection .4 }
}}

#declare cover = material { texture
{
	pigment { image_map { png "coke_label.png" map_type 0 } translate x scale <1,1.5,1> }
	finish { diffuse 0.4 ambient .5 reflection .15}
}}


#declare can = union
{
	cylinder { 0.05*y, 1.45*y, .503 open material {cover} } 
	cylinder { 0, 1.5*y, .5 open material {alum} }
	cylinder { 1.68*y, 1.7*y, .46 material {alum} }
	torus { 0.45, 0.05 material {alum} } 
	cone {1.5*y, .5, 1.7*y, .45 open material {alum} }
	cone {-.04*y, .49, -.08*y, .3 open material {alum} }
	torus { 0.3, 0.05 material {alum} translate <0,-.04,0> }
	#declare butt = difference
	{
		sphere {0,.3 material {alum}}
		box {-1,0 material {alum} translate <.5,0,.5>}
		sphere {0,.28 material {alum}}
	}
	object {butt scale <1,.25,1> translate <0,-.04,0>}
}

object {can rotate <90,45,0> scale .1 translate <1,.045,1.5>}



                                                      