// light trails POV-Ray source file
// by Bill Pragnell, 2005

// NB you don't really need the macros file to make the scene
// work - the 'slanted box' macro is simply a bevelled box...

#include "shapes.inc"
#include "colors.inc"
#include "BillMacros.inc"

global_settings { max_trace_level 10 }

camera { location <40, 40, -40>
         up <0, 1, 0>
         right <2/3, 0, 0>
         direction <0, 0, FoV_45>
         look_at <-5, 7.5, -5> }

// some textures
#declare RoughKerb = texture {
  pigment { color Gray90 }
  finish { ambient 0 }
  normal { granite 0.1 scale 0.2 } }
#declare RoughStone = texture {
  pigment { color Gray75 }
  finish { ambient 0 }
  normal { granite 0.15 scale 0.02 } }
#declare Paving = texture {
  pigment { granite
            color_map { [0 color Gray20]
                        [0.1 color Gray75]
                        [1 color Gray75] }
            scale 2 }
  finish { ambient 0 }
  normal { granite 0.1 scale 2 } }
#declare Road = texture {
  pigment { gradient z turbulence 0.1 octaves 8 omega 0.7
            color_map { [0 color Gray50]
                        [0.15 color Gray45]
                        [0.3 color Gray40]
                        [0.45 color Gray35]
                        [0.55 color Gray35]
                        [0.7 color Gray40]
                        [0.85 color Gray45]
                        [1 color Gray50] }
            scale 4 }
  finish { ambient 0 }
  normal { crackle 0.5 scale 0.01 } }
#declare WhiteLine = texture {
  pigment { bozo turbulence 0.2 octaves 8 omega 0.7
            color_map { [0 color White]
                        [0.8 color White]
                        [0.801 color Clear]
                        [1 color Clear] }
            scale 0.1 }
  finish { ambient 0 diffuse 0.8 } }

// double lamp-post
#declare LampStruts = union {
  cylinder { <0.15, 0, 0>, <0.1, -0.3, 0>, 0.01 }
  cylinder { <0.15, 0, 0>, <0.1, -0.3, 0>, 0.01 rotate <0, 45, 0> }
  cylinder { <0.15, 0, 0>, <0.1, -0.3, 0>, 0.01 rotate <0, 90, 0> }
  cylinder { <0.15, 0, 0>, <0.1, -0.3, 0>, 0.01 rotate <0, 135, 0> }
  cylinder { <0.15, 0, 0>, <0.1, -0.3, 0>, 0.01 rotate <0, 180, 0> }
  cylinder { <0.15, 0, 0>, <0.1, -0.3, 0>, 0.01 rotate <0, 225, 0> }
  cylinder { <0.15, 0, 0>, <0.1, -0.3, 0>, 0.01 rotate <0, 270, 0> }
  cylinder { <0.15, 0, 0>, <0.1, -0.3, 0>, 0.01 rotate <0, 315, 0> }
  no_shadow }
#declare LampHang = union {
  difference { torus { 0.5, 0.05 rotate <90, 0, 0> translate <0.5, 0, 0> }
               plane { <0, 1, 0>, 0 } }
  difference { sphere { <1, 0, 0>, 0.15 scale <1, 0.5, 1> }
               plane { <0, 1, 0>, 0 } }
  torus { 0.15, 0.025 translate <1, 0, 0> }
  object { LampStruts translate <1, 0, 0> }
  torus { 0.1, 0.025 translate <1, -0.3, 0> }
  difference { sphere { <1, 0, 0>, 0.075 scale <1, 0.5, 1> }
               plane { <0, -1, 0>, 0 }
               translate <0, -0.3, 0> }
  sphere { <1, -0.34, 0>, 0.05 }
  sphere { <1, -0.34, 0>, 0.75 pigment { color rgbt <0,0,0,1> } hollow
           interior {
             media {
               emission 1
               density {
                 spherical density_map {
                   [0 rgbt <0,0,0,1>]
                   [0.3 rgbt <0.1, 0.09, 0.07, 1>]
                   [0.6 rgbt <0.333, 0.3, 0.233, 1>]
                   [0.8 rgbt <1, 0.9, 0.7, 1>]
                   [1 rgbt <1, 0.9, 0.7, 1>] } }
               scale 0.75
               translate <1, -0.1, 0> } } }
  light_source { <1, -0.125, 0> color 1.5*Orange
                 area_light <0.125, 0, 0>, <0, 0.125, 0>, 5, 5
                 adaptive 0.2 jitter circular orient
                 fade_power 1 fade_distance 1 }
  sphere { <1, -0.1, 0>, 0.1 pigment { color rgb <1, 0.9, 0.7> } finish { ambient 1 diffuse 0 } no_shadow } }
#declare LampPostBase = union {
  cone { <0, 0, 0>, 0.3, <0, 0.3, 0>, 0.2 }
  torus { 0.2, 0.025 translate <0, 0.3, 0> }
  difference { cylinder { <0, 0.3, 0>, <0, 0.6, 0>, 0.2 }
               torus { 0.2, 0.1 scale <1, 3, 1> translate <0, 0.6, 0> } }
  torus { 0.1, 0.025 translate <0, 0.6, 0> }
  cylinder { <0.04, 0.6, 0>, <0.04, 3, 0>, 0.05 }
  cylinder { <0.04, 0.6, 0>, <0.04, 3, 0>, 0.05 rotate <0, 45, 0> }
  cylinder { <0.04, 0.6, 0>, <0.04, 3, 0>, 0.05 rotate <0, 90, 0> }
  cylinder { <0.04, 0.6, 0>, <0.04, 3, 0>, 0.05 rotate <0, 135, 0> }
  cylinder { <0.04, 0.6, 0>, <0.04, 3, 0>, 0.05 rotate <0, 180, 0> }
  cylinder { <0.04, 0.6, 0>, <0.04, 3, 0>, 0.05 rotate <0, 225, 0> }
  cylinder { <0.04, 0.6, 0>, <0.04, 3, 0>, 0.05 rotate <0, 270, 0> }
  cylinder { <0.04, 0.6, 0>, <0.04, 3, 0>, 0.05 rotate <0, 315, 0> }
  torus { 0.1, 0.025 translate <0, 3, 0> } }
#declare LampPost1 = union {
  object { LampPostBase }
  object { LampHang translate <0.05, 3, 0> }
  object { LampHang rotate <0, 180, 0> translate <-0.05, 3, 0> }
  difference { sphere { <0, 0, 0>, 0.1 scale <1, 1.5, 1> }
               plane { <0, 1, 0>, 0 }
               translate <0, 3, 0> }
  sphere { <0, 3.16, 0>, 0.04 }
  pigment { color Gray20 }
  finish { ambient 0 phong 1 phong_size 30 } }

// lamp streak macro
#macro LampStreak(pos1, pos2, pos3, wid, rad, col)
  sphere_sweep {
    cubic_spline
    5,
    #local b = vnormalize(vcross(pos2-pos1,y));
    pos1+pos1-pos2+b*wid, rad
    pos1+b*wid, rad
    #local a = vnormalize(pos2-pos1) + vnormalize(pos3-pos2);
    #local b = vnormalize(vcross(a, y));
    pos2+b*wid, rad
    #local b = vnormalize(vcross(pos3-pos2,y));
    pos3+b*wid, rad
    pos3+pos3-pos2+b*wid, rad
    no_shadow
    pigment { color col }
    finish { ambient 1 diffuse 0 } }
  sphere_sweep {
    cubic_spline
    5,
    #local b = vnormalize(vcross(pos2-pos1,y));
    pos1+pos1-pos2-b*wid, rad
    pos1-b*wid, rad
    #local a = vnormalize(pos2-pos1) + vnormalize(pos3-pos2);
    #local b = vnormalize(vcross(a, y));
    pos2-b*wid, rad
    #local b = vnormalize(vcross(pos3-pos2,y));
    pos3-b*wid, rad
    pos3+pos3-pos2-b*wid, rad
    no_shadow
    pigment { color col }
    finish { ambient 1 diffuse 0 } }
#end
// chain and blocks
#declare Block = union {
  difference { object { SlantedBox(0.5, 0.6, 0.5, 0.02) translate <0, 0.4, 0> }
               object { Cube scale <0.025, 0.3, 0.4> translate <0.5, 0.6, 0> }
               object { Cube scale <0.025, 0.3, 0.4> translate <-0.5, 0.6, 0> }
               object { Cube scale <0.4, 0.3, 0.025> translate <0, 0.6, 0.5> }
               object { Cube scale <0.4, 0.3, 0.025> translate <0, 0.6, -0.5> } }
  object { SlantedBox(0.525, 0.1, 0.525, 0.02) }
  object { SlantedBox(0.475, 0.1, 0.475, 0.02) translate <0, 1, 0> }
  texture { RoughStone } }
#declare Link = union {
  difference { torus { 0.05, 0.02 }
               plane { <0, 0, -1>, 0 }
               translate <0, 0, -0.025> }
  cylinder { <0.05, 0, 0.025>, <0.05, 0, -0.025>, 0.02 }
  cylinder { <-0.05, 0, 0.025>, <-0.05, 0, -0.025>, 0.02 }
  difference { torus { 0.05, 0.02 }
               plane { <0, 0, 1>, 0 }
               translate <0, 0, 0.025> }
  pigment { color Bronze }
  finish { ambient 0 phong 0.5 phong_size 10 }
  normal { dents 1 scale 0.01 } }
// simple circular link path - endpoints must be at same height and same x-position
#declare p1 = <0, 0.8, -2.5>;
#declare p2 = <0, 0.8, 2.5>;
#declare r = 8;
#declare centre = ((p1-p2)/2)+p2;
#declare ang = degrees(asin(vlength((p1-p2)/2) / r));
#declare centre = <centre.x, centre.y+sqrt(r*r - pow(vlength((p1-p2)/2),2)), centre.z>;
#declare ll = 0.11;
#declare angp = degrees(ll/r);
#declare a = -ang;
#declare Chain = union {
  #while (a <= ang)
    object { Link translate <0, -r, 0> rotate <a, 0, 0> }
    #declare a = a + angp;
    object { Link rotate <0, 0, 90> translate <0, -r, 0> rotate <a, 0, 0> }
    #declare a = a + angp;
  #end
  translate centre }

// brick row macro
#macro BrickLine(zini, zfin, wid, hei, space, gap, bev)
  #local zp = zini;
  #while (zp < zfin)
    object { SlantedBox(wid, hei, space-gap/2, bev) translate <0, 0, zp> }
    #declare zp = zp + space * 2;
  #end
#end
// quay edge bricks
#declare QuayBricks = union {
  BrickLine(-40, 80, 0.5, 1, 1, 0.02, 0.02)
  texture { RoughKerb } }
// kerbstones
#declare KerbStones = union {
  BrickLine(-80, 80, 0.2, 0.12, 2, 0.02, 0.02)
  texture { RoughKerb } }
// highway
#declare LineWidth = 0.05;
#declare LineLength = 1;
#declare UnderRoad = union {
  object { Cube scale <11, 1, 100> translate <0, -1, 0> }
  // road surface
  object { Cube scale <4.1, 0.0001, 100> texture { Road rotate <0, 90, 0> } translate <4, 0, 0> }
  object { Cube scale <4.1, 0.0001, 100> texture { Road rotate <0, 90, 0> } translate <-4, 0, 4> }
  // pavements
  object { SlantedBox(4, 0.1, 100, 0.02) translate <12, 0, 0> texture { Paving } }
  object { SlantedBox(4, 0.1, 100, 0.02) translate <-12, 0, 0> texture { Paving } }
  // quay edge
  object { QuayBricks translate <-16.02, -1+0.12, 0> }
  // kerbstones
  object { KerbStones translate <-8.18, 0, -1> }
  object { KerbStones translate <8.18, 0, 3> }
  // quayside blocks + chains
  object { Block translate <-14, 0, -15> }
  object { Block translate <-14, 0, -9> }
  object { Block translate <-14, 0, -3> }
  object { Block translate <-14, 0, 3> }
  object { Block translate <-14, 0, 9> }
  object { Block translate <-14, 0, 15> }
  object { Block translate <-14, 0, 21> }
  object { Block translate <-14, 0, 27> }
  object { Block translate <-14, 0, 33> }
  object { Block translate <-14, 0, 39> }
  object { Block translate <-14, 0, 45> }
  object { Block translate <-14, 0, 51> }
  object { Chain translate <-14, 0, -12> }
  object { Chain translate <-14, 0, -6> }
  object { Chain translate <-14, 0, 0> }
  object { Chain translate <-14, 0, 6> }
  object { Chain translate <-14, 0, 12> }
  object { Chain translate <-14, 0, 18> }
  object { Chain translate <-14, 0, 24> }
  object { Chain translate <-14, 0, 30> }
  object { Chain translate <-14, 0, 36> }
  object { Chain translate <-14, 0, 42> }
  object { Chain translate <-14, 0, 48> }
  // lamp-posts
  object { LampPost1 translate <-9.25, 0, -20> }
  object { LampPost1 translate <-9.25, 0, 0> }
  object { LampPost1 translate <-9.25, 0, 20> }
  object { LampPost1 translate <9.25, 0, -10> }
  object { LampPost1 translate <9.25, 0, 10> }
  // road markings
  union {
    object { Cube scale <LineWidth, 0.0002, 100> translate <0.2, 0, 0> }
    object { Cube scale <LineWidth, 0.0002, 100> translate <7.8, 0, 0> }
    object { Cube scale <LineWidth, 0.0002, 100> translate <-0.2, 0, 0> }
    object { Cube scale <LineWidth, 0.0002, 100> translate <-7.8, 0, 0> }
    #declare zp = -100;
    #while (zp < 100)
      object { Cube scale <LineWidth, 0.0002, LineLength> translate <4, 0, zp> }
      object { Cube scale <LineWidth, 0.0002, LineLength> translate <-4, 0, zp> }
      #declare zp = zp + LineLength*5;
    #end
    texture { WhiteLine } }
  pigment { color Gray75 }
  finish { ambient 0 } }

// railing components
#declare Railing = union {
  torus { 0.15, 0.025 translate <0, 0.025, 0> }
  difference {
    sphere { <0, 0.125, 0>, 0.175 }
    plane { <0, 1, 0>, 0 } }
  torus { 0.15, 0.025 translate <0, 0.25, 0> }
  sphere { <0, 0, 0>, 0.25 scale <1, 1.25, 1> translate <0, 0.5, 0> }
  torus { 0.15, 0.025 translate <0, 0.75, 0> }
  difference {
    sphere { <0, 0.875, 0>, 0.175 }
    plane { <0, -1, 0>, -1 } }
  torus { 0.15, 0.025 translate <0, 0.975, 0> }
  scale 0.8
  texture { RoughStone } }
#declare RailingBlock = union {
  difference {
    object { SlantedBox(0.5, 0.75, 0.4, 0.02) translate <0, 0.75, 0> }
    object { Cube scale <0.4, 0.4, 0.05> translate <0, 1, -0.4> }
    object { Cube scale <0.4, 0.4, 0.05> translate <0, 1, 0.4> } }
  object { Cube scale <0.45, 0.05, 0.35> translate <0, 1.5, 0> }
  sphere { <0, 1.7, 0>, 0.25 }
  translate <0, -0.02, 0>
  texture { RoughStone } }
#declare RailingRow = union {
  object { Railing translate <-4.25, 0, 0> }
  object { Railing translate <-3.75, 0, 0> }
  object { Railing translate <-3.25, 0, 0> }
  object { Railing translate <-2.75, 0, 0> }
  object { Railing translate <-2.25, 0, 0> }
  object { Railing translate <-1.75, 0, 0> }
  object { Railing translate <-1.25, 0, 0> }
  object { Railing translate <-0.75, 0, 0> }
  object { Railing translate <-0.25, 0, 0> }
  object { Railing translate <0.25, 0, 0> }
  object { Railing translate <0.75, 0, 0> }
  object { Railing translate <1.25, 0, 0> }
  object { Railing translate <1.75, 0, 0> }
  object { Railing translate <2.25, 0, 0> }
  object { Railing translate <2.75, 0, 0> }
  object { Railing translate <3.25, 0, 0> }
  object { Railing translate <3.75, 0, 0> }
  object { Railing translate <4.25, 0, 0> } }
#declare Circut = union {
  cone { <0, 0, 0>, 1.02, <0, 0, 0.02>, 1 }
  cylinder { <0, 0, 0>, <0, 0, 0.1>, 1 } }
#declare Brickwork = union {
  #declare xp = -40;
  #while (xp <= 40)
    object { SlantedBox(0.99, 0.49, 0.5, 0.02) translate <xp, 0, 0> }
    #declare xp = xp + 2;
  #end }

//bridge
#declare Bridge = union {
  difference {
    union {
      object { Cube scale <100, 5, 7.8> translate <0, 4.9, 0> }
      object { Brickwork translate <0, 8.5, -7.45> }
      object { Brickwork translate <1, 7.5, -7.45> }
      object { Brickwork translate <0, 6.5, -7.45> }
      object { Brickwork translate <1, 5.5, -7.45> }
      object { Brickwork translate <0, 4.5, -7.45> }
      object { Brickwork translate <1, 3.5, -7.45> } }
    cylinder { <0, -10, -10>, <0, -10, 10>, 15 scale <3, 1, 1> translate <-10, 0, 0> } }
  // road surface
  object { Cube scale <100, 0.0001, 4.1> translate <0, 9.9, 0> texture { Road translate <0, 0, 8> } }
  // pavements
  object { SlantedBox(100, 0.1, 1.9, 0.02) translate <0, 9.9, -5.9> texture { Paving } }
  object { SlantedBox(100, 0.1, 1.9, 0.02) translate <0, 9.9, 5.9> texture { Paving } }
  // kerbstones
  object { KerbStones rotate <0, 90, 0> translate <0, 9.9, -4.18> }
  object { KerbStones rotate <0, 90, 0> translate <0, 9.9, 4.18> }
  // arch panel
  difference {
    cylinder { <0, -10, -0.08>, <0, -10, 0.1>, 16 scale <3, 1, 1> }
    cylinder { <0, -10, -0.2>, <0, -10, 0.2>, 15 scale <3, 1, 1> }
    translate <-10, 0, -7.9> }
  difference {
    cone { <0, -10, -0.08>, 16, <0, -10, -0.1>, 15.98 scale <3, 1, 1> }
    cylinder { <0, -10, -0.2>, <0, -10, 0.2>, 15 scale <3, 1, 1> }
    cone { <0, -10, -0.2>, 15.04, <0, -10, 0.2>, 14.96 scale <3, 1, 1> }
    translate <-10, 0, -7.9> }
  difference {
    cylinder { <0, -10, -0.08>, <0, -10, 0.1>, 15.9 scale <3, 1, 1> }
    cylinder { <0, -10, -0.2>, <0, -10, 0.2>, 15.1 scale <3, 1, 1> }
    translate <-10, 0, -8> }
  difference {
    cone { <0, -10, -0.08>, 15.9, <0, -10, -0.1>, 15.88 scale <3, 1, 1> }
    cylinder { <0, -10, -0.2>, <0, -10, 0.2>, 15.1 scale <3, 1, 1> }
    cone { <0, -10, -0.2>, 15.14, <0, -10, 0.2>, 15.04 scale <3, 1, 1> }
    translate <-10, 0, -8> }
  // panel surround
  object { SlantedBox(100, 0.4, 0.1, 0.02) translate <0, 9.5, -7.98> }
  object { SlantedBox(100, 0.5, 0.1, 0.02) translate <0, 9.5, -7.9> }
  // railing base / rail
  object { SlantedBox(100, 0.2, 0.175, 0.02) translate <0, 10, -7.5> }
  object { SlantedBox(100, 0.2, 0.175, 0.02) translate <0, 10, 7.5> }
  object { SlantedBox(100, 0.1, 0.175, 0.02) translate <0, 11.025, -7.5> }
  object { SlantedBox(100, 0.1, 0.175, 0.02) translate <0, 11.025, 7.5> }
  cylinder { <-100, 11.125, 0>, <100, 11.125, 0>, 0.1 scale <1, 1, 2.5> translate <0, 0, -7.5> }
  cylinder { <-100, 11.125, 0>, <100, 11.125, 0>, 0.1 scale <1, 1, 2.5> translate <0, 0, 7.5> }
  // plinths
  object { RailingBlock translate <-30, 10, -7.5> }
  object { RailingBlock translate <-30, 10, 7.5> }
  object { RailingBlock translate <-20, 10, -7.5> }
  object { RailingBlock translate <-20, 10, 7.5> }
  object { RailingBlock translate <-10, 10, -7.5> }
  object { RailingBlock translate <-10, 10, 7.5> }
  object { RailingBlock translate <0, 10, -7.5> }
  object { RailingBlock translate <0, 10, 7.5> }
  object { RailingBlock translate <10, 10, -7.5> }
  object { RailingBlock translate <10, 10, 7.5> }
  object { RailingBlock translate <20, 10, -7.5> }
  object { RailingBlock translate <20, 10, 7.5> }
  // railing verticals
  object { RailingRow translate <-25, 10.15, -7.5> }
  object { RailingRow translate <-25, 10.15, 7.5> }
  object { RailingRow translate <-15, 10.15, -7.5> }
  object { RailingRow translate <-15, 10.15, 7.5> }
  object { RailingRow translate <-5, 10.15, -7.5> }
  object { RailingRow translate <-5, 10.15, 7.5> }
  object { RailingRow translate <5, 10.15, -7.5> }
  object { RailingRow translate <5, 10.15, 7.5> }
  object { RailingRow translate <15, 10.15, -7.5> }
  object { RailingRow translate <15, 10.15, 7.5> }
  object { RailingRow translate <25, 10.15, -7.5> }
  object { RailingRow translate <25, 10.15, 7.5> }
  // lamp-posts
  object { LampPost1 rotate <0, 90, 0> translate <-25, 10, -4.75> }
  object { LampPost1 rotate <0, 90, 0> translate <-5, 10, -4.75> }
  object { LampPost1 rotate <0, 90, 0> translate <15, 10, -4.75> }
  object { LampPost1 rotate <0, 90, 0> translate <-35, 10, 4.75> }
  object { LampPost1 rotate <0, 90, 0> translate <-15, 10, 4.75> }
  object { LampPost1 rotate <0, 90, 0> translate <5, 10, 4.75> }
  // road markings
  union {
    object { Cube scale <100, 0.0002, LineWidth> translate <0, 9.9, -3.8> }
    object { Cube scale <100, 0.0002, LineWidth> translate <0, 9.9, 3.8> }
    #declare xp = -100;
    #while (xp < 100)
      object { Cube scale <LineLength, 0.0002, LineWidth> translate <xp, 9.9, 0> }
      #declare xp = xp + LineLength*5;
    #end
    texture { WhiteLine } }
  texture { RoughStone } }

// headlamp streaks
#macro Streak(pos1, pos2, wid, rad, typ)
  #local b = vnormalize(vcross(pos2-pos1,y));
  #local col = rgb <1,0,0>;
  #local em = 4;
  #local ra = rad*3;
  union {
    #if (typ = 1)
      cylinder { pos1+b*wid, pos2+b*wid, rad pigment { color White } finish { ambient 1 diffuse 0 } no_shadow }
      cylinder { pos1-b*wid, pos2-b*wid, rad pigment { color White } finish { ambient 1 diffuse 0 } no_shadow }
      #local col = rgb <1,0.85,0.6>;
      #local em = 4;
      #local ra = rad*8;
    #end
    cylinder { pos1+b*wid, pos2+b*wid, ra hollow no_shadow
               pigment { color rgbt 1 }
               interior { media {
                            emission em
                            density {
                              cylindrical
                              density_map { [0 color rgb 0]
                                            [1 color col] } }
                            scale ra
                            rotate <90, 0, 0>
                            #if (pos2.x != pos1.x)
                              rotate <0, degrees(atan2(pos2.x-pos1.x, pos2.z-pos1.z)), 0>
                            #end
                            translate 0.5*(pos2-pos1) + pos1 + b*wid } } }
    cylinder { pos1-b*wid, pos2-b*wid, ra hollow no_shadow
               pigment { color rgbt 1 }
               interior { media {
                            emission em
                            density {
                              cylindrical
                              density_map { [0 color rgb 0]
                                            [1 color col] } }
                            scale ra
                            rotate <90, 0, 0>
                            #if (pos2.x != pos1.x)
                              rotate <0, degrees(atan2(pos2.x-pos1.x, pos2.z-pos1.z)), 0>
                            #end
                            translate 0.5*(pos2-pos1) + pos1 - b*wid } } } }
#end
#declare r1 = seed(3);
#declare Headlights = union {
  #declare n = 0;
  #while (n < 5)
    #declare h = rand(r1)*0.15+0.2;
    Streak(<-3+rand(r1)*2, h, 100>, <-3+rand(r1)*2, h, -100>, rand(r1)*0.3+0.6, rand(r1)*0.005+0.015, 1)
    Streak(<-7+rand(r1)*2, h, 100>, <-7+rand(r1)*2, h, -100>, rand(r1)*0.3+0.6, rand(r1)*0.005+0.015, 1)
    Streak(<1+rand(r1)*2, h, 100>, <1+rand(r1)*2, h, -100>, rand(r1)*0.3+0.6, rand(r1)*0.005+0.015, 2)
    Streak(<5+rand(r1)*2, h, 100>, <5+rand(r1)*2, h, -100>, rand(r1)*0.3+0.6, rand(r1)*0.005+0.015, 2)
    #declare n = n + 1;
  #end
  Streak(<-3+rand(r1)*2, 0.3, 100>, <-7+rand(r1)*2, 0.5, -100>, rand(r1)*0.3+0.6, rand(r1)*0.01+0.015, 1)
  Streak(<1+rand(r1)*2, 0.3, 100>, <5+rand(r1)*2, 0.5, -100>, rand(r1)*0.3+0.6, rand(r1)*0.01+0.015, 2) }
#declare BridgeHeadlights = union {
  #declare n = 0;
  #while (n < 6)
    #declare h = rand(r1)*0.15+0.2;
    Streak(<-3+rand(r1)*2, h, 100>, <-3+rand(r1)*2, h, -100>, rand(r1)*0.3+0.6, rand(r1)*0.01+0.015, 1)
    Streak(<1+rand(r1)*2, h, 100>, <1+rand(r1)*2, h, -100>, rand(r1)*0.3+0.6, rand(r1)*0.01+0.015, 2)
    #declare n = n + 1;
  #end
  rotate <0, -90, 0>
  translate <0, 10, 8> }

object { UnderRoad }

object { Headlights }

object { Bridge translate <0, 0, 8> }

object { BridgeHeadlights }

// sky and water elements
plane { <0, 1, 0>, -5 pigment { color Black }
                      finish { ambient 0 diffuse 0.4 reflection { 0.75 } }
                      normal { bozo 0.4 turbulence 0.1 scale <0.3, 0.3, 2> rotate <40, 0, 0> } }
sphere { <0, 0, 0>, 1000000 hollow
         pigment { gradient y
                   color_map { [0 color SkyBlue]
                               [0.3 color rgb<0.1,0.05,0.05>]
                               [1 color Black] }
                   scale 1000000 }
         finish { ambient 1 diffuse 0 } }
cylinder { <-200, 0, 180>, <-200, 100, 180>, 1 pigment { color rgb <1,0.9,0.7> } finish { ambient 1 } }
cylinder { <-200, 0, 120>, <-200, 75, 120>, 1 pigment { color White } finish { ambient 1 } }
