//override the materials output by daz via poseray
//these materials redefine the names actually applied in the _mat.inc files poseray generates,

#version unofficial megapov 1.21;

//default controls, can be overridden by calling scene file.
#ifndef ( childSkin )	#declare childSkin = off;	#end
#ifndef (jacketColour)	#declare jacketColour = .1;	#end
#ifndef (trouserColour)	#declare trouserColour = .1;	#end
#ifndef (shirtColour)	#declare shirtColour = .8;	#end
#ifndef (hairColour)	#declare hairColour = 1;	#end
#ifndef (tiePattern)	#declare tiePattern = p_map12;	#end


//modify these macros to globally affect everything of that type
#macro Skin( colourmap, normalmap, sheenScale )
	#if (1)
		#if ( childSkin )
			#declare sheenScale = sheenScale*.2;
			#declare fudge = 30;
		#else
			#declare fudge = 100;
		#end
		#if ( childSkin ) //this is basically the same, but pov gets bitchy about #ifs in the middle of layered textures
			texture {
				//Child sub-surface
				pigment { rgb x*.85*2*1.2 }		//fake sub surface, red has different brilliance
				normal { uv_mapping normalmap }
				finish { brilliance 1.5 }
			}
			texture {
				pigment { rgb (y+z)*2*1.2 transmit .5 }
				normal { uv_mapping normalmap }
				finish { brilliance 2 }
			}
			texture {
				//freckles!
				pigment {
					crackle solid scale .001
					poly_wave .2
					colour_map { [0 rgb <.5,.2,.03>][1 rgb <.5,.2,.03> transmit 1] }
				}
				finish { diffuse 0 }
			}
			texture {
				pigment { colourmap }
				finish { diffuse 0 }
			}
			texture {
				pigment { colourmap } //gamma correct from 2.2 to linear space - filter over itself
				normal { uv_mapping normalmap }
				finish { diffuse 0 specular .15*sheenScale roughness 1/fudge }	//sharp highlight
			}
			texture {
				pigment { rgb 0 transmit 1 }
				normal { uv_mapping normalmap }
				finish {
					phong 1 phong_size 30 metallic 1	//small-angle sheen, metallic on black material controls falloff of specular
					//reflection { .2 metallic 1 } conserve_energy
				}
			}
		#else
			texture {
				//Adult sub-surface
				pigment { rgb x*.9*2 }		//.9 - actually lessen redness on bits facing light, for balance.
				normal { uv_mapping normalmap }
				finish { brilliance 1.7 } //less sub surface
			}
			texture {
				pigment { rgb (y+z)*2 transmit .5 }
				normal { uv_mapping normalmap }
				finish { brilliance 2 }
			}
			texture {
				pigment { colourmap }
				finish { diffuse 0 }
			}
			texture {
				pigment { colourmap } //gamma correct from 2.2 to linear space - filter over itself
				normal { uv_mapping normalmap }
				finish { diffuse 0 specular .15*sheenScale roughness 1/fudge }	//sharp highlight
			}
			texture {
				pigment { rgb 0 transmit 1 }
				normal { uv_mapping normalmap }
				finish {
					phong 1 phong_size 30 metallic 1	//small-angle sheen, metallic on black material controls falloff of specular
					//reflection { .2 metallic 1 } conserve_energy
				}
			}
		#end
	#else
		texture {} //default
	#end
#end

#macro HairNorm( colourMap, normalMap, opacityMap )
	#if ( hairFull )
		#local layered =
					texture {
						pigment{ rgb hairColour } 
						normal { uv_mapping normalMap }
						finish{
							diffuse defaultDiffuse/2
							phong defaultDiffuse/2 phong_size 10 metallic 1
						}
					}
					texture {
						pigment{ colourMap } //could put second aniso highlight in here.
						finish { diffuse 0 }
					}
					texture {
						pigment{ colourMap }
						normal { uv_mapping normalMap }
						finish { diffuse 0 specular .5 roughness 1/50 metallic .9 } //was .17 .8 but wasn't showing now hair bumpier
					};
		texture{
			pigment_pattern{ opacityMap }
			texture_map{
				[0 pigment { rgbt 1 }]
				[1
					layered
				]
			}
		}
	#else
		texture {}
	#end
#end

#macro Hair( colourMap, opacityMap )
	#local norm = 
		normal {
			//assume hairs along v
			uv_mapping
			spotted scale <.02,1,1>*.25
			//granite scale <.02,1,1>*40
		}
	HairNorm( colourMap, norm, opacityMap )
#end

#macro Fabric( colourMap, tint, wrinkle, acc )
	#local col = <pow((tint*x).x,.3),pow((tint*y).y,.3),pow((tint*z).z,.3)>; //desaturate towards white, but keep a hint of the original colour.
	#if ( wrinkle > 0 )
		#local realWrinkles =
			normal {
				uv_mapping
				//the "wrinkles" pattern looks nothing like wrinkles.
				pigment_pattern {
					average
					pigment_map {
						[1 crackle poly_wave 2]
						[1 crackle translate 6 poly_wave 2]
						[1 crackle translate -6 poly_wave 2]
					}
				} wrinkle
				turbulence .2
				octaves 4
				scale .05//.03
				accuracy acc
			}
	#else
		#local realWrinkles = normal { spotted 0 };
	#end
	texture{
		pigment{ colourMap }
		//normal { uv_mapping quilted -.3 cubic_wave scale .0003 }
		normal { realWrinkles }
	}
	texture{
		pigment{ rgb tint filter 1 }
	}
	texture { //fuz effect, anisotropic stuff
		pigment {
			pigment_pattern { aoi colour_map { [0 rgb 0][.5 rgb 1] } }
			poly_wave 5
			colour_map {
				[0 rgb col transmit 1]
				[1 rgb col transmit .7]
			}
		}
		finish { brilliance .3 }//diffuse 0 ambient 1 }
		normal { realWrinkles }
	}
#end



//head skin
#declare SkinHead_= Skin( p_map4, p_map5, 1 )
#declare SkinScalp_= Skin( p_map4, p_map5, 1 )
#declare Nostrils_= Skin( p_map4, p_map5, 1 )
#declare EyeSocket_= Skin( p_map4, p_map5, 1 )
#declare InnerMouth_= Skin( p_map4, p_map5, 1 )
#declare Lips_= Skin( p_map4, p_map5, 1 )
#declare Lacrimal_= Skin( p_map4, p_map5, 1 )
#declare Tongue_= Skin( p_map4, p_map5, 1 )
#declare Gums_= Skin( p_map6, p_map7, 1 )

//teeth
#declare Teeth_=  //todo
texture{pigment {color rgb <1,1,1> transmit  0} 
        normal{uv_mapping p_map7 bump_size -0.15} 
        finish{phong 1 phong_size 10.1753 diffuse 0.6*1 ambient rgb <0.0745098,0.0745098,0.0745098> reflection{0 }}}
texture{pigment{p_map6} 
        normal{uv_mapping p_map7 bump_size -0.15} 
        finish{ phong 1 phong_size 10.1753 diffuse 0.6*1 ambient rgb <0.0745098,0.0745098,0.0745098> reflection{0 }}}

//wedge cut hair
#declare Layer1_= Hair( p_map14, p_map15 )
#declare Layer2_= Hair( p_map14, p_map16 )
#declare Layer3_= Hair( p_map14, p_map17 )
#declare Layer4_= Hair( p_map14, p_map18 )
#declare SweptBangs1_= Hair( p_map14, p_map19 )
#declare SmallBangs_= Hair( p_map14, p_map19 )

//jason hair
#declare scalp_ = HairNorm( p_map14j, p_map15j, p_map16j )
#declare front_ = HairNorm( p_map17j, p_map18j, p_map19j )
#declare middle_= HairNorm( p_map20j, p_map21j, p_map22j )
#declare back_  = HairNorm( p_map23j, p_map24j, p_map25j )


#declare PubicHair__opaque=texture{} //pretty sure you ain't gonna be seeing this!

#declare Eyebrows_= 
	texture{
		pigment_pattern{ p_map3 }
		texture_map{
			[0 pigment{ rgbt 1 }]
			[1
				pigment {color rgb <0.223529411764706,0.141176470588235,0.0117647058823529> transmit  0} 
			]
		}
	}
#declare Eyelashes_= 
	texture{
		pigment_pattern{ p_map3 }
		texture_map{
			[0 pigment{ rgbt 1 }]
			[1
				pigment {color rgb <0.223529411764706,0.141176470588235,0.0117647058823529> transmit  0} 
			]
		}
	}


//eyes
#declare LPupil_= 
	texture {
		pigment { rgb 1 }
		normal { uv_mapping p_map9 bump_size -0.15 }
	}
	texture{ pigment{ p_map8 } finish{ diffuse 0 } }
	texture{ pigment{ p_map8 } finish{ diffuse 0 } }	//gamma correction - filter over itself. obviously could just correct textures but this saves me some work (plus gamma correcting textures would unevenly reduce their colour depth)
#declare LIris_= 
	texture{
		pigment { rgb 1 }
		normal{ uv_mapping p_map9 bump_size -0.2 } 
		finish{ phong .05 phong_size 10 }	//it's under the cornea so doesn't need much.
	}
	texture{ pigment{ p_map8 } finish{ diffuse 0 } }
	texture{ pigment{ p_map8 } finish{ diffuse 0 } }	//gamma correction - filter over itself. obviously could just correct textures but this saves me some work (plus gamma correcting textures would unevenly reduce their colour depth)
#declare LCornea_= 
	texture {
		pigment { color rgbt 1 }
		finish {
			phong 2 phong_size 500
			reflection { .05, 1 falloff 5 } conserve_energy
		}
	}
#declare LEyewhite_= 
	texture{
		pigment{ rgb 1 }
		normal{ uv_mapping p_map9 bump_size -0.2 } 
	}
	texture{ pigment{ p_map8 } finish{ diffuse 0 } }
	texture{ pigment{ p_map8 } finish{ diffuse 0 } }	//gamma correction - filter over itself. obviously could just correct textures but this saves me some work (plus gamma correcting textures would unevenly reduce their colour depth)
	texture{
		pigment { rgbt 1 }
		finish{
			phong 1 phong_size 500
			reflection { .03, 1 falloff 5 } conserve_energy
		}
	}
#declare RCornea_= LCornea_;
#declare RPupil_= LPupil_;
#declare REyewhite_= LEyewhite_;
#declare RIris_= LIris_;


//body skin
#declare SkinNeck_= Skin( p_map1, p_map2, 1 )
#declare SkinHip_= Skin( p_map1, p_map2, 1 )
#declare SkinTorso_= Skin( p_map1, p_map2, 1 )
#declare Nipples_= Skin( p_map1, p_map2, 1 )
#declare SkinForearm_= Skin( p_map1, p_map2, .3 ) 
#declare SkinArm_= Skin( p_map1, p_map2, 1 ) 
#declare SkinHand_= Skin( p_map1, p_map2, .3 ) 
#declare Fingernails_= Skin( p_map1, p_map2, 1 ) 
#declare SkinLeg_= Skin( p_map1, p_map2, 1 ) 
#declare SkinFeet_= Skin( p_map1, p_map2, 1 ) 
#declare Toenails_= Skin( p_map1, p_map2, 1 ) 


//jacket
#declare Jacket_= Fabric(p_map13, jacketColour, .7, 1/20)
#declare PocketFlap_= Fabric(p_map13, jacketColour, .7, 1/20)
#declare Lapel_Notched_= Fabric(p_map13, jacketColour, .7, 1/20)

#declare Jacket_SBButtons_= 
texture{pigment{p_map13} 
        finish{ phong 0.4980392 phong_size 10.1753 diffuse 0.6*1 ambient rgb <0,0,0> reflection{0 }}}
#declare Button_Sleeves_= 
texture{pigment{p_map13} 
        finish{ phong 0.4980392 phong_size 10.1753 diffuse 0.6*1 ambient rgb <0,0,0> reflection{0 }}}

//trousers
#declare Pants_=  Fabric(p_map11, trouserColour, .7, 1/20)
#declare Button_Back_= 
texture{pigment {color rgb <0.984313725490196,0.984313725490196,0.984313725490196> transmit  0} 
        finish{phong 0.4980392 phong_size 10.1753 diffuse 0.6*1 ambient rgb <0,0,0> reflection{0 }}}
texture{pigment{p_map11} 
        finish{ phong 0.4980392 phong_size 10.1753 diffuse 0.6*1 ambient rgb <0,0,0> reflection{0 }}}
#declare Pocket_Flap_= 
texture{pigment{p_map11} 
        finish{ phong 0.04313725 phong_size 10.1753 diffuse 0.6*1 ambient rgb <0,0,0> reflection{0 }}}
#declare Belt_= 
	texture {
		pigment { rgb .01 }
		normal { wrinkles .1 poly_wave .2 scale .3 }
		finish { specular .8 roughness 1/200 }
	} 
#declare Belt_Buckle_= 
texture{pigment {color rgb <0,0,0> transmit  0} 
        finish{phong 1 phong_size 10.1753 diffuse 0.6*0.6 ambient rgb <0,0,0> reflection{0.4 }}}
#declare Belt_Loop_= Pants_;
#declare Belt_Loops_= Pants_;


//shirt        
#declare Shirt_= Fabric(p_map10, shirtColour, 1, 1/10)
#declare Shirtcenterline_= Fabric(p_map10, shirtColour, 1, 1/10) 
#declare Top_= Fabric(p_map10, shirtColour, 1, 1/10) 
#declare Collar_inner_= Fabric(p_map10, shirtColour, 1, 1/10) 
#declare Sleeve_= Fabric(p_map10, shirtColour, 1, 1/10) 
#declare Cuff_regular_= Fabric(p_map10, shirtColour, 1, 1/10)
#declare Collar_regular_= Fabric(p_map10, shirtColour, 1, 1/10) 

#declare Shirt_Buttons_= 
texture{pigment {color rgb <1,1,1> transmit  0} 
        finish{phong 0 phong_size 10.1753 diffuse 0.6*1 ambient rgb <0,0,0> reflection{0 }}}
texture{pigment{p_map10} 
        finish{ phong 0 phong_size 10.1753 diffuse 0.6*1 ambient rgb <0,0,0> reflection{0 }}}
#declare Cuff_button_= 
texture{pigment {color rgb <1,1,1> transmit  0} 
        finish{phong 0 phong_size 10.1753 diffuse 0.6*1 ambient rgb <0,0,0> reflection{0 }}}
texture{pigment{p_map10} 
        finish{ phong 0 phong_size 10.1753 diffuse 0.6*1 ambient rgb <0,0,0> reflection{0 }}}
#declare Button_Front_= 
texture{pigment {color rgb <0.749019607843137,0.549019607843137,0.447058823529412> transmit  0} 
        finish{phong 0.4980392 phong_size 10.1753 diffuse 0.6*1 ambient rgb <0,0,0> reflection{0 }}}
texture{pigment{p_map11} 
        finish{ phong 0.4980392 phong_size 10.1753 diffuse 0.6*1 ambient rgb <0,0,0> reflection{0 }}}
#declare Band_= 
texture{pigment {color rgb <0.0980392156862745,0.0980392156862745,0.0980392156862745> transmit  0} 
        finish{phong 0.4980392 phong_size 10.1753 diffuse 0.6*1 ambient rgb <0,0,0> reflection{0 }}}
texture{pigment{p_map11} 
        finish{ phong 0.4980392 phong_size 10.1753 diffuse 0.6*1 ambient rgb <0,0,0> reflection{0 }}}


//tie
#declare TieMaterial_= 
	texture{
		pigment{ tiePattern }
		finish { diffuse defaultDiffuse/2 phong defaultDiffuse phong_size 3 metallic 1 }
	}
#declare Tie_Neck_= TieMaterial_

        
//shoes
#declare Shoe_=
	texture {
		granite
		scale .05
		poly_wave .05
		texture_map {
			[0
				//worn
				pigment { rgb <.2,.14,.12> }
				normal { granite .1 poly_wave .2 }
				finish { }
			]
			[1
				//polished
				pigment { rgb <.01,.006,.005> }
				normal { granite .1 poly_wave .2 }
				finish { specular .3 roughness 1/200 }
			]
		}
	} 
#declare Inner_Upper_= Shoe_
#declare Upper_= Shoe_
#declare Heel_= Shoe_
#declare Laces_= Fabric( rgb 1, .03, 0, 1/10 );
#declare Socks_= Fabric( rgb 1, .1, 0, 1/10 );
//==================================================
#declare Sole_= 
texture{pigment {color rgb <0.12156862745098,0.12156862745098,0.12156862745098> transmit  0} 
        finish{phong 0.1808627 phong_size 10.1753 diffuse 0.6*1 ambient rgb <0,0,0> reflection{0 }}}
//==================================================
#declare Inner_Sole_= 
texture{pigment {color rgb <0.356862745098039,0.305882352941176,0.145098039215686> transmit  0} 
        finish{phong 0.1231373 phong_size 10.1753 diffuse 0.6*1 ambient rgb <0,0,0> reflection{0 }}}
//==================================================
#declare Eyelets_= 
texture{pigment {color rgb <0.666666666666667,0.666666666666667,0.666666666666667> transmit  0} 
        finish{phong 0.1231373 phong_size 10.1753 diffuse 0.6*1 ambient rgb <0,0,0> reflection{0 }}}


//glasses
#declare Glasses_= 
	texture {
		pigment { rgb .8 filter 1 }
		finish {
			diffuse 0
			specular 1 roughness 1/1000
			reflection { .03, 1 falloff 5 }
		}
	}

#declare Hinge_Cylinder_= 
texture{pigment {color rgb <0,0,0> transmit  0} 
        finish{phong 1 phong_size 10.1753 diffuse 0.6*0.6 ambient rgb <0,0,0> reflection{0.4 }}}
//==================================================
#declare Hinge1_= 
texture{pigment {color rgb <0,0,0> transmit  0} 
        finish{phong 1 phong_size 10.1753 diffuse 0.6*0.6 ambient rgb <0,0,0> reflection{0.4 }}}
//==================================================
#declare Hinge2_= 
texture{pigment {color rgb <0,0,0> transmit  0} 
        finish{phong 1 phong_size 10.1753 diffuse 0.6*0.6 ambient rgb <0,0,0> reflection{0.4 }}}
//==================================================
#declare Sides_Back_= 
texture{pigment {color rgb <0,0,0> transmit  0} 
        finish{phong 1 phong_size 10.1753 diffuse 0.6*0.6 ambient rgb <0,0,0> reflection{0.4 }}}
//==================================================
#declare Sides_Nose_= 
texture{pigment {color rgb <0.52156862745098,0.313725490196078,0> transmit  0.8} 
        finish{phong 0.6418431 phong_size 10.1753 diffuse 0.6*1 ambient rgb <0.2823529,0.1647059,0> reflection{0 }}}
//==================================================
#declare Metal_NoseSide_= 
texture{pigment {color rgb <0,0,0> transmit  0} 
        finish{phong 1 phong_size 10.1753 diffuse 0.6*0.6 ambient rgb <0,0,0> reflection{0.4 }}}
//==================================================
#declare Metal_Nose_= 
texture{pigment {color rgb <0,0,0> transmit  0} 
        finish{phong 1 phong_size 10.1753 diffuse 0.6*0.6 ambient rgb <0,0,0> reflection{0.4 }}}
//==================================================
#declare Sides_Middle_= 
texture{pigment {color rgb <0,0,0> transmit  0} 
        finish{phong 1 phong_size 10.1753 diffuse 0.6*0.6 ambient rgb <0,0,0> reflection{0.4 }}}
//==================================================
#declare Sides_Front_= 
texture{pigment {color rgb <0,0,0> transmit  0} 
        finish{phong 1 phong_size 10.1753 diffuse 0.6*0.6 ambient rgb <0,0,0> reflection{0.4 }}}



#if (childSkin)
	//textures different/unique for child
	//where possible these should just clone some of the main character ones, but some have to use different maps
	#declare SkinHead_ = Skin(childHeadColour,childHeadNormal, 1)
	#declare Lips_ = Skin(childHeadColour,childHeadNormal, 1)
	#declare Lacrimal_ = Skin(childHeadColour,childHeadNormal, 1)
	#declare InnerMouth_ = Skin(childHeadColour,childHeadNormal, 1)
	#declare Tongue_ = Skin(childHeadColour,childHeadNormal, 1)
	#declare Nostrils_ = Skin(childHeadColour,childHeadNormal, 1)
	#declare Teeth_ = Skin(childHeadColour,childHeadNormal, 1)
	#declare EyeBrows_ = Skin(childHeadColour,childHeadNormal, 1)
	#declare EyeLashes_= 
		texture{
			pigment_pattern{ childHeadTransp }
			texture_map{
				[0
					pigment {color rgb 1 transmit  1} 
				]
				[1
					pigment {color rgb hairColour*<.2,.15,.1> transmit  0} 
				]
			}
		}
	#declare UpperEyebrows_ = 
		texture{
			pigment_pattern{ childHeadTransp }
			texture_map{
				[0
					pigment {color rgb hairColour*<.4,.3,.2> transmit  1} 
				]
				[1
					pigment {color rgb hairColour*<.4,.3,.2> transmit  0} 
				]
			}
		}

	#declare Pupils_= 
		texture {
			pigment { rgb 0 }
		}
		/*texture {
			pigment { color rgbt 1 }
			finish {
				phong 2 phong_size 500
				reflection { .05, 1 falloff 5 } conserve_energy
			}
		}*/
	#declare Irises_= 
		texture{
			pigment { rgb 1 }
			finish{ phong .05 phong_size 10 }	//it's under the cornea so doesn't need much.
		}
		texture{ pigment{ childHeadColour } finish{ diffuse 0 } }
		texture{ pigment{ childHeadColour } finish{ diffuse 0 } }	//gamma correction - filter over itself. obviously could just correct textures but this saves me some work (plus gamma correcting textures would unevenly reduce their colour depth)
		/*texture {
			pigment { color rgbt 1 }
			finish {
				phong 2 phong_size 500
				reflection { .05, 1 falloff 5 } conserve_energy
			}
		}*/
	#declare Eyewhites_= Irises_ 
	#declare Eyeballs_= LCornea_

	#declare SkinBody_ = Skin(childBodyColour,childBodyNormal,1)
	#declare Fingernails_ = Skin(childBodyColour,childBodyNormal,1)
	#declare Toenails_ = Skin(childBodyColour,childBodyNormal,1)
	
	//child clothes
	#declare trouserPattern = pigment{ image_map { jpeg "worstenwoolgreytile.jpg" interpolate 2 transmit all 0 filter all 0} scale .25 }
	#declare Band_ = Belt_;
	#declare Shorts_ = Fabric( trouserPattern, trouserColour, 1.5, 1/20 );
	#declare Capris_ = Fabric( trouserPattern, trouserColour, 1.5, 1/20 );
	#declare Pants_ = Fabric( trouserPattern, trouserColour, 1.5, 1/20 );
	#declare sole_ = Sole_;
	#declare cloth_ = Shoe_;
	#declare sole_Preschool_Shoe_R_ = sole_
	#declare cloth_Preschool_Shoe_R_ = cloth_;

	//same shirt as adult, but more wrinkled
	#declare Shirt_= Fabric(p_map10, shirtColour, 2, 1/10)
	#declare Shirtcenterline_= Fabric(p_map10, shirtColour, 2, 1/10) 
	#declare Top_= Fabric(p_map10, shirtColour, 2, 1/10) 
	#declare Collar_inner_= Fabric(p_map10, shirtColour, 2, 1/10) 
	#declare Sleeve_= Fabric(p_map10, shirtColour, 2, 1/10) 
	#declare Cuff_regular_= Fabric(p_map10, shirtColour, 2, 1/10)
	#declare Collar_regular_= Fabric(p_map10, shirtColour, 2, 1/10) 
#end