// macro for a balloon 
//use Balloon(Color) 
// zero point at knot

#ifndef(MAC_BAL)
 #declare MAC_BAL=10;
#ifndef(Get)
 global_settings{ max_trace_level 30
}

 #include "colors.inc"
 #include"transforms.inc"

camera{ location <0,-1,-20> 
       right  x*image_width/image_height
       angle 54.5
       look_at <0,-1,0>
       }
//light_source{ <4,10,-10> color White}
//light_source{ <9,10,-10> color White*2}
light_source{ <-30,100,-40> color White}
//light_source{ <0,20,0> color Gold}
light_source{ <30,50,-150> color White}

background{rgb<.6,.6,.8>}

plane{-z,300 pigment{agate 
        color_map{[0 rgbt 1][.25 rgb<.2,.5,.1>]
        [.5 rgb<.6,.2,.3>][.75 rgb <.1,.4,.7>][1 rgbt 1]}scale 500}
        hollow}

plane{y,-8 pigment{White}}//rgb<.3,.3,.5>}}
#end

#macro Balloon(Col,Shad) 
 union{
blob{threshold .25
     sphere{0,1,1} 
     sphere{-y*.5,.3,1 scale<2,.1,2>} 
     sphere{-y*1,1,.25}
    sturm
    scale <1.5,2,1.5> } 
cone{0,0,-y*.15,.05 open rotate x*14 translate -y*2}
torus{.05,.01 rotate x*14 translate -y*2.15  }
sphere{0,.055 translate -y*2}
 pigment{Col}
 interior{ior 1.000036  caustics .05 fade_distance 10 fade_power 1}
 finish{ambient .1 diffuse .5 
        reflection.15 
        specular .9 roughness .002
         brilliance 6 
 } 
translate y*2
#if (Shad=0) no_shadow #end
}
#end

#ifndef(Get)
Balloon(rgbt<1,0,1,.5>,no)
object{Balloon(rgbf<1,1,0,.8>,yes) rotate <0,60,20> translate <4,5,0>}
object{Balloon(rgbf<1,1,1,.8>,yes) rotate <0,70,20> translate <-4,5,0>}
object{Balloon(rgbf<0,0,1,.8>,no) rotate <0,160,20> translate <-4,-5,0>}
object{Balloon(rgbf<0,1,0,.8>,no) rotate <0,15,20> translate <4,-5,0>}
#end
#end