//elements - opposites
//earth vs air, fire vs water.

#declare hfresscale = 2;
#declare SlowLensFX = off;
#declare Photons = on;
#declare PhotonLoad = off;	//this saves photons when off, save them (off) with everything but the lens fx turned on, and a v low res image.
#declare Rad = on;
#declare Beach = on;
#declare Fire = on;
#declare FireWood = on;
#declare FireIso = on;
#declare FireMedia = on;
#declare Rock = on;
#declare Sea = on;
#declare SeaShading = on;

#include "functions.inc"
#include "rad_def.inc"
#include "transforms.inc"

global_settings {
	assumed_gamma 1	//work in linear colour space, pov will gamma correct the result
	max_trace_level 12
	#if ( Rad )
		radiosity { Rad_Settings( Radiosity_Fast, on, off ) brightness .7 }//gray_threshold .5 }	//media off 'cause my water fog effect confuses it
	#end
	#if ( Photons )
		photons {
			//note, we need a lot of photons to get a good shadow from the rocks and firewood in the foreground
			spacing .003	//for some reason count doesn't work in this scene. also it spends a very long time at 0, as if it's trying to find where to send photons
			radius .01 //for final gather, smaller is more precise but samples fewer photons
			//we can get away with quite noisy photons in this scene.
			#if ( PhotonLoad ) 
				load_file "photons"
			#else
				save_file "photons"
			#end
		}
	#end
}

#default { pigment { rgb 1 } finish { diffuse .8 ambient 0 brilliance 1 } }

camera {
	right		x*image_width/image_height
	up			y
	direction	z*.7
	
	location 0 rotate -x*15	//lens cam
	//location <0,30,-10> look_at z*15 //overview

	#if ( SlowLensFX )
		aperture	.001
		focal_point	z*.05
		blur_samples	4	//this can be pretty low, 'cause the dispersion effectively gets us some more samples in the blurrier areas.
	#end
}
//lens
#if (1)
	difference {
		cylinder { 0, z*1.01, 2 }
		//sphere { 0, 1 }
		quadric { <1,1,0>,<0,0,0>,<0,0,1>,-1 }	//111,000,000,-1 gives the same sphere, xx+yy+z-1 gives a parabola with point at <0,0,1> and edges further back
		scale .01*<1,1,.6>
		translate .005*z
		
		photons { collect off }
		
		pigment {
			pigment_pattern { cylindrical rotate x*90 cubic_wave }
			poly_wave .5
			scale .013
			colour_map {
				[0	rgb 0 transmit .2]//vignetting
				[1	rgb 0 transmit 1]
			}
		}
		interior {
			ior 1.3
			#if ( SlowLensFX )	
				dispersion 1.01 dispersion_samples 7 //(7 default)
			#end
		}
		rotate -x*15
	}
#end
     
//the sun
//#declare sunDir = vnormalize(<-4,5,3>);	//in frame, for the final image
#declare sunDir = vnormalize(<-11,9,2>);	//tweak - extreme top left
//#declare sunDir = vnormalize(<-4,5,-3>);	//roughly matching a reference photo
//#declare sunDir = vnormalize(<0,1,-2>);		//good lighting on the rock
light_source {
	sunDir*10000, rgb <4,3.5,3>//<2.2,2,1.5>
	parallel point_at 0
	photons {
		refraction on
		reflection on
	}
}
sphere {
	0, 1
	hollow on
	no_shadow
	pigment { rgbt 1 }
	interior {
		media {
			emission rgb 20*<3,2,1>
			density {
				granite
				poly_wave 1/3
				density_map {
					[0 spherical poly_wave 100]
					[1 spherical poly_wave 200]
				}
			}
		}
	}
	scale 400   
	translate sunDir * 1000
}

//sky
//background { rgb <.2,.4,1> }
sky_sphere {
	pigment {
		/*planar
		poly_wave .5
		colour_map {
			[0 rgb z transmit .5]
			[1 rgb z]
		}*/
		rgb z
	}
	pigment {
		planar
		poly_wave .5
		colour_map {
			[0 rgb <.1,.5,1> transmit 1]
			[1 rgb <.1,.5,1>]
		}
	}
	pigment {
		planar
		poly_wave 8
		colour_map {
			[0 rgb 2 transmit 1]
			[1 rgb 2 transmit .5]
		}
	}
	
	//atmospheric reaction to sun
	pigment {
		gradient z
		scale 2 translate -1
		Reorient_Trans( z, sunDir )
		poly_wave 100
		color_map {
			[0 rgb <.1,.5,1>*7-4*<.4,.8,1.2> transmit 1]
			[1 rgb <.4,.8,1.2> transmit .5]	//I just stumbled across this, darker area round the sun tricks your eye into thinking the sun's brighter! cool!
		}
	}
}


//ground
#declare earthRad = 6000;


#declare f_easeUnit =
	function(Var) {
		3*pow(Var,2) - 2*pow(Var,3)	//curve from 0 to 1 with symmetry and niceness.
	}

#declare f_ease =
	function(Var, Min, Max) {
		f_easeUnit( max(0,min(1,(Var-Min)/(Max-Min))) )
	}

#declare f_lerp =
	function ( v1, v2, l ) {
		v1*(1-l) + l*v2
	}

#macro vPow(V,P) <pow(V.x,P),pow(V.y,P),pow(V.z,P)> #end


//foreground beach
#macro heightFromFunc( func, box0, box1 )
	height_field {
		//map 0,1 -> box0,box1
		#declare boxscale = box1-box0;
		#declare boxtranslate = -boxscale/2 + (box1+box0)/2;
		#declare boxtranslateX = boxtranslate.x; #declare boxtranslateY = boxtranslate.y; #declare boxtranslateZ = boxtranslate.z;
		#declare boxscaleX = boxscale.x; #declare boxscaleY = boxscale.y; #declare boxscaleZ = boxscale.z;
		function 1024*hfresscale,1024*hfresscale { func(x*boxscaleX+boxtranslateX, 0,(1-y)*boxscaleZ+boxtranslateZ) }	//fun with coordinate systems...
		scale boxscale
		translate boxtranslate
	}
#end

#declare beachFunc =
	function(x,y,z) {
		f_ease( sqrt(x*x+(z-15)*(z-15)), 13, 16 )*.8
		+(1-f_granite(x/8-2.01,0,z/8))*.2
	}

#declare nearBox0 = <-13,0,-1>;
#declare nearBox1 = <13,0,13>;

//for photons, chop this thing up so we don't waste photons where they won't be seen
#declare photonicRegion = cylinder { -y, y, 2 Shear_Trans(x, sunDir+y/2, z) translate z*1 }


#if ( Beach )
	//beach
	//todo - shove these in heightfields instead, we're getting accuracy problems.
	#declare beachSurface =
		union {
			heightFromFunc( beachFunc, nearBox0-.45*y, nearBox1-.1*y )
			intersection {
				sphere { -earthRad*y, earthRad-.1 }
				plane { y*9+z, 0 translate nearBox0 -.2*y }
			}
			sphere { -earthRad*y, earthRad-.4 }
		}
	
	#declare beachMat =
		material {
			texture {
				pigment {
					crackle solid scale .001
					poly_wave 3
					colour_map {
						[0 rgb <1,.8,.5>]
						[1 rgb <.3,.2,.1>]
					}
				}
				normal {
					crackle 1 scale .001
				}
				finish {
					phong 1 phong_size 200
				}
			}
		}
	
	object {
		beachSurface
		material { beachMat }
		photons {
			collect on
		}
	}
#end

#if ( Sea )
	//waves
	#declare Waves =
		object {
			#declare waterFunc =
				function(x,y,z) {
					pow(
						sin(
							f_lerp(
								beachFunc(x,0,z)*30,	//base the waves on the beach function
								(z-20)*2 + (1-f_granite(x/8-2.01,0,z/8))*2,	//more distant waves more regular with some noise
							 	f_ease(z,1,6)//modify the beach function in the distance because it levels out so our wave pattern breaks down.
							)
						)
					,6)*5/6		//sharpen the waves, so we just get small ridges in a mostly smooth surface
					+ f_spotted(x*20,0,z*20)/6	//some random bumpiness
				}
			heightFromFunc( waterFunc, nearBox0-.25*y, nearBox1-.235*y )
		}

	#declare WaveInterior =
		interior {
			ior 1.33
			/*fade_color rgb <.0,.05,.05>
			fade_power 2
			fade_distance .02*/
			//DAMMIT! photons don't behave themselves with fade_color, the beach surface appears as if there's no fading when it's lit by photons.
			
			media {
				absorption 1
				emission rgb <.0,.05,.05>
				density { rgb 10 }
			}
		}
		
	#declare WaveMat =
		material {
			texture {  
				//foam when water gets close to the beach
				function {
					f_ease( (waterFunc(x,y,z)*.015-.25 - beachFunc(x,y,z)*.35+.45), 0, .02 )
				}
				texture_map {
					[0
						#if (SeaShading)
							//foam
							pigment {
								granite
								scale .04
								cubic_wave
								colour_map {
									[0 rgb 1 transmit 1]
									[1 rgb 1 transmit 0]
								}
							}
							finish { diffuse 1 reflection { .0, .4 fresnel } conserve_energy }
							normal {
								granite
								scale .04
							}
						#else
							pigment { rgb .6 }
						#end
					]
					[1
						#if (SeaShading)
							pigment { rgb <.0,.05,.05> transmit .9 }
							finish { reflection { .05, 1 fresnel } conserve_energy }
						#else
							pigment {
								function { waterFunc(x,y,z) }
								colour_map {
									[0 rgb <.1,.2,.5>*.7]
									[1 rgb <.1,.2,.5>*1.4]
								}
							}
						#end
					]
				}
			}
			//texture { pigment { rgbt 1 } }
			interior { WaveInterior }
		}
	

	//note: there's a visible edge caused by the shadow between the non-refracted conventional lighting and the refracted photons.
	//this is unavoidable, but should be placed somewhere out of sight.

	//you wouldn't believe how many permutations of this CSG I tried before getting a truly invisible seam.
	union {
		//inner section, this will have photons
		object {
			Waves
			clipped_by { object { photonicRegion } }
			material { WaveMat }
			
			photons {
				target 1.0
				refraction on
				reflection on
				collect off
			}
		}
		//outer section, no photons
		object { Waves clipped_by { object { photonicRegion inverse } } photons { collect off } material { WaveMat } }
		
		hollow on
	}

	//distant sea
	difference {
		sphere {
			-earthRad*y, earthRad-.25
		}
		box { nearBox0*1.001-.4*y, nearBox1*1.001-.1*y }
		
		#if (SeaShading)
			texture {
				pigment { rgb <.0,.05,.05> transmit .9 }
				finish { reflection { .05, 1 fresnel } conserve_energy }
				normal {
					//almost identical to the complex pattern in the foreground (or it was, before I made foreground waves more regular)
					pigment_pattern {
						spotted
						sine_wave
						frequency 10
						turbulence .8
						scale 4
					} .1
					poly_wave 4
				}
			}
			interior {
				ior 1.33
				fade_color rgb <.0,.05,.05>
				fade_power 2
				fade_distance .02
			}
		#else
			pigment { rgb <.1,.2,.5> }
			normal {
				pigment_pattern {
					spotted
					sine_wave
					frequency 10
					turbulence .8
					scale 4
				} .1
				poly_wave 4
			}
		#end
	}
#end



//rocks
#declare rockPattern =
	function {
		pigment {
			average
			pigment_map {
				[.3
					pigment_pattern {
						granite
						colour_map {
							[0 rgb 1]
							[1 rgb 0]
						}
						scale 10
					}
					poly_wave 2
				]
				[.1
					//layers
					granite scale <40,4,40>
					colour_map { [0 rgb 1][1 rgb 0] }
				]
				[1
					//large scale smooth variation to hide the underlying shape
					spotted scale 3 poly_wave 2
				]
			}
		}
	}

#if (Rock)
	isosurface {
		function {
			//overlap them nicely, by giving them a small area of influence beyond themselves
			min( .5, f_sphere((x-5)/2,y-14,z, 5) ) +	//lump at the top
			min( .5, sqrt(y*2.5+(x+y*y/18-22)*(x+y*y/18-22)+z*z)-7 )	//arm holding it up
			-.5
			+(rockPattern(x,y,z).x-.1)*2
		}
		max_gradient 2
		contained_by { box { <-5,-.5,-8>, <20,20,8> } }
		
		photons { collect off }
	
		//pigment { function { rockPattern(x,y,z).x } }	
		pigment {
			function { pow(min(1,max(0,rockPattern(x,y,z).x*1-0)),.5) }
			cubic_wave
			pigment_map {
				[0
					//layers
					spotted scale <5,.5,5>
					warp { turbulence .4 lambda 4 }
					colour_map {
						[0.0 rgb <.4,.2,0>]	//fungus
						[0.2 rgb <1,.9,.8>]
						[0.7 rgb <.9,.7,.5>]
						[1.0 rgb <.5,.35,.2>]//<.8,.7,.6>-.2]//<.3,.2,.1>]
					}
				]
				[1	//dirt
					rgb <.07,.01,0>
				]
			}
		}
	
		bounded_by {
			box {
				-1, 1
				scale <6,13,6>
				rotate <0,0,45>
				translate <9,8,0>
			}
		}
	
		scale <1,.9,1>
		rotate -y*10
		translate z*12
	}

	//dark reflector for radiosity, faking some more rocks behind the camera.	
	box {
		<-20,0,-1>, <20,15,-2>
		pigment { rgb .0 }
	}
#end



#if ( Fire ) //dadada
	//I'll take you to burn

	#macro driftwood(V)
		#local f_driftwood =
			function {
				pigment {
					function {  //we're running round in circles here...
						min(1, max(0,
							.5-f_superellipsoid(x,y,z, .5,.5)*.5
						))
					}
					translate V
					warp { turbulence .4 } //grain, lumps etc.
					translate -V
				}
			}
		
		object {
			#if ( FireIso )		
				isosurface {
					function {
						f_driftwood(x,y,z).x*2-1
					}
					max_gradient 2
					accuracy 1/10000
					contained_by { box { -1.2, 1.2 } }
				}
			#else
				box { -.9,.9 }
			#end
			
			pigment {
				spherical
				scale sqrt(3)
				turbulence .1
				pigment_map {
					[.1	
						crackle
						solid
						scale .003
						poly_wave 1/10
						colour_map {
							[0 rgb x*2] //embers
							[1 rgb 0]
						}
					]
					[.2 rgb 0]
					[.4
						wood
						sine_wave
						frequency 4
						turbulence .4
						colour_map {
							[0 rgb <.2,.14,.1>]//burnt
							[1 rgb <.1,.1,.1>]	//burnt
						}
					]
					[.6
						wood
						sine_wave
						frequency 4
						turbulence .4
						colour_map {
							[0 rgb <.7,.4,.2>]	//not burnt
							[1 rgb <.6,.3,.1>]	//not burnt
						}
					]
				}
			}
		}
	#end
	
	union {
	
		#if ( FireWood )
			union {
				//main structure	
				object { driftwood(0) scale <.15,.03,.03> rotate <0,0,0> translate <-.26,-.24,.5> }
				object { driftwood(2) scale <.03,.005,.13> rotate <-20,0,0> translate <-.28,-.21,.48> }
				object { driftwood(6) scale <.01,.01,.11> rotate <40,20,10> translate <-.21,-.22,.55> }
				object { driftwood(8) scale <.01,.01,.11> rotate <-50,-40,0> translate <-.19,-.22,.46> }
			
				//smaller burnt bits
				object { driftwood(4) scale <.06,.005,.03> rotate <0,10,0> translate <-.21,-.265,.43> }
				object { driftwood(9) translate -x scale <.03,.01,.01> rotate <0,-20,-9> translate <-.36,-.26,.43> }
				object { driftwood(5) translate  x scale <.03,.01,.01> rotate <0,-20,-4> translate <-.36,-.26,.43> }
					
				//tweak position
				translate <0,.01,0>
			}

			//stone circle round fire
			difference {
				union {
					#local rsShape      = seed(27);
					#local rsScale      = seed(26);
					#local rsRotate     = seed(25);
					#local rsTranslate  = seed(24);
					#local rsAng        = seed(167);
					#local rsCol        = seed(15);
	
					#local ang = 0;
					#while ( ang < 340 )
						superellipsoid {
							<.5+.5*rand(rsShape),.5+.5*rand(rsShape)>
							scale <.02+rand(rsScale)*.03,.01+rand(rsScale)*.02,.02+rand(rsScale)*.02>
							rotate <rand(rsRotate)*60-30, rand(rsRotate)*20-10, rand(rsRotate)*40-20>
							#local trans1 = -z*(.17+.04*rand(rsTranslate));
							#local trans2 = <-.27,-.25,.51>;
							//translate trans1
							rotate ang*y
							//translate trans2
							
							#local pos = vrotate(trans1,ang*y) + trans2;
							
							//offset to ground
							translate trace(beachSurface, pos+y, -y) //- y*.05
							
							#local bright = rand(rsCol);
							texture {				
								pigment {
									granite
									colour_map {
										[-.3 rgb vPow(<.3,.1,0>,.5+bright*2)]
										[.6 rgb vPow(<.6,.5,.3>,.5+bright*2)]
										[.7 rgb vPow(<.3,.1,0>, .5+bright*2)]
									}
								}
								//should they even have any bumps?
								normal {
									average
									normal_map {
										[1
											granite .2
											slope_map {
												[0 <.5,0>]
												[.6 <1,0>]
												[1 <0,0>]	//soft bumps matching pigment
											}
										]
										[1 dents 3 scale .01 ]	// pourus (sp?)
									}
								}
								finish {
									//wet
									reflection { .04, 1 fresnel }
									specular 1 roughness .01
								}
								scale .1
							}
							interior { ior 1.33 } //to get fresnel of water.
						}
						#local ang = ang + rand(rsAng)*20+20;
					#end
				}
				object { beachSurface } //fixes some cracks seen in the shadows.
			}
		#end
		
		//flames
		#if ( PhotonLoad )
			difference {
			#if (FireMedia)
				sphere { 0, .7
			#else
				disc { 0, -z, .4
			#end
					
					hollow on
					photons { collect off } //it's casting a shadow in the photons, so I have 2 options: do very slow photon-media interaction just to get the very faint shadow that should be there, or turn it off since most people won't expect a shadow from fire.
					
			#if (FireMedia)
					pigment { rgbt 1 }
					interior {
						media {
							emission 600
							absorption 100
							//intervals 20 //after some tweaking of the bounding volume, I no longer need this much precision.
							density {
			#else
							pigment {
			#end
								pigment_pattern {
									pigment_pattern {
										spherical
										poly_wave .5
										pigment_map {
											[0
												pigment_pattern {
													granite
													cubic_wave
												}
												scale <1,1.5,1>*9
												warp { turbulence 5 lambda 3 octaves 2 }
												poly_wave 1/6
												colour_map {
													[0 rgb .5]
													[1 rgb 0]
												}
											]
											[1
												pigment_pattern {
													granite
													cubic_wave
												}
												scale <1,1.5,1>*9
												warp { turbulence 5 lambda 3 octaves 2 }
												poly_wave 1/6    
												colour_map {
													[0 rgb 1]
													[1 rgb .5]
												}
											]
										}
									}
									colour_map {
										[.5	rgb 0]
										[.9	rgb 1]
									}
								}
								cubic_wave
								colour_map {
									[0	rgb 0]
									[1	rgb <1,.2,.02>]
								}
							}
			#if (FireMedia)
						}
					}
			#else
					finish { ambient 1 diffuse 0 }
			#end
					
					scale .2*<1,2,1>
					translate <-.26,-.24,.5>
				}
				#if ( Sea )
					object { Waves translate y*.001 pigment { rgbt 1 } }	//stop the media intersecting with the sea.
				#end
			}
		#end
	}
#end
