// Persistence of Vision Ray Tracer Scene Description File
// File: Untitled17.pov
// Vers: POV-RAY 3.6.1
// Desc: Irtc entry for "Forces Of Nature" topic
// Date: May-June 2005
// Auth: B. Gimeno
// http://usuarios.lycos.es/game2413  
// e-mail: bgimeno@lycos.es
/* 
 Arbre.inc (c) 1999 Steven Pigeon
 
 Cat Poser mesh imported with Poseray (c) 2003 FlyerX
 
 Furtext macro (c) 2000 Rune S. Johansenn 
 
*/

// +w1024 +h633

#version 3.5;

#include "colors.inc"
#include "transforms.inc"
#include "shapes.inc"
 #include "arbre.inc" // is not included due to copyright permission, you can find it at http://home.pacbell.net/tylereng/
 #include "furtex.inc" // available on www.runevision.com
// ----------------------------------------
#default {finish{ ambient 0} }
global_settings {
  assumed_gamma 1
   radiosity {
      pretrace_start 0.08
      pretrace_end   0.02
      count 80
      nearest_count 5
      error_bound 0.4
      recursion_limit 1
      low_error_factor 0.9
      gray_threshold 0
      minimum_reuse 0.025
      brightness 1.0
      adc_bailout 0.01/2
   //   load_file "untitled6.rca"
   //   always_sample off
   }

  }

// ----------------------------------------
/*  // general non blurred camera
camera {
  location  <10.0, 35, -25.0>
  right     x*image_width/image_height
  look_at   <0, 0,0>
}
*/
/*
// Cat's camera
camera {
  location  <-10.0, 12, -20.0>
  right     x*image_width/image_height
  look_at   <-24, 2.1,-2.75>
}*/

camera {
  location  <10.0, 35, -25.0>
  right     x*image_width/image_height
  look_at   <0, 0,0>
  aperture 1.047
  focal_point<-0.138,0,0.345>
  blur_samples 30
  variance 1/256
  confidence .999
}

light_source {
      <0, 0, 0>  color rgb <1, 1, 1>  translate <-100, 300, -130>
      parallel   point_at <0,0,0>
      }


plane{<0,1,0>,1 hollow
       texture{ pigment{ bozo turbulence 0.76
                         color_map { [0.5 rgb <138,170,253>/255]
                                     [0.6 rgb <1,1,1>]
                                     [1.0 rgb <0.5,0.5,0.5>]}
                       }
                finish {ambient 1 diffuse 0} }
       scale 10000}

// ----------------------------------------

#declare ground =
height_field{ tga "campo3.tga" smooth double_illuminate
              translate<-0.5,0,-0.5>
              scale<140,3.2,140> 
              texture{
                       pigment {
                                bozo
                                pigment_map {[0 rgb <128,64,0>/255]
                                             [1 rgb <9,33,65>/255]
                                             }
                                }
                       normal  {bumps 0.45 scale 0.025  }
                       finish  {ambient 0.1 diffuse 0.8 }
                     scale 4
                     }
              rotate<0,0,0>
              translate<0,0,0>
            }
// -------------------------------------------------------------
// gr -> stands for golden ratio
#declare gr = 1.61803398874989484820458683436 ;
#macro adoquin (rs_adoquin) 
#local rnd_ad= seed(rs_adoquin) ;
     isosurface {
            function{f_rounded_box(x,y,z,0.15,1.75*gr,1.75,1.75)-
                     (f_bozo(x*1.85*gr+rs_adoquin,y*1.85+rs_adoquin,z*1.85-rs_adoquin)*0.3)
                     }
            threshold 0
            contained_by {box {<-2*gr,-2,-2>,<2*gr,2,2>}}
             max_gradient 1.358
            scale .5
            }

#end
// pavimento -----------------------------------------------------------

#declare X_filas_max = 17 ; #local X_filas_min = -34 ; // 17 -34
#declare Z_filas_max = 28 ; #local Z_filas_min = -15 ; // 28 -15
#declare Stone_pavement =
union { 
#declare X_filas_r = X_filas_max ; #while (X_filas_r>X_filas_min)
#declare Z_filas_r = Z_filas_max ; #while (Z_filas_r>Z_filas_min)

#declare R_S = seed ((X_filas_r+Z_filas_r)+(X_filas_r*Z_filas_r)+X_filas_max*20+Z_filas_r);
 #if (2*div(Z_filas_r,2)=Z_filas_r)
   #local From = <X_filas_r, 1000000000,Z_filas_r> ;
   #local To   = <X_filas_r,-1000000000,Z_filas_r> ;
 #else
   #local From = <X_filas_r+(gr*.5), 1000000000,Z_filas_r> ;
   #local To   = <X_filas_r+(gr*.5),-1000000000,Z_filas_r> ;
 #end

 #local Normal = <0,0,0> ;
 #local OverT = trace (ground,From,To,Normal);
   #if (vlength(OverT)!=0)
   #if (rand(R_S)>.02)
    object {adoquin (X_filas_r+Z_filas_r)
               texture {
                  pigment {
                           bozo
                                pigment_map {[0.0 rgb (<90,88,90>/255)+(.075*sin(radians(360*rand(R_S))))]
                                             [0.5 rgb (<115,100,112>/255)+(.075*sin(radians(360*rand(R_S))))]
                                             [1.0 rgb (<120,115,118>/255)+(.075*sin(radians(360*rand(R_S))))]
                                             }
                          }
                  finish {
                          phong .05
                          }
                  normal {wrinkles 1}
                  normal {bumps .3}
                  scale .5
                  rotate <360*sin(radians(360*rand(R_S))),
                          360*sin(radians(360*rand(R_S))),
                          360*sin(radians(360*rand(R_S)))>
                  }
              texture {
                      pigment {
                        gradient y
                        pigment_map {
                                    [0.25 Brown*.25 filter .85]
                                    [1 Clear]
                                    }
                 scale 2.01
                 translate -y*1
                        }
                     }
           Reorient_Trans(y,Normal)
           translate OverT
           }
   #end
   #end
#declare Z_filas_r = Z_filas_r-1; #end
#declare X_filas_r = X_filas_r-gr; #end
     }

// ladrillos irregulares sobre el suelo -------------------------------------------

#declare Num_adoq = 20 ;

#declare Stone_pavement_random =
union {
#declare Adoq_r = Num_adoq ; #while (Adoq_r>0)

#declare R_S = seed (Adoq_r*2);
#declare R_S1 = seed (Adoq_r);
#declare R_S2 = seed (Adoq_r);
 
   #local From = <-30*sin(radians(360*rand(R_S1))),1000000000,-20*sin(radians(360*rand(R_S1)))> ;
   #local To   = <-30*sin(radians(360*rand(R_S2))),-1000000000,-20*sin(radians(360*rand(R_S2)))> ;

 #local Normal = <0,0,0> ;
 #local OverT = trace (Stone_pavement,From,To,Normal);
   #if (vlength(OverT)!=0)
    object {adoquin (Adoq_r)
               texture {
                  pigment {
                           bozo
                                pigment_map {[0.0 rgb (<90,88,90>/255)+(.075*sin(radians(360*rand(R_S))))]
                                             [0.5 rgb (<115,100,112>/255)+(.075*sin(radians(360*rand(R_S))))]
                                             [1.0 rgb (<120,115,118>/255)+(.075*sin(radians(360*rand(R_S))))]
                                             }
                          }
                  finish {
                          phong .05
                          }
                  normal {wrinkles .4}
                  normal {bumps .3}
                  scale .5
                  rotate <360*sin(radians(360*rand(R_S))),
                          360*sin(radians(360*rand(R_S))),
                          360*sin(radians(360*rand(R_S)))>
                  }
            rotate y*360*rand(R_S)
            translate OverT
           }
   #end
   
#declare Adoq_r = Adoq_r-1; #end
     }
// --------------------------------------------------------------------------------
// agua       
#declare water = 
   height_field{ tga "agua.tga" smooth
                 translate<-0.5,0,-0.5>
                 scale<140,1,110>
                 translate<0,2.3,0>
             texture {
                 pigment {rgbt <200,150,125,20>/255 filter .8}
                 finish { phong .7 reflection 0.35}
                 normal {wrinkles .006}
                 }
            }
// trees --------------------------------------------------------------------------

#declare TreeLevel=7;
#declare LeafLevel=6;

#declare leaf=
 union
  {
   polygon // hojas
    {
     7,
     <0,0>, <0,0.5>, <1,1>, <0,2>, <-1,1>, <-1,0.5>, <0,0>
     pigment { Green / 2 }
     translate <0,1,0>
    }
   // tallo
   cylinder { 0, <0,1,0>, 0.05 pigment { Green / 2 } normal { crackle scale 0.2 } }
   
   scale 0.25
  }
#declare Trees =
union {
object
 {
  Arbre( 32341,TreeLevel,2,3,0.05,5,0.25,0.95,2,0.5,0.7,40,1.1,
           texture { pigment { rgb <1,.8,.4> } normal { crackle scale 0.1} },
         leaf, LeafLevel, 3, 90 )
  scale 4  
  translate <-40,0,95>
 }
 
object
 {
  Arbre( 657123,TreeLevel, 2, 3, 0.05,5,0.25,0.95,2,0.5,0.7,40,1.1,
         texture { pigment { rgb <1,.8,.4> } normal { crackle scale 0.1} },
         leaf, LeafLevel, 3, 90 )
  scale 4
  translate <40,0,95>
 }

object
 {
  Arbre( 46874,
         TreeLevel, 2, 3, 0.05, 5, 0.25, 0.95, 2, 0.5, 0.7, 40, 1.1,
         texture { pigment { rgb <1,.8,.4> } normal { crackle scale 0.1} },
         leaf, LeafLevel, 3, 90  )
  scale 4  
  translate <-80,0,95>
 }
}
//--------------------------------------------------------------------------
// verja
#declare fence =
union {
   cylinder {<-200,15,60>,<200,15,60>,.4 }
   cylinder {<-200,35,60>,<200,35,60>,.4 }
   #local num_cyl = 150 ;
   #while (num_cyl>0)
     cylinder {<-200,0,60>,<-200,40,60>,.5
               translate x*num_cyl*5
              }
   #local num_cyl=num_cyl-1;
   #end
   pigment {Black}
   }
//--------------------------------------------------------------------------

#macro Bird (r_seed)
 #local rs = seed (r_seed) ;
 #local rs2 = seed (r_seed) ;
 union {
   sphere_sweep {
     b_spline  5
     <-2,1.5,0>,.5 <-1,.5,0>,.15 <0,-.1,0>,.45 <.8,-.25,0>,.65 <1.5,-.5,0>,.4
   }

  cone {<-1.6,.5,0>,0<-1.1,.5,0>.1 pigment {Red*.65}}
  sphere {<.3,0,-.2>,.4 scale <1,.25,2> translate z*-.36 
          rotate  x*60*sin(radians(360*rand(rs))) translate y*.15 }
  sphere {<.3,0, .2>,.4 scale <1,.25,2> translate z* .36 
          rotate -x*60*sin(radians(360*rand(rs2))) translate y*.15 }
  pigment {White }
 }

#end
#macro Birds(num_birds)
union {
#while (num_birds>0)
#local R_S = seed(num_birds) ;
  object {Bird (num_birds*21)
          rotate y*(10+(10*sin(radians(360*rand(R_S)))))
          rotate x*(20+(10*sin(radians(360*rand(R_S)))))
          rotate z*(-20+(10*sin(radians(360*rand(R_S)))))

          translate x*(-30+(30*sin(radians(360*rand(R_S)))))
          translate y*(60+(5*sin(radians(360*rand(R_S)))))
          translate z*(-30+(30*sin(radians(360*rand(R_S)))))
          no_shadow
         }

 #declare num_birds = num_birds-1 ;
#end
}
#end
//--------------------------------------------------------------------------
#macro Leaf (random_seed)
#local rnd_leaf = seed(random_seed) ;
 union
  {
   polygon 
    {
     9,
     <0,0>,
     <0,0.5>,
     <1+(0.2*sin(radians(360*rand(rnd_leaf)))),1+(0.2*sin(radians(360*rand(rnd_leaf))))>, 
     <.5+(0.2*sin(radians(360*rand(rnd_leaf)))),2+(0.2*sin(radians(360*rand(rnd_leaf))))>, 
     <0+(0.2*sin(radians(360*rand(rnd_leaf)))),2.75+(0.2*sin(radians(360*rand(rnd_leaf))))>, 
     <-.5+(0.2*sin(radians(360*rand(rnd_leaf)))),2+(0.2*sin(radians(360*rand(rnd_leaf))))>, 
     <-1+(0.2*sin(radians(360*rand(rnd_leaf)))),1+(0.2*sin(radians(360*rand(rnd_leaf))))>, 
     <0,0.5>,
     <0,0>
    }
   cylinder { 0, <0,1,0>, 0.05  }
   rotate x*90
   scale 0.4+(0.1*sin(radians(360*rand(rnd_leaf))))
  }
#end
   
#macro Leafs (num_leafs)
union {
#declare Leaf_r = num_leafs ; #while (Leaf_r>0)

#declare R_S = seed (Leaf_r*2);
#declare R_S1 = seed (Leaf_r);
#declare R_S2 = seed (Leaf_r);
 
   #local From = <0+(15*sin(radians(360*rand(R_S1)))),1000000000,0+(15*sin(radians(360*rand(R_S1))))> ;
   #local To   = <0+(25*sin(radians(360*rand(R_S2)))),-1000000000,0+(25*sin(radians(360*rand(R_S2))))> ;

 #local Normal = <0,0,0> ;
 #local OverT = trace (Stone_pavement,From,To,Normal);
   #if (vlength(OverT)!=0)   
    object {Leaf(Leaf_r)
            rotate y*720*rand(R_S)
            Reorient_Trans(y,Normal)
            translate OverT
            translate y*0.15
            texture {
                pigment { granite
                           pigment_map {
                           [0  rgb <250+(15*sin(radians(360*rand(R_S)))),
                                220+(25*sin(radians(360*rand(R_S)))),
                                125+(25*sin(radians(360*rand(R_S))))
                                >/255 ]
                           [0.5 Brown]
                           [1   rgb <250+(15*sin(radians(360*rand(R_S)))),
                                220+(15*sin(radians(360*rand(R_S)))),
                                125+(15*sin(radians(360*rand(R_S))))
                                >/255]
                           }
                        }
               normal {bumps .5}
               normal {wrinkles .02 }
               scale .5
               }
           }
   #end
   
#declare Leaf_r = Leaf_r-1; #end
     }
#end
//--------------------------------------------------------------------------
Leafs (400)
object {Stone_pavement}
object {ground translate y*0.5}
object {water}
object {fence}
object {Stone_pavement_random}
object {Birds (150) translate z*20 translate x*-10}

// object {Trees} // this object needs "arbre.inc" include file


// to render this furry mesh, must include on this folder the Furtext macro of Rune Johansenn, available on www.runevision.com

#declare Fur = FurTex(color <165,165,175>/255 ) ;
#include "gato3_pov.inc"
object{
      GATO3
      scale <-1,1,1>
      scale 23
      rotate y*90
      translate <-24.5,2.9,-2.75>
      }
      
//--------------------------------------------------------------------------
