#declare epsilon=.001;
#declare WineGlass = lathe {
  bezier_spline
  36,
  <0,0>,<.5,0>,<1,0>,<1.69,0>, // continuous
  <1.69,0>,<1.8,0>,<1.83,.17>,<1.69,.2>, // continuous
  <1.69,.2>,<1.3,.23>,<.7,.39>,<.52,.44>,
  <.52,.44>,<.52,.45>,<.52,.50>,<.52,.51>,
  <.52,.51>,<.1,1.31>,<.22,1.73>,<.75,2.33>,
  <.75,2.33>,<.7,2.36>,<.64,2.5>,<.63,2.53>,
  <.63,2.53>,<1.75,2.8>,<2,4.5>,<2.15,7>,
  <2.15,7>,<2.13,7.02>,<2.09,7.02>,<2.07,7>,
  <2.07,7>,<1.9,5>,<1.6,3.05>,<0,3.05>
  sturm
  pigment {
    rgbf <.9,.9,.9,.99>
  }
  finish {
    //ambient 0
    //diffuse 0.2
    reflection .1
    specular 1
    roughness .005
  }
  interior {
    ior 1.8
    //dispersion 1.02
    caustics 4
  }
  photons {
    target
    reflection on
    refraction on
    collect off
  }
} 

#declare DrinkInGlass = lathe {
  bezier_spline
  4,
  <2.07-epsilon,7>,<1.9-epsilon,5>,<1.6,3.05+epsilon>,<0,3.05+epsilon>
  sturm
  hollow
}

#macro FillGlass(height, mr)
  /* height is the height above the bottom of the glass
   * mr is the radius of the meniscus
   */
  #local intersect = trace(DrinkInGlass,y*height,x);
  #local r = (intersect.x - mr);
  difference {
    object {DrinkInGlass}
    cylinder {
      y*height, y*(height-mr),r
    }
    plane {
      -y,-height
    }
    torus {
      r,mr
      rotate x*90
      translate y*height
    }
    material {M_RedWine}
    photons {
      reflection off
      refraction on
      collect on
    }
  }
#end

#declare WineBottle = lathe {
  cubic_spline
  33,
  <-.3,1>,<0,1>,<2.5,.4>,<2.7,.05>,<3.4,.15>,
  <3.55,2>,<3.55,6>,<3.55,14>,<2.8,16.8>,<1.8,18.3>,<1.4,19.4>,
  <1.4,22.4>,<1.45,22.6>,<1.5,22.65>,<1.5,23.5>,<1.45,23.7>,<1.4,23.9>,<1.4,24.4>,<1.4,24.5>,
  // reached the top, now go inside
  <1.25,24.5>,<1.2,24.2>,<1.2,22.6>,<1.2,19.2>
  <1.6,18.1>,<2.7,16.55>,<3.35,14>,<3.35,6>,<3.35,2>,
  <3.2,.2>,<2.7,.25>,<2.5,.6>,<0,1.2>,<-.3,1.2>
  sturm
  photons {
    reflection on
    refraction on
    collect off
  }
}

#declare DrinkInBottle = lathe {
  cubic_spline
  13,
  <1.2-epsilon,24.2>,<1.2-epsilon,22.6>,
  <1.2-epsilon,19.2>,<1.6-epsilon,18.1>,<2.7-epsilon,16.55>,<3.35-epsilon,14>,<3.35-epsilon,6>,<3.35-epsilon,2>,
  <3.2-epsilon,.2+epsilon>,<2.7,.25+epsilon>,<2.5,.6+epsilon>,<0,1.2+epsilon>,<-.3,1.2+epsilon>
  sturm
}

#declare Cork = cylinder {
  <-2,0,0>,<2,0,0>,1.2
}

#declare M_RedWine = material {
  texture {
    pigment {
      rgbf <.66,.027,.07,.99>
    }
    finish {
      reflection 0.1
      ambient 0
      diffuse 0
    }
  }
  interior {
    ior 1.33
    fade_colour <.2,.18,.24>
    fade_distance 2
    fade_power 2
    caustics 4
  }
}

#declare T_WineBottle1 = // layered texture for label and glass
texture { // glass layer
  pigment {
    rgbt 1
  }
  finish {
    ambient .01
    diffuse .4
    specular .1
    roughness .005
    reflection {
      .1
    }
  }
}
texture { // label layer
  pigment {
    image_map {
      png "winelabel.png"
      map_type 2
      interpolate 4
      once
    }
  }
}

#declare M_WineBottle = // the actual texture to include
material {
  texture {
    material_map {
      png "winerim.png"
      map_type 2
      interpolate 4
      once
      texture { // not gold rim
	T_WineBottle1
      }
      texture { // gold rim
	pigment {colour Gold}
	finish {
	  diffuse .5
	  specular 1
	  metallic
	}
      }
    }
    scale <1,5,1>
    translate <0,8>
  }
  interior {
    ior 1.5
    fade_color <.45,.82,.5>
    fade_distance .05
    fade_power 2
  }
}

#declare T_Cork = texture {
  pigment {
    crackle
    colour_map {
      [0.0 rgb <.35,.22,.11>]
      [0.03 rgb <.4,.3,.2>]
      [.08 rgb <.88,.6,.4>]
      [1 rgb <.88,.6,.4>]
    }
    scale .4
  }
  finish {
    ambient .2
    specular .3
    roughness .2
  }
}

