#include "colors.inc" // reqd only for wine gold rim
#include "wineglass.inc"
#include "zwood.inc"
#include "tree.inc"
#include "TOMTREE.inc"
#declare epsilon = 0.001;
#declare slatwidth = 0.2;
global_settings {
  max_trace_level 10
  photons {
    spacing .01
    autostop 0
  }
}

camera {
  angle 23
  location <0, 32, -58>
  look_at <-1.5, 8, 0>
}

#declare Window = // window for projecting sunlight through
polygon {
  20,
  <-1,1>,<-slatwidth,1>,<-slatwidth,slatwidth>,<-1,slatwidth>,<-1,1>,
  <slatwidth,1>,<1,1>,<1,slatwidth>,<slatwidth,slatwidth>,<slatwidth,1>,
  <slatwidth,-slatwidth>,<1,-slatwidth>,<1,-1>,<slatwidth,-1>,<slatwidth,-slatwidth>,
  <-1,-slatwidth>,<-slatwidth,-slatwidth>,<-slatwidth,-1>,<-1,-1>,<-1,-slatwidth>
}

light_source { //sun
  <10,16,45>
  colour rgb <.7,.65,.6>
  parallel
  point_at <-8,0,20>
  projected_through {
    Window
    scale <15,10,1>
    translate <9.5,11,30>
  }
  photons {
    reflection on
    refraction on
  }
}

light_source { // candle, or whatever
  <3,10,-10>
  colour rgb <1,.9,.8>
  fade_distance 60
  fade_power 2
  photons {
    reflection on
    refraction on
  }
}

light_source { // fill-in ceiling light
  <0,10,12>
  colour rgb .5
  shadowless
  photons {
    reflection off
    refraction off
  }
}

object { //glass
  WineGlass
}

object { // bottle
  WineBottle
  material {M_WineBottle}
  rotate y*-120
  scale .5
  translate <-14,0,6>
  photons {
    reflection on
    refraction on
    collect on
  }
}

intersection { // half-full bottle
  object {
    DrinkInBottle
  }
  plane {
    y,10
  }
  scale .5
  translate <-14,0,6>
  material {M_RedWine}
  photons {
    reflection off
    refraction on
    collect on
  }
}

FillGlass(5.5, .1)

difference {
  object {
    DrinkInGlass
  }
  plane {
    -y,-5.5
  }
  material {M_RedWine}
}

object {
  Cork
  scale .5
  rotate y*40
  translate <-10,.6,18>
  texture { T_Cork }
}

object { //tree
  TREE
  scale 11
  translate <0,5.5,0>
}

plane { // table surface
  y,-epsilon
  texture {
    zOak
    finish {
      ambient .2
    }
  }
}

object { // window with view, to reflect off wine bottle
  Window
  pigment {
    gradient y
    colour_map {
      [0.0 rgb <.05,.7,.4>]
      [0.3 rgb <.3,.4,.8>]
      [0.5 rgb <.3,.4,.4>]
      [.8 rgb <.3,.3,.3>]
    }
    turbulence .4
    octaves 1
  }
  finish {
    ambient 2
    diffuse 1
  }
  no_image
  no_shadow
  rotate 90*y
  scale <1,10,30>
  translate <10,15,-10>
}
