#debug " --- Ants.inc --- \n"

#macro PlaceAnts( XSize, ZSize, X, Z, Angle, Spacing, Jitter, Seed )
	#local ARand = seed( Seed );
	#local XCount = 0;
	#local ZCount = 0;
	#while( ZCount < ZSize )
		#while( XCount < XSize )
			#local XPos = XCount*Spacing+Jitter*rand( ARand );
			#local ZPos = ZCount*Spacing+Jitter*rand( ARand );
			#local Position = <XPos,0,ZPos>;
			#local Position = vrotate( Position, <0.0,Angle,0.0>);	
			#local XPos = Position.x+X;
			#local ZPos = Position.z+Z;
			#local AYAngle = Angle+20*rand(ARand)-10;
			#local AZAngle = 10*rand(ARand)-5;
			#local ASeed = int( rand( ARand )*XSize*ZSize );			
			PlaceAnt( XPos, ZPos, AYAngle, AZAngle, ASeed )
			#local XCount = XCount+1;
		#end
		#local XCount = 0;
		#local ZCount = ZCount+1;
	#end
#end

#macro PlaceAnt( AntX, AntZ, AntYRot, AntZRot, Seed )
	#declare Rand = seed( Seed );
	#local Normal = <0,0,0>;
	#local AntLocation = trace( Ground, <AntX,30,AntZ>, -y, Normal );
	RandomizeAnt( Seed )
		object { Ant() 
			rotate z*AntZRot
			translate y*1.05
			scale 0.15*0.2
			rotate y*AntYRot translate AntLocation 
		}
		#debug concat( "Ant location <", vstr( 3,AntLocation,", ",1,5),">, Seed ", str( Seed, 1, 5 ), " \n" )
#end


#if( Quality > 8 )

//	#declare Rand = seed( 5 );
//	//object { Ant()  rotate y*45   }
//	#declare ACount = 0;
//	#while( ACount < 200 )
//		#declare AntYRot = 230+rand( Rand )*20;
//		#declare AntZRot = rand( Rand )*10-5;
//		#declare AntX = rand( Rand )*9.25-10;
//		#declare AntZ = -(1-pow(rand( Rand ),2))*7-4;
//		#local Normal = <0,0,0>;
//		#local AntLocation = trace( Ground, <AntX,30,AntZ>, -y, Normal );
//		RandomizeAnt( ACount )
//		object { Ant() 
//			rotate z*AntZRot
//			translate y*1.05
//			scale 0.15*0.2
//			rotate y*AntYRot translate AntLocation 
//		}
////		#debug concat( "Ant location <", vstr( 3,AntLocation,", ",1,5),">, Seed ", str( ACount, 1, 1 ), " \n" )
////		#debug concat( "Y Rot ", str( AntYRot, 1, 3 ), "\n" ) 		
////		#debug concat( "Z Rot ", str( AntZRot, 1, 3 ), "\n" ) 		
////		#debug concat( "AntX ", str( AntX, 1, 3 ), "\n" ) 		
////		#debug concat( "AntZ ", str( AntZ, 1, 3 ), "\n" ) 		
////		text {
////			ttf "timrom.ttf",
////			str( ACount, 3, 1 )
////			0.3, <0.0, 0.0, 0.0>
////			scale 0.25
////			translate AntLocation+<0,0.1,0>
////			pigment { rgb 1 }
////		}
//		#declare ACount = ACount+1;
//	#end
	
	#declare AntScaleFactor = 0.75;
	
	// 2.7 x 4.5
	PlaceAnts( 13, 20, -1.7, -9.25, 83.5+180, 0.225, 0.09, 5 )
	
	// 4.2 x 4.9
	PlaceAnts( 17, 20, -3.3, -4.50, 83+180, 0.24, 0.075, 6 )

	PlaceAnts( 12, 10, -3.3, 1, 117+180, 0.24, 0.075, 10 )


#end


PlaceAnt( -2.588, -4.558, 249.603, -3.148, 184 )
PlaceAnt( -2.143, -4.381, 233.400, 2.167, 100 )
PlaceAnt( -1.654, -4.930, 249.974, 1.181, 7 )
PlaceAnt( -1.382, -5.280, 238.556, -3.649, 145 )
PlaceAnt( -1.494, -6.043, 238.251, -3.737, 91 )

#if( Quality > 8 )
	// Black ants
	#declare AntTex = texture {
		pigment {
			bozo
			color_map {
				[ 0.5 rgb <0.145418, 0.131106, 0.171939> ]
				[ 1 rgb <0.190265, 0.178805, 0.217197> ]
			}
			scale <0.3,0.25,0.25>
		}
	#declare AntHairTex = texture {
		pigment {
			rgb <0.190265, 0.178805, 0.217197>
		}
		finish {
			specular 0.7 roughness 0.01
		}
	}

		#if( Quality > 7 )
		normal {
			bumps 0.75 scale 0.0075
		}
		#end
		finish {
			specular 0.7 roughness 0.01
			irid {
				0.005
				thickness 0.05
				turbulence <0.3, 0.5, 0.3>
			}		
		}
	}
	#declare AntScaleFactor = 0.825*0.75;

	// 2.25 x 2.25
	// Foreground black ants
	PlaceAnts( 13, 13, -1.1, -7.25, 82, 0.19, 0.09, 7 )

	// Background black ants
	PlaceAnts( 12, 9, -1.4, 0.2, 87, 0.19, 0.09, 9 )

	// Right black ants
	PlaceAnts( 15, 9, 4.4, -2.8, 83, 0.2, 0.09, 10 )


	#declare AntScaleFactor = 0.825;
	
	// Ant on top of sugar cubes
	RandomizeAnt( 87 )
	object { Ant() 				
		scale 0.15*0.2
		rotate x*-10
		rotate y*68
		translate 
		<-0.325+0.6,1.52,-0.54-5.05>
	}
	
	// Ant climbing the sugar cubes
	RandomizeAnt( 88 )
	object { Ant() 				
		scale 0.15*0.2
		rotate y*180
		rotate x*-90
		rotate z*8
		translate z*-0.25
		rotate y*10
		translate 
		<-0.025+0.6,0.76+0.1,-0.475-5.05>
	}

#end

