// Fired...
// Thomas Pimmel 2004
global_settings {
   adc_bailout 0.0039216
   ambient_light rgb <0.01, 0.01, 0.01>
   assumed_gamma 1.5
   max_trace_level 10
   
   radiosity {
      brightness 0.5
   }
}

#declare Queue6 = union {
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.62901, 11.0935, -4>, <2.62876, 9.33749, -3.22>, <2.68725, 7.48615, -2.62477>, <2.62826, 5.82557, -1.66>,
      <0.719249, 11.6853, -4>, <0.718999, 9.92939, -3.22>, <1.32623, 7.79182, -2.62477>, <1.26724, 6.13124, -1.66>,
      <-2.26282, 11.0536, -4>, <-1.71432, 9.01142, -3.22>, <-1.09537, 7.62893, -2.47954>, <-0.705735, 5.56585, -1.66>,
      <-3.10028, 12.8692, -4>, <-2.55179, 10.827, -3.22>, <-1.84444, 8.80567, -2.47954>, <-1.4548, 6.74259, -1.66>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-3.10028, 12.8692, -4>, <-2.55179, 10.827, -3.22>, <-1.84444, 8.80567, -2.47954>, <-1.4548, 6.74259, -1.66>,
      <-3.83777, 14.468, -4>, <-3.28928, 12.4258, -3.22>, <-2.39374, 9.66859, -2.47954>, <-2.0041, 7.60551, -1.66>,
      <-1.29583, 15.9011, -4>, <-1.02151, 13.1433, -3.22>, <-0.324794, 11.008, -2.69036>, <-0.151299, 8.32523, -1.66>,
      <-0.237781, 17.3084, -4>, <0.036546, 14.5506, -3.22>, <0.411706, 11.7179, -2.69036>, <0.585201, 9.03511, -1.66>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.237781, 17.3084, -4>, <0.036546, 14.5506, -3.22>, <0.411706, 11.7179, -2.69036>, <0.585201, 9.03511, -1.66>,
      <0.618616, 18.4475, -4>, <0.892943, 15.6897, -3.22>, <1.0399, 12.3233, -2.69036>, <1.21339, 9.6406, -1.66>,
      <1.19959, 20.4841, -4>, <1.19975, 17.2144, -3.22>, <1.82721, 13.8047, -2.88446>, <1.75271, 10.6751, -1.66>,
      <2.62472, 20.4841, -4>, <2.62488, 17.2144, -3.22>, <2.6997, 13.8047, -2.88446>, <2.6252, 10.6751, -1.66>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.62472, 20.4841, -4>, <2.62488, 17.2144, -3.22>, <2.6997, 13.8047, -2.88446>, <2.6252, 10.6751, -1.66>,
      <4.04985, 20.4841, -4>, <4.05001, 17.2144, -3.22>, <3.57219, 13.8047, -2.88446>, <3.49769, 10.6751, -1.66>,
      <4.63082, 18.4475, -4>, <4.35682, 15.6897, -3.22>, <4.3402, 12.2059, -2.93122>, <4.03701, 9.6406, -1.66>,
      <5.48722, 17.3084, -4>, <5.21321, 14.5506, -3.22>, <4.96839, 11.6004, -2.93122>, <4.6652, 9.03511, -1.66>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <5.48722, 17.3084, -4>, <5.21321, 14.5506, -3.22>, <4.96839, 11.6004, -2.93122>, <4.6652, 9.03511, -1.66>,
      <6.54527, 15.9011, -4>, <6.27127, 13.1433, -3.22>, <5.70489, 10.8905, -2.93122>, <5.4017, 8.32523, -1.66>,
      <9.08721, 14.468, -4>, <8.53904, 12.4258, -3.22>, <7.71978, 9.44008, -2.88363>, <7.2545, 7.60551, -1.66>,
      <8.34972, 12.8692, -4>, <7.80155, 10.827, -3.22>, <7.17048, 8.57716, -2.88363>, <6.7052, 6.74259, -1.66>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <8.34972, 12.8692, -4>, <7.80155, 10.827, -3.22>, <7.17048, 8.57716, -2.88363>, <6.7052, 6.74259, -1.66>,
      <7.51225, 11.0536, -4>, <6.96408, 9.01142, -3.22>, <6.42141, 7.40042, -2.88363>, <5.95614, 5.56585, -1.66>,
      <4.53019, 11.6853, -4>, <4.53076, 9.92939, -3.22>, <4.04156, 7.792, -2.62451>, <3.98316, 6.13124, -1.66>,
      <2.62042, 11.0935, -4>, <2.621, 9.33749, -3.22>, <2.68054, 7.48632, -2.62451>, <2.62214, 5.82557, -1.66>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.62826, 5.82557, -1.66>, <2.55877, 3.86933, -0.523448>, <2.759, 1.4237, 0.372816>, <2.24563, 0.301204, 2.27016>,
      <1.26724, 6.13124, -1.66>, <1.19775, 4.175, -0.523448>, <1.71871, 1.68592, -0.157236>, <1.20534, 0.563421, 1.74011>,
      <-0.705735, 5.56585, -1.66>, <-0.351498, 3.69022, -0.914925>, <-0.241273, 1.15492, -0.770669>, <-0.302691, 0.0784011, 0.971724>,
      <-1.4548, 6.74259, -1.66>, <-1.10056, 4.86696, -0.914925>, <-0.813814, 2.16437, -1.06239>, <-0.875232, 1.08786, 0.68>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-1.4548, 6.74259, -1.66>, <-1.10056, 4.86696, -0.914925>, <-0.813814, 2.16437, -1.06239>, <-0.875232, 1.08786, 0.68>,
      <-2.0041, 7.60551, -1.66>, <-1.64986, 5.72988, -0.914925>, <-1.23367, 2.90462, -1.27632>, <-1.29509, 1.82811, 0.466074>,
      <-0.151299, 8.32523, -1.66>, <-0.0156514, 6.22772, -0.854408>, <0.389177, 3.79445, -0.59433>, <0.121089, 2.44552, 1.18765>,
      <0.585201, 9.03511, -1.66>, <0.720849, 6.9376, -0.854408>, <0.952116, 4.40342, -0.307498>, <0.684028, 3.05449, 1.47448>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.585201, 9.03511, -1.66>, <0.720849, 6.9376, -0.854408>, <0.952116, 4.40342, -0.307498>, <0.684028, 3.05449, 1.47448>,
      <1.21339, 9.6406, -1.66>, <1.34904, 7.54309, -0.854408>, <1.43227, 4.92283, -0.0628458>, <1.16418, 3.5739, 1.71913>,
      <1.75271, 10.6751, -1.66>, <1.69832, 8.39049, -0.766128>, <2.06802, 6.03423, 0.11097>, <1.5764, 4.46135, 1.92917>,
      <2.6252, 10.6751, -1.66>, <2.57081, 8.39049, -0.766128>, <2.73491, 6.03423, 0.450765>, <2.24329, 4.46135, 2.26897>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.6252, 10.6751, -1.66>, <2.57081, 8.39049, -0.766128>, <2.73491, 6.03423, 0.450765>, <2.24329, 4.46135, 2.26897>,
      <3.49769, 10.6751, -1.66>, <3.44331, 8.39049, -0.766128>, <3.40179, 6.03423, 0.79056>, <2.91017, 4.46135, 2.60876>,
      <4.03701, 9.6406, -1.66>, <3.76778, 7.36264, -0.531165>, <4.08032, 5.08609, 0.901845>, <3.32239, 3.5739, 2.8188>,
      <4.6652, 9.03511, -1.66>, <4.39597, 6.75715, -0.531165>, <4.56048, 4.56667, 1.1465>, <3.80255, 3.05449, 3.06345>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <4.6652, 9.03511, -1.66>, <4.39597, 6.75715, -0.531165>, <4.56048, 4.56667, 1.1465>, <3.80255, 3.05449, 3.06345>,
      <5.4017, 8.32523, -1.66>, <5.13247, 6.04727, -0.531165>, <5.12342, 3.95771, 1.43333>, <4.36549, 2.44552, 3.35028>,
      <7.2545, 7.60551, -1.66>, <6.70301, 5.43095, -0.209609>, <6.85053, 3.19221, 2.03883>, <5.78167, 1.82811, 4.07186>,
      <6.7052, 6.74259, -1.66>, <6.1537, 4.56803, -0.209609>, <6.43067, 2.45196, 1.8249>, <5.36181, 1.08786, 3.85793>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <6.7052, 6.74259, -1.66>, <6.1537, 4.56803, -0.209609>, <6.43067, 2.45196, 1.8249>, <5.36181, 1.08786, 3.85793>,
      <5.95614, 5.56585, -1.66>, <5.40464, 3.3913, -0.209609>, <5.85813, 1.4425, 1.53318>, <4.78927, 0.0784006, 3.56621>,
      <3.98316, 6.13124, -1.66>, <3.91438, 4.17522, -0.524005>, <3.79384, 1.6857, 0.900732>, <3.28124, 0.563421, 2.79783>,
      <2.62214, 5.82557, -1.66>, <2.55336, 3.86955, -0.524005>, <2.75355, 1.42349, 0.370679>, <2.24095, 0.301204, 2.26777>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.24563, 0.301204, 2.27016>, <1.85238, -0.558646, 3.72355>, <0.523459, 0.78752, 5.35694>, <0.266935, 0.662441, 7.06717>,
      <1.20534, 0.563421, 1.74011>, <0.812095, -0.296429, 3.1935>, <-0.157224, 0.942752, 5.47697>, <-0.413748, 0.817674, 7.1872>,
      <-0.302691, 0.0784011, 0.971724>, <-0.370703, -1.11369, 2.90118>, <-1.45216, 0.772333, 5.10567>, <-1.40049, 0.530541, 7.36119>,
      <-0.875232, 1.08786, 0.68>, <-0.943244, -0.104235, 2.60946>, <-1.82679, 1.36993, 5.17172>, <-1.77511, 1.12814, 7.42724>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.875232, 1.08786, 0.68>, <-0.943244, -0.104235, 2.60946>, <-1.82679, 1.36993, 5.17172>, <-1.77511, 1.12814, 7.42724>,
      <-1.29509, 1.82811, 0.466074>, <-1.3631, 0.636015, 2.39553>, <-2.10151, 1.80816, 5.22016>, <-2.04983, 1.56637, 7.47568>,
      <0.121089, 2.44552, 1.18765>, <-0.117031, 1.24738, 2.77043>, <-1.00401, 2.33889, 5.35843>, <-1.1232, 1.93188, 7.31229>,
      <0.684028, 3.05449, 1.47448>, <0.445908, 1.85634, 3.05727>, <-0.635661, 2.6994, 5.29348>, <-0.754855, 2.29238, 7.24734>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.684028, 3.05449, 1.47448>, <0.445908, 1.85634, 3.05727>, <-0.635661, 2.6994, 5.29348>, <-0.754855, 2.29238, 7.24734>,
      <1.16418, 3.5739, 1.71913>, <0.926064, 2.37576, 3.30192>, <-0.321484, 3.0069, 5.23808>, <-0.440678, 2.59988, 7.19195>,
      <1.5764, 4.46135, 1.92917>, <1.2185, 3.31628, 3.25284>, <0.0837651, 3.61248, 5.44465>, <-0.170953, 3.12525, 7.14439>,
      <2.24329, 4.46135, 2.26897>, <1.88538, 3.31628, 3.59264>, <0.520123, 3.61248, 5.3677>, <0.265405, 3.12525, 7.06745>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.24329, 4.46135, 2.26897>, <1.88538, 3.31628, 3.59264>, <0.520123, 3.61248, 5.3677>, <0.265405, 3.12525, 7.06745>,
      <2.91017, 4.46135, 2.60876>, <2.55227, 3.31628, 3.93243>, <0.956481, 3.61248, 5.29076>, <0.701763, 3.12525, 6.9905>,
      <3.32239, 3.5739, 2.8188>, <2.86376, 2.65885, 3.97878>, <1.33017, 2.92453, 5.47353>, <0.971488, 2.59988, 6.94294>,
      <3.80255, 3.05449, 3.06345>, <3.34391, 2.13943, 4.22344>, <1.64434, 2.61704, 5.41813>, <1.28567, 2.29238, 6.88755>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <3.80255, 3.05449, 3.06345>, <3.34391, 2.13943, 4.22344>, <1.64434, 2.61704, 5.41813>, <1.28567, 2.29238, 6.88755>,
      <4.36549, 2.44552, 3.35028>, <3.90685, 1.53047, 4.51027>, <2.01269, 2.25653, 5.35318>, <1.65401, 1.93188, 6.8226>,
      <5.78167, 1.82811, 4.07186>, <5.22436, 1.11686, 5.13188>, <3.03108, 1.72418, 5.35066>, <2.58065, 1.56637, 6.65921>,
      <5.36181, 1.08786, 3.85793>, <4.80451, 0.376614, 4.91795>, <2.75636, 1.28595, 5.3991>, <2.30593, 1.12814, 6.70765>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <5.36181, 1.08786, 3.85793>, <4.80451, 0.376614, 4.91795>, <2.75636, 1.28595, 5.3991>, <2.30593, 1.12814, 6.70765>,
      <4.78927, 0.0784006, 3.56621>, <4.23197, -0.632842, 4.62623>, <2.38173, 0.688355, 5.46515>, <1.9313, 0.530541, 6.7737>,
      <3.28124, 0.563421, 2.79783>, <2.88833, -0.296792, 4.25193>, <1.20073, 0.942796, 5.23671>, <0.944558, 0.817674, 6.94769>,
      <2.24095, 0.301204, 2.26777>, <1.84805, -0.55901, 3.72187>, <0.520042, 0.787564, 5.35673>, <0.263874, 0.662441, 7.06771>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.266935, 0.662441, 7.06717>, <-0.00908241, 0.527858, 8.90737>, <1.10461, -0.313469, 10.7175>, <0.705976, -0.449515, 12.5349>,
      <-0.413748, 0.817674, 7.1872>, <-0.689765, 0.68309, 9.02739>, <0.660553, -0.189403, 10.3889>, <0.261914, -0.325449, 12.2063>,
      <-1.40049, 0.530541, 7.36119>, <-1.36674, 0.372632, 8.83423>, <-0.157223, -0.431002, 10.2705>, <-0.381812, -0.554933, 11.73>,
      <-1.77511, 1.12814, 7.42724>, <-1.74137, 0.970229, 8.90028>, <-0.401621, 0.0466146, 10.0897>, <-0.62621, -0.077316, 11.5492>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-1.77511, 1.12814, 7.42724>, <-1.74137, 0.970229, 8.90028>, <-0.401621, 0.0466146, 10.0897>, <-0.62621, -0.077316, 11.5492>,
      <-2.04983, 1.56637, 7.47568>, <-2.01609, 1.40846, 8.94872>, <-0.580842, 0.396859, 9.95705>, <-0.805431, 0.272928, 11.4165>,
      <-1.1232, 1.93188, 7.31229>, <-1.22392, 1.58795, 8.96328>, <0.106398, 0.755621, 10.2136>, <-0.200916, 0.565052, 11.8639>,
      <-0.754855, 2.29238, 7.24734>, <-0.855572, 1.94846, 8.89833>, <0.346697, 1.04375, 10.3914>, <0.039383, 0.85318, 12.0417>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.754855, 2.29238, 7.24734>, <-0.855572, 1.94846, 8.89833>, <0.346697, 1.04375, 10.3914>, <0.039383, 0.85318, 12.0417>,
      <-0.440678, 2.59988, 7.19195>, <-0.541395, 2.25595, 8.84293>, <0.551658, 1.28951, 10.5431>, <0.244344, 1.09894, 12.1933>,
      <-0.170953, 3.12525, 7.14439>, <-0.442565, 2.6057, 8.95686>, <0.824671, 1.77368, 10.4795>, <0.420306, 1.51883, 12.3235>,
      <0.265405, 3.12525, 7.06745>, <-0.00620732, 2.6057, 8.87992>, <1.10934, 1.77368, 10.6902>, <0.704975, 1.51883, 12.5342>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.265405, 3.12525, 7.06745>, <-0.00620732, 2.6057, 8.87992>, <1.10934, 1.77368, 10.6902>, <0.704975, 1.51883, 12.5342>,
      <0.701763, 3.12525, 6.9905>, <0.430151, 2.6057, 8.80298>, <1.39401, 1.77368, 10.9008>, <0.989644, 1.51883, 12.7448>,
      <0.971488, 2.59988, 6.94294>, <0.484122, 2.15874, 8.93957>, <1.67805, 1.33807, 10.8505>, <1.16561, 1.09894, 12.875>,
      <1.28567, 2.29238, 6.88755>, <0.798299, 1.85125, 8.88417>, <1.88301, 1.09232, 11.0021>, <1.37057, 0.85318, 13.0267>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.28567, 2.29238, 6.88755>, <0.798299, 1.85125, 8.88417>, <1.88301, 1.09232, 11.0021>, <1.37057, 0.85318, 13.0267>,
      <1.65401, 1.93188, 6.8226>, <1.16664, 1.49074, 8.81922>, <2.12331, 0.804188, 11.18>, <1.61087, 0.565052, 13.2045>,
      <2.58065, 1.56637, 6.65921>, <1.83442, 1.30492, 8.82706>, <2.85111, 0.469228, 11.4423>, <2.21538, 0.272928, 13.6518>,
      <2.30593, 1.12814, 6.70765>, <1.5597, 0.866691, 8.8755>, <2.67189, 0.118983, 11.3097>, <2.03616, -0.077316, 13.5192>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.30593, 1.12814, 6.70765>, <1.5597, 0.866691, 8.8755>, <2.67189, 0.118983, 11.3097>, <2.03616, -0.077316, 13.5192>,
      <1.9313, 0.530541, 6.7737>, <1.18507, 0.269092, 8.94156>, <2.4275, -0.358633, 11.1288>, <1.79176, -0.554933, 13.3384>,
      <0.944558, 0.817674, 6.94769>, <0.669127, 0.683142, 8.78734>, <1.54637, -0.189451, 11.0451>, <1.14804, -0.325449, 12.862>,
      <0.263874, 0.662441, 7.06771>, <-0.0115569, 0.527909, 8.90736>, <1.10231, -0.313517, 10.7166>, <0.703978, -0.449515, 12.5334>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.705976, -0.449515, 12.5349>, <0.307128, -0.585632, 14.3533>, <-1.89157, -0.112776, 15.5603>, <-2.00459, -0.112776, 17.4235>,
      <0.261914, -0.325449, 12.2063>, <-0.136934, -0.461566, 14.0248>, <-2.35831, 0.00110141, 15.7584>, <-2.47133, 0.00110141, 17.6216>,
      <-0.381812, -0.554933, 11.73>, <-0.737814, -0.751379, 14.0435>, <-3.04629, -0.198484, 15.5621>, <-3.14793, -0.209536, 17.9088>,
      <-0.62621, -0.077316, 11.5492>, <-0.982212, -0.273762, 13.8626>, <-3.30317, 0.239908, 15.6711>, <-3.40481, 0.228856, 18.0178>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.62621, -0.077316, 11.5492>, <-0.982212, -0.273762, 13.8626>, <-3.30317, 0.239908, 15.6711>, <-3.40481, 0.228856, 18.0178>,
      <-0.805431, 0.272928, 11.4165>, <-1.16143, 0.0764821, 13.73>, <-3.49154, 0.561388, 15.7511>, <-3.59318, 0.550336, 18.0978>,
      <-0.200916, 0.565052, 11.8639>, <-0.583628, 0.327728, 13.919>, <-2.8497, 0.855203, 15.7272>, <-2.95779, 0.81847, 17.8281>,
      <0.039383, 0.85318, 12.0417>, <-0.34333, 0.615855, 14.0968>, <-2.59713, 1.11967, 15.62>, <-2.70522, 1.08294, 17.7209>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.039383, 0.85318, 12.0417>, <-0.34333, 0.615855, 14.0968>, <-2.59713, 1.11967, 15.62>, <-2.70522, 1.08294, 17.7209>,
      <0.244344, 1.09894, 12.1933>, <-0.138368, 0.861612, 14.2485>, <-2.3817, 1.34524, 15.5286>, <-2.4898, 1.30851, 17.6294>,
      <0.420306, 1.51883, 12.3235>, <0.0245228, 1.26938, 14.1284>, <-2.19203, 1.74624, 15.6906>, <-2.30485, 1.69392, 17.5509>,
      <0.704975, 1.51883, 12.5342>, <0.309192, 1.26938, 14.339>, <-1.89282, 1.74624, 15.5636>, <-2.00564, 1.69392, 17.4239>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.704975, 1.51883, 12.5342>, <0.309192, 1.26938, 14.339>, <-1.89282, 1.74624, 15.5636>, <-2.00564, 1.69392, 17.4239>,
      <0.989644, 1.51883, 12.7448>, <0.593861, 1.26938, 14.5497>, <-1.59361, 1.74624, 15.4366>, <-1.70643, 1.69392, 17.2969>,
      <1.16561, 1.09894, 12.875>, <0.767272, 0.913051, 14.4488>, <-1.40561, 1.34094, 15.5888>, <-1.52148, 1.30851, 17.2184>,
      <1.37057, 0.85318, 13.0267>, <0.972234, 0.667294, 14.6004>, <-1.19018, 1.11537, 15.4974>, <-1.30606, 1.08294, 17.127>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.37057, 0.85318, 13.0267>, <0.972234, 0.667294, 14.6004>, <-1.19018, 1.11537, 15.4974>, <-1.30606, 1.08294, 17.127>,
      <1.61087, 0.565052, 13.2045>, <1.21253, 0.379166, 14.7783>, <-0.937608, 0.850902, 15.3902>, <-1.05349, 0.81847, 17.0197>,
      <2.21538, 0.272928, 13.6518>, <1.82535, 0.152495, 15.0074>, <-0.300817, 0.558955, 15.3392>, <-0.418099, 0.550337, 16.75>,
      <2.03616, -0.077316, 13.5192>, <1.64613, -0.197749, 14.8748>, <-0.489191, 0.237475, 15.4192>, <-0.606472, 0.228856, 16.83>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.03616, -0.077316, 13.5192>, <1.64613, -0.197749, 14.8748>, <-0.489191, 0.237475, 15.4192>, <-0.606472, 0.228856, 16.83>,
      <1.79176, -0.554933, 13.3384>, <1.40173, -0.675366, 14.694>, <-0.746069, -0.200918, 15.5282>, <-0.863351, -0.209537, 16.939>,
      <1.14804, -0.325449, 12.862>, <0.749214, -0.461616, 14.6812>, <-1.42694, 0.00110141, 15.3623>, <-1.53995, 0.00110141, 17.2262>,
      <0.703978, -0.449515, 12.5334>, <0.305153, -0.585682, 14.3526>, <-1.89368, -0.112776, 15.5605>, <-2.00669, -0.112776, 17.4244>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-2.00459, -0.112776, 17.4235>, <-2.17243, -0.112776, 20.1904>, <-0.93754, -0.546066, 22.8724>, <-0.0809088, -0.449515, 25.507>,
      <-2.47133, 0.00110141, 17.6216>, <-2.63917, 0.00110141, 20.3885>, <-1.33083, -0.445, 23.1035>, <-0.474195, -0.348449, 25.7381>,
      <-3.14793, -0.209536, 17.9088>, <-3.27005, -0.222816, 20.7285>, <-1.9953, -0.6175, 23.4166>, <-1.04236, -0.538913, 26.072>,
      <-3.40481, 0.228856, 18.0178>, <-3.52693, 0.215577, 20.8375>, <-2.21372, -0.224903, 23.5449>, <-1.26077, -0.146317, 26.2004>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-3.40481, 0.228856, 18.0178>, <-3.52693, 0.215577, 20.8375>, <-2.21372, -0.224903, 23.5449>, <-1.26077, -0.146317, 26.2004>,
      <-3.59318, 0.550336, 18.0978>, <-3.7153, 0.537057, 20.9175>, <-2.37278, 0.0610098, 23.6384>, <-1.41983, 0.139596, 26.2939>,
      <-2.95779, 0.81847, 17.8281>, <-3.10159, 0.769604, 20.6229>, <-1.79, 0.340069, 23.331>, <-0.883883, 0.377209, 25.9789>,
      <-2.70522, 1.08294, 17.7209>, <-2.84902, 1.03407, 20.5157>, <-1.5774, 0.574537, 23.206>, <-0.671282, 0.611677, 25.8539>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-2.70522, 1.08294, 17.7209>, <-2.84902, 1.03407, 20.5157>, <-1.5774, 0.574537, 23.206>, <-0.671282, 0.611677, 25.8539>,
      <-2.4898, 1.30851, 17.6294>, <-2.63359, 1.25964, 20.4242>, <-1.39565, 0.774977, 23.0992>, <-0.489536, 0.812117, 25.7471>,
      <-2.30485, 1.69392, 17.5509>, <-2.4728, 1.61602, 20.3204>, <-1.19091, 1.14681, 23.0153>, <-0.33258, 1.15392, 25.6549>,
      <-2.00564, 1.69392, 17.4239>, <-2.17359, 1.61602, 20.1934>, <-0.940121, 1.14681, 22.8679>, <-0.0817943, 1.15392, 25.5075>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-2.00564, 1.69392, 17.4239>, <-2.17359, 1.61602, 20.1934>, <-0.940121, 1.14681, 22.8679>, <-0.0817943, 1.15392, 25.5075>,
      <-1.70643, 1.69392, 17.2969>, <-1.87439, 1.61602, 20.0663>, <-0.689335, 1.14681, 22.7205>, <0.168991, 1.15392, 25.3601>,
      <-1.52148, 1.30851, 17.2184>, <-1.7165, 1.25393, 19.9608>, <-0.482917, 0.77446, 22.6399>, <0.325946, 0.812117, 25.2679>,
      <-1.30606, 1.08294, 17.127>, <-1.50107, 1.02835, 19.8694>, <-0.301171, 0.574021, 22.5331>, <0.507692, 0.611677, 25.161>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-1.30606, 1.08294, 17.127>, <-1.50107, 1.02835, 19.8694>, <-0.301171, 0.574021, 22.5331>, <0.507692, 0.611677, 25.161>,
      <-1.05349, 0.81847, 17.0197>, <-1.2485, 0.763889, 19.7622>, <-0.0885694, 0.339553, 22.4081>, <0.720293, 0.377209, 25.0361>,
      <-0.418099, 0.550337, 16.75>, <-0.643786, 0.533752, 19.4649>, <0.497749, 0.0588168, 22.1058>, <1.25625, 0.139596, 24.7211>,
      <-0.606472, 0.228856, 16.83>, <-0.83216, 0.212271, 19.5449>, <0.338687, -0.227097, 22.1993>, <1.09718, -0.146317, 24.8146>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.606472, 0.228856, 16.83>, <-0.83216, 0.212271, 19.5449>, <0.338687, -0.227097, 22.1993>, <1.09718, -0.146317, 24.8146>,
      <-0.863351, -0.209537, 16.939>, <-1.08904, -0.226121, 19.6539>, <0.120274, -0.619693, 22.3276>, <0.878771, -0.538913, 24.943>,
      <-1.53995, 0.00110141, 17.2262>, <-1.70772, 0.00110141, 19.9932>, <-0.54617, -0.444998, 22.6423>, <0.310608, -0.348449, 25.2769>,
      <-2.00669, -0.112776, 17.4244>, <-2.17446, -0.112776, 20.1914>, <-0.939457, -0.546064, 22.8734>, <-0.0826797, -0.449515, 25.508>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.0809088, -0.449515, 25.507>, <0.742516, -0.356707, 28.0394>, <1.87377, -0.306049, 30.5352>, <3.00365, 0.451702, 32.8263>,
      <-0.474195, -0.348449, 25.7381>, <0.34923, -0.255641, 28.2706>, <1.61953, -0.225136, 30.8432>, <2.74941, 0.532615, 33.1342>,
      <-1.04236, -0.538913, 26.072>, <-0.100944, -0.461279, 28.6954>, <0.990079, -0.383743, 31.276>, <2.39048, 0.361525, 33.569>,
      <-1.26077, -0.146317, 26.2004>, <-0.319357, -0.0686821, 28.8237>, <0.840528, -0.0508287, 31.4572>, <2.24093, 0.69444, 33.7501>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-1.26077, -0.146317, 26.2004>, <-0.319357, -0.0686821, 28.8237>, <0.840528, -0.0508287, 31.4572>, <2.24093, 0.69444, 33.7501>,
      <-1.41983, 0.139596, 26.2939>, <-0.478419, 0.217231, 28.9172>, <0.736241, 0.181323, 31.5835>, <2.13664, 0.926592, 33.8764>,
      <-0.883883, 0.377209, 25.9789>, <-0.00325811, 0.413304, 28.5523>, <1.20639, 0.511815, 31.1302>, <2.4855, 1.11485, 33.4539>,
      <-0.671282, 0.611677, 25.8539>, <0.209342, 0.647772, 28.4274>, <1.34289, 0.69825, 30.9648>, <2.622, 1.30129, 33.2885>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.671282, 0.611677, 25.8539>, <0.209342, 0.647772, 28.4274>, <1.34289, 0.69825, 30.9648>, <2.622, 1.30129, 33.2885>,
      <-0.489536, 0.812117, 25.7471>, <0.391088, 0.848211, 28.3206>, <1.4613, 0.859978, 30.8214>, <2.74041, 1.46301, 33.1451>,
      <-0.33258, 1.15392, 25.6549>, <0.488368, 1.16072, 28.1795>, <1.69269, 1.23694, 30.6785>, <2.84616, 1.7354, 33.017>,
      <-0.0817943, 1.15392, 25.5075>, <0.739153, 1.16072, 28.0321>, <1.84961, 1.23694, 30.4885>, <3.00308, 1.7354, 32.827>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <-0.0817943, 1.15392, 25.5075>, <0.739153, 1.16072, 28.0321>, <1.84961, 1.23694, 30.4885>, <3.00308, 1.7354, 32.827>,
      <0.168991, 1.15392, 25.3601>, <0.989938, 1.16072, 27.8847>, <2.00653, 1.23694, 30.2984>, <3.16, 1.7354, 32.6369>,
      <0.325946, 0.812117, 25.2679>, <1.08954, 0.847665, 27.7488>, <2.24814, 0.891084, 30.1901>, <3.26575, 1.46301, 32.5089>,
      <0.507692, 0.611677, 25.161>, <1.27128, 0.647226, 27.642>, <2.36655, 0.729356, 30.0467>, <3.38416, 1.30129, 32.3654>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <0.507692, 0.611677, 25.161>, <1.27128, 0.647226, 27.642>, <2.36655, 0.729356, 30.0467>, <3.38416, 1.30129, 32.3654>,
      <0.720293, 0.377209, 25.0361>, <1.48388, 0.412758, 27.517>, <2.50305, 0.542921, 29.8814>, <3.52065, 1.11485, 32.2001>,
      <1.25625, 0.139596, 24.7211>, <1.96354, 0.214923, 27.1599>, <2.98498, 0.255723, 29.4926>, <3.86951, 0.926589, 31.7776>,
      <1.09718, -0.146317, 24.8146>, <1.80448, -0.0709903, 27.2534>, <2.88069, 0.0235744, 29.6189>, <3.76523, 0.69444, 31.9039>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <1.09718, -0.146317, 24.8146>, <1.80448, -0.0709903, 27.2534>, <2.88069, 0.0235744, 29.6189>, <3.76523, 0.69444, 31.9039>,
      <0.878771, -0.538913, 24.943>, <1.58607, -0.463587, 27.3818>, <2.73114, -0.309339, 29.8>, <3.61567, 0.361527, 32.085>,
      <0.310608, -0.348449, 25.2769>, <1.13421, -0.255639, 27.8095>, <2.12648, -0.225195, 30.2287>, <3.25674, 0.532615, 32.5198>,
      <-0.0826797, -0.449515, 25.508>, <0.74092, -0.356705, 28.0406>, <1.87224, -0.306108, 30.5366>, <3.0025, 0.451702, 32.8277>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <3.00365, 0.451702, 32.8263>, <4.15306, 1.22255, 35.157>, <5.42962, 2.85697, 37.0358>, <6.6426, 4.0596, 39.1405>,
      <2.74941, 0.532615, 33.1342>, <3.89882, 1.30346, 35.4649>, <5.42957, 2.85698, 37.0358>, <6.64255, 4.05961, 39.1405>,
      <2.39048, 0.361525, 33.569>, <3.68467, 1.05027, 35.688>, <5.17531, 2.93785, 37.3438>, <6.64249, 4.05958, 39.1406>,
      <2.24093, 0.69444, 33.7501>, <3.53512, 1.38318, 35.8691>, <5.17528, 2.93791, 37.3438>, <6.64246, 4.05964, 39.1407>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.24093, 0.69444, 33.7501>, <3.53512, 1.38318, 35.8691>, <5.17528, 2.93791, 37.3438>, <6.64246, 4.05964, 39.1407>,
      <2.13664, 0.926592, 33.8764>, <3.43083, 1.61534, 35.9954>, <5.17526, 2.93795, 37.3438>, <6.64244, 4.05969, 39.1407>,
      <2.4855, 1.11485, 33.4539>, <3.67943, 1.67773, 35.6228>, <5.30233, 3.14023, 37.1899>, <6.6425, 4.05972, 39.1406>,
      <2.622, 1.30129, 33.2885>, <3.81593, 1.86416, 35.4575>, <5.30235, 3.14027, 37.1899>, <6.64253, 4.05976, 39.1406>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <2.622, 1.30129, 33.2885>, <3.81593, 1.86416, 35.4575>, <5.30235, 3.14027, 37.1899>, <6.64253, 4.05976, 39.1406>,
      <2.74041, 1.46301, 33.1451>, <3.93434, 2.02589, 35.3141>, <5.30237, 3.1403, 37.1899>, <6.64255, 4.05979, 39.1405>,
      <2.84616, 1.7354, 33.017>, <3.95399, 2.21415, 35.2631>, <5.42939, 3.28503, 37.036>, <6.64257, 4.05984, 39.1405>,
      <3.00308, 1.7354, 32.827>, <4.11091, 2.21415, 35.073>, <5.42943, 3.28503, 37.036>, <6.6426, 4.05984, 39.1405>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <3.00308, 1.7354, 32.827>, <4.11091, 2.21415, 35.073>, <5.42943, 3.28503, 37.036>, <6.6426, 4.05984, 39.1405>,
      <3.16, 1.7354, 32.6369>, <4.26783, 2.21415, 34.883>, <5.42945, 3.28503, 37.036>, <6.64263, 4.05984, 39.1405>,
      <3.26575, 1.46301, 32.5089>, <4.31209, 2.0511, 34.8931>, <5.55648, 3.1403, 36.8821>, <6.64265, 4.05979, 39.1404>,
      <3.38416, 1.30129, 32.3654>, <4.4305, 1.88937, 34.7497>, <5.5565, 3.14027, 36.8821>, <6.64267, 4.05976, 39.1404>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <3.38416, 1.30129, 32.3654>, <4.4305, 1.88937, 34.7497>, <5.5565, 3.14027, 36.8821>, <6.64267, 4.05976, 39.1404>,
      <3.52065, 1.11485, 32.2001>, <4.567, 1.70293, 34.5844>, <5.55653, 3.14023, 36.8821>, <6.6427, 4.05972, 39.1404>,
      <3.86951, 0.926589, 31.7776>, <4.85413, 1.67336, 34.3211>, <5.68359, 2.93795, 36.7282>, <6.64276, 4.05969, 39.1403>,
      <3.76523, 0.69444, 31.9039>, <4.74984, 1.44121, 34.4474>, <5.68357, 2.93791, 36.7282>, <6.64274, 4.05964, 39.1403>
   }
   
   bicubic_patch {
      type 1
      u_steps 3
      v_steps 3
      <3.76523, 0.69444, 31.9039>, <4.74984, 1.44121, 34.4474>, <5.68357, 2.93791, 36.7282>, <6.64274, 4.05964, 39.1403>,
      <3.61567, 0.361527, 32.085>, <4.60029, 1.1083, 34.6286>, <5.68354, 2.93785, 36.7282>, <6.64271, 4.05958, 39.1404>,
      <3.25674, 0.532615, 32.5198>, <4.40639, 1.30342, 34.8501>, <5.42928, 2.85698, 37.0362>, <6.64265, 4.05961, 39.1404>,
      <3.0025, 0.451702, 32.8277>, <4.15215, 1.22251, 35.1581>, <5.42923, 2.85697, 37.0362>, <6.6426, 4.0596, 39.1405>
   }
}

#declare MetalSale = texture {
   bumps
   turbulence <1, 1, 1>
   
   texture_map {
      [ 0 normal {
         bumps
         0.056
         turbulence <0, 0.01, 0>
         scale 0.1
      }
      
      pigment {
         color rgb <0.509804, 0.509804, 0.509804>
      }
      
      finish {
         metallic 1
         specular 0.09
         roughness 0.1
      }
      ]
      [ 0.5 normal {
         bumps
         0.056
         turbulence <0, 0.01, 0>
         scale 0.1
      }
      
      pigment {
         color rgb <0.513725, 0.513725, 0.513725>
      }
      
      finish {
         metallic 1
         specular 0.1
         roughness 0.1
      }
      ]
   }
   scale 0.4
}

#declare Ciment = texture {
   normal {
      dents
      1
      turbulence <0.1, 0.1, 0.1>
      scale 0.1
   }
   
   pigment {
      color rgb <0.541176, 0.498039, 0.486275>
   }
   
   finish {
      roughness 0.5
      crand 0.1
   }
}

#declare UnePierre = union {
   box {
      <0.15, 0, 0>, <-0.14, 0.08, -0.08>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      <0.15, -0.01, 0>, <-0.145, 0.02, -0.08>
      scale 1
      rotate x*2
      translate <0.05, 0, -0.08>
   }
   
   texture {
      Ciment
   }
}

#declare CinqPierres = union {
   object {
      UnePierre
      scale 1
      rotate z*(-0.6)
      translate <0, 0, 0>
   }
   
   object {
      UnePierre
      scale 1
      rotate <0, 0, 0>
      translate x*0.3
   }
   
   object {
      UnePierre
      scale 1
      rotate z*0.5
      translate x*0.6
   }
   
   object {
      UnePierre
      scale 1
      rotate z*0.2
      translate x*0.9
   }
   
   object {
      UnePierre
      scale 1
      rotate z*(-1.7)
      translate x*1.2
   }
}

#declare VingtPierres = union {
   object {
      CinqPierres
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      CinqPierres
      scale 1
      rotate <0, 0, 0>
      translate x*1.2
   }
   
   object {
      CinqPierres
      scale 1
      rotate <0, 0, 0>
      translate x*2.4
   }
   
   object {
      CinqPierres
      scale 1
      rotate <0, 0, 0>
      translate x*3.6
   }
}

#declare TrouEgout = intersection {
   cylinder {
      <0, 0.002, 0>, <0, -0.032, 0>, 0.22
      scale <1, 1, 0.2>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      <-0.24, 0.002, -0.018>, <0.24, -0.032, 0.018>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
}

#declare MetalNoir = texture {
   pigment {
      color rgb <0.219608, 0.219608, 0.219608>
   }
   
   finish {
      phong 5
      phong_size 20
      roughness 0.01
   }
}

#declare BetonEgout = texture {
   pigment {
      color rgb <0.729412, 0.729412, 0.729412>
   }
   
   finish {
      crand 0.1
   }
}

#declare Goudron = texture {
   pigment {
      image_map {
         jpeg
         "/home/tom/RayTrace/Textures/asphalt2.jpg"
         map_type 0
      }
      translate z*0.5
   }
   
   finish {
      roughness 0.05
   }
}

#declare Goudron2 = texture {
   pigment {
      color rgb <0.309804, 0.309804, 0.309804>
   }
   
   finish {
      roughness 0.05
      crand 0.1
   }
}

union {
   //*PMName Rue
   
   difference {
      //*PMName Rue
      
      union {
         //*PMName Rue2
         
         cylinder {
            //*PMName Chausse
            <-5, 0, 0>, <18, 0, 0>, 4
            
            texture {
               Goudron
               scale 0.8
            }
            scale <1, 0.04, 1>
            rotate <0, 0, 0>
            translate <0, -0.1, -5>
         }
         
         box {
            <-5, 0, 0.1>, <18, -0.1, -1>
            
            texture {
               normal {
                  bumps
                  0.5
                  turbulence <0.2, 0.2, 0.2>
                  scale <2, 1, 1>
               }
               
               pigment {
                  image_map {
                     png
                     "/home/tom/RayTrace/Textures/brick043nb.png"
                     map_type 0
                  }
                  scale 0.6
                  rotate <90, 45, 0>
                  translate <0, 0, 0>
               }
               
               finish {
                  roughness 0.05
               }
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         union {
            object {
               VingtPierres
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            object {
               VingtPierres
               scale 1
               rotate <0, 0, 0>
               translate x*(-5.1)
            }
            
            object {
               VingtPierres
               scale 1
               rotate <0, 0, 0>
               translate x*5.1
            }
            
            object {
               CinqPierres
               scale 1
               rotate <0, 0, 0>
               translate x*10.2
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, -0.07, -1>
         }
      }
      
      union {
         //*PMName Dcoupe
         
         cylinder {
            <-0.28, 0, 0>, <0.28, 0, 0>, 0.06
            scale 1
            rotate <0, 0, 0>
            translate z*0.285
         }
         
         cylinder {
            <-0.28, 0, 0>, <0.28, 0, 0>, 0.06
            scale 1
            rotate <0, 0, 0>
            translate z*(-0.285)
         }
         
         cylinder {
            <0, 0, -0.285>, <0, 0, 0.285>, 0.06
            scale 1
            rotate <0, 0, 0>
            translate x*0.28
         }
         
         cylinder {
            <0, 0, -0.285>, <0, 0, 0.285>, 0.06
            scale 1
            rotate <0, 0, 0>
            translate x*(-0.28)
         }
         
         sphere {
            <0, 0, 0>, 0.06
            scale 1
            rotate <0, 0, 0>
            translate <-0.28, 0, -0.285>
         }
         
         sphere {
            <0, 0, 0>, 0.06
            scale 1
            rotate <0, 0, 0>
            translate <0.28, 0, -0.285>
         }
         
         sphere {
            <0, 0, 0>, 0.06
            scale 1
            rotate <0, 0, 0>
            translate <0.28, 0, 0.285>
         }
         
         sphere {
            <0, 0, 0>, 0.06
            scale 1
            rotate <0, 0, 0>
            translate <-0.28, 0, 0.285>
         }
         
         box {
            <-0.28, 0.05, -0.285>, <0.28, -0.5, 0.285>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         scale 0.7
         rotate y*90
         rotate x*4
         translate <-0.5, -0.0145, -1.33>
         
         texture {
            Ciment
         }
      }
   }
   
   union {
      //*PMName Egout
      
      difference {
         //*PMName Grille
         
         box {
            <-0.25, 0, -0.25>, <0.25, -0.03, 0.26>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         object {
            TrouEgout
            scale 1
            rotate <0, 0, 0>
            translate z*0.21
         }
         
         object {
            TrouEgout
            scale 1
            rotate <0, 0, 0>
            translate z*0.15
         }
         
         object {
            TrouEgout
            scale 1
            rotate <0, 0, 0>
            translate z*0.08
         }
         
         object {
            TrouEgout
            scale 1
            rotate <0, 0, 0>
            translate z*0.01
         }
         
         object {
            TrouEgout
            scale 1
            rotate <0, 0, 0>
            translate z*(-0.06)
         }
         
         object {
            TrouEgout
            scale 1
            rotate <0, 0, 0>
            translate z*(-0.13)
         }
         
         object {
            TrouEgout
            scale 1
            rotate <0, 0, 0>
            translate z*(-0.2)
         }
         translate y*(-0.01)
         
         texture {
            MetalNoir
         }
      }
      
      union {
         //*PMName Tour
         
         box {
            <-0.27, 0, -0.255>, <-0.255, -0.03, 0.265>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <0.27, 0, -0.255>, <0.255, -0.03, 0.265>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <-0.27, 0, 0.265>, <0.27, -0.03, 0.285>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <-0.27, 0, -0.255>, <0.27, -0.03, -0.275>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         translate <0, 0, 0>
         
         texture {
            MetalNoir
         }
      }
      
      union {
         //*PMName Beton
         
         box {
            <-0.28, -0.1, -0.275>, <0.28, 0, -0.285>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <-0.28, -0.1, 0.275>, <0.28, 0, 0.285>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <-0.27, -0.1, -0.275>, <-0.28, 0, 0.285>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <0.27, -0.1, -0.275>, <0.28, 0, 0.285>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            BetonEgout
         }
      }
      scale 0.7
      rotate y*90
      rotate x*4
      translate <-0.5, -0.042, -1.33>
   }
}

union {
   //*PMName Mur
   
   box {
      //*PMName Mur
      <2.5, 1.8, 0.3>, <18, 0, 0>
      
      texture {
         pigment {
            image_map {
               jpeg
               "/home/tom/RayTrace/Textures/brick065.jpg"
               map_type 0
            }
            scale <2, 1.8, 2>
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
      }
      scale 1
      rotate <0, 0, 0>
   }
   
   union {
      //*PMName Haut
      
      box {
         <2.5, 0, 0.3>, <18, 0.05, 0>
         scale 1
         rotate <0, 0, 0>
      }
      
      cylinder {
         <2.5, 0, 0>, <18, 0, 0>, 0.025
         scale 1
         rotate <0, 0, 0>
         translate y*0.025
      }
      scale 1
      rotate x*(-7.9)
      translate y*1.8
      
      texture {
         normal {
            dents
            1
            turbulence <0.1, 0.1, 0.1>
            scale 0.1
         }
         
         pigment {
            color rgb <0.541176, 0.498039, 0.486275>
         }
         
         finish {
            roughness 0.5
            crand 0.1
         }
      }
   }
   translate z*0.1
}

#declare CylPoub = cylinder {
   <-0.3, 1, 0>, <-0.3, 0, 0>, 0.1
   scale 1
   rotate z*4
   translate <0, 0, 0>
}

#declare QuartPoub = union {
   //*PMName QuartPoub
   
   object {
      CylPoub
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      CylPoub
      scale 1
      rotate y*15
      translate <0, 0, 0>
   }
   
   object {
      CylPoub
      scale 1
      rotate y*30
      translate <0, 0, 0>
   }
   
   object {
      CylPoub
      scale 1
      rotate y*45
      translate <0, 0, 0>
   }
   
   object {
      CylPoub
      scale 1
      rotate y*60
      translate <0, 0, 0>
   }
   
   object {
      CylPoub
      scale 1
      rotate y*75
      translate <0, 0, 0>
   }
}

#declare CouvCyl = cylinder {
   <-0.05, 0, 0>, <-0.444, 0, 0>, 0.075
   scale <1, 0.9, 1>
   rotate z*5.4
   translate <0, 0, 0>
}

#declare CouvercleCyl = union {
   object {
      CouvCyl
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      CouvCyl
      scale 1
      rotate y*15
      translate <0, 0, 0>
   }
   
   object {
      CouvCyl
      scale 1
      rotate y*15
      translate <0, 0, 0>
   }
   
   object {
      CouvCyl
      scale 1
      rotate y*30
      translate <0, 0, 0>
   }
   
   object {
      CouvCyl
      scale 1
      rotate y*45
      translate <0, 0, 0>
   }
   
   object {
      CouvCyl
      scale 1
      rotate y*60
      translate <0, 0, 0>
   }
   
   object {
      CouvCyl
      scale 1
      rotate y*75
      translate <0, 0, 0>
   }
}

union {
   //*PMName Poubelle
   
   difference {
      //*PMName Corps
      
      union {
         object {
            QuartPoub
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         object {
            QuartPoub
            scale 1
            rotate y*90
            translate <0, 0, 0>
         }
         
         object {
            QuartPoub
            scale 1
            rotate y*180
            translate <0, 0, 0>
         }
         
         object {
            QuartPoub
            scale 1
            rotate y*270
            translate <0, 0, 0>
         }
      }
      
      cone {
         <0, 0.03, 0>, 0.35,
         <0, 0.99, 0>, 0.42
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      translate <0, 0, 0>
   }
   
   difference {
      //*PMName Couvercle
      
      union {
         //*PMName Couvercle
         
         torus {
            0.47, 0.02
            scale <1, 0.5, 1>
            rotate <0, 0, 0>
            translate y*0.98
         }
         
         cone {
            <0, 1.02, 0>, 0.45,
            <0, 0.98, 0>, 0.48
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         object {
            CouvercleCyl
            scale 1
            rotate <0, 0, 0>
            translate y*1
         }
         
         object {
            CouvercleCyl
            scale 1
            rotate y*90
            translate y*1
         }
         
         object {
            CouvercleCyl
            scale 1
            rotate y*180
            translate y*1
         }
         
         object {
            CouvercleCyl
            scale 1
            rotate y*270
            translate y*1
         }
         
         sphere {
            <0, 1.05, 0>, 0.05
            scale <1, 0.4, 1>
            rotate <0, 0, 0>
            translate y*0.62601
         }
         
         torus {
            0.11, 0.02
            scale <1, 1, 0.5>
            rotate x*90
            translate y*1.05
         }
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0.97, 0>, <0, 0.86, 0>, 0.5
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      rotate <0, 0, -0>
      translate <0, 0, 0>
   }
   
   texture {
      agate
      agate_turb 1.5
      turbulence <1, 1, 1>
      
      texture_map {
         [ 0 normal {
            bumps
            0.056
            turbulence <0, 0.01, 0>
            scale 0.1
         }
         
         pigment {
            color rgb <0.419608, 0.419608, 0.419608>
         }
         
         finish {
            phong 1.95
            phong_size 10
         }
         ]
         [ 0.5 normal {
            bumps
            0.056
            turbulence <0, 0.01, 0>
            scale 0.1
         }
         
         pigment {
            color rgb <0.423529, 0.423529, 0.423529>
         }
         
         finish {
            phong 2
            phong_size 10
         }
         ]
      }
      scale 0.4
   }
   scale 0.8
   translate <-3.84, 0, -0.5>
}

#declare MetalBrillant = texture {
   pigment {
      color rgb <0.368627, 0.368627, 0.368627>
   }
   
   finish {
      brilliance 0.5
      phong 20
      phong_size 30
      roughness 0.05
      reflection rgb <0.494118, 0.494118, 0.494118>
   }
}

#declare BoisBlanc = texture {
   pigment {
      color rgb <0.501961, 0.266667, 0.270588>
   }
   
   normal {
      bump_map {
         jpeg
         "/home/tom/RayTrace/Textures/murpeint.jpg"
         map_type 0
         use_index
         bump_size 1
      }
   }
   
   finish {
      phong 5
      phong_size 20
      roughness 0.05
   }
}

#declare BriqueTex = texture {
   pigment {
      image_map {
         jpeg
         "/home/tom/RayTrace/Textures/brick015.jpg"
         map_type 0
         interpolate 4
      }
   }
   
   normal {
      bump_map {
         jpeg
         "/home/tom/RayTrace/Textures/brick015.jpg"
         map_type 0
      }
      bump_size 1.1
   }
   scale 0.4
}

#declare Verre = material {
   interior {
      ior 0.9
      caustics 0.9
   }
   
   texture {
      pigment {
         color rgbf <1, 1, 1, 0.95>
      }
      
      finish {
         phong 1
         phong_size 40
         reflection rgb <0.027451, 0.027451, 0.027451>
      }
   }
}

#declare UneBrique = box {
   //*PMName vbrique
   <0.1125, -0.055, 0.1>, <-0.1125, 0.055, -0.1>
   
   texture {
      BriqueTex
      translate <-0.1, 0.06, 0>
   }
   scale 1
   rotate <0, 0, 0>
   translate <0, 0, 0>
}

#declare volet = union {
   //*PMName Volet
   
   cylinder {
      <-0.5, 0, 0>, <0.5, 0, 0>, 0.02
      scale <1, 0.9, 0.2>
      rotate <0, 0, 0>
      translate y*0.002
   }
   
   box {
      <-0.5, -0.002, -0.0005>, <0.5, 0.002, 0.0005>
      
      pigment {
         image_map {
            png
            "/home/tom/RayTrace/Textures/volet.png"
            map_type 0
         }
         scale <0.015, 0.003, 1>
         translate y*0.0015
      }
      scale <1, 1.4, 1>
      rotate <0, 0, 0>
      translate y*(-0.019)
   }
}

#declare volet2 = union {
   //*PMName Volet
   
   cylinder {
      <-0.5, 0, 0>, <0.5, 0, 0>, 0.02
      scale <1, 1, 0.2>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      <-0.5, -0.002, -0.0005>, <0.5, 0.002, 0.0005>
      
      pigment {
         image_map {
            png
            "/home/tom/RayTrace/Textures/volet.png"
            map_type 0
         }
         scale <0.015, 0.003, 1>
         translate y*0.0015
      }
      scale 1
      rotate <0, 0, 0>
      translate y*(-0.021)
   }
}

#declare persienne = union {
   object {
      volet
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      volet
      scale 1
      rotate <0, 0, 0>
      translate y*0.042
   }
   
   object {
      volet
      scale 1
      rotate <0, 0, 0>
      translate y*0.084
   }
   
   object {
      volet
      scale 1
      rotate <0, 0, 0>
      translate y*0.126
   }
   
   object {
      volet
      scale 1
      rotate <0, 0, 0>
      translate y*0.168
   }
   translate z*(-0.11)
}

#declare persienne2 = union {
   object {
      volet2
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      volet2
      scale 1
      rotate <0, 0, 0>
      translate y*0.042
   }
   
   object {
      volet2
      scale 1
      rotate <0, 0, 0>
      translate y*0.084
   }
   
   object {
      volet2
      scale 1
      rotate <0, 0, 0>
      translate y*0.126
   }
   
   object {
      volet2
      scale 1
      rotate <0, 0, 0>
      translate y*0.168
   }
   translate z*(-0.11)
}

#declare DecoFen = union {
   union {
      union {
         //*PMName DecoFenetreGauche
         
         object {
            //*PMName B2
            UneBrique
            scale 1
            rotate z*92
            translate <-0.1, -0.005, 0>
         }
         
         object {
            //*PMName B3
            UneBrique
            scale 1
            rotate z*94
            translate <-0.2, -0.01, 0>
         }
         
         object {
            //*PMName B4
            UneBrique
            scale 1
            rotate z*96
            translate <-0.3, -0.015, 0>
         }
         
         object {
            //*PMName B5
            UneBrique
            scale 1
            rotate z*98
            translate <-0.4, -0.025, 0>
         }
         
         object {
            //*PMName B6
            UneBrique
            scale 1
            rotate z*100
            translate <-0.5, -0.04, 0>
         }
      }
      
      union {
         //*PMName DecoFenetreDroit
         
         object {
            //*PMName B1
            UneBrique
            scale 1
            rotate z*90
            translate <0, 0, 0>
         }
         
         object {
            //*PMName B2
            UneBrique
            scale 1
            rotate z*88
            translate <0.1, -0.005, 0>
         }
         
         object {
            //*PMName B3
            UneBrique
            scale 1
            rotate z*86
            translate <0.2, -0.01, 0>
         }
         
         object {
            //*PMName B4
            UneBrique
            scale 1
            rotate z*84
            translate <0.3, -0.015, 0>
         }
         
         object {
            //*PMName B5
            UneBrique
            scale 1
            rotate z*82
            translate <0.4, -0.025, 0>
         }
         
         object {
            //*PMName B6
            UneBrique
            scale 1
            rotate z*80
            translate <0.5, -0.04, 0>
         }
      }
      translate z*0.08
   }
   
   union {
      //*PMName Volet
      
      box {
         //*PMName CacheHaut
         <-0.5, 1.63, -0.12>, <0.5, 1.505, -0.13>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      union {
         object {
            persienne
            scale 1
            rotate <0, 0, 0>
            translate y*1.32
         }
         
         object {
            persienne
            scale 1
            rotate <0, 0, 0>
            translate y*1.11
         }
         
         object {
            persienne
            scale 1
            rotate <0, 0, 0>
            translate y*0.9
         }
         
         object {
            persienne
            scale 1
            rotate <0, 0, 0>
            translate y*0.69
         }
         
         object {
            persienne
            scale 1
            rotate <0, 0, 0>
            translate y*0.48
         }
         
         object {
            persienne
            scale 1
            rotate <0, 0, 0>
            translate y*0.27
         }
         scale <1, 1.2, 1>
         translate y*(-0.1)
      }
      
      box {
         //*PMName CacheBas
         <-0.5, 0, -0.105>, <0.5, 0.03, -0.115>
         scale 1
         rotate <0, 0, 0>
         translate y*0.22
      }
      
      box {
         //*PMName GlissireG
         <-0.5, 0.22, -0.115>, <-0.48, 1.6, -0.119>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         //*PMName GlissireD
         <0.5, 0.22, -0.115>, <0.48, 1.6, -0.119>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         //*PMName DecoBriqueD
         <0.5, 1.6, -0.17>, <0.49999, 0.2, -0.1>
         
         texture {
            BriqueTex
            rotate y*90
         }
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         //*PMName DecoBriqueG
         <-0.5, 1.6, -0.17>, <-0.49999, 0.2, -0.1>
         
         texture {
            BriqueTex
            rotate y*90
         }
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      texture {
         pigment {
            color rgb <0.603922, 0.603922, 0.603922>
         }
      }
      translate <0, -1.721, 0.17>
   }
}

#declare Tuile = union {
   box {
      <0, 0, -0.01>, <0.15, -0.25, 0.005>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      <0, 0, 0>, <0, -0.25, 0>, 0.015
      scale 1
      rotate <0, 0, 0>
      translate <0.135, 0, -0.01>
   }
   rotate x*47
}

#declare Tuiles = union {
   //*PMName Tuiles4
   
   object {
      Tuile
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Tuile
      scale 1
      rotate <0, 0, 0>
      translate <0, 0.15, 0.14>
   }
   
   object {
      Tuile
      scale 1
      rotate <0, 0, 0>
      translate <0, 0.3, 0.28>
   }
   
   object {
      Tuile
      scale 1
      rotate <0, 0, 0>
      translate <0, 0.45, 0.42>
   }
}

#declare AttacheGout = union {
   cylinder {
      <0, 0.02, 0>, <0, 0, 0>, 0.056
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      <0.075, 0, 0.07>, <-0.075, 0.02, 0.056>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   difference {
      sphere {
         <0, 0, 0.058>, 0.006
         scale 1
         rotate <0, 0, 0>
      }
      
      box {
         <0.01, -0.001, 0>, <-0.01, 0.001, 0.005>
         scale 1
         rotate <0, 0, 0>
         translate z*0.05
      }
      
      box {
         <0.01, -0.001, 0>, <-0.01, 0.001, 0.005>
         scale 1
         rotate z*90
         translate z*0.05
      }
      translate <-0.065, 0.01, 0>
   }
}

#declare CadreVitrine = union {
   //*PMName CadreVitrine
   
   union {
      //*PMName Briques
      
      box {
         <-1.5, 0, -0.1>, <1.5, 0.001, -0.2>
         
         texture {
            BriqueTex
            rotate x*90
         }
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         <-1.5, 0, -0.1>, <1.5, -0.001, -0.2>
         
         texture {
            BriqueTex
            rotate x*90
         }
         scale 1
         rotate <0, 0, 0>
         translate y*1.9
      }
      
      box {
         <-1.5, -0.95, -0.1>, <-1.499, 0.95, -0.2>
         
         texture {
            BriqueTex
            rotate y*90
            translate y*(-1.45)
         }
         scale 1
         rotate <0, 0, 0>
         translate y*0.95
      }
      
      box {
         <1.5, -0.95, -0.1>, <1.499, 0.95, -0.2>
         
         texture {
            BriqueTex
            rotate y*90
            translate y*(-1.45)
         }
         scale 1
         rotate <0, 0, 0>
         translate y*0.95
      }
   }
   
   difference {
      //*PMName Bas
      
      box {
         <-1.5, 0, 0>, <1.5, 0.05, -0.1>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         <-1.501, -0.2, 0>, <1.501, -0.14, -0.06>
         scale 1
         rotate x*30
         translate y*0.173
      }
   }
   
   difference {
      //*PMName Haut
      
      box {
         <-1.5, 0, 0>, <1.5, 0.05, -0.1>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         <-1.501, -0.2, 0>, <1.501, -0.14, -0.06>
         scale 1
         rotate x*30
         translate y*0.173
      }
      rotate z*180
      translate y*1.9
   }
   
   difference {
      //*PMName Gauche
      
      box {
         <-0.95, 0, 0>, <0.95, 0.05, -0.1>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         <-0.951, -0.2, 0>, <0.951, -0.14, -0.06>
         scale 1
         rotate x*30
         translate y*0.173
      }
      rotate z*(-90)
      translate <-1.5, 0.95, 0>
   }
   
   difference {
      //*PMName Droite
      
      box {
         <-0.95, 0, 0>, <0.95, 0.05, -0.1>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         <-0.951, -0.2, 0>, <0.951, -0.14, -0.06>
         scale 1
         rotate x*30
         translate y*0.173
      }
      rotate z*90
      translate <1.5, 0.95, 0>
   }
   
   box {
      //*PMName Vitre
      <1.5, 1.9, -0.02>, <-1.5, 0, -0.05>
      
      material {
         Verre
      }
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   texture {
      pigment {
         color rgb <0.388235, 0.203922, 0.207843>
      }
      
      finish {
         phong 5
         phong_size 20
         roughness 0.09
      }
   }
}

#declare Hetre = texture {
   pigment {
      image_map {
         jpeg
         "/home/tom/RayTrace/Textures/wood057.jpg"
         map_type 0
      }
      scale 0.4
      translate <0, 0, 0>
   }
}

#declare Moquette = texture {
   pigment {
      color rgb <0.305882, 0.360784, 0.0784314>
   }
}

#declare VBois = texture {
   pigment {
      image_map {
         jpeg
         "/home/tom/RayTrace/Textures/wood_old.jpg"
         map_type 0
      }
   }
   scale 0.4
}

#declare Cloison = intersection {
   //*PMName Cloison
   
   box {
      <0, 0, 0.5>, <0.03, 0.8, 0>
      scale 1
      rotate x*38.2
      translate <0, 0, 0>
   }
   
   box {
      <-0.0001, 0.6, 0.5>, <0.0301, 0, 0>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   texture {
      Hetre
      rotate y*90
      rotate x*90
   }
}

#declare Cuivre = texture {
   pigment {
      color rgb <0.584314, 0.427451, 0.356863>
   }
   
   finish {
      phong 20
      phong_size 40
      reflection rgb <0.133333, 0.133333, 0.133333>
   }
}

#declare Halogene = union {
   //*PMName Lampe
   
   union {
      //*PMName Contacts
      
      cylinder {
         <0, 0, -0.005>, <0, 0, 0.005>, 0.0025
         scale 1
         rotate <0, 0, 0>
         translate z*(-0.001)
      }
      
      cylinder {
         <0, 0, -0.005>, <0, 0, 0.005>, 0.0025
         scale 1
         rotate x*180
         translate z*0.069
      }
      
      texture {
         MetalBrillant
      }
   }
   
   union {
      //*PMName Fils
      
      union {
         //*PMName Avant
         
         cylinder {
            <0, 0.05, 0>, <0, -0.2, 0>, 0.0015
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         sphere {
            <0, 0, 0>, 0.0015
            scale 1
            rotate <0, 0, 0>
            translate y*(-0.2)
         }
         
         cylinder {
            <0, -0.2, 0>, <0, -0.25, 0.035>, 0.0015
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         sphere {
            <0, 0, 0>, 0.0015
            scale 1
            rotate <0, 0, 0>
            translate <0, -0.25, 0.035>
         }
         
         cylinder {
            <0, -0.25, 0.035>, <0, -0.275, 0.035>, 0.0015
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
      }
      
      union {
         //*PMName Arrire
         
         cylinder {
            <0, 0.05, 0>, <0, -0.2, 0>, 0.0015
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         sphere {
            <0, 0, 0>, 0.0015
            scale 1
            rotate <0, 0, 0>
            translate y*(-0.2)
         }
         
         cylinder {
            <0, -0.2, 0>, <0, -0.25, -0.035>, 0.0015
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         sphere {
            <0, 0, 0>, 0.0015
            scale 1
            rotate <0, 0, 0>
            translate <0, -0.25, -0.035>
         }
         
         cylinder {
            <0, -0.25, -0.035>, <0, -0.275, -0.035>, 0.0015
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         translate <-0.02, 0, 0.07>
      }
      
      union {
         //*PMName Plastique
         
         cylinder {
            <0, 0.0055, 0>, <0, -0.0055, 0>, 0.002
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <0, 0.0055, 0>, <0, -0.0055, 0>, 0.002
            scale 1
            rotate <0, 0, 0>
            translate x*(-0.02)
         }
         
         box {
            <-0.02, 0.004, -0.0005>, <0, -0.004, 0.0005>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         translate <0, -0.26, 0.035>
         
         texture {
            pigment {
               color rgbf <0.91373, 0.91373, 0.91373, 0.8>
            }
         }
      }
      
      texture {
         Cuivre
      }
      translate z*(-0.004)
   }
   
   union {
      //*PMName Ampoule
      
      box {
         <-0.0185, 0.003, 0.002>, <-0.0015, -0.02, -0.002>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <-0.023, 0, 0>, <-0.0185, 0, 0>, 0.003
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <-0.023, 0, 0>, <-0.0185, 0, 0>, 0.003
         scale 1
         rotate <0, 0, 0>
         translate x*0.0215
      }
      
      cone {
         <0, 0, 0>, 0.001,
         <0, -0.045, 0>, 0.035
         open
         
         texture {
            pigment {
               color rgbft <0.8902, 0.8902, 0.8902, 0.1, 0.1>
            }
            
            finish {
               phong 2
               phong_size 10
               reflection rgb <0.462745, 0.462745, 0.462745>
            }
         }
         scale 1
         rotate <0, 0, 0>
         translate <-0.01, -0.015, 0>
         hollow
      }
      
      light_source {
         <0, 0, 0>, rgb <0.454902, 0.443137, 0.4>
         fade_distance 1.5
         fade_power 100
         translate <-0.01, -0.03, 0>
      }
      rotate x*(-5.5)
      translate <0, -0.272, 0.031>
      
      texture {
         MetalBrillant
      }
   }
}

#declare Livre = union {
   //*PMName Livre
   
   difference {
      box {
         //*PMName Livre
         <0, 0.25, 0>, <0.05, 0, -0.2>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0.251, 0>, <0, -0.001, 0>, 0.026
         scale <1, 1, 0.5>
         rotate <0, 0, 0>
         translate <0.025, 0, -0.2>
      }
   }
   translate <-0.65, 0.05, -0.17>
   
   pigment {
      color rgb <1, 1, 1>
   }
}

#declare Etage = union {
   //*PMName Trans
   
   object {
      Livre
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Livre
      scale 1
      rotate <0, 0, 0>
      translate x*0.05
   }
   
   object {
      Livre
      scale 1
      rotate <0, 0, 0>
      translate x*0.1
   }
   
   object {
      Livre
      scale 1
      rotate <0, 0, 0>
      translate x*0.15
   }
   
   object {
      Livre
      scale 1
      rotate <0, 0, 0>
      translate x*0.2
   }
   
   object {
      Livre
      scale 1
      rotate <0, 0, 0>
      translate x*0.25
   }
   
   object {
      Livre
      scale 1
      rotate <0, 0, 0>
      translate x*0.3
   }
   
   object {
      Livre
      scale 1
      rotate <0, 0, 0>
      translate x*0.35
   }
   
   object {
      Livre
      scale 1
      rotate <0, 0, 0>
      translate x*0.4
   }
   
   object {
      Livre
      scale 1
      rotate <0, 0, 0>
      translate x*0.45
   }
   
   object {
      Livre
      scale 1
      rotate <0, 0, 0>
      translate x*0.5
   }
   
   object {
      Livre
      scale 1
      rotate <0, 0, 0>
      translate x*0.55
   }
   
   object {
      Livre
      scale 1
      rotate <0, 0, 0>
      translate x*0.6
   }
   
   object {
      Livre
      scale 1
      rotate <0, 0, 0>
      translate x*0.65
   }
   
   object {
      Livre
      scale 1
      rotate <0, 0, 0>
      translate x*0.7
   }
   
   object {
      Livre
      scale 1
      rotate <0, 0, 0>
      translate x*0.75
   }
   
   object {
      Livre
      scale 1
      rotate <0, 0, 0>
      translate x*0.8
   }
   
   object {
      Livre
      scale 1
      rotate <0, 0, 0>
      translate x*0.85
   }
   
   object {
      Livre
      scale 1
      rotate <0, 0, 0>
      translate x*0.9
   }
   
   object {
      Livre
      scale 1
      rotate <0, 0, 0>
      translate x*0.95
   }
   
   object {
      Livre
      scale 1
      rotate <0, 0, 0>
      translate x*1
   }
   
   object {
      Livre
      scale 1
      rotate <0, 0, 0>
      translate x*1.05
   }
   
   object {
      Livre
      scale 1
      rotate <0, 0, 0>
      translate x*1.1
   }
   
   object {
      Livre
      scale 1
      rotate <0, 0, 0>
      translate x*1.15
   }
   
   object {
      Livre
      scale 1
      rotate <0, 0, 0>
      translate x*1.2
   }
   
   object {
      Livre
      scale 1
      rotate <0, 0, 0>
      translate x*1.25
   }
   
   box {
      <-0.68, 0.035, -0.4>, <-0.65, 0, -0.1>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      <0.68, 0.035, -0.4>, <0.65, 0, -0.1>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      <0.67, 0.0351, -0.41>, <-0.67, 0.05, -0.11>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
      
      texture {
         Moquette
      }
   }
   
   sphere {
      <-0.67, 0.042, -0.432>, 0.009
      
      texture {
         MetalSale
      }
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   sphere {
      <0.67, 0.042, -0.432>, 0.009
      
      texture {
         MetalSale
      }
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   texture {
      Hetre
   }
}

union {
   //*PMName Goutire
   
   union {
      //*PMName Base
      
      box {
         <-0.09, 0.03, -0.07>, <0.09, 0.005, 0.07>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0.03, 0>, <0, 0.005, 0>, 0.09
         scale 1
         rotate <0, 0, 0>
         translate z*(-0.07)
      }
      
      texture {
         MetalNoir
      }
   }
   
   union {
      //*PMName BaseTex
      
      box {
         <-0.09, 0.03, -0.07>, <0.09, 0.0299, 0.07>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0.03, 0>, <0, 0.0299, 0>, 0.09
         scale 1
         rotate <0, 0, 0>
         translate z*(-0.07)
      }
      
      texture {
         pigment {
            color rgb <0.219608, 0.219608, 0.219608>
         }
         
         normal {
            bump_map {
               jpeg
               "/home/tom/RayTrace/Textures/metal012.jpg"
               map_type 0
            }
            scale <1, 0.67, 1>
            rotate x*90
            translate <0, 0, 0>
            bump_size 5
         }
         
         finish {
            phong 5
            phong_size 40
            roughness 0.01
         }
      }
   }
   
   union {
      //*PMName BaseBeton
      
      box {
         <-0.09, 0.005, -0.07>, <0.09, 0, 0.07>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0.005, 0>, <0, 0, 0>, 0.09
         scale 1
         rotate <0, 0, 0>
         translate z*(-0.07)
      }
      translate <0, 0, 0>
      
      texture {
         Ciment
      }
   }
   
   object {
      AttacheGout
      scale 1
      rotate <0, 0, 0>
      translate y*1.5
   }
   
   object {
      AttacheGout
      scale 1
      rotate <0, 0, 0>
      translate y*3
   }
   
   cylinder {
      <0, 5, 0>, <0, 0, 0>, 0.05
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cone {
      <0, 0.04, 0>, 0.05,
      <0, 0.03, 0>, 0.06
      
      texture {
         Ciment
      }
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   texture {
      MetalSale
   }
   translate <-2.57, 0, 0.04>
}

union {
   //*PMName Immeuble1
   
   union {
      //*PMName Etagere
      
      union {
         //*PMName Montants
         
         box {
            <-0.7, 2.2, -0.435>, <-0.65, 0, -0.1>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <0.7, 2.2, -0.435>, <0.65, 0, -0.1>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            Hetre
         }
         rotate <0, 0, 0>
      }
      
      union {
         //*PMName Etages
         
         object {
            //*PMName Etage
            Etage
            scale 1
            rotate <0, 0, 0>
            translate y*0.05
         }
         
         object {
            Etage
            scale 1
            rotate <0, 0, 0>
            translate y*0.35
         }
         
         object {
            Etage
            scale 1
            rotate <0, 0, 0>
            translate y*0.65
         }
         
         object {
            Etage
            scale 1
            rotate <0, 0, 0>
            translate y*0.95
         }
         
         object {
            Etage
            scale 1
            rotate <0, 0, 0>
            translate y*1.25
         }
         
         object {
            Etage
            scale 1
            rotate <0, 0, 0>
            translate y*1.55
         }
         
         object {
            Etage
            scale 1
            rotate <0, 0, 0>
            translate y*1.85
         }
      }
      scale 1
      rotate y*90
      translate <2.47, 0, 1.8>
   }
   
   union {
      //*PMName Prsentoir
      
      union {
         //*PMName Affiche
         
         bicubic_patch {
            type 0
            u_steps 3
            v_steps 3
            <-3, 0, -3>, <-1, 0, -3>, <1, 0, -3>, <3, 0, -3>,
            <-3, 0, -1>, <-1, 0, -1>, <1, 0, -1>, <3, 0, -1>,
            <-3, 0, 1>, <-1, 0, 1>, <1, 0, 1>, <3, 0, 1>,
            <-3, 0, 3>, <-1, 0, 3>, <1, 0, 3>, <2.65608, -0.0754997, 2.71424>
            scale <0.167, 1, 0.25>
            rotate x*90
            translate <0.5, -0.75, 0>
            
            texture {
               pigment {
                  image_map {
                     png
                     "/home/tom/RayTrace/Textures/affiche2.png"
                     map_type 0
                  }
                  scale <1, 1.5, 1>
                  rotate y*180
               }
               
               finish {
                  specular 0.5
                  roughness 0.01
               }
            }
         }
         
         union {
            //*PMName Scotch
            
            box {
               <0, 0, -0.001>, <0.2, -0.065, 0>
               scale 1
               rotate z*(-43.8)
               translate <0.93125, 0.070833, 0.0001>
            }
            
            box {
               <0, 0, -0.001>, <-0.23, -0.065, 0>
               scale 1
               rotate z*43.8
               translate <0.0520833, 0.0812497, 0.0001>
            }
            
            box {
               <0, 0, -0.001>, <-0.22, -0.065, 0>
               scale 1
               rotate z*140.8
               translate <-0.0789436, -1.43922, 0.0001>
            }
            
            material {
               interior {
                  ior 0.9
                  caustics 0.9
               }
               
               texture {
                  pigment {
                     color rgbf <0.79608, 0.79608, 0.79608, 0.87>
                  }
                  
                  finish {
                     phong 1
                     phong_size 40
                     reflection rgb <0.027451, 0.027451, 0.027451>
                  }
               }
            }
         }
         scale 0.4
         rotate y*180
         translate <1.35, 1.0632, 0.001>
      }
      
      union {
         //*PMName Livre0
         
         difference {
            //*PMName Couv
            
            union {
               box {
                  //*PMName Couv
                  <0, 0, 0.2>, <1, -1.45, 0>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, -1.45, 0>, 0.11
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
            
            union {
               box {
                  //*PMName Couv
                  <0, 0.01, 0.185>, <1.01, -1.46, 0.015>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0.01, 0>, <0, -1.46, 0>, 0.095
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
         }
         
         union {
            //*PMName Pages
            
            box {
               //*PMName Pages
               <0, -0.03, 0.18>, <0.98, -1.42, 0.02>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, -0.03, 0>, <0, -1.42, 0>, 0.09
               scale 1
               rotate <0, 0, 0>
               translate z*0.1
            }
            
            pigment {
               color rgb <1, 1, 1>
            }
         }
         
         box {
            //*PMName PremCouv
            <0, 0, 0>, <1, -1.45, -0.001>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            pigment {
               image_map {
                  png
                  "/home/tom/RayTrace/Textures/Couverture0.png"
                  map_type 0
               }
               scale <1.2, 1.44, 1>
               rotate <0, 0, 0>
               translate x*(-0.22)
            }
            
            finish {
               phong 4
               phong_size 18
            }
         }
         scale <0.25, 0.24, 0.14>
         rotate x*22.4
         translate <-1.17, 0.35043, 0.19905>
      }
      
      union {
         //*PMName Livre
         
         difference {
            //*PMName Couv
            
            union {
               box {
                  //*PMName Couv
                  <0, 0, 0.2>, <1, -1.45, 0>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, -1.45, 0>, 0.11
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
            
            union {
               box {
                  //*PMName Couv
                  <0, 0.01, 0.185>, <1.01, -1.46, 0.015>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0.01, 0>, <0, -1.46, 0>, 0.095
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
         }
         
         union {
            //*PMName Pages
            
            box {
               //*PMName Pages
               <0, -0.03, 0.18>, <0.98, -1.42, 0.02>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, -0.03, 0>, <0, -1.42, 0>, 0.09
               scale 1
               rotate <0, 0, 0>
               translate z*0.1
            }
            
            pigment {
               color rgb <1, 1, 1>
            }
         }
         
         box {
            //*PMName PremCouv
            <0, 0, 0>, <1, -1.45, -0.001>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            pigment {
               image_map {
                  png
                  "/home/tom/RayTrace/Textures/Couverture1.png"
                  map_type 0
               }
               scale <1.2, 1.44, 1>
               rotate <0, 0, 0>
               translate x*(-0.22)
            }
            
            finish {
               phong 4
               phong_size 18
            }
         }
         scale <0.25, 0.25, 0.1>
         rotate x*22.4
         translate <-0.82, 0.36041, 0.2032>
      }
      
      union {
         //*PMName Livre2
         
         difference {
            //*PMName Couv
            
            union {
               box {
                  //*PMName Couv
                  <0, 0, 0.2>, <1, -1.45, 0>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, -1.45, 0>, 0.11
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
            
            union {
               box {
                  //*PMName Couv
                  <0, 0.01, 0.185>, <1.01, -1.46, 0.015>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0.01, 0>, <0, -1.46, 0>, 0.095
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
         }
         
         union {
            //*PMName Pages
            
            box {
               //*PMName Pages
               <0, -0.03, 0.18>, <0.98, -1.42, 0.02>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, -0.03, 0>, <0, -1.42, 0>, 0.09
               scale 1
               rotate <0, 0, 0>
               translate z*0.1
            }
            
            pigment {
               color rgb <1, 1, 1>
            }
         }
         
         box {
            //*PMName PremCouv
            <0, 0, 0>, <1, -1.45, -0.001>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            pigment {
               image_map {
                  png
                  "/home/tom/RayTrace/Textures/Couverture2.png"
                  map_type 0
               }
               scale <1.2, 1.44, 1>
               rotate <0, 0, 0>
               translate x*(-0.22)
            }
            
            finish {
               phong 4
               phong_size 18
            }
         }
         scale <0.23, 0.23, 0.15>
         rotate x*23.4
         translate <-0.48, 0.33354, 0.18772>
      }
      
      union {
         //*PMName Livre3
         
         difference {
            //*PMName Couv
            
            union {
               box {
                  //*PMName Couv
                  <0, 0, 0.2>, <1, -1.45, 0>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, -1.45, 0>, 0.11
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
            
            union {
               box {
                  //*PMName Couv
                  <0, 0.01, 0.185>, <1.01, -1.46, 0.015>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0.01, 0>, <0, -1.46, 0>, 0.095
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
         }
         
         union {
            //*PMName Pages
            
            box {
               //*PMName Pages
               <0, -0.03, 0.18>, <0.98, -1.42, 0.02>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, -0.03, 0>, <0, -1.42, 0>, 0.09
               scale 1
               rotate <0, 0, 0>
               translate z*0.1
            }
            
            pigment {
               color rgb <1, 1, 1>
            }
         }
         
         box {
            //*PMName PremCouv
            <0, 0, 0>, <1, -1.45, -0.001>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            pigment {
               image_map {
                  png
                  "/home/tom/RayTrace/Textures/Couverture3.png"
                  map_type 0
               }
               scale <1.2, 1.44, 1>
               rotate <0, 0, 0>
               translate x*(-0.22)
            }
            
            finish {
               phong 4
               phong_size 18
            }
         }
         scale <0.24, 0.24, 0.11>
         rotate x*19.8
         translate <-0.15, 0.35349, 0.20042>
      }
      
      union {
         //*PMName Livre4
         
         difference {
            //*PMName Couv
            
            union {
               box {
                  //*PMName Couv
                  <0, 0, 0.2>, <1, -1.45, 0>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, -1.45, 0>, 0.11
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
            
            union {
               box {
                  //*PMName Couv
                  <0, 0.01, 0.185>, <1.01, -1.46, 0.015>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0.01, 0>, <0, -1.46, 0>, 0.095
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
         }
         
         union {
            //*PMName Pages
            
            box {
               //*PMName Pages
               <0, -0.03, 0.18>, <0.98, -1.42, 0.02>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, -0.03, 0>, <0, -1.42, 0>, 0.09
               scale 1
               rotate <0, 0, 0>
               translate z*0.1
            }
            
            pigment {
               color rgb <1, 1, 1>
            }
         }
         
         box {
            //*PMName PremCouv
            <0, 0, 0>, <1, -1.45, -0.001>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            pigment {
               image_map {
                  png
                  "/home/tom/RayTrace/Textures/Couverture4.png"
                  map_type 0
               }
               scale <1.2, 1.44, 1>
               rotate <0, 0, 0>
               translate x*(-0.22)
            }
            
            finish {
               phong 4
               phong_size 18
            }
         }
         scale <0.25, 0.24, 0.14>
         rotate x*22.4
         translate <0.18, 0.35043, 0.19905>
      }
      
      union {
         //*PMName Livre5
         
         difference {
            //*PMName Couv
            
            union {
               box {
                  //*PMName Couv
                  <0, 0, 0.2>, <1, -1.45, 0>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, -1.45, 0>, 0.11
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
            
            union {
               box {
                  //*PMName Couv
                  <0, 0.01, 0.185>, <1.01, -1.46, 0.015>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0.01, 0>, <0, -1.46, 0>, 0.095
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
         }
         
         union {
            //*PMName Pages
            
            box {
               //*PMName Pages
               <0, -0.03, 0.18>, <0.98, -1.42, 0.02>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, -0.03, 0>, <0, -1.42, 0>, 0.09
               scale 1
               rotate <0, 0, 0>
               translate z*0.1
            }
            
            pigment {
               color rgb <1, 1, 1>
            }
         }
         
         box {
            //*PMName PremCouv
            <0, 0, 0>, <1, -1.45, -0.001>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            pigment {
               image_map {
                  png
                  "/home/tom/RayTrace/Textures/Couverture5.png"
                  map_type 0
               }
               scale <1.2, 1.44, 1>
               rotate <0, 0, 0>
               translate x*(-0.22)
            }
            
            finish {
               phong 4
               phong_size 18
            }
         }
         scale <0.23, 0.21, 0.14>
         rotate x*25.9
         translate <0.5, 0.30205, 0.1823>
      }
      
      union {
         //*PMName Livre6
         
         difference {
            //*PMName Couv
            
            union {
               box {
                  //*PMName Couv
                  <0, 0, 0.2>, <1, -1.45, 0>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, -1.45, 0>, 0.11
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
            
            union {
               box {
                  //*PMName Couv
                  <0, 0.01, 0.185>, <1.01, -1.46, 0.015>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0.01, 0>, <0, -1.46, 0>, 0.095
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
         }
         
         union {
            //*PMName Pages
            
            box {
               //*PMName Pages
               <0, -0.03, 0.18>, <0.98, -1.42, 0.02>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, -0.03, 0>, <0, -1.42, 0>, 0.09
               scale 1
               rotate <0, 0, 0>
               translate z*0.1
            }
            
            pigment {
               color rgb <1, 1, 1>
            }
         }
         
         box {
            //*PMName PremCouv
            <0, 0, 0>, <1, -1.45, -0.001>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            pigment {
               image_map {
                  png
                  "/home/tom/RayTrace/Textures/Couverture6.png"
                  map_type 0
               }
               scale <1.2, 1.44, 1>
               rotate <0, 0, 0>
               translate x*(-0.22)
            }
            
            finish {
               phong 4
               phong_size 18
            }
         }
         scale <0.24, 0.23, 0.12>
         rotate x*20.8
         translate <0.82, 0.33555, 0.19426>
      }
      
      union {
         //*PMName Livre7
         
         difference {
            //*PMName Couv
            
            union {
               box {
                  //*PMName Couv
                  <0, 0, 0.2>, <1, -1.45, 0>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, -1.45, 0>, 0.11
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
            
            union {
               box {
                  //*PMName Couv
                  <0, 0.01, 0.185>, <1.01, -1.46, 0.015>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0.01, 0>, <0, -1.46, 0>, 0.095
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
         }
         
         union {
            //*PMName Pages
            
            box {
               //*PMName Pages
               <0, -0.03, 0.18>, <0.98, -1.42, 0.02>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, -0.03, 0>, <0, -1.42, 0>, 0.09
               scale 1
               rotate <0, 0, 0>
               translate z*0.1
            }
            
            pigment {
               color rgb <1, 1, 1>
            }
         }
         
         box {
            //*PMName PremCouv
            <0, 0, 0>, <1, -1.45, -0.001>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            pigment {
               image_map {
                  png
                  "/home/tom/RayTrace/Textures/Couverture7.png"
                  map_type 0
               }
               scale <1.2, 1.44, 1>
               rotate <0, 0, 0>
               translate x*(-0.22)
            }
            
            finish {
               phong 4
               phong_size 18
            }
         }
         scale <0.22, 0.21, 0.14>
         rotate x*25.9
         translate <1.15, 0.30205, 0.18133>
      }
      
      union {
         //*PMName Livre8
         
         difference {
            //*PMName Couv
            
            union {
               box {
                  //*PMName Couv
                  <0, 0, 0.2>, <1, -1.45, 0>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, -1.45, 0>, 0.11
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
            
            union {
               box {
                  //*PMName Couv
                  <0, 0.01, 0.185>, <1.01, -1.46, 0.015>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0.01, 0>, <0, -1.46, 0>, 0.095
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
         }
         
         union {
            //*PMName Pages
            
            box {
               //*PMName Pages
               <0, -0.03, 0.18>, <0.98, -1.42, 0.02>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, -0.03, 0>, <0, -1.42, 0>, 0.09
               scale 1
               rotate <0, 0, 0>
               translate z*0.1
            }
            
            pigment {
               color rgb <1, 1, 1>
            }
         }
         
         box {
            //*PMName PremCouv
            <0, 0, 0>, <1, -1.45, -0.001>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            pigment {
               image_map {
                  png
                  "/home/tom/RayTrace/Textures/Couverture8.png"
                  map_type 0
               }
               scale <1.2, 1.44, 1>
               rotate <0, 0, 0>
               translate x*(-0.22)
            }
            
            finish {
               phong 0.5
               phong_size 8
               roughness 0.05
            }
         }
         scale <0.21, 0.21, 0.15>
         rotate x*25.9
         translate <-1.12, 0.504837, 0.353741>
      }
      
      union {
         //*PMName Livre10
         
         difference {
            //*PMName Couv
            
            union {
               box {
                  //*PMName Couv
                  <0, 0, 0.2>, <1, -1.45, 0>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, -1.45, 0>, 0.11
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
            
            union {
               box {
                  //*PMName Couv
                  <0, 0.01, 0.185>, <1.01, -1.46, 0.015>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0.01, 0>, <0, -1.46, 0>, 0.095
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
         }
         
         union {
            //*PMName Pages
            
            box {
               //*PMName Pages
               <0, -0.03, 0.18>, <0.98, -1.42, 0.02>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, -0.03, 0>, <0, -1.42, 0>, 0.09
               scale 1
               rotate <0, 0, 0>
               translate z*0.1
            }
            
            pigment {
               color rgb <1, 1, 1>
            }
         }
         
         box {
            //*PMName PremCouv
            <0, 0, 0>, <1, -1.45, -0.001>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            pigment {
               image_map {
                  png
                  "/home/tom/RayTrace/Textures/Couverture10.png"
                  map_type 0
               }
               scale <1.2, 1.44, 1>
               rotate <0, 0, 0>
               translate x*(-0.22)
            }
            
            finish {
               phong 0.5
               phong_size 8
               roughness 0.05
            }
         }
         scale <0.21, 0.21, 0.15>
         rotate x*25.9
         translate <-0.6, 0.50389, 0.35282>
      }
      
      union {
         //*PMName Livre11
         
         difference {
            //*PMName Couv
            
            union {
               box {
                  //*PMName Couv
                  <0, 0, 0.2>, <1, -1.45, 0>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, -1.45, 0>, 0.11
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
            
            union {
               box {
                  //*PMName Couv
                  <0, 0.01, 0.185>, <1.01, -1.46, 0.015>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0.01, 0>, <0, -1.46, 0>, 0.095
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
         }
         
         union {
            //*PMName Pages
            
            box {
               //*PMName Pages
               <0, -0.03, 0.18>, <0.98, -1.42, 0.02>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, -0.03, 0>, <0, -1.42, 0>, 0.09
               scale 1
               rotate <0, 0, 0>
               translate z*0.1
            }
            
            pigment {
               color rgb <1, 1, 1>
            }
         }
         
         box {
            //*PMName PremCouv
            <0, 0, 0>, <1, -1.45, -0.001>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            pigment {
               image_map {
                  png
                  "/home/tom/RayTrace/Textures/Couverture11.png"
                  map_type 0
               }
               scale <1.2, 1.44, 1>
               rotate <0, 0, 0>
               translate x*(-0.22)
            }
            
            finish {
               phong 0.5
               phong_size 8
               roughness 0.05
            }
         }
         scale <0.21, 0.21, 0.15>
         rotate x*25.9
         translate <-0.86, 0.50705, 0.3526>
      }
      
      union {
         //*PMName Livre9
         
         difference {
            //*PMName Couv
            
            union {
               box {
                  //*PMName Couv
                  <0, 0, 0.2>, <1, -1.45, 0>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, -1.45, 0>, 0.11
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
            
            union {
               box {
                  //*PMName Couv
                  <0, 0.01, 0.185>, <1.01, -1.46, 0.015>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0.01, 0>, <0, -1.46, 0>, 0.095
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
         }
         
         union {
            //*PMName Pages
            
            box {
               //*PMName Pages
               <0, -0.03, 0.18>, <0.98, -1.42, 0.02>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, -0.03, 0>, <0, -1.42, 0>, 0.09
               scale 1
               rotate <0, 0, 0>
               translate z*0.1
            }
            
            pigment {
               color rgb <1, 1, 1>
            }
         }
         
         box {
            //*PMName PremCouv
            <0, 0, 0>, <1, -1.45, -0.001>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            pigment {
               image_map {
                  png
                  "/home/tom/RayTrace/Textures/Couverture9.png"
                  map_type 0
               }
               scale <1.2, 1.44, 1>
               rotate <0, 0, 0>
               translate x*(-0.22)
            }
            
            finish {
               phong 0.5
               phong_size 8
               roughness 0.05
            }
         }
         scale <0.21, 0.21, 0.15>
         rotate x*25.9
         translate <-0.34, 0.50705, 0.3526>
      }
      
      union {
         //*PMName LivreN
         
         difference {
            //*PMName Couv
            
            union {
               box {
                  //*PMName Couv
                  <0, 0, 0.2>, <1, -1.45, 0>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, -1.45, 0>, 0.11
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
            
            union {
               box {
                  //*PMName Couv
                  <0, 0.01, 0.185>, <1.01, -1.46, 0.015>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0.01, 0>, <0, -1.46, 0>, 0.095
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
         }
         
         union {
            //*PMName Pages
            
            box {
               //*PMName Pages
               <0, -0.03, 0.18>, <0.98, -1.42, 0.02>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, -0.03, 0>, <0, -1.42, 0>, 0.09
               scale 1
               rotate <0, 0, 0>
               translate z*0.1
            }
            
            pigment {
               color rgb <1, 1, 1>
            }
         }
         
         box {
            //*PMName PremCouv
            <0, 0, 0>, <1, -1.45, -0.001>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            pigment {
               image_map {
                  png
                  "/home/tom/RayTrace/Textures/livrenorbert.png"
                  map_type 0
               }
               scale <1.2, 1.44, 1>
               rotate <0, 0, 0>
               translate x*(-0.22)
            }
            
            finish {
               phong 0.5
               phong_size 8
               roughness 0.05
            }
         }
         scale <0.21, 0.21, 0.15>
         rotate x*19
         translate <1.2, 0.71586, 0.48347>
      }
      
      union {
         //*PMName LivreN2
         
         difference {
            //*PMName Couv
            
            union {
               box {
                  //*PMName Couv
                  <0, 0, 0.2>, <1, -1.45, 0>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, -1.45, 0>, 0.11
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
            
            union {
               box {
                  //*PMName Couv
                  <0, 0.01, 0.185>, <1.01, -1.46, 0.015>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0.01, 0>, <0, -1.46, 0>, 0.095
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
         }
         
         union {
            //*PMName Pages
            
            box {
               //*PMName Pages
               <0, -0.03, 0.18>, <0.98, -1.42, 0.02>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, -0.03, 0>, <0, -1.42, 0>, 0.09
               scale 1
               rotate <0, 0, 0>
               translate z*0.1
            }
            
            pigment {
               color rgb <1, 1, 1>
            }
         }
         
         box {
            //*PMName PremCouv
            <0, 0, 0>, <1, -1.45, -0.001>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            pigment {
               image_map {
                  png
                  "/home/tom/RayTrace/Textures/livrenorbert.png"
                  map_type 0
               }
               scale <1.2, 1.44, 1>
               rotate <0, 0, 0>
               translate x*(-0.22)
            }
            
            finish {
               phong 0.5
               phong_size 8
               roughness 0.05
            }
         }
         scale <0.21, 0.21, 0.15>
         rotate x*20.5
         translate <0.94, 0.71227, 0.48347>
      }
      
      union {
         //*PMName LivreN3
         
         difference {
            //*PMName Couv
            
            union {
               box {
                  //*PMName Couv
                  <0, 0, 0.2>, <1, -1.45, 0>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, -1.45, 0>, 0.11
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
            
            union {
               box {
                  //*PMName Couv
                  <0, 0.01, 0.185>, <1.01, -1.46, 0.015>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0.01, 0>, <0, -1.46, 0>, 0.095
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
         }
         
         union {
            //*PMName Pages
            
            box {
               //*PMName Pages
               <0, -0.03, 0.18>, <0.98, -1.42, 0.02>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, -0.03, 0>, <0, -1.42, 0>, 0.09
               scale 1
               rotate <0, 0, 0>
               translate z*0.1
            }
            
            pigment {
               color rgb <1, 1, 1>
            }
         }
         
         box {
            //*PMName PremCouv
            <0, 0, 0>, <1, -1.45, -0.001>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            pigment {
               image_map {
                  png
                  "/home/tom/RayTrace/Textures/livrenorbert.png"
                  map_type 0
               }
               scale <1.2, 1.44, 1>
               rotate <0, 0, 0>
               translate x*(-0.22)
            }
            
            finish {
               phong 0.5
               phong_size 8
               roughness 0.05
            }
         }
         scale <0.21, 0.21, 0.15>
         rotate x*19
         translate <0.68, 0.71586, 0.48347>
      }
      
      union {
         //*PMName LivreN4
         
         difference {
            //*PMName Couv
            
            union {
               box {
                  //*PMName Couv
                  <0, 0, 0.2>, <1, -1.45, 0>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, -1.45, 0>, 0.11
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
            
            union {
               box {
                  //*PMName Couv
                  <0, 0.01, 0.185>, <1.01, -1.46, 0.015>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0.01, 0>, <0, -1.46, 0>, 0.095
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
         }
         
         union {
            //*PMName Pages
            
            box {
               //*PMName Pages
               <0, -0.03, 0.18>, <0.98, -1.42, 0.02>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, -0.03, 0>, <0, -1.42, 0>, 0.09
               scale 1
               rotate <0, 0, 0>
               translate z*0.1
            }
            
            pigment {
               color rgb <1, 1, 1>
            }
         }
         
         box {
            //*PMName PremCouv
            <0, 0, 0>, <1, -1.45, -0.001>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            pigment {
               image_map {
                  png
                  "/home/tom/RayTrace/Textures/livrenorbert.png"
                  map_type 0
               }
               scale <1.2, 1.44, 1>
               rotate <0, 0, 0>
               translate x*(-0.22)
            }
            
            finish {
               phong 0.5
               phong_size 8
               roughness 0.05
            }
         }
         scale <0.21, 0.21, 0.15>
         rotate x*17.4
         translate <0.41, 0.71586, 0.47749>
      }
      
      union {
         //*PMName double
         
         intersection {
            //*PMName pages
            
            merge {
               cylinder {
                  <0, 0.5, 0>, <0, -0.5, 0>, 0.5
                  scale <1, 1, 0.1>
                  rotate <0, 0, 0>
                  translate x*(-0.4)
               }
               
               cylinder {
                  <0, 0.5, 0>, <0, -0.5, 0>, 0.5
                  scale <1, 1, 0.1>
                  rotate <0, 0, 0>
                  translate x*0.4
               }
            }
            
            difference {
               box {
                  <-0.5, -0.51, 0>, <0.5, 0.51, 0.2>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               box {
                  <-0.1, -0.5, 0>, <0, 0.5, 0.2>
                  scale 1
                  rotate y*20
                  translate x*(-0.5)
               }
               
               box {
                  <0.1, -0.5, 0>, <0, 0.5, 0.2>
                  scale 1
                  rotate y*(-20)
                  translate x*0.5
               }
            }
            
            texture {
               pigment {
                  image_map {
                     png
                     "/home/tom/RayTrace/Textures/doublepage.png"
                     map_type 0
                  }
                  rotate <0, 180, -180>
                  translate <-0.5, -0.5, 0>
               }
               
               finish {
                  diffuse 0.5
               }
            }
         }
         
         union {
            //*PMName couv
            
            box {
               <-0.505, -0.5, 0>, <0.505, 0.5, -0.02>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            texture {
               pigment {
                  color rgb <0.996078, 0.815686, 0.0666667>
               }
            }
         }
         scale <0.42, 0.3, 0.3>
         rotate x*(-154.3)
         translate <0.132465, 0.560923, 0.439554>
      }
      
      union {
         //*PMName LivreN5
         
         difference {
            //*PMName Couv
            
            union {
               box {
                  //*PMName Couv
                  <0, 0, 0.2>, <1, -1.45, 0>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, -1.45, 0>, 0.11
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
            
            union {
               box {
                  //*PMName Couv
                  <0, 0.01, 0.185>, <1.01, -1.46, 0.015>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0.01, 0>, <0, -1.46, 0>, 0.095
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
         }
         
         union {
            //*PMName Pages
            
            box {
               //*PMName Pages
               <0, -0.03, 0.18>, <0.98, -1.42, 0.02>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, -0.03, 0>, <0, -1.42, 0>, 0.09
               scale 1
               rotate <0, 0, 0>
               translate z*0.1
            }
            
            pigment {
               color rgb <1, 1, 1>
            }
         }
         
         box {
            //*PMName PremCouv
            <0, 0, 0>, <1, -1.45, -0.001>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            pigment {
               image_map {
                  png
                  "/home/tom/RayTrace/Textures/livrenorbert.png"
                  map_type 0
               }
               scale <1.2, 1.44, 1>
               rotate <0, 0, 0>
               translate x*(-0.22)
            }
            
            finish {
               phong 0.5
               phong_size 8
               roughness 0.05
            }
         }
         scale <0.21, 0.21, 0.15>
         rotate x*14.9
         translate <-0.36, 0.718093, 0.466326>
      }
      
      union {
         //*PMName LivreN6
         
         difference {
            //*PMName Couv
            
            union {
               box {
                  //*PMName Couv
                  <0, 0, 0.2>, <1, -1.45, 0>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, -1.45, 0>, 0.11
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
            
            union {
               box {
                  //*PMName Couv
                  <0, 0.01, 0.185>, <1.01, -1.46, 0.015>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0.01, 0>, <0, -1.46, 0>, 0.095
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
         }
         
         union {
            //*PMName Pages
            
            box {
               //*PMName Pages
               <0, -0.03, 0.18>, <0.98, -1.42, 0.02>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, -0.03, 0>, <0, -1.42, 0>, 0.09
               scale 1
               rotate <0, 0, 0>
               translate z*0.1
            }
            
            pigment {
               color rgb <1, 1, 1>
            }
         }
         
         box {
            //*PMName PremCouv
            <0, 0, 0>, <1, -1.45, -0.001>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            pigment {
               image_map {
                  png
                  "/home/tom/RayTrace/Textures/livrenorbert.png"
                  map_type 0
               }
               scale <1.2, 1.44, 1>
               rotate <0, 0, 0>
               translate x*(-0.22)
            }
            
            finish {
               phong 0.5
               phong_size 8
               roughness 0.05
            }
         }
         scale <0.21, 0.21, 0.15>
         rotate x*11.9
         translate <-0.64, 0.722559, 0.466326>
      }
      
      union {
         //*PMName LivreN7
         
         difference {
            //*PMName Couv
            
            union {
               box {
                  //*PMName Couv
                  <0, 0, 0.2>, <1, -1.45, 0>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, -1.45, 0>, 0.11
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
            
            union {
               box {
                  //*PMName Couv
                  <0, 0.01, 0.185>, <1.01, -1.46, 0.015>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0.01, 0>, <0, -1.46, 0>, 0.095
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
         }
         
         union {
            //*PMName Pages
            
            box {
               //*PMName Pages
               <0, -0.03, 0.18>, <0.98, -1.42, 0.02>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, -0.03, 0>, <0, -1.42, 0>, 0.09
               scale 1
               rotate <0, 0, 0>
               translate z*0.1
            }
            
            pigment {
               color rgb <1, 1, 1>
            }
         }
         
         box {
            //*PMName PremCouv
            <0, 0, 0>, <1, -1.45, -0.001>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            pigment {
               image_map {
                  png
                  "/home/tom/RayTrace/Textures/livrenorbert.png"
                  map_type 0
               }
               scale <1.2, 1.44, 1>
               rotate <0, 0, 0>
               translate x*(-0.22)
            }
            
            finish {
               phong 0.5
               phong_size 8
               roughness 0.05
            }
         }
         scale <0.21, 0.21, 0.15>
         rotate x*11.9
         translate <-0.92, 0.72256, 0.46633>
      }
      
      union {
         //*PMName Livre12
         
         difference {
            //*PMName Couv
            
            union {
               box {
                  //*PMName Couv
                  <0, 0, 0.2>, <1, -1.45, 0>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, -1.45, 0>, 0.11
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
            
            union {
               box {
                  //*PMName Couv
                  <0, 0.01, 0.185>, <1.01, -1.46, 0.015>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0.01, 0>, <0, -1.46, 0>, 0.095
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
         }
         
         union {
            //*PMName Pages
            
            box {
               //*PMName Pages
               <0, -0.03, 0.18>, <0.98, -1.42, 0.02>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, -0.03, 0>, <0, -1.42, 0>, 0.09
               scale 1
               rotate <0, 0, 0>
               translate z*0.1
            }
            
            pigment {
               color rgb <1, 1, 1>
            }
         }
         
         box {
            //*PMName PremCouv
            <0, 0, 0>, <1, -1.45, -0.001>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            pigment {
               image_map {
                  png
                  "/home/tom/RayTrace/Textures/Couverture12.png"
                  map_type 0
               }
               scale <1.2, 1.44, 1>
               rotate <0, 0, 0>
               translate x*(-0.22)
            }
            
            finish {
               phong 0.5
               phong_size 8
               roughness 0.05
            }
         }
         scale <0.21, 0.21, 0.15>
         rotate x*21.3
         translate <-0.08, 0.51731, 0.337211>
      }
      
      union {
         //*PMName Livre13
         
         difference {
            //*PMName Couv
            
            union {
               box {
                  //*PMName Couv
                  <0, 0, 0.2>, <1, -1.45, 0>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, -1.45, 0>, 0.11
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
            
            union {
               box {
                  //*PMName Couv
                  <0, 0.01, 0.185>, <1.01, -1.46, 0.015>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0.01, 0>, <0, -1.46, 0>, 0.095
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
         }
         
         union {
            //*PMName Pages
            
            box {
               //*PMName Pages
               <0, -0.03, 0.18>, <0.98, -1.42, 0.02>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, -0.03, 0>, <0, -1.42, 0>, 0.09
               scale 1
               rotate <0, 0, 0>
               translate z*0.1
            }
            
            pigment {
               color rgb <1, 1, 1>
            }
         }
         
         box {
            //*PMName PremCouv
            <0, 0, 0>, <1, -1.45, -0.001>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            pigment {
               image_map {
                  png
                  "/home/tom/RayTrace/Textures/Couverture13.png"
                  map_type 0
               }
               scale <1.2, 1.44, 1>
               rotate <0, 0, 0>
               translate x*(-0.22)
            }
            
            finish {
               phong 0.5
               phong_size 8
               roughness 0.05
            }
         }
         scale <0.21, 0.21, 0.15>
         rotate x*19.5
         translate <0.2, 0.521477, 0.333043>
      }
      
      union {
         //*PMName Livre14
         
         difference {
            //*PMName Couv
            
            union {
               box {
                  //*PMName Couv
                  <0, 0, 0.2>, <1, -1.45, 0>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, -1.45, 0>, 0.11
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
            
            union {
               box {
                  //*PMName Couv
                  <0, 0.01, 0.185>, <1.01, -1.46, 0.015>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0.01, 0>, <0, -1.46, 0>, 0.095
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
         }
         
         union {
            //*PMName Pages
            
            box {
               //*PMName Pages
               <0, -0.03, 0.18>, <0.98, -1.42, 0.02>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, -0.03, 0>, <0, -1.42, 0>, 0.09
               scale 1
               rotate <0, 0, 0>
               translate z*0.1
            }
            
            pigment {
               color rgb <1, 1, 1>
            }
         }
         
         box {
            //*PMName PremCouv
            <0, 0, 0>, <1, -1.45, -0.001>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            pigment {
               image_map {
                  png
                  "/home/tom/RayTrace/Textures/Couverture14.png"
                  map_type 0
               }
               scale <1.2, 1.44, 1>
               rotate <0, 0, 0>
               translate x*(-0.22)
            }
            
            finish {
               phong 0.5
               phong_size 8
               roughness 0.05
            }
         }
         scale <0.21, 0.21, 0.15>
         rotate x*18.5
         translate <0.47, 0.52148, 0.33304>
      }
      
      union {
         //*PMName Livre8bis
         
         difference {
            //*PMName Couv
            
            union {
               box {
                  //*PMName Couv
                  <0, 0, 0.2>, <1, -1.45, 0>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, -1.45, 0>, 0.11
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
            
            union {
               box {
                  //*PMName Couv
                  <0, 0.01, 0.185>, <1.01, -1.46, 0.015>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0.01, 0>, <0, -1.46, 0>, 0.095
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
         }
         
         union {
            //*PMName Pages
            
            box {
               //*PMName Pages
               <0, -0.03, 0.18>, <0.98, -1.42, 0.02>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, -0.03, 0>, <0, -1.42, 0>, 0.09
               scale 1
               rotate <0, 0, 0>
               translate z*0.1
            }
            
            pigment {
               color rgb <1, 1, 1>
            }
         }
         
         box {
            //*PMName PremCouv
            <0, 0, 0>, <1, -1.45, -0.001>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            pigment {
               image_map {
                  png
                  "/home/tom/RayTrace/Textures/Couverture8.png"
                  map_type 0
               }
               scale <1.2, 1.44, 1>
               rotate <0, 0, 0>
               translate x*(-0.22)
            }
            
            finish {
               phong 0.5
               phong_size 8
               roughness 0.05
            }
         }
         scale <0.21, 0.21, 0.15>
         rotate x*19
         translate <0.78, 0.52023, 0.34861>
      }
      
      union {
         //*PMName Livre15
         
         difference {
            //*PMName Couv
            
            union {
               box {
                  //*PMName Couv
                  <0, 0, 0.2>, <1, -1.45, 0>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, -1.45, 0>, 0.11
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
            
            union {
               box {
                  //*PMName Couv
                  <0, 0.01, 0.185>, <1.01, -1.46, 0.015>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0.01, 0>, <0, -1.46, 0>, 0.095
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.1
               }
            }
         }
         
         union {
            //*PMName Pages
            
            box {
               //*PMName Pages
               <0, -0.03, 0.18>, <0.98, -1.42, 0.02>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, -0.03, 0>, <0, -1.42, 0>, 0.09
               scale 1
               rotate <0, 0, 0>
               translate z*0.1
            }
            
            pigment {
               color rgb <1, 1, 1>
            }
         }
         
         box {
            //*PMName PremCouv
            <0, 0, 0>, <1, -1.45, -0.001>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            pigment {
               image_map {
                  png
                  "/home/tom/RayTrace/Textures/Couverture15.png"
                  map_type 0
               }
               scale <1.2, 1.44, 1>
               rotate <0, 0, 0>
               translate x*(-0.22)
            }
            
            finish {
               phong 0.5
               phong_size 8
               roughness 0.05
            }
         }
         scale <0.21, 0.21, 0.15>
         rotate x*19
         translate <1.05, 0.52023, 0.34861>
      }
      
      union {
         //*PMName Halogne
         
         cylinder {
            <-1.5, 0, 0>, <1.5, 0, 0>, 0.002
            
            texture {
               Cuivre
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <-1.5, 0, 0>, <1.5, 0, 0>, 0.002
            
            texture {
               Cuivre
            }
            scale 1
            rotate <0, 0, 0>
            translate z*0.07
         }
         
         object {
            //*PMName Lampe1
            Halogene
            scale 1
            rotate <0, 0, 0>
            translate x*(-1)
         }
         
         object {
            //*PMName Lampe2
            Halogene
            scale 1
            rotate <0, 0, 0>
            translate x*(-0.5)
         }
         
         object {
            //*PMName Lampe3
            Halogene
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         object {
            //*PMName Lampe4
            Halogene
            scale 1
            rotate <0, 0, 0>
            translate x*0.5
         }
         
         object {
            //*PMName Lampe5
            Halogene
            scale 1
            rotate <0, 0, 0>
            translate x*1
         }
         translate <0, 1.7, 0.05>
      }
      
      union {
         //*PMName PorteLivres
         
         object {
            //*PMName CloisonG
            Cloison
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         object {
            //*PMName CloisonD
            Cloison
            scale 1
            rotate <0, 0, 0>
            translate x*2.965
         }
         
         union {
            //*PMName Etage0
            
            box {
               //*PMName Etage
               <0.03, 0.015, 0.5>, <2.965, 0, 0>
               
               texture {
                  Hetre
                  rotate x*90
               }
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            box {
               //*PMName Latte
               <0.03, 0.01, 0.02>, <2.965, 0, 0>
               
               texture {
                  Hetre
                  rotate <0, 0, 0>
               }
               scale 1
               rotate <0, 0, 0>
               translate y*0.015
            }
         }
         
         union {
            //*PMName Etage1
            
            box {
               //*PMName Etage
               <0.03, 0.015, 0.5>, <2.965, 0, 0.18>
               
               texture {
                  Hetre
                  rotate x*90
               }
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            box {
               //*PMName Latte
               <0.03, 0.01, 0.02>, <2.965, 0, 0>
               
               texture {
                  Hetre
                  rotate <0, 0, 0>
               }
               scale 1
               rotate <0, 0, 0>
               translate <0, 0.015, 0.18>
            }
            
            box {
               //*PMName Fond
               <0.03, 0.01, 0.02>, <2.965, -0.2, 0>
               
               texture {
                  Moquette
               }
               scale 1
               rotate <0, 0, 0>
               translate z*0.2
            }
            translate y*0.2
         }
         
         union {
            //*PMName Etage2
            
            box {
               //*PMName Etage
               <0.03, 0.015, 0.5>, <2.965, 0, 0.35>
               
               texture {
                  Hetre
                  rotate x*90
               }
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            box {
               //*PMName Latte
               <0.03, 0.01, 0.02>, <2.965, 0, 0>
               
               texture {
                  Hetre
                  rotate <0, 0, 0>
               }
               scale 1
               rotate <0, 0, 0>
               translate <0, 0.015, 0.35>
            }
            
            box {
               //*PMName Fond
               <0.03, 0.01, 0.02>, <2.965, -0.2, 0>
               
               texture {
                  Moquette
               }
               scale 1
               rotate <0, 0, 0>
               translate z*0.37
            }
            translate y*0.4
         }
         
         union {
            //*PMName Haut
            
            box {
               //*PMName Latte
               <0, 0.005, 0.02>, <3, -0.01, 0>
               
               texture {
                  Hetre
                  rotate <0, 0, 0>
               }
               scale 1
               rotate <0, 0, 0>
               translate z*0.48
            }
            
            box {
               //*PMName Fond
               <0.03, -0.01, 0.02>, <2.965, -0.2, 0>
               
               texture {
                  Moquette
               }
               scale 1
               rotate <0, 0, 0>
               translate z*0.48
            }
            translate y*0.6
         }
         translate x*(-1.495)
      }
      
      union {
         //*PMName Cadre
         
         box {
            <-1.5, 0.01, 0.5>, <1.5, -0.01, 0>
            
            texture {
               VBois
               scale 1
               rotate x*90
               rotate y*90
            }
            scale 1
            rotate <0, 0, 0>
            translate y*1.9
         }
         
         box {
            <-1.51, -0.01, 0.5>, <-1.49, 1.91, 0>
            
            texture {
               VBois
               scale 1
               rotate y*90
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <1.51, -0.01, 0.5>, <1.49, 1.91, 0>
            
            texture {
               VBois
               scale 1
               rotate y*90
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
      }
      translate <0.7, 0.4, 0.2>
   }
   
   union {
      //*PMName Toit
      
      object {
         Tuiles
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      object {
         Tuiles
         scale 1
         rotate <0, 0, 0>
         translate x*(-0.15)
      }
      
      object {
         Tuiles
         scale 1
         rotate <0, 0, 0>
         translate x*(-0.3)
      }
      
      object {
         Tuiles
         scale 1
         rotate <0, 0, 0>
         translate x*(-0.45)
      }
      
      object {
         Tuiles
         scale 1
         rotate <0, 0, 0>
         translate x*(-0.6)
      }
      
      object {
         Tuiles
         scale 1
         rotate <0, 0, 0>
         translate x*(-0.75)
      }
      
      object {
         Tuiles
         scale 1
         rotate <0, 0, 0>
         translate x*(-0.9)
      }
      
      object {
         Tuiles
         scale 1
         rotate <0, 0, 0>
         translate x*(-1.05)
      }
      
      object {
         Tuiles
         scale 1
         rotate <0, 0, 0>
         translate x*(-1.2)
      }
      
      object {
         Tuiles
         scale 1
         rotate <0, 0, 0>
         translate x*(-1.35)
      }
      
      texture {
         pigment {
            color rgb <0.403922, 0.0823529, 0.117647>
         }
      }
      scale 1
      rotate <0, 0, 0>
      translate <2.36643, 5.376, 0.169223>
   }
   
   union {
      //*PMName Cloison
      
      box {
         <-2.495, -0.1, 3.99>, <2.495, 0.1, 0.05>
         scale 1
         rotate <0, 0, 0>
         translate y*2.8
      }
      
      box {
         <-0.85, 0, 3.99>, <-0.86, 2.3, 0.05>
         scale 1
         rotate <0, 0, 0>
         translate y*2.8
      }
      
      texture {
         pigment {
            color rgb <0.760784, 0.760784, 0.760784>
         }
      }
   }
   
   difference {
      //*PMName Batiment
      
      box {
         //*PMName Corps
         <-2.5, 0, 0>, <2.5, 5.2, 4>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
         hollow false
      }
      
      box {
         //*PMName CorpsInt
         <-2.4, 0, 0.1>, <2.4, 5.1, 3.9>
         
         texture {
            pigment {
               color rgb <1, 0.862745, 0.309804>
            }
         }
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
         hollow false
      }
      
      box {
         <2.2, 0.4, -0.1>, <-0.8, 2.3, 0.2>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         <-1, 0, -0.1>, <-2.3, 2.3, 0.2>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         //*PMName Trou
         <-0.5, 1.6, -0.15>, <0.5, 0.2, 0.2>
         scale 1
         rotate <0, 0, 0>
         translate y*3.2
      }
      
      box {
         //*PMName Trou
         <-0.5, 1.6, -0.15>, <0.5, 0.2, 0.2>
         scale 1
         rotate <0, 0, 0>
         translate <1.5, 3.2, 0>
      }
      
      box {
         //*PMName Trou
         <-0.5, 1.6, -0.15>, <0.5, 0.2, 0.2>
         scale 1
         rotate <0, 0, 0>
         translate <-1.5, 3.2, 0>
      }
      
      texture {
         BriqueTex
      }
   }
   
   union {
      //*PMName Entre
      
      union {
         //*PMName Paillasson
         
         box {
            //*PMName Paillasson
            <0, 0, 0>, <1, 0.75, 0.01>
            
            pigment {
               image_map {
                  png
                  "/home/tom/RayTrace/Textures/welcome.png"
                  map_type 0
               }
               translate y*(-0.125)
            }
            
            normal {
               crackle
               0.1
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         scale <0.5, 0.5, 1>
         rotate x*90
         translate <-1.9, 0.04, 0.1>
      }
      
      union {
         //*PMName Plancher
         
         box {
            //*PMName Plancher
            <-1, 0.0499, 0.1>, <2.41, 0, 4>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            //*PMName Plancher
            <-2.41, 0.0499, 0.6>, <-1, 0, 4>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            pigment {
               image_map {
                  jpeg
                  "/home/tom/RayTrace/Textures/wood_old.jpg"
                  map_type 0
               }
            }
            scale 0.7
            rotate x*90
         }
      }
      
      difference {
         //*PMName EntreBeton
         
         box {
            //*PMName EntreBton
            <-2.3, 0, 0>, <-1, 0.05, 0.7>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            //*PMName Paillasson
            <0, 0, -0.02>, <1, 0.75, 0.02>
            scale <0.5, 0.5, 1>
            rotate x*90
            translate <-1.9, 0.05, 0.1>
         }
         
         texture {
            pigment {
               color rgb <0.505882, 0.505882, 0.505882>
            }
            
            normal {
               granite
               scale 0.01
               rotate <0, 0, 0>
            }
         }
      }
      
      box {
         //*PMName EntreMurD
         <-1.001, 0, 0>, <-1, 2.3, 0.7>
         
         texture {
            BriqueTex
            rotate y*90
         }
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         //*PMName EntreMurG
         <-2.3, 0, 0>, <-2.301, 2.3, 0.7>
         
         texture {
            BriqueTex
            rotate y*90
         }
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         //*PMName LattePorteG
         <-0.03, 0, -0.01>, <0.03, 2.3, 0.01>
         
         texture {
            BoisBlanc
            rotate z*90
         }
         scale 1
         rotate <0, 0, 0>
         translate <-2.27, 0, 0.6>
      }
      
      box {
         //*PMName LattePorteD
         <-0.02, 0, -0.01>, <0.03, 2.3, 0.01>
         
         texture {
            BoisBlanc
            rotate z*90
         }
         scale 1
         rotate <0, 0, 0>
         translate <-1.03, 0, 0.6>
      }
      
      box {
         //*PMName LattePorteH
         <-0.03, -0.01, -0.01>, <0.03, 1.18, 0.01>
         
         texture {
            BoisBlanc
            rotate z*90
         }
         scale 1
         rotate z*90
         translate <-1.06, 2.27, 0.6>
      }
      
      union {
         //*PMName Porte
         
         box {
            //*PMName Haut
            <0, 2.2, 0>, <1.29, 2.28, -0.04>
            scale 1
            rotate <-0, 0, 0>
         }
         
         box {
            //*PMName Gauche
            <0, 0.0505, 0>, <0.08, 2.28, -0.04>
            scale 1
            rotate <-0, 0, 0>
         }
         
         box {
            //*PMName Droite
            <1.12, 0.0505, 0>, <1.29, 2.28, -0.04>
            scale 1
            rotate <-0, 0, 0>
         }
         
         box {
            //*PMName Vitre
            <0.03, 0.4, -0.01>, <1.14, 2.27, -0.03>
            
            material {
               Verre
            }
            scale 1
            rotate <-0, 0, 0>
         }
         
         union {
            //*PMName Closed
            
            difference {
               //*PMName Carton
               
               box {
                  //*PMName Closed
                  <0, 0, 0.005>, <1, 0.3428, 0.006>
                  
                  pigment {
                     image_map {
                        png
                        "/home/tom/RayTrace/Textures/closed2.png"
                        map_type 0
                     }
                     scale <1, 0.3428, 1>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, -0.01>, <0, 0, 0.01>, 0.027
                  scale 1
                  rotate <0, 0, 0>
                  translate <0.05, 0.29, 0>
               }
               
               cylinder {
                  <0, 0, -0.01>, <0, 0, 0.01>, 0.027
                  scale 1
                  rotate <0, 0, 0>
                  translate <0.95, 0.29, 0>
               }
               translate z*0.015
            }
            
            union {
               //*PMName Ficelle
               
               sphere {
                  <0, 0, 0>, 0.005
                  scale 1
                  rotate <0, 0, 0>
                  translate <0.0651298, 0.30513, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.005
                  scale 1
                  rotate <0, 0, 0>
                  translate <0.93958, 0.30513, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.005
                  scale 1
                  rotate <0, 0, 0>
                  translate <0.499103, 0.94141, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, 0.77, 0>, 0.005
                  scale 1
                  rotate z*(-34.3)
                  translate <0.0651298, 0.30513, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <-0.00522878, 0.773748, 0>, 0.005
                  scale 1
                  rotate z*34.3
                  translate <0.93958, 0.30513, 0>
               }
               
               pigment {
                  color rgb <0.0745098, 0.133333, 0.470588>
               }
               translate z*0.015
            }
            
            union {
               //*PMName Ventouse
               
               sphere {
                  <0, 0, 0.02>, 0.012
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cone {
                  <0, 0, 0>, 0.05,
                  <0, 0, 0.02>, 0
                  scale 1
                  rotate <0, 0, 0>
               }
               translate <0.5, 0.91, 0>
               
               texture {
                  pigment {
                     color rgbf <0.63922, 0.7098, 0.36471, 0.4>
                  }
               }
            }
            scale 0.4
            rotate z*(-5)
            translate <0.420833, 1.30417, -0.01>
         }
         
         box {
            //*PMName CB
            <0, 0, 0>, <0.8, 1, 0.0005>
            
            texture {
               pigment {
                  image_map {
                     png
                     "/home/tom/RayTrace/Textures/visa.png"
                     map_type 0
                  }
               }
            }
            scale 0.2
            rotate <0, 0, 0>
            translate <0.92, 1, 0>
         }
         
         box {
            //*PMName PorteBoite
            <0, 0, -0.04>, <0.29, 0.05, -0.03>
            
            texture {
               MetalBrillant
            }
            scale 1
            rotate <0, 0, 0>
            translate <0.5, 0.25, 0>
         }
         
         difference {
            //*PMName BoiteBas
            
            union {
               box {
                  //*PMName Bas
                  <0, 0.051, 0>, <1.29, 0.41, -0.04>
                  scale 1
                  rotate <-0, 0, 0>
               }
               
               union {
                  //*PMName BoiteMetal
                  
                  box {
                     //*PMName boite
                     <-0.02, -0.02, -0.041>, <0.31, 0.07, -0.03>
                     scale 1
                     rotate <0, 0, 0>
                     translate <0.5, 0.25, 0>
                  }
                  
                  cylinder {
                     <0, 0, 0>, <0, 0, 0.02>, 0.035
                     scale 1
                     rotate <0, 0, 0>
                     translate <0.48, 0.275, -0.041>
                  }
                  
                  cylinder {
                     <0, 0, 0>, <0, 0, 0.02>, 0.035
                     scale 1
                     rotate <0, 0, 0>
                     translate <0.81, 0.275, -0.041>
                  }
                  
                  texture {
                     MetalBrillant
                  }
               }
            }
            
            box {
               //*PMName Trou
               <0, 0, -0.05>, <0.29, 0.05, 0>
               
               texture {
                  MetalBrillant
               }
               scale 1
               rotate <0, 0, 0>
               translate <0.5, 0.25, 0>
            }
         }
         
         union {
            //*PMName Poigne
            
            cylinder {
               <0, 0, 0>, <0, 0.4, 0>, 0.025
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            sphere {
               <0, 0, 0>, 0.025
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            sphere {
               <0, 0, 0>, 0.025
               scale 1
               rotate <0, 0, 0>
               translate y*0.4
            }
            
            cylinder {
               <0, 0, 0>, <0, 0, 0.06>, 0.02
               
               texture {
                  MetalNoir
               }
               scale 1
               rotate <0, 0, 0>
               translate y*0.05
            }
            
            cylinder {
               <0, 0, 0>, <0, 0, 0.06>, 0.02
               
               texture {
                  MetalNoir
               }
               scale 1
               rotate <0, 0, 0>
               translate y*0.35
            }
            
            pigment {
               color rgb <0.0666667, 0.0666667, 0.0666667>
            }
            
            finish {
               phong 2
               phong_size 10
               roughness 0.05
            }
            translate <1.2, 1, -0.1>
         }
         
         difference {
            //*PMName Serrure
            
            union {
               cylinder {
                  <0, 0, 0.5>, <0, 0, 0>, 0.4
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               difference {
                  box {
                     <-0.4, 1, 0>, <0.4, 0, 0.5>
                     scale 1
                     rotate <0, 0, 0>
                     translate y*(-1)
                  }
                  
                  box {
                     <0, 1, -0.01>, <0.4, 0, 0.51>
                     scale 1
                     rotate z*(-15)
                     translate <-0.8, -1, 0>
                  }
                  
                  box {
                     <-0.4, 1, -0.01>, <0, 0, 0.51>
                     scale 1
                     rotate z*15
                     translate <0.8, -1, 0>
                  }
               }
            }
            
            box {
               <-0.05, -0.5, -0.02>, <0.05, 0.5, 0.25>
               scale 1
               rotate <0, 0, 0>
               translate y*(-0.35)
            }
            
            pigment {
               color rgb <0.729412, 0.729412, 0.729412>
            }
            scale 0.05
            rotate <0, 0, 0>
            translate <1.2, 0.92, -0.05>
         }
         
         texture {
            pigment {
               color rgb <0.329412, 0.164706, 0.164706>
            }
            
            normal {
               bump_map {
                  jpeg
                  "/home/tom/RayTrace/Textures/murpeint.jpg"
                  map_type 0
                  bump_size 1
               }
               rotate z*90
               bump_size 1
            }
            
            finish {
               specular 0.2
               roughness 0.1
            }
         }
         rotate y*(-30)
         translate <-2.3, 0, 0.65>
      }
      
      difference {
         //*PMName Plafond
         
         box {
            //*PMName EntrePlafond
            <-2.3, 2.3, 0.7>, <-1, 2.299, 0.001>
            
            texture {
               BriqueTex
               rotate x*90
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         union {
            //*PMName Lampe
            
            cone {
               <0, 0.06, 0>, 0,
               <0, 0, 0>, 0.05
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            translate <-1.65, 2.29, 0.3>
         }
      }
      
      union {
         //*PMName Lampe
         
         cone {
            <0, 0.06, 0>, 0,
            <0, 0, 0>, 0.05
            open
            
            pigment {
               color rgb <1, 1, 1>
            }
            
            finish {
               ambient rgb <0.47451, 0.47451, 0.47451>
               reflection rgb <1, 1, 1>
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         light_source {
            <0, 0, 0>, rgb <1, 0.913725, 0.886275>
            spotlight
            radius 1
            falloff 60
            point_at <0, -2.3, 0>
            fade_distance 2.3
            fade_power 30
            translate y*0.02
         }
         translate <-1.65, 2.29, 0.3>
      }
   }
   
   union {
      //*PMName Fentres
      
      object {
         DecoFen
         scale 1
         rotate <0, 0, 0>
         translate <-1.5, 0.4, 0>
      }
      
      object {
         DecoFen
         scale 1
         rotate <0, 0, 0>
         translate y*0.4
      }
      
      object {
         DecoFen
         scale 1
         rotate <0, 0, 0>
         translate <1.5, 0.4, 0>
      }
      
      light_source {
         <-1.62552, 0, 0.0714516>, rgb <0.768627, 0.694118, 0.615686>
         translate z*2
      }
      translate y*4.5
   }
   
   union {
      //*PMName Vitrine
      
      object {
         CadreVitrine
         scale 1
         rotate <0, 0, 0>
         translate <0.7, 0.4, 0.2>
      }
   }
   
   union {
      //*PMName Goutire
      
      intersection {
         cylinder {
            <-2.5, 0, 0>, <2.5, 0, 0>, 0.05
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <-2.5, 0, -0.05>, <2.5, -0.05, 0.05>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
      }
      
      texture {
         MetalSale
      }
      scale 1
      translate y*5.19
   }
}

union {
   //*PMName Immeuble2
   
   union {
      //*PMName Fentre1
      
      union {
         //*PMName Deco
         
         union {
            union {
               //*PMName DecoFenetreGauche
               
               object {
                  //*PMName B2
                  UneBrique
                  scale 1
                  rotate z*92
                  translate <-0.1, -0.005, 0>
               }
               
               object {
                  //*PMName B3
                  UneBrique
                  scale 1
                  rotate z*94
                  translate <-0.2, -0.01, 0>
               }
               
               object {
                  //*PMName B4
                  UneBrique
                  scale 1
                  rotate z*96
                  translate <-0.3, -0.015, 0>
               }
               
               object {
                  //*PMName B5
                  UneBrique
                  scale 1
                  rotate z*98
                  translate <-0.4, -0.025, 0>
               }
               
               object {
                  //*PMName B6
                  UneBrique
                  scale 1
                  rotate z*100
                  translate <-0.5, -0.04, 0>
               }
            }
            
            union {
               //*PMName DecoFenetreDroit
               
               object {
                  //*PMName B1
                  UneBrique
                  scale 1
                  rotate z*90
                  translate <0, 0, 0>
               }
               
               object {
                  //*PMName B2
                  UneBrique
                  scale 1
                  rotate z*88
                  translate <0.1, -0.005, 0>
               }
               
               object {
                  //*PMName B3
                  UneBrique
                  scale 1
                  rotate z*86
                  translate <0.2, -0.01, 0>
               }
               
               object {
                  //*PMName B4
                  UneBrique
                  scale 1
                  rotate z*84
                  translate <0.3, -0.015, 0>
               }
               
               object {
                  //*PMName B5
                  UneBrique
                  scale 1
                  rotate z*82
                  translate <0.4, -0.025, 0>
               }
               
               object {
                  //*PMName B6
                  UneBrique
                  scale 1
                  rotate z*80
                  translate <0.5, -0.04, 0>
               }
            }
            translate <-3.7, 2.66, 0.18>
         }
      }
      
      union {
         //*PMName Volet
         
         union {
            //*PMName Lattes
            
            object {
               persienne2
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            object {
               persienne2
               scale 1
               rotate <0, 0, 0>
               translate y*0.21
            }
            
            object {
               persienne2
               scale 1
               rotate <0, 0, 0>
               translate y*0.42
            }
            
            object {
               persienne2
               scale 1
               rotate <0, 0, 0>
               translate y*0.63
            }
            
            object {
               persienne2
               scale 1
               rotate <0, 0, 0>
               translate y*0.84
            }
            scale <1, 1.8, 1>
            translate z*0.115
         }
         
         box {
            <-0.5, 0.01, -0.02>, <0.5, 0.05, 0>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <-0.5, -0.1, -0.02>, <0.5, 0.05, 0>
            scale 1
            rotate <0, 0, 0>
            translate <0, 1.5, -0.015>
         }
         
         box {
            <0.48, 1.5, -0.02>, <0.5, 0, -0.01>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <-0.48, 1.5, -0.02>, <-0.5, 0, -0.01>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         scale 1
         rotate <0, 0, 0>
         translate <-3.7, 1.03, 0.3>
         
         texture {
            pigment {
               color rgb <1, 1, 1>
            }
         }
      }
      
      union {
         //*PMName Rebord
         
         box {
            <-4.2, 1, 0.34>, <-3.2, 1.03, 0>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         difference {
            cylinder {
               <-4.2, 0, 0>, <-3.2, 0, 0>, 0.03
               scale 1
               rotate <0, 0, 0>
            }
            
            box {
               <-4.201, 0, -0.0301>, <-3.1999, -0.0301, 0.0301>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            translate y*1
         }
         
         texture {
            pigment {
               color rgb <0.501961, 0.501961, 0.501961>
            }
         }
         rotate x*(-3.1)
         translate z*0.02
      }
      
      box {
         //*PMName BriqueD
         <-0.501, 0, 0.3>, <-0.499, 1.5, 0>
         
         texture {
            pigment {
               image_map {
                  jpeg
                  "/home/tom/RayTrace/Textures/brick015b.jpg"
                  map_type 0
               }
               scale 0.4
               rotate y*90
               translate y*0.05
            }
         }
         scale 1
         rotate <0, 0, 0>
         translate <-2.7, 1, 0>
      }
   }
   
   union {
      //*PMName Fentre2
      
      union {
         //*PMName Deco
         
         union {
            union {
               //*PMName DecoFenetreGauche
               
               object {
                  //*PMName B2
                  UneBrique
                  scale 1
                  rotate z*92
                  translate <-0.1, -0.005, 0>
               }
               
               object {
                  //*PMName B3
                  UneBrique
                  scale 1
                  rotate z*94
                  translate <-0.2, -0.01, 0>
               }
               
               object {
                  //*PMName B4
                  UneBrique
                  scale 1
                  rotate z*96
                  translate <-0.3, -0.015, 0>
               }
               
               object {
                  //*PMName B5
                  UneBrique
                  scale 1
                  rotate z*98
                  translate <-0.4, -0.025, 0>
               }
               
               object {
                  //*PMName B6
                  UneBrique
                  scale 1
                  rotate z*100
                  translate <-0.5, -0.04, 0>
               }
            }
            
            union {
               //*PMName DecoFenetreDroit
               
               object {
                  //*PMName B1
                  UneBrique
                  scale 1
                  rotate z*90
                  translate <0, 0, 0>
               }
               
               object {
                  //*PMName B2
                  UneBrique
                  scale 1
                  rotate z*88
                  translate <0.1, -0.005, 0>
               }
               
               object {
                  //*PMName B3
                  UneBrique
                  scale 1
                  rotate z*86
                  translate <0.2, -0.01, 0>
               }
               
               object {
                  //*PMName B4
                  UneBrique
                  scale 1
                  rotate z*84
                  translate <0.3, -0.015, 0>
               }
               
               object {
                  //*PMName B5
                  UneBrique
                  scale 1
                  rotate z*82
                  translate <0.4, -0.025, 0>
               }
               
               object {
                  //*PMName B6
                  UneBrique
                  scale 1
                  rotate z*80
                  translate <0.5, -0.04, 0>
               }
            }
            translate <-3.7, 2.66, 0.18>
         }
      }
      
      union {
         //*PMName Rebord
         
         box {
            <-4.2, 1, 0.34>, <-3.2, 1.03, 0>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         difference {
            cylinder {
               <-4.2, 0, 0>, <-3.2, 0, 0>, 0.03
               scale 1
               rotate <0, 0, 0>
            }
            
            box {
               <-4.201, 0, -0.0301>, <-3.1999, -0.0301, 0.0301>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            translate y*1
         }
         
         texture {
            pigment {
               color rgb <0.501961, 0.501961, 0.501961>
            }
         }
         rotate x*(-3.1)
         translate z*0.02
      }
      
      box {
         //*PMName BriqueD
         <-0.5, 0, 0.3>, <-0.50001, 1.5, 0>
         
         texture {
            pigment {
               image_map {
                  jpeg
                  "/home/tom/RayTrace/Textures/brick015b.jpg"
                  map_type 0
               }
               scale 0.4
               rotate y*90
               translate y*0.05
            }
         }
         scale 1
         rotate <0, 0, 0>
         translate <-2.7, 1, 0>
      }
      translate y*2.6
   }
   
   difference {
      box {
         //*PMName Corps
         <-2.5, 0, 0.1>, <-5, 5.2, 4>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
         hollow false
      }
      
      box {
         <-4.2, 1, 1>, <-3.2, 2.5, 0>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         <-4.2, 1, 1>, <-3.2, 2.5, 0>
         scale 1
         rotate <0, 0, 0>
         translate y*2.6
      }
   }
   
   texture {
      pigment {
         image_map {
            jpeg
            "/home/tom/RayTrace/Textures/brick015b.jpg"
            map_type 0
         }
         scale 0.4
         translate y*0.05
      }
      
      normal {
         bump_map {
            jpeg
            "/home/tom/RayTrace/Textures/brick015.jpg"
            map_type 0
         }
         scale 0.4
         translate y*0.05
         bump_size 1
      }
   }
}

union {
   //*PMName Rverbre
   
   cone {
      <0, 0.02, 0>, 0.05,
      <0, 0, 0>, 0.06
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      <0, 1, 0>, <0, 0.02, 0>, 0.05
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cone {
      <0, 1.03, 0>, 0.03,
      <0, 1, 0>, 0.05
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      <0, 3, 0>, <0, 1.03, 0>, 0.03
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cone {
      <0, 3.05, 0>, 0.02,
      <0, 3, 0>, 0.03
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   intersection {
      //*PMName Arc
      
      torus {
         1, 0.02
         scale 1
         rotate z*90
         translate <0, 3.05, -1>
      }
      
      box {
         <-0.035, 3.05, -1>, <0.035, 4.1, 0.05>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
   }
   
   difference {
      intersection {
         //*PMName Lampe
         
         sphere {
            <0, 0, -1.05>, 0.15
            scale <0.8, 0.5, 1.1>
            rotate <0, 0, 0>
         }
         
         box {
            <-0.15, -0.02, -0.98>, <0.15, 0.1, -1.33>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         translate y*4.05
      }
      
      sphere {
         <0, 0, -1.05>, 0.13
         
         pigment {
            color rgbft <1, 1, 0.42745, 0.8, 0.8>
         }
         scale <0.8, 0.5, 1.1>
         rotate <0, 0, 0>
         translate y*4.04
         
         finish {
            diffuse 0.6
         }
      }
   }
   
   union {
      //*PMName Ampoule
      
      sphere {
         <0, 0, -1.05>, 0.1
         
         texture {
            pigment {
               color rgbft <1, 1, 1, 0.9, 0.9>
            }
         }
         scale <0.8, 0.5, 1.1>
         rotate <0, 0, 0>
         translate y*4.04
      }
      
      light_source {
         <0, 0, 0>, rgb <0.494118, 0.431373, 0.384314>
         spotlight
         radius 45
         falloff 50
         point_at <0, -3, 0>
         fade_distance 5
         fade_power 20
         translate <0, 4.07385, -1.15505>
      }
      
      light_source {
         <0, 0, 0>, rgb <0.470588, 0.470588, 0.470588>
         fade_distance 0.5
         fade_power 100
         translate <0, 4.07385, -1.15505>
      }
   }
   
   texture {
      MetalSale
   }
   scale 1.2
   rotate <0, 0, 0>
   translate <2.7, 0, -0.15>
}

#declare Pigment = pigment {
   granite
   turbulence <0.5, 0.5, 0.5>
   octaves 16
   omega 0.1
   lambda 5
   
   color_map {
      [ 0 color rgb <0.67451, 0.0470588, 0.0470588>
      ]
      [ 0.9 color rgb <0.811765, 0.243137, 0.0980392>
      ]
   }
}

#declare Vert = pigment {
   Pigment
}

#declare TexEcailles = texture {
   normal {
      bump_map {
         png
         "/home/tom/RayTrace/Textures/ecailles01.png"
         map_type 0
      }
      scale 1
      bump_size 1.4
   }
   
   pigment {
      Vert
   }
   scale 0.4
}

#declare BlancOeil = texture {
   pigment {
      color rgb <1, 1, 1>
   }
   
   finish {
      phong 1
      phong_size 50
      roughness 0.05
   }
}

#declare NoirOeil = texture {
   pigment {
      color rgb <0, 0, 0>
   }
   
   finish {
      phong 2
      phong_size 40
      roughness 0.05
      reflection rgb <0.0470588, 0.0470588, 0.0470588>
   }
}

#declare TexAiles = texture {
   pigment {
      color rgbft <0.69412, 0.55686, 0.35294, 0.05, 0.05>
   }
   
   normal {
      granite
      0.1
      turbulence <0.01, 0.01, 0.01>
   }
}

#declare BarreOreille = union {
   union {
      cylinder {
         <-0.2, 0, 0>, <0, 0, 0>, 0.005
         scale 1
         rotate <0, 0, 0>
      }
      
      sphere {
         <0, 0, 0>, 0.006
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cone {
         <-0.2, 0, 0>, 0.005,
         <-0.25, 0, 0>, 0
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      translate x*(-0.3)
      
      texture {
         TexEcailles
      }
   }
   
   cylinder {
      <-0.3, 0, 0>, <0, 0, 0>, 0.005
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   texture {
      TexEcailles
   }
}

#declare Oreille = union {
   //*PMName oreille
   
   union {
      //*PMName Peau
      
      bicubic_patch {
         type 0
         u_steps 3
         v_steps 3
         <-1.39305, 0, -2.53909>, <-0.488827, 0, -2.01117>, <0.806403, -3.66329e-18, -1.26417>, <3, 0, 0>,
         <-1.05863, -0.632264, -1.48804>, <-0.347455, -0.439836, -0.48112>, <0.747199, -0.219918, -0.801357>, <3, 0, 0>,
         <-1.34341, -0.632264, -0.782695>, <-0.312852, -0.439836, -1.18793>, <0.645654, -0.219918, -0.468748>, <3, 0, 0>,
         <-2.07551, 0, 0.00359234>, <-0.675116, 0, -0.00498425>, <0.588255, 0, -0.00232608>, <3, 0, 0>
         scale 0.1
         rotate <0, 0, 0>
         translate x*(-0.3)
      }
      
      texture {
         TexAiles
      }
   }
   
   sphere {
      <0, 0, 0>, 0.01
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   union {
      //*PMName Milieu
      
      object {
         BarreOreille
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
   }
   
   union {
      //*PMName Haut
      
      object {
         BarreOreille
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      rotate y*(-30)
   }
   scale 1
   rotate <0, 0, 0>
   translate <0, 0, 0>
}

#declare Oeil = union {
   sphere {
      //*PMName Orbites
      <0, 0, 0>, 0.2
      scale <1, 0.5, 1>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   sphere {
      //*PMName Blanc
      <0, 0, 0>, 0.155
      
      texture {
         BlancOeil
      }
      scale <1, 0.9, 1>
      rotate <0, 0, 0>
      translate y*0.066687
   }
   
   sphere {
      //*PMName Noir
      <0, 0, 0>, 0.11
      
      texture {
         NoirOeil
      }
      scale 1
      rotate <0, 0, 0>
      translate y*0.12
   }
   scale <1, 1, 1.2>
}

#declare Sourcil = cylinder {
   <0.1, 0, 0>, <-0.1, 0, 0>, 0.02
   
   pigment {
      color rgb <0, 0, 0>
   }
   scale 1
   rotate y*10
   translate x*0.05
   no_shadow
}

#declare Corne = union {
   //*PMName Corne
   
   sphere {
      <0, 0, 0>, 0.1
      scale <1, 1, 0.7>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   sphere {
      <0, 0.0213778, 0.0780111>, 0.09
      scale <1, 1, 0.7>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   sphere {
      <0, 0.0333434, 0.158395>, 0.08
      scale <1, 1, 0.7>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   sphere {
      <0, 0.0574349, 0.230891>, 0.07
      scale <1, 1, 0.7>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   sphere {
      <0, 0.0721494, 0.295621>, 0.06
      scale <1, 1, 0.7>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   scale 0.6
   rotate <0, 0, -0>
   translate <0, 0, 0>
   
   texture {
      pigment {
         color rgb <1, 0.964706, 0.890196>
      }
      
      finish {
         phong 1
         phong_size 10
      }
   }
}

#declare Tete = union {
   //*PMName Tte
   
   union {
      //*PMName Tte
      
      object {
         //*PMName CorneG
         Corne
         scale <1, 1, 1.2>
         rotate <-12.5, -19, 4.1>
         translate <-0.164938, 1.00178, 4.10743>
      }
      
      object {
         //*PMName CorneD
         Corne
         scale <1, 1, 1.2>
         rotate <-12.5, 19, 4.1>
         translate <0.16494, 1.0018, 4.1074>
      }
      
      union {
         //*PMName OreilleG
         
         object {
            Oreille
            scale 1
            rotate z*(-10)
            translate <0, 0, 0>
         }
         
         object {
            Oreille
            scale 1
            rotate <-0, -30, 5>
            translate <0, 0, 0>
         }
         
         object {
            Oreille
            scale 1
            rotate <-0, 30, 8>
            translate <0, 0, 0>
         }
         scale <0.5, 0.5, 0.7>
         rotate <-10, 16.3, -20.8>
         translate <-0.497754, 1.13491, 3.63312>
      }
      
      union {
         //*PMName OreilleD
         
         object {
            Oreille
            scale 1
            rotate z*(-8)
            translate <0, 0, 0>
         }
         
         object {
            Oreille
            scale 1
            rotate <-0, -30, -7>
            translate <0, 0, 0>
         }
         
         object {
            Oreille
            scale 1
            rotate <-0, 30, 5>
            translate <0, 0, 0>
         }
         scale <0.5, 0.5, 0.7>
         rotate <-171, 6.6, -136.2>
         translate <0.49775, 1.1349, 3.6331>
      }
      
      union {
         //*PMName Dents
         
         cone {
            <0, 0, -0.1>, 0,
            <0, 0, 0.1>, 0.1
            scale <0.5, 1, 1>
            rotate <0, 0, 0>
            translate <-0.300166, 2.17469, 3.26977>
         }
         
         cone {
            <0, 0, -0.1>, 0,
            <0, 0, 0.1>, 0.1
            scale <0.5, 1, 1>
            rotate <0, 0, 0>
            translate <0.30017, 2.1747, 3.2698>
         }
         
         cone {
            <0, 0, -0.1>, 0,
            <0, 0, 0.1>, 0.1
            scale <0.5, 1, 1>
            rotate <-180, 0, -17>
            translate <-0.243739, 2.34597, 3.29008>
         }
         
         cone {
            <0, 0, -0.1>, 0,
            <0, 0, 0.1>, 0.1
            scale <0.5, 1, 1>
            rotate <180, -0, 17>
            translate <0.24374, 2.346, 3.2901>
         }
         
         pigment {
            color rgb <1, 1, 1>
         }
      }
      
      union {
         //*PMName Sourcils
         
         object {
            Sourcil
            scale 1
            rotate <0, 0, 0>
            translate x*(-0.2)
         }
         
         object {
            Sourcil
            scale 1
            rotate z*180
            translate x*0.2
            rotate <0, 0, 0>
         }
         scale 1
         rotate <0, 0, 0>
         translate <0.00631549, 1.4979, 4.05988>
      }
      
      difference {
         //*PMName Bouche
         
         merge {
            //*PMName Crane
            
            intersection {
               sphere {
                  <0, 0, 0>, 0.6
                  
                  texture {
                     pigment {
                        Pigment
                        scale 0.4
                     }
                     
                     normal {
                        bump_map {
                           png
                           "/home/tom/RayTrace/Textures/ecailles04.png"
                           map_type 2
                        }
                        scale 0.25
                        bump_size 1.4
                     }
                  }
                  scale <0.9, 2.5, 0.8>
                  rotate <0, 0, -0>
               }
               
               box {
                  <-0.55, 0, -0.5>, <0.55, 1.51, 0.5>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               translate <-0.0131602, 1.20676, 3.27485>
            }
            
            intersection {
               sphere {
                  <0, 0, 0>, 0.6
                  
                  texture {
                     pigment {
                        Pigment
                        scale 0.4
                     }
                     
                     normal {
                        bump_map {
                           png
                           "/home/tom/RayTrace/Textures/ecailles04.png"
                           map_type 2
                        }
                        scale 0.25
                        bump_size 1.4
                     }
                  }
                  scale <0.9, 1.9, 0.8>
                  rotate <0, 0, -0>
               }
               
               box {
                  <-0.55, 0, -0.5>, <0.55, -1.2, 0.5>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               translate <-0.0131602, 1.20676, 3.27485>
            }
            
            cone {
               <0, -0.23831, -0.30384>, 0,
               <0, 0.31202, -0.30918>, 0.18
               scale <1, 1, 0.8>
               rotate <0, 0, 0>
               translate <-0.09, 2.2749, 3.745>
            }
            
            cone {
               <0, -0.23831, -0.30384>, 0,
               <0, 0.31202, -0.30918>, 0.18
               scale <1, 1, 0.8>
               rotate <0, 0, 0>
               translate <0.09, 2.2749, 3.75>
            }
         }
         
         difference {
            sphere {
               <0, 0, 0>, 0.5
               scale <1.4, 1.5, 0.2>
               rotate <0, 0, 0>
               translate <0, 2.46, 3.283>
            }
            
            box {
               <-0.703128, -0.593992, -0.344587>, <0.717638, 0.470382, 0.219637>
               scale 1
               rotate <0, 0, 0>
               translate <0, 1.19895, 3.32881>
            }
         }
         
         cone {
            <0, -0.0399358, -0.455275>, 0,
            <0, 0.400928, -0.409041>, 0.0865456
            scale 1
            rotate <0, 0, 0>
            translate <-0.0954897, 2.2111, 3.91907>
         }
         
         cone {
            <0, -0.0399358, -0.455275>, 0,
            <0, 0.400928, -0.409041>, 0.0865456
            scale 1
            rotate <0, 0, 0>
            translate <0.09549, 2.2111, 3.9191>
         }
      }
      
      torus {
         0.36186, 0.04
         scale <1.2, 1, 2.5>
         rotate x*83
         translate <0, 1.72, 3.28>
      }
      
      torus {
         0.36186, 0.04
         scale <1.2, 1, 2.5>
         rotate x*94
         translate <0, 1.7064, 3.3>
      }
      
      sphere {
         //*PMName crane
         <0, 0, 0>, 0.5
         
         texture {
            pigment {
               Pigment
               scale 0.4
            }
            
            normal {
               bump_map {
                  png
                  "/home/tom/RayTrace/Textures/ecailles03.png"
                  map_type 2
               }
               scale 0.25
               bump_size 1.4
            }
         }
         scale <1, 1.2, 1>
         rotate <0, 0, 0>
         translate <0, 0.94409, 3.6339>
      }
      
      object {
         //*PMName OeilG
         Oeil
         scale 1
         rotate <0, 0, 0>
         translate <-0.09, 1.4176, 3.85>
      }
      
      object {
         //*PMName OeilD
         Oeil
         scale 1
         rotate <0, 0, 0>
         translate <0.09, 1.4176, 3.85>
      }
   }
   rotate <-5, 0, -3.1>
   translate y*(-0.202096)
}

#declare Dragon2 = union {
   //*PMName Dragon
   
   object {
      Queue6
      scale 0.2
      rotate x*90
      translate <-0.515101, 0.15082, -4.55139>
   }
   
   union {
      //*PMName Ailes
      
      union {
         //*PMName AileG
         
         cylinder {
            <0, 0, 0>, <-4, 0, 0>, 0.05
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         bicubic_patch {
            type 0
            u_steps 3
            v_steps 3
            <-2, 0, -1>, <-1.0554, -1, 0.462914>, <1, 0, 0>, <2, 0, 2>,
            <-2, 0, 0>, <-0.963502, -0.986624, 0.888102>, <1, 0, 1>, <2, 0, 2>,
            <-2, 0, 1>, <-1.19008, -0.956472, 1.6641>, <1, 0, 2>, <2, 0, 2>,
            <-2, 0, 2>, <-1, 0, 2>, <1, 0, 2>, <2, 0, 2>
            
            texture {
               TexAiles
            }
            scale 1
            rotate <0, 0, 0>
            translate <-2, 0, -2>
         }
         
         bicubic_patch {
            type 0
            u_steps 3
            v_steps 3
            <-2, 0, -3>, <-0.90975, 0, -2.07945>, <0.88209, -0.945815, -1.65361>, <2, 0, -3>,
            <-2, 0, -1.704>, <-0.797255, -0.541502, -0.747179>, <0.10576, -0.676877, -0.019561>, <2, 0, -1>,
            <-2, 0, -0.73281>, <-0.90975, 0, 0.0794473>, <0.803933, -0.623633, 1.15678>, <2, 0, 1>,
            <-2, 0, 0.18414>, <-1, 0, 0.942294>, <1.13538, 0, 2.29605>, <2, 0, 3>
            
            texture {
               TexAiles
            }
            scale <0.6, 1, 0.5>
            rotate <0, 0, 0>
            translate <-5.2, 0, -1.5>
         }
         
         bicubic_patch {
            type 0
            u_steps 3
            v_steps 3
            <-4.314, 0, -2.99148>, <-3.03241, 0, -2.7156>, <-2.78615, -0.319202, -2.43274>, <-2, 0, -3>,
            <-4.28549, 0, -2.96269>, <-3.37132, 0, -2.90191>, <-2.69219, -0.406257, -1.88041>, <-2, 0, -1>,
            <-4.27712, 0, -2.94927>, <-3.39489, 0, -2.26561>, <-2.9205, 0, -1.1808>, <-1.9444, 0, 0.26667>,
            <-4.2517, 0, -2.89581>, <-3.4774, 0, -1.7064>, <-2.94085, 0, -0.501194>, <-1.90975, 0, 0.292492>
            
            texture {
               TexAiles
            }
            scale <0.6, 1, 0.5>
            rotate <0, 0, 0>
            translate <-5.2, 0, -1.5>
         }
         
         union {
            sphere {
               <0, 0, 0>, 0.05
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, 0, 0>, <-3, 0, 0>, 0.05
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            union {
               sphere {
                  <0, 0, 0>, 0.05
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cone {
                  <-1.93294, 0, 0.0344044>, 0.01,
                  <0, 0, 0>, 0.05
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               rotate y*(-24)
               translate x*(-3)
            }
            rotate y*(-29.4)
            translate x*(-4)
         }
         rotate <-90, 0, -33.8>
         translate x*(-0.5)
         
         texture {
            TexEcailles
         }
      }
      
      union {
         //*PMName AileD
         
         cylinder {
            <0, 0, 0>, <-4, 0, 0>, 0.05
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         bicubic_patch {
            type 0
            u_steps 3
            v_steps 3
            <-2, 0, -1>, <-0.624309, 0.95685, 0.588883>, <1, 0, 0>, <2, 0, 2>,
            <-2, 0, 0>, <-0.857994, 0.943096, 1.02558>, <1, 0, 1>, <2, 0, 2>,
            <-2, 0, 1>, <-0.778404, 0.966667, 1.64835>, <1, 0, 2>, <2, 0, 2>,
            <-2, 0, 2>, <-1, 0, 2>, <1, 0, 2>, <2, 0, 2>
            
            texture {
               TexAiles
            }
            scale 1
            rotate <0, 0, 0>
            translate <-2, 0, -2>
         }
         
         bicubic_patch {
            type 0
            u_steps 3
            v_steps 3
            <-2, 0, -3>, <-0.90975, 0, -2.07945>, <0.570639, 0.879612, -1.38001>, <2, 0, -3>,
            <-2, 0, -1.704>, <-0.90975, 0, -0.83755>, <0.491153, 0.859601, -0.26869>, <2, 0, -1>,
            <-2, 0, -0.73281>, <-0.90975, 0, 0.0794473>, <0.769171, 0.8, 0.814568>, <2, 0, 1>,
            <-2, 0, 0.18414>, <-1, 0, 0.942294>, <1.13538, 0, 2.29605>, <2, 0, 3>
            
            texture {
               TexAiles
            }
            scale <0.6, 1, 0.5>
            rotate <0, 0, 0>
            translate <-5.2, 0, -1.5>
         }
         
         bicubic_patch {
            type 0
            u_steps 3
            v_steps 3
            <-4.314, 0, -2.99148>, <-3.0987, 0.134015, -2.76885>, <-2.70563, 0.422995, -2.54266>, <-2, 0, -3>,
            <-4.28549, 0, -2.96269>, <-3.37132, 0, -2.90191>, <-2.71909, 0.26803, -1.83218>, <-2, 0, -1>,
            <-4.27712, 0, -2.94927>, <-3.39489, 0, -2.26561>, <-2.76063, 0.196086, -1.19205>, <-1.9444, 0, 0.26667>,
            <-4.2517, 0, -2.89581>, <-3.4774, 0, -1.7064>, <-2.94085, 0, -0.501194>, <-1.90975, 0, 0.292492>
            
            texture {
               TexAiles
            }
            scale <0.6, 1, 0.5>
            rotate <0, 0, 0>
            translate <-5.2, 0, -1.5>
         }
         
         union {
            sphere {
               <0, 0, 0>, 0.05
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, 0, 0>, <-3, 0, 0>, 0.05
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            union {
               sphere {
                  <0, 0, 0>, 0.05
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cone {
                  <-1.93294, 0, 0.0344044>, 0.01,
                  <0, 0, 0>, 0.05
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               rotate y*(-24)
               translate x*(-3)
            }
            rotate y*(-29.4)
            translate x*(-4)
         }
         rotate <-90, 180, 33.8>
         translate x*0.5
         
         texture {
            TexEcailles
         }
      }
      scale <0.45, 0.9, 1>
      rotate x*90
      translate <0, 0.3, 0.8>
   }
   
   object {
      //*PMName Tte
      Tete
      scale 1.1
      rotate x*(-4.9)
      translate <0, -0.604785, -0.165551>
   }
   
   union {
      //*PMName Nombril
      
      cone {
         <0, 0.07, -0.002578>, 0.0358815,
         <0, 0.102559, -0.00190263>, 0.12
         open
         scale <1, 1, 0.8>
         rotate <0, 0, 0>
         translate <0, 2.91, -1.4056>
      }
      
      sphere {
         <0, 0, 0>, 0.12
         scale <1, 1, 0.8>
         rotate <0, 0, 0>
         translate <0, 2.89307, -1.37265>
      }
      
      texture {
         pigment {
            color rgb <1, 0.776471, 0.580392>
         }
         
         normal {
            ripples
            0.1
            scale <0.4, 0.4, 0.2>
         }
      }
      translate y*0.01
   }
   
   difference {
      union {
         bicubic_patch {
            //*PMName DinoCorps
            type 1
            u_steps 6
            v_steps 6
            <0, 0, -3>, <-1, 2, -3>, <1, 2, -3>, <0, 0, -3>,
            <0, 0, -1>, <-10, 6, -2.5>, <10, 6, -2.5>, <0, 0, -1>,
            <0, 0, 1>, <-5, 3, 0>, <5, 3, 0>, <0, 0, 1>,
            <0, 0, 3>, <-1, 1.5, 3>, <1, 1.5, 3>, <0, 0, 3>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
            
            texture {
               normal {
                  bump_map {
                     png
                     "/home/tom/RayTrace/Textures/ecailles08.png"
                     map_type 2
                  }
                  scale <0.5, 1, 1>
                  rotate x*45
                  bump_size 1.4
               }
               
               pigment {
                  Pigment
                  scale 0.4
               }
            }
         }
         
         bicubic_patch {
            //*PMName DinoCorps2
            type 1
            u_steps 6
            v_steps 6
            <0, 0, -3>, <-1, 2.03333, -2.93333>, <1, 2.03333, -2.93333>, <0, 0, -3>,
            <0, 0, -1>, <-10, 6, -2.5>, <10, 6, -2.5>, <0, 0, -1>,
            <0, 0, 1>, <-4.3, 3.1, 0>, <4.3, 3.1, 0>, <0, 0, 1>,
            <0, 0, 3>, <-1, 1.73094, 2.43333>, <1, 1.73094, 2.43333>, <0, 0, 3>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
      }
      
      cone {
         <0, 0, 0>, 0.1,
         <0, 0.1, 0>, 0.12
         scale <1, 1, 0.8>
         rotate <0, 0, 0>
         translate <0, 2.93, -1.4056>
      }
      
      texture {
         pigment {
            color rgb <1, 0.776471, 0.580392>
         }
         
         normal {
            ripples
            0.1
            scale <0.4, 0.4, 0.2>
         }
      }
   }
   
   union {
      //*PMName Bras
      
      union {
         //*PMName Axe
         
         cylinder {
            <0, 0, 1.15>, <0, 0, -1.15>, 0.4
            scale 1
            rotate y*(-90)
            translate <0, 0, 0>
         }
         
         sphere {
            <0, 0, 0>, 0.4
            scale 1
            rotate <0, 0, 0>
            translate x*(-1.15)
         }
         
         cone {
            <0, 0.7, 0>, 0,
            <0, -0.2, 0>, 0.4
            translate y*0.2
            scale <1, 1, 0.7>
            rotate z*(-30)
            translate x*(-1.15)
         }
         
         sphere {
            <0, 0, 0>, 0.4
            scale 1
            rotate <0, 0, 0>
            translate x*1.15
         }
         
         cone {
            <0, 0.7, 0>, 0,
            <0, -0.2, 0>, 0.4
            translate y*0.2
            scale <1, 1, 0.7>
            rotate z*30
            translate x*1.15
         }
      }
      
      union {
         //*PMName AvBrasG
         
         sphere {
            <0, 0, 0>, 0.265
            scale <0.7, 1, 1>
            rotate <0, 0, 0>
            translate <-0.1, -1.1836, 0>
         }
         
         sor {
            4,
            <0.26473, -1.30968>, <0.26473, -1.18357>, <0.37466, 0>, <0.22824, -0.71569>
            scale <0.7, 1, 1>
            rotate <0, 0, 0>
            translate x*(-0.1)
         }
         
         union {
            //*PMName Main
            
            sor {
               4,
               <0, -0.348159>, <0.0988416, -1.03896>, <0.23219, 0>, <0.0049944, 0.32825>
               scale <0.7, 1, 1>
            }
            
            union {
               //*PMName Doigts
               
               union {
                  //*PMName billet
                  
                  bicubic_patch {
                     type 0
                     u_steps 3
                     v_steps 3
                     <-3.0025, 0.386926, -3.23196>, <-1, 0, -3>, <1, 0, -3>, <2.99841, 0.23821, -3.16466>,
                     <-3, 0, -1>, <-1, 0, -1>, <1, 0, -1>, <3, 0, -1>,
                     <-3, 0, 1>, <-1, 0, 1>, <1, 0, 1>, <2.99887, 0.225573, 1.00024>,
                     <-3.00364, 0.57723, 2.69328>, <-1, 0, 3>, <1, 0, 3>, <2.94757, 0.313551, 2.7591>
                     translate <3, 3, 3>
                     rotate x*90
                     translate <0, 0, 0>
                  }
                  
                  texture {
                     pigment {
                        image_map {
                           jpeg
                           "/home/tom/RayTrace/Textures/billet.jpg"
                           map_type 0
                        }
                        scale 6
                     }
                  }
                  scale <1, 0.56, 1>
                  scale 0.09
                  rotate <-43.4, 90, 0>
                  translate <-0.160874, -0.345694, 0.28883>
               }
               
               union {
                  //*PMName billet
                  
                  bicubic_patch {
                     type 0
                     u_steps 3
                     v_steps 3
                     <-3.0025, 0.386926, -3.23196>, <-1, 0, -3>, <1, 0, -3>, <2.99841, 0.23821, -3.16466>,
                     <-3, 0, -1>, <-1, 0, -1>, <1, 0, -1>, <3, 0, -1>,
                     <-3, 0, 1>, <-1, 0, 1>, <1, 0, 1>, <2.99887, 0.225573, 1.00024>,
                     <-3.00364, 0.57723, 2.69328>, <-1, 0, 3>, <1, 0, 3>, <2.9483, 0.265289, 2.99632>
                     translate <3, 3, 3>
                     rotate x*90
                     translate <0, 0, 0>
                  }
                  
                  texture {
                     pigment {
                        image_map {
                           jpeg
                           "/home/tom/RayTrace/Textures/billet.jpg"
                           map_type 0
                        }
                        scale 6
                     }
                  }
                  scale <1, 0.56, 1>
                  scale 0.09
                  rotate <-43.4, 90, 0>
                  translate <-0.155232, -0.338449, 0.275047>
               }
               
               union {
                  //*PMName billet
                  
                  bicubic_patch {
                     type 0
                     u_steps 3
                     v_steps 3
                     <-3.0025, 0.386926, -3.23196>, <-1, 0, -3>, <1, 0, -3>, <2.99841, 0.23821, -3.16466>,
                     <-3, 0, -1>, <-1, 0, -1>, <1, 0, -1>, <3, 0, -1>,
                     <-3, 0, 1>, <-1, 0, 1>, <1, 0, 1>, <2.99887, 0.225573, 1.00024>,
                     <-3.00364, 0.57723, 2.69328>, <-1, 0, 3>, <1, 0, 3>, <2.9483, 0.265289, 2.99632>
                     translate <3, 3, 3>
                     rotate x*90
                     translate <0, 0, 0>
                  }
                  
                  texture {
                     pigment {
                        image_map {
                           jpeg
                           "/home/tom/RayTrace/Textures/billet.jpg"
                           map_type 0
                        }
                        scale 6
                     }
                  }
                  scale <1, 0.56, 1>
                  scale 0.09
                  rotate <-43.4, 90, 0>
                  translate <-0.15266, -0.334693, 0.285452>
               }
               
               sphere {
                  <0, 0, 0>, 0.2
                  scale <0.4, 1, 0.8>
                  rotate <0, 0, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.2
                  scale <0.4, 0.5, 0.3>
                  rotate <0, 0, 0>
                  translate <0.0237449, -0.0270751, -0.0744565>
               }
               
               union {
                  //*PMName TiDoigt
                  
                  sphere {
                     <0, 0, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  cylinder {
                     <0, 0, 0>, <0, -0.4, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     //*PMName D2
                     
                     sphere {
                        <0, 0, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     cylinder {
                        <0, 0, 0>, <0, -0.3, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     union {
                        //*PMName D3
                        
                        sphere {
                           <0, 0, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cylinder {
                           <0, 0, 0>, <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cone {
                           <0, -0.2, 0>, 0,
                           <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        rotate z*10
                        translate y*(-0.3)
                     }
                     rotate <0.6, 1, 24.1>
                     translate y*(-0.4)
                  }
                  scale <0.4, 0.3, 0.4>
                  rotate <-4.5, -7, 20.3>
                  translate <0, -0.131592, 0.0996585>
               }
               
               union {
                  //*PMName Ori
                  
                  sphere {
                     <0, 0, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  cylinder {
                     <0, 0, 0>, <0, -0.4, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     //*PMName D2
                     
                     sphere {
                        <0, 0, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     cylinder {
                        <0, 0, 0>, <0, -0.3, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     union {
                        //*PMName D3
                        
                        sphere {
                           <0, 0, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cylinder {
                           <0, 0, 0>, <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cone {
                           <0, -0.2, 0>, 0,
                           <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        rotate z*25
                        translate y*(-0.3)
                     }
                     rotate <0.1, 0, 20.8>
                     translate y*(-0.4)
                  }
                  scale 0.4
                  rotate z*31
                  translate <0, -0.158386, 0.0505357>
               }
               
               union {
                  //*PMName Majeur
                  
                  sphere {
                     <0, 0, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  cylinder {
                     <0, 0, 0>, <0, -0.4, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     //*PMName D2
                     
                     sphere {
                        <0, 0, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     cylinder {
                        <0, 0, 0>, <0, -0.3, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     union {
                        //*PMName D3
                        
                        sphere {
                           <0, 0, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cylinder {
                           <0, 0, 0>, <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cone {
                           <0, -0.2, 0>, 0,
                           <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        rotate z*8
                        translate y*(-0.3)
                     }
                     rotate z*20.8
                     translate y*(-0.4)
                  }
                  scale <0.4, 0.42, 0.4>
                  rotate <1.9, 1.4, 35.2>
                  translate <0, -0.174017, 0.00141276>
               }
               
               union {
                  //*PMName Index
                  
                  sphere {
                     <0, 0, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  cylinder {
                     <0, 0, 0>, <0, -0.4, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     //*PMName D2
                     
                     sphere {
                        <0, 0, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     cylinder {
                        <0, 0, 0>, <0, -0.3, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     union {
                        //*PMName D3
                        
                        sphere {
                           <0, 0, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cylinder {
                           <0, 0, 0>, <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cone {
                           <0, -0.2, 0>, 0,
                           <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        rotate z*10
                        translate y*(-0.3)
                     }
                     rotate <-6.7, -1.5, 31.5>
                     translate y*(-0.4)
                  }
                  scale <0.4, 0.36, 0.4>
                  rotate <9.1, 10.9, 29.1>
                  translate <0, -0.167318, -0.0454773>
               }
               
               union {
                  //*PMName Pouce
                  
                  sphere {
                     <0, 0, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  cylinder {
                     <0, 0, 0>, <0, -0.4, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     //*PMName D2
                     
                     sphere {
                        <0, 0, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     cylinder {
                        <0, 0, 0>, <0, -0.2, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     union {
                        //*PMName D3
                        
                        sphere {
                           <0, 0, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cylinder {
                           <0, 0, 0>, <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cone {
                           <0, -0.2, 0>, 0,
                           <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        rotate x*(-10)
                        translate y*(-0.2)
                     }
                     rotate <-13.5, -4.4, -0.4>
                     translate y*(-0.4)
                  }
                  scale <0.5, 0.34, 0.5>
                  rotate <20.9, -6.9, 36.9>
                  translate <0.0570246, -0.0373954, -0.0742163>
               }
               scale <1.3, 1, 1.3>
               translate y*(-1.039)
            }
            rotate <40, -20, 0>
            translate <-0.1, -1.1836, 0>
         }
         rotate <25.5, 7.3, -34.7>
         translate x*(-1.15)
      }
      
      union {
         //*PMName AvBrasD
         
         sphere {
            //*PMName Coude
            <0, 0, 0>, 0.265
            scale <0.7, 1, 1>
            rotate <0, 0, 0>
            translate <0.1, -1.1836, 0>
         }
         
         sor {
            //*PMName Bras
            4,
            <0.26473, -1.3097>, <0.26473, -1.1836>, <0.37466, 0>, <0.22824, -0.71569>
            scale <0.7, 1, 1>
            rotate <0, 0, 0>
            translate x*0.1
         }
         
         union {
            //*PMName Main
            
            sor {
               4,
               <0, -0.348159>, <0.0988416, -1.03896>, <0.23219, 0>, <0.0049944, 0.32825>
               scale <0.7, 1, 1>
            }
            
            union {
               //*PMName Doigts
               
               sphere {
                  <0, 0, 0>, 0.2
                  scale <0.4, 1, 0.8>
                  rotate <0, 0, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.2
                  scale <0.4, 0.5, 0.3>
                  rotate <0, 0, 0>
                  translate <-0.023745, -0.027075, -0.074456>
               }
               
               union {
                  //*PMName TiDoigt
                  
                  sphere {
                     <0, 0, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  cylinder {
                     <0, 0, 0>, <0, -0.4, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     //*PMName D2
                     
                     sphere {
                        <0, 0, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     cylinder {
                        <0, 0, 0>, <0, -0.3, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     union {
                        //*PMName D3
                        
                        sphere {
                           <0, 0, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cylinder {
                           <0, 0, 0>, <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cone {
                           <0, -0.2, 0>, 0,
                           <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        rotate z*(-10)
                        translate y*(-0.3)
                     }
                     rotate z*(-30)
                     translate y*(-0.4)
                  }
                  scale <0.4, 0.3, 0.4>
                  rotate <-6, 0, -30>
                  translate <0, -0.131592, 0.0996585>
               }
               
               union {
                  //*PMName Ori
                  
                  sphere {
                     <0, 0, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  cylinder {
                     <0, 0, 0>, <0, -0.4, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     //*PMName D2
                     
                     sphere {
                        <0, 0, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     cylinder {
                        <0, 0, 0>, <0, -0.3, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     union {
                        //*PMName D3
                        
                        sphere {
                           <0, 0, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cylinder {
                           <0, 0, 0>, <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cone {
                           <0, -0.2, 0>, 0,
                           <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        rotate z*(-25)
                        translate y*(-0.3)
                     }
                     rotate z*(-30)
                     translate y*(-0.4)
                  }
                  scale 0.4
                  rotate z*(-35)
                  translate <0, -0.158386, 0.0505357>
               }
               
               union {
                  //*PMName Majeur
                  
                  sphere {
                     <0, 0, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  cylinder {
                     <0, 0, 0>, <0, -0.4, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     //*PMName D2
                     
                     sphere {
                        <0, 0, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     cylinder {
                        <0, 0, 0>, <0, -0.3, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     union {
                        //*PMName D3
                        
                        sphere {
                           <0, 0, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cylinder {
                           <0, 0, 0>, <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cone {
                           <0, -0.2, 0>, 0,
                           <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        rotate z*(-8)
                        translate y*(-0.3)
                     }
                     rotate z*(-35)
                     translate y*(-0.4)
                  }
                  scale <0.4, 0.42, 0.4>
                  rotate z*(-25)
                  translate <0, -0.174017, 0.00141276>
               }
               
               union {
                  //*PMName Index
                  
                  sphere {
                     <0, 0, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  cylinder {
                     <0, 0, 0>, <0, -0.4, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     //*PMName D2
                     
                     sphere {
                        <0, 0, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     cylinder {
                        <0, 0, 0>, <0, -0.3, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     union {
                        //*PMName D3
                        
                        sphere {
                           <0, 0, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cylinder {
                           <0, 0, 0>, <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cone {
                           <0, -0.2, 0>, 0,
                           <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        rotate z*(-10)
                        translate y*(-0.3)
                     }
                     rotate z*(-35)
                     translate y*(-0.4)
                  }
                  scale <0.4, 0.36, 0.4>
                  rotate z*(-34)
                  translate <0, -0.167318, -0.0454773>
               }
               
               union {
                  //*PMName Pouce
                  
                  sphere {
                     <0, 0, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  cylinder {
                     <0, 0, 0>, <0, -0.4, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     //*PMName D2
                     
                     sphere {
                        <0, 0, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     cylinder {
                        <0, 0, 0>, <0, -0.2, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     union {
                        //*PMName D3
                        
                        sphere {
                           <0, 0, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cylinder {
                           <0, 0, 0>, <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cone {
                           <0, -0.2, 0>, 0,
                           <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        rotate x*(-10)
                        translate y*(-0.2)
                     }
                     rotate x*(-25)
                     translate y*(-0.4)
                  }
                  scale <0.5, 0.34, 0.5>
                  rotate z*(-20)
                  translate <-0.057025, -0.037395, -0.074216>
               }
               scale <1.3, 1, 1.3>
               translate y*(-1.039)
            }
            rotate x*35
            translate <0.1, -1.1836, 0>
         }
         rotate <-30, 0, 22>
         translate x*1.15
      }
      rotate <90, 0, -5>
      translate <0, 1.1, 1.2>
   }
   
   union {
      //*PMName JambeG
      
      sor {
         //*PMName Jambe
         4,
         <0.0031515, -0.55626>, <0.5, -0.10431>, <0.48969, 1.1769>, <0.74272, 1.5074>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      union {
         //*PMName Bas
         
         sor {
            //*PMName Tibia
            4,
            <0, -2.2617>, <0.47223, -0.13067>, <0.21894, 1.204>, <0.79687, 1.9948>
            scale 1
            translate <0, 1.40412, -0.0253477>
         }
         
         union {
            //*PMName Pied
            
            sphere {
               <0, 0, 0>, 0.25
               scale <1, 0.5, 1>
               rotate x*(-9.9)
               translate <0, -0.042944, -0.113777>
            }
            
            difference {
               sphere {
                  <0, 0, 0.25>, 0.5
                  scale <0.7, 0.4, 1>
                  rotate <0, -0, 0>
                  translate <0, 0, 0>
               }
               
               box {
                  <-0.5, 0, -0.5>, <0.5, 0.5, 0.5>
                  scale <0.7, 0.4, 1>
                  rotate <0, 0, 0>
                  translate z*0.25
               }
            }
            
            sphere {
               <0, 0, 0.25>, 0.5
               scale <0.7, 0.2, 1>
               rotate <0, -0, 0>
               translate <0, 0, 0>
            }
            
            sphere {
               <0.0387198, -0.0176596, -0.0291941>, 0.135973
               scale <0.7, 0.5, 1>
               rotate <0, 0, 0>
               translate <0.18, 0.03, 0.7>
            }
            
            sphere {
               <0.026939, -0.0067821, -0.028391>, 0.11
               scale <0.7, 0.5, 1>
               rotate <0, 0, 0>
               translate <0.04, 0.03, 0.75>
            }
            
            sphere {
               <0.03872, -0.01766, -0.029194>, 0.1
               scale <0.7, 0.5, 1>
               rotate <0, 0, 0>
               translate <-0.11, 0.03, 0.75>
            }
            
            sphere {
               <0.03872, -0.01766, -0.029194>, 0.09
               scale <0.7, 0.5, 1>
               rotate <0.2, -12.3, 1.8>
               translate <-0.238333, 0.03, 0.7>
            }
            rotate x*33
            translate <0, 2.51773, 0.091387>
         }
         rotate x*(-19.6)
         translate <0, 0.176933, 0.406901>
      }
      
      sphere {
         //*PMName Genou
         <0, 1.3059, -0.0082828>, 0.58
         scale <0.9, 1, 0.9>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      rotate x*(-111.6)
      translate <-0.545943, 1.03296, -2.43036>
   }
   
   union {
      //*PMName JambeD
      
      sor {
         //*PMName Jambe
         4,
         <0.0031515, -0.55626>, <0.5, -0.10431>, <0.48969, 1.1769>, <0.74272, 1.5074>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      union {
         //*PMName Bas
         
         sor {
            //*PMName Tibia
            4,
            <0, -2.2617>, <0.47223, -0.13067>, <0.21894, 1.204>, <0.79687, 1.9948>
            scale 1
            translate <0, 0.0365439, 0.0177351>
         }
         
         union {
            //*PMName Pied
            
            sphere {
               <0, 0, 0>, 0.25
               scale <1, 0.5, 1>
               rotate x*(-9.9)
               translate <0, -0.042944, -0.113777>
            }
            
            difference {
               sphere {
                  <0, 0, 0.25>, 0.5
                  scale <0.7, 0.4, 1>
                  rotate <0, -0, 0>
                  translate <0, 0, 0>
               }
               
               box {
                  <-0.5, 0, -0.5>, <0.5, 0.5, 0.5>
                  scale <0.7, 0.4, 1>
                  rotate <0, 0, 0>
                  translate z*0.25
               }
            }
            
            sphere {
               <0, 0, 0.25>, 0.5
               scale <0.7, 0.2, 1>
               rotate <0, -0, 0>
               translate <0, 0, 0>
            }
            
            sphere {
               <0.0387198, -0.0176596, -0.0291941>, 0.135973
               scale <0.7, 0.5, 1>
               rotate <0, 0, 0>
               translate <-0.284749, 0.0299785, 0.701251>
            }
            
            sphere {
               <0.026939, -0.0067821, -0.028391>, 0.11
               scale <0.7, 0.5, 1>
               rotate <0, 0, 0>
               translate <-0.110996, 0.0253482, 0.751425>
            }
            
            sphere {
               <0.03872, -0.01766, -0.029194>, 0.1
               scale <0.7, 0.5, 1>
               rotate <0, 0, 0>
               translate <0.0374734, 0.0343501, 0.765736>
            }
            
            sphere {
               <0.03872, -0.01766, -0.029194>, 0.09
               scale <0.7, 0.5, 1>
               rotate <0.2, 12.3, 1.8>
               translate <0.183572, 0.0433204, 0.704989>
            }
            rotate x*1.6
            translate <0, 1.2345, 0.12492>
         }
         rotate x*(-28.3)
         translate <0, 1.45482, -0.0482014>
      }
      
      sphere {
         //*PMName Genou
         <0, 1.3059, -0.0082828>, 0.58
         scale <0.9, 1, 0.9>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      rotate x*(-44.4)
      translate <0.54594, 1.033, -2.4304>
   }
}

#declare Dragon = union {
   //*PMName Dragon
   
   object {
      Queue6
      scale 0.2
      rotate x*90
      translate <-0.515101, 0.15082, -4.55139>
   }
   
   union {
      //*PMName Ailes
      
      union {
         //*PMName AileG
         
         cylinder {
            <0, 0, 0>, <-4, 0, 0>, 0.05
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         bicubic_patch {
            type 0
            u_steps 3
            v_steps 3
            <-2, 0, -1>, <-1.0554, -1, 0.462914>, <1, 0, 0>, <2, 0, 2>,
            <-2, 0, 0>, <-0.963502, -0.986624, 0.888102>, <1, 0, 1>, <2, 0, 2>,
            <-2, 0, 1>, <-1.19008, -0.956472, 1.6641>, <1, 0, 2>, <2, 0, 2>,
            <-2, 0, 2>, <-1, 0, 2>, <1, 0, 2>, <2, 0, 2>
            
            texture {
               TexAiles
            }
            scale 1
            rotate <0, 0, 0>
            translate <-2, 0, -2>
         }
         
         bicubic_patch {
            type 0
            u_steps 3
            v_steps 3
            <-2, 0, -3>, <-0.90975, 0, -2.07945>, <0.88209, -0.945815, -1.65361>, <2, 0, -3>,
            <-2, 0, -1.704>, <-0.797255, -0.541502, -0.747179>, <0.10576, -0.676877, -0.019561>, <2, 0, -1>,
            <-2, 0, -0.73281>, <-0.90975, 0, 0.0794473>, <0.803933, -0.623633, 1.15678>, <2, 0, 1>,
            <-2, 0, 0.18414>, <-1, 0, 0.942294>, <1.13538, 0, 2.29605>, <2, 0, 3>
            
            texture {
               TexAiles
            }
            scale <0.6, 1, 0.5>
            rotate <0, 0, 0>
            translate <-5.2, 0, -1.5>
         }
         
         bicubic_patch {
            type 0
            u_steps 3
            v_steps 3
            <-4.314, 0, -2.99148>, <-3.03241, 0, -2.7156>, <-2.78615, -0.319202, -2.43274>, <-2, 0, -3>,
            <-4.28549, 0, -2.96269>, <-3.37132, 0, -2.90191>, <-2.69219, -0.406257, -1.88041>, <-2, 0, -1>,
            <-4.27712, 0, -2.94927>, <-3.39489, 0, -2.26561>, <-2.9205, 0, -1.1808>, <-1.9444, 0, 0.26667>,
            <-4.2517, 0, -2.89581>, <-3.4774, 0, -1.7064>, <-2.94085, 0, -0.501194>, <-1.90975, 0, 0.292492>
            
            texture {
               TexAiles
            }
            scale <0.6, 1, 0.5>
            rotate <0, 0, 0>
            translate <-5.2, 0, -1.5>
         }
         
         union {
            sphere {
               <0, 0, 0>, 0.05
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, 0, 0>, <-3, 0, 0>, 0.05
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            union {
               sphere {
                  <0, 0, 0>, 0.05
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cone {
                  <-1.93294, 0, 0.0344044>, 0.01,
                  <0, 0, 0>, 0.05
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               rotate y*(-24)
               translate x*(-3)
            }
            rotate y*(-29.4)
            translate x*(-4)
         }
         rotate <-90, 0, -33.8>
         translate x*(-0.5)
         
         texture {
            TexEcailles
         }
      }
      
      union {
         //*PMName AileD
         
         cylinder {
            <0, 0, 0>, <-4, 0, 0>, 0.05
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         bicubic_patch {
            type 0
            u_steps 3
            v_steps 3
            <-2, 0, -1>, <-0.624309, 0.95685, 0.588883>, <1, 0, 0>, <2, 0, 2>,
            <-2, 0, 0>, <-0.857994, 0.943096, 1.02558>, <1, 0, 1>, <2, 0, 2>,
            <-2, 0, 1>, <-0.778404, 0.966667, 1.64835>, <1, 0, 2>, <2, 0, 2>,
            <-2, 0, 2>, <-1, 0, 2>, <1, 0, 2>, <2, 0, 2>
            
            texture {
               TexAiles
            }
            scale 1
            rotate <0, 0, 0>
            translate <-2, 0, -2>
         }
         
         bicubic_patch {
            type 0
            u_steps 3
            v_steps 3
            <-2, 0, -3>, <-0.90975, 0, -2.07945>, <0.570639, 0.879612, -1.38001>, <2, 0, -3>,
            <-2, 0, -1.704>, <-0.90975, 0, -0.83755>, <0.491153, 0.859601, -0.26869>, <2, 0, -1>,
            <-2, 0, -0.73281>, <-0.90975, 0, 0.0794473>, <0.769171, 0.8, 0.814568>, <2, 0, 1>,
            <-2, 0, 0.18414>, <-1, 0, 0.942294>, <1.13538, 0, 2.29605>, <2, 0, 3>
            
            texture {
               TexAiles
            }
            scale <0.6, 1, 0.5>
            rotate <0, 0, 0>
            translate <-5.2, 0, -1.5>
         }
         
         bicubic_patch {
            type 0
            u_steps 3
            v_steps 3
            <-4.314, 0, -2.99148>, <-3.0987, 0.134015, -2.76885>, <-2.70563, 0.422995, -2.54266>, <-2, 0, -3>,
            <-4.28549, 0, -2.96269>, <-3.37132, 0, -2.90191>, <-2.71909, 0.26803, -1.83218>, <-2, 0, -1>,
            <-4.27712, 0, -2.94927>, <-3.39489, 0, -2.26561>, <-2.76063, 0.196086, -1.19205>, <-1.9444, 0, 0.26667>,
            <-4.2517, 0, -2.89581>, <-3.4774, 0, -1.7064>, <-2.94085, 0, -0.501194>, <-1.90975, 0, 0.292492>
            
            texture {
               TexAiles
            }
            scale <0.6, 1, 0.5>
            rotate <0, 0, 0>
            translate <-5.2, 0, -1.5>
         }
         
         union {
            sphere {
               <0, 0, 0>, 0.05
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cylinder {
               <0, 0, 0>, <-3, 0, 0>, 0.05
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            union {
               sphere {
                  <0, 0, 0>, 0.05
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cone {
                  <-1.93294, 0, 0.0344044>, 0.01,
                  <0, 0, 0>, 0.05
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               rotate y*(-24)
               translate x*(-3)
            }
            rotate y*(-29.4)
            translate x*(-4)
         }
         rotate <-90, 180, 33.8>
         translate x*0.5
         
         texture {
            TexEcailles
         }
      }
      scale <0.45, 0.9, 1>
      rotate x*90
      translate <0, 0.3, 0.8>
   }
   
   object {
      //*PMName Tte
      Tete
      scale 1.1
      rotate x*(-4.9)
      translate <0, -0.604785, -0.165551>
   }
   
   union {
      //*PMName Nombril
      
      cone {
         <0, 0.07, -0.002578>, 0.0358815,
         <0, 0.105717, -0.00190263>, 0.115097
         open
         scale <1, 1, 0.8>
         rotate <0, 0, 0>
         translate <0, 2.91, -1.4056>
      }
      
      sphere {
         <0, 0, 0>, 0.12
         scale <1, 1, 0.8>
         rotate <0, 0, 0>
         translate <0, 2.89307, -1.37265>
      }
      
      texture {
         pigment {
            color rgb <1, 0.776471, 0.580392>
         }
         
         normal {
            ripples
            0.1
            scale <0.4, 0.4, 0.2>
         }
      }
      translate y*0.01
   }
   
   difference {
      union {
         bicubic_patch {
            //*PMName DinoCorps
            type 1
            u_steps 6
            v_steps 6
            <0, 0, -3>, <-1, 2, -3>, <1, 2, -3>, <0, 0, -3>,
            <0, 0, -1>, <-10, 6, -2.5>, <10, 6, -2.5>, <0, 0, -1>,
            <0, 0, 1>, <-5, 3, 0>, <5, 3, 0>, <0, 0, 1>,
            <0, 0, 3>, <-1, 1.5, 3>, <1, 1.5, 3>, <0, 0, 3>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
            
            texture {
               normal {
                  bump_map {
                     png
                     "/home/tom/RayTrace/Textures/ecailles08.png"
                     map_type 2
                  }
                  scale <0.5, 1, 1>
                  rotate x*45
                  bump_size 1.4
               }
               
               pigment {
                  Pigment
                  scale 0.4
               }
            }
         }
         
         bicubic_patch {
            //*PMName DinoCorps2
            type 1
            u_steps 6
            v_steps 6
            <0, 0, -3>, <-1, 2.0333, -2.9333>, <1, 2.0333, -2.9333>, <0, 0, -3>,
            <0, 0, -1>, <-10, 6, -2.5>, <10, 6, -2.5>, <0, 0, -1>,
            <0, 0, 1>, <-4.2, 3.1, 0>, <4.2, 3.1, 0>, <0, 0, 1>,
            <0, 0, 3>, <-1.1, 1.7, 2.45>, <1.1, 1.7, 2.45>, <0, 0, 3>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
      }
      
      cone {
         <0, 0, 0>, 0.1,
         <0, 0.104419, 0.00184142>, 0.12
         scale <1, 1, 0.8>
         rotate <0, 0, 0>
         translate <0, 2.93, -1.4056>
      }
      
      texture {
         pigment {
            color rgb <1, 0.776471, 0.580392>
         }
         
         normal {
            ripples
            0.1
            scale <0.4, 0.4, 0.2>
         }
      }
   }
   
   union {
      //*PMName Bras
      
      union {
         //*PMName Axe
         
         cylinder {
            <0, 0, 1.15>, <0, 0, -1.15>, 0.4
            scale 1
            rotate y*(-90)
            translate <0, 0, 0>
         }
         
         sphere {
            <0, 0, 0>, 0.4
            scale 1
            rotate <0, 0, 0>
            translate x*(-1.15)
         }
         
         cone {
            <0, 0.7, 0>, 0,
            <0, -0.2, 0>, 0.4
            translate y*0.2
            scale <1, 1, 0.7>
            rotate z*(-30)
            translate x*(-1.15)
         }
         
         sphere {
            <0, 0, 0>, 0.4
            scale 1
            rotate <0, 0, 0>
            translate x*1.15
         }
         
         cone {
            <0, 0.7, 0>, 0,
            <0, -0.2, 0>, 0.4
            translate y*0.2
            scale <1, 1, 0.7>
            rotate z*30
            translate x*1.15
         }
      }
      
      union {
         //*PMName AvBrasG
         
         sphere {
            <0, 0, 0>, 0.265
            scale <0.7, 1, 1>
            rotate <0, 0, 0>
            translate <-0.1, -1.1836, 0>
         }
         
         sor {
            4,
            <0.26473, -1.30968>, <0.26473, -1.18357>, <0.37466, 0>, <0.22824, -0.71569>
            scale <0.7, 1, 1>
            rotate <0, 0, 0>
            translate x*(-0.1)
         }
         
         union {
            //*PMName Main
            
            sor {
               4,
               <0, -0.348159>, <0.0988416, -1.03896>, <0.23219, 0>, <0.0049944, 0.32825>
               scale <0.7, 1, 1>
            }
            
            union {
               //*PMName Doigts
               
               union {
                  //*PMName billet
                  
                  bicubic_patch {
                     type 0
                     u_steps 3
                     v_steps 3
                     <-3.0025, 0.386926, -3.23196>, <-1, 0, -3>, <1, 0, -3>, <2.99841, 0.23821, -3.16466>,
                     <-3, 0, -1>, <-1, 0, -1>, <1, 0, -1>, <3, 0, -1>,
                     <-3, 0, 1>, <-1, 0, 1>, <1, 0, 1>, <2.99887, 0.225573, 1.00024>,
                     <-3.00364, 0.57723, 2.69328>, <-1, 0, 3>, <1, 0, 3>, <2.94757, 0.313551, 2.7591>
                     translate <3, 3, 3>
                     rotate x*90
                     translate <0, 0, 0>
                  }
                  
                  texture {
                     pigment {
                        image_map {
                           jpeg
                           "/home/tom/RayTrace/Textures/billet.jpg"
                           map_type 0
                        }
                        scale 6
                     }
                  }
                  scale <1, 0.56, 1>
                  scale 0.09
                  rotate <-43.4, 90, 0>
                  translate <-0.160874, -0.345694, 0.28883>
               }
               
               union {
                  //*PMName billet
                  
                  bicubic_patch {
                     type 0
                     u_steps 3
                     v_steps 3
                     <-3.0025, 0.386926, -3.23196>, <-1, 0, -3>, <1, 0, -3>, <2.99841, 0.23821, -3.16466>,
                     <-3, 0, -1>, <-1, 0, -1>, <1, 0, -1>, <3, 0, -1>,
                     <-3, 0, 1>, <-1, 0, 1>, <1, 0, 1>, <2.99887, 0.225573, 1.00024>,
                     <-3.00364, 0.57723, 2.69328>, <-1, 0, 3>, <1, 0, 3>, <2.9483, 0.265289, 2.99632>
                     translate <3, 3, 3>
                     rotate x*90
                     translate <0, 0, 0>
                  }
                  
                  texture {
                     pigment {
                        image_map {
                           jpeg
                           "/home/tom/RayTrace/Textures/billet.jpg"
                           map_type 0
                        }
                        scale 6
                     }
                  }
                  scale <1, 0.56, 1>
                  scale 0.09
                  rotate <-43.4, 90, 0>
                  translate <-0.155232, -0.338449, 0.275047>
               }
               
               union {
                  //*PMName billet
                  
                  bicubic_patch {
                     type 0
                     u_steps 3
                     v_steps 3
                     <-3.0025, 0.386926, -3.23196>, <-1, 0, -3>, <1, 0, -3>, <2.99841, 0.23821, -3.16466>,
                     <-3, 0, -1>, <-1, 0, -1>, <1, 0, -1>, <3, 0, -1>,
                     <-3, 0, 1>, <-1, 0, 1>, <1, 0, 1>, <2.99887, 0.225573, 1.00024>,
                     <-3.00364, 0.57723, 2.69328>, <-1, 0, 3>, <1, 0, 3>, <2.9483, 0.265289, 2.99632>
                     translate <3, 3, 3>
                     rotate x*90
                     translate <0, 0, 0>
                  }
                  
                  texture {
                     pigment {
                        image_map {
                           jpeg
                           "/home/tom/RayTrace/Textures/billet.jpg"
                           map_type 0
                        }
                        scale 6
                     }
                  }
                  scale <1, 0.56, 1>
                  scale 0.09
                  rotate <-43.4, 90, 0>
                  translate <-0.15266, -0.334693, 0.285452>
               }
               
               sphere {
                  <0, 0, 0>, 0.2
                  scale <0.4, 1, 0.8>
                  rotate <0, 0, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.2
                  scale <0.4, 0.5, 0.3>
                  rotate <0, 0, 0>
                  translate <0.0237449, -0.0270751, -0.0744565>
               }
               
               union {
                  //*PMName TiDoigt
                  
                  sphere {
                     <0, 0, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  cylinder {
                     <0, 0, 0>, <0, -0.4, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     //*PMName D2
                     
                     sphere {
                        <0, 0, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     cylinder {
                        <0, 0, 0>, <0, -0.3, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     union {
                        //*PMName D3
                        
                        sphere {
                           <0, 0, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cylinder {
                           <0, 0, 0>, <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cone {
                           <0, -0.2, 0>, 0,
                           <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        rotate z*10
                        translate y*(-0.3)
                     }
                     rotate <0.6, 1, 24.1>
                     translate y*(-0.4)
                  }
                  scale <0.4, 0.3, 0.4>
                  rotate <-4.5, -7, 20.3>
                  translate <0, -0.131592, 0.0996585>
               }
               
               union {
                  //*PMName Ori
                  
                  sphere {
                     <0, 0, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  cylinder {
                     <0, 0, 0>, <0, -0.4, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     //*PMName D2
                     
                     sphere {
                        <0, 0, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     cylinder {
                        <0, 0, 0>, <0, -0.3, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     union {
                        //*PMName D3
                        
                        sphere {
                           <0, 0, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cylinder {
                           <0, 0, 0>, <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cone {
                           <0, -0.2, 0>, 0,
                           <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        rotate z*25
                        translate y*(-0.3)
                     }
                     rotate <0.1, 0, 20.8>
                     translate y*(-0.4)
                  }
                  scale 0.4
                  rotate z*31
                  translate <0, -0.158386, 0.0505357>
               }
               
               union {
                  //*PMName Majeur
                  
                  sphere {
                     <0, 0, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  cylinder {
                     <0, 0, 0>, <0, -0.4, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     //*PMName D2
                     
                     sphere {
                        <0, 0, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     cylinder {
                        <0, 0, 0>, <0, -0.3, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     union {
                        //*PMName D3
                        
                        sphere {
                           <0, 0, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cylinder {
                           <0, 0, 0>, <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cone {
                           <0, -0.2, 0>, 0,
                           <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        rotate z*8
                        translate y*(-0.3)
                     }
                     rotate z*20.8
                     translate y*(-0.4)
                  }
                  scale <0.4, 0.42, 0.4>
                  rotate <1.9, 1.4, 35.2>
                  translate <0, -0.174017, 0.00141276>
               }
               
               union {
                  //*PMName Index
                  
                  sphere {
                     <0, 0, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  cylinder {
                     <0, 0, 0>, <0, -0.4, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     //*PMName D2
                     
                     sphere {
                        <0, 0, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     cylinder {
                        <0, 0, 0>, <0, -0.3, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     union {
                        //*PMName D3
                        
                        sphere {
                           <0, 0, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cylinder {
                           <0, 0, 0>, <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cone {
                           <0, -0.2, 0>, 0,
                           <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        rotate z*10
                        translate y*(-0.3)
                     }
                     rotate <-6.7, -1.5, 31.5>
                     translate y*(-0.4)
                  }
                  scale <0.4, 0.36, 0.4>
                  rotate <9.1, 10.9, 29.1>
                  translate <0, -0.167318, -0.0454773>
               }
               
               union {
                  //*PMName Pouce
                  
                  sphere {
                     <0, 0, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  cylinder {
                     <0, 0, 0>, <0, -0.4, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     //*PMName D2
                     
                     sphere {
                        <0, 0, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     cylinder {
                        <0, 0, 0>, <0, -0.2, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     union {
                        //*PMName D3
                        
                        sphere {
                           <0, 0, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cylinder {
                           <0, 0, 0>, <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cone {
                           <0, -0.2, 0>, 0,
                           <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        rotate x*(-10)
                        translate y*(-0.2)
                     }
                     rotate <-13.5, -4.4, -0.4>
                     translate y*(-0.4)
                  }
                  scale <0.5, 0.34, 0.5>
                  rotate <20.9, -6.9, 36.9>
                  translate <0.0570246, -0.0373954, -0.0742163>
               }
               scale <1.3, 1, 1.3>
               translate y*(-1.039)
            }
            rotate <40, -20, 0>
            translate <-0.1, -1.1836, 0>
         }
         rotate <25.5, 7.3, -34.7>
         translate x*(-1.15)
      }
      
      union {
         //*PMName AvBrasD
         
         sphere {
            //*PMName Coude
            <0, 0, 0>, 0.265
            scale <0.7, 1, 1>
            rotate <0, 0, 0>
            translate <0.1, -1.1836, 0>
         }
         
         sor {
            //*PMName Bras
            4,
            <0.26473, -1.3097>, <0.26473, -1.1836>, <0.37466, 0>, <0.22824, -0.71569>
            scale <0.7, 1, 1>
            rotate <0, 0, 0>
            translate x*0.1
         }
         
         union {
            //*PMName Main
            
            sor {
               4,
               <0, -0.348159>, <0.0988416, -1.03896>, <0.23219, 0>, <0.0049944, 0.32825>
               scale <0.7, 1, 1>
            }
            
            union {
               //*PMName Doigts
               
               sphere {
                  <0, 0, 0>, 0.2
                  scale <0.4, 1, 0.8>
                  rotate <0, 0, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.2
                  scale <0.4, 0.5, 0.3>
                  rotate <0, 0, 0>
                  translate <-0.023745, -0.027075, -0.074456>
               }
               
               union {
                  //*PMName TiDoigt
                  
                  sphere {
                     <0, 0, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  cylinder {
                     <0, 0, 0>, <0, -0.4, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     //*PMName D2
                     
                     sphere {
                        <0, 0, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     cylinder {
                        <0, 0, 0>, <0, -0.3, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     union {
                        //*PMName D3
                        
                        sphere {
                           <0, 0, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cylinder {
                           <0, 0, 0>, <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cone {
                           <0, -0.2, 0>, 0,
                           <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        rotate z*(-10)
                        translate y*(-0.3)
                     }
                     rotate z*(-30)
                     translate y*(-0.4)
                  }
                  scale <0.4, 0.3, 0.4>
                  rotate <-6, 0, -30>
                  translate <0, -0.131592, 0.0996585>
               }
               
               union {
                  //*PMName Ori
                  
                  sphere {
                     <0, 0, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  cylinder {
                     <0, 0, 0>, <0, -0.4, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     //*PMName D2
                     
                     sphere {
                        <0, 0, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     cylinder {
                        <0, 0, 0>, <0, -0.3, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     union {
                        //*PMName D3
                        
                        sphere {
                           <0, 0, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cylinder {
                           <0, 0, 0>, <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cone {
                           <0, -0.2, 0>, 0,
                           <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        rotate z*(-25)
                        translate y*(-0.3)
                     }
                     rotate z*(-30)
                     translate y*(-0.4)
                  }
                  scale 0.4
                  rotate z*(-35)
                  translate <0, -0.158386, 0.0505357>
               }
               
               union {
                  //*PMName Majeur
                  
                  sphere {
                     <0, 0, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  cylinder {
                     <0, 0, 0>, <0, -0.4, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     //*PMName D2
                     
                     sphere {
                        <0, 0, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     cylinder {
                        <0, 0, 0>, <0, -0.3, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     union {
                        //*PMName D3
                        
                        sphere {
                           <0, 0, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cylinder {
                           <0, 0, 0>, <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cone {
                           <0, -0.2, 0>, 0,
                           <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        rotate z*(-8)
                        translate y*(-0.3)
                     }
                     rotate z*(-35)
                     translate y*(-0.4)
                  }
                  scale <0.4, 0.42, 0.4>
                  rotate z*(-25)
                  translate <0, -0.174017, 0.00141276>
               }
               
               union {
                  //*PMName Index
                  
                  sphere {
                     <0, 0, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  cylinder {
                     <0, 0, 0>, <0, -0.4, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     //*PMName D2
                     
                     sphere {
                        <0, 0, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     cylinder {
                        <0, 0, 0>, <0, -0.3, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     union {
                        //*PMName D3
                        
                        sphere {
                           <0, 0, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cylinder {
                           <0, 0, 0>, <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cone {
                           <0, -0.2, 0>, 0,
                           <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        rotate z*(-10)
                        translate y*(-0.3)
                     }
                     rotate z*(-35)
                     translate y*(-0.4)
                  }
                  scale <0.4, 0.36, 0.4>
                  rotate z*(-34)
                  translate <0, -0.167318, -0.0454773>
               }
               
               union {
                  //*PMName Pouce
                  
                  sphere {
                     <0, 0, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  cylinder {
                     <0, 0, 0>, <0, -0.4, 0>, 0.1
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  union {
                     //*PMName D2
                     
                     sphere {
                        <0, 0, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     cylinder {
                        <0, 0, 0>, <0, -0.2, 0>, 0.1
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     union {
                        //*PMName D3
                        
                        sphere {
                           <0, 0, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cylinder {
                           <0, 0, 0>, <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        
                        cone {
                           <0, -0.2, 0>, 0,
                           <0, -0.1, 0>, 0.1
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, 0, 0>
                        }
                        rotate x*(-10)
                        translate y*(-0.2)
                     }
                     rotate x*(-25)
                     translate y*(-0.4)
                  }
                  scale <0.5, 0.34, 0.5>
                  rotate z*(-20)
                  translate <-0.057025, -0.037395, -0.074216>
               }
               scale <1.3, 1, 1.3>
               translate y*(-1.039)
            }
            rotate x*35
            translate <0.1, -1.1836, 0>
         }
         rotate <-30, 0, 22>
         translate x*1.15
      }
      rotate <90, 0, -5>
      translate <0, 1.1, 1.2>
   }
   
   union {
      //*PMName JambeG
      
      sor {
         //*PMName Jambe
         4,
         <0.0031515, -0.55626>, <0.5, -0.10431>, <0.48969, 1.1769>, <0.74272, 1.5074>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      union {
         //*PMName Bas
         
         sor {
            //*PMName Tibia
            4,
            <0, -2.2617>, <0.47223, -0.13067>, <0.21894, 1.204>, <0.79687, 1.9948>
            scale 1
            translate <0, 1.40412, -0.0253477>
         }
         
         union {
            //*PMName Pied
            
            sphere {
               <0, 0, 0>, 0.25
               scale <1, 0.5, 1>
               rotate x*(-9.9)
               translate <0, -0.042944, -0.113777>
            }
            
            difference {
               sphere {
                  <0, 0, 0.25>, 0.5
                  scale <0.7, 0.4, 1>
                  rotate <0, -0, 0>
                  translate <0, 0, 0>
               }
               
               box {
                  <-0.5, 0, -0.5>, <0.5, 0.5, 0.5>
                  scale <0.7, 0.4, 1>
                  rotate <0, 0, 0>
                  translate z*0.25
               }
            }
            
            sphere {
               <0, 0, 0.25>, 0.5
               scale <0.7, 0.2, 1>
               rotate <0, -0, 0>
               translate <0, 0, 0>
            }
            
            sphere {
               <0.0387198, -0.0176596, -0.0291941>, 0.135973
               scale <0.7, 0.5, 1>
               rotate <0, 0, 0>
               translate <0.18, 0.03, 0.7>
            }
            
            sphere {
               <0.026939, -0.0067821, -0.028391>, 0.11
               scale <0.7, 0.5, 1>
               rotate <0, 0, 0>
               translate <0.04, 0.03, 0.75>
            }
            
            sphere {
               <0.03872, -0.01766, -0.029194>, 0.1
               scale <0.7, 0.5, 1>
               rotate <0, 0, 0>
               translate <-0.11, 0.03, 0.75>
            }
            
            sphere {
               <0.03872, -0.01766, -0.029194>, 0.09
               scale <0.7, 0.5, 1>
               rotate <0.2, -12.3, 1.8>
               translate <-0.238333, 0.03, 0.7>
            }
            rotate x*33
            translate <0, 2.51773, 0.091387>
         }
         rotate x*(-19.6)
         translate <0, 0.176933, 0.406901>
      }
      
      sphere {
         //*PMName Genou
         <0, 1.3059, -0.0082828>, 0.58
         scale <0.9, 1, 0.9>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      rotate x*(-111.6)
      translate <-0.545943, 1.03296, -2.43036>
   }
   
   union {
      //*PMName JambeD
      
      sor {
         //*PMName Jambe
         4,
         <0.0031515, -0.55626>, <0.5, -0.10431>, <0.48969, 1.1769>, <0.74272, 1.5074>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      union {
         //*PMName Bas
         
         sor {
            //*PMName Tibia
            4,
            <0, -2.2617>, <0.47223, -0.13067>, <0.21894, 1.204>, <0.79687, 1.9948>
            scale 1
            translate <0, 0.0365439, 0.0177351>
         }
         
         union {
            //*PMName Pied
            
            sphere {
               <0, 0, 0>, 0.25
               scale <1, 0.5, 1>
               rotate x*(-9.9)
               translate <0, -0.042944, -0.113777>
            }
            
            difference {
               sphere {
                  <0, 0, 0.25>, 0.5
                  scale <0.7, 0.4, 1>
                  rotate <0, -0, 0>
                  translate <0, 0, 0>
               }
               
               box {
                  <-0.5, 0, -0.5>, <0.5, 0.5, 0.5>
                  scale <0.7, 0.4, 1>
                  rotate <0, 0, 0>
                  translate z*0.25
               }
            }
            
            sphere {
               <0, 0, 0.25>, 0.5
               scale <0.7, 0.2, 1>
               rotate <0, -0, 0>
               translate <0, 0, 0>
            }
            
            sphere {
               <0.0387198, -0.0176596, -0.0291941>, 0.135973
               scale <0.7, 0.5, 1>
               rotate <0, 0, 0>
               translate <-0.284749, 0.0299785, 0.701251>
            }
            
            sphere {
               <0.026939, -0.0067821, -0.028391>, 0.11
               scale <0.7, 0.5, 1>
               rotate <0, 0, 0>
               translate <-0.110996, 0.0253482, 0.751425>
            }
            
            sphere {
               <0.03872, -0.01766, -0.029194>, 0.1
               scale <0.7, 0.5, 1>
               rotate <0, 0, 0>
               translate <0.0374734, 0.0343501, 0.765736>
            }
            
            sphere {
               <0.03872, -0.01766, -0.029194>, 0.09
               scale <0.7, 0.5, 1>
               rotate <0.2, 12.3, 1.8>
               translate <0.183572, 0.0433204, 0.704989>
            }
            rotate x*1.6
            translate <0, 1.2345, 0.12492>
         }
         rotate x*(-28.3)
         translate <0, 1.45482, -0.0482014>
      }
      
      sphere {
         //*PMName Genou
         <0, 1.3059, -0.0082828>, 0.58
         scale <0.9, 1, 0.9>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      rotate x*(-44.4)
      translate <0.54594, 1.033, -2.4304>
   }
}

union {
   //*PMName Dragon
   
   object {
      Dragon
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   scale 0.25
   rotate <-90, 20, 0>
   translate <-1.7333, 1.22, -0.4>
   
   texture {
      TexEcailles
      scale 0.7
   }
}

#declare Boule = union {
   sphere {
      <0, 0, 0>, 0.03
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
}

#declare Bouclier = union {
   cylinder {
      <-0.5, 0, 0>, <-0.5, 1.5, 0>, 0.03
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Boule
      scale 1
      rotate <0, 0, 0>
      translate x*(-0.5)
   }
   
   object {
      Boule
      scale 1
      rotate <0, 0, 0>
      translate <-0.5, 1.5, 0>
   }
   
   cylinder {
      <-0.5, 0, 0>, <0, -0.2, 0>, 0.03
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Boule
      scale 1
      rotate <0, 0, 0>
      translate y*(-0.2)
   }
   
   cylinder {
      <-0.5, 1.5, 0>, <0, 1.4, 0>, 0.03
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Boule
      scale 1
      rotate <0, 0, 0>
      translate y*1.4
   }
}

#declare Epee = union {
   cylinder {
      <-0.15, 1.2, 0>, <-0.13, -0.8, 0>, 0.03
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Boule
      scale 1
      rotate <0, 0, 0>
      translate <-0.13, -0.8, 0>
   }
   
   cylinder {
      <-0.13, -0.8, 0>, <0, -1.1, 0>, 0.03
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Boule
      scale 1
      rotate <0, 0, 0>
      translate y*(-1.1)
   }
   
   cylinder {
      <-0.4, 1.2, 0>, <-0.15, 1.2, 0>, 0.03
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Boule
      scale 1
      rotate <0, 0, 0>
      translate <-0.15, 1.2, 0>
   }
   
   cylinder {
      <-0.4, 1.2, 0>, <-0.4, 1.4, 0>, 0.03
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Boule
      scale 1
      rotate <0, 0, 0>
      translate <-0.4, 1.2, 0>
   }
   
   cylinder {
      <-0.4, 1.4, 0>, <-0.1, 1.35, 0>, 0.03
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Boule
      scale 1
      rotate <0, 0, 0>
      translate <-0.4, 1.4, 0>
   }
   
   cylinder {
      <-0.12, 1.75, 0>, <-0.1, 1.35, 0>, 0.03
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Boule
      scale 1
      rotate <0, 0, 0>
      translate <-0.1, 1.35, 0>
   }
   
   cylinder {
      <-0.12, 1.75, 0>, <0, 1.7, 0>, 0.03
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Boule
      scale 1
      rotate <0, 0, 0>
      translate <-0.12, 1.75, 0>
   }
   
   object {
      Boule
      scale 1
      rotate <0, 0, 0>
      translate y*1.7
   }
}

#declare Epee2 = union {
   object {
      Epee
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Epee
      scale 1
      rotate y*180
      translate <0, 0, 0>
   }
}

union {
   //*PMName Neon
   
   union {
      //*PMName Barres
      
      cylinder {
         <-0.45, 0, 0>, <-1.4, 0, 0>, 0.02
         scale 1
         rotate <0, 0, 0>
         translate y*0.3
      }
      
      cylinder {
         <-0.35, 0, 0>, <-1.4, 0, 0>, 0.02
         scale 1
         rotate <0, 0, 0>
         translate y*1
      }
      
      texture {
         pigment {
            color rgb <0.309804, 0.309804, 0.309804>
         }
      }
   }
   
   union {
      //*PMName Lampes
      
      light_source {
         <0, 0, 0>, rgb <0.227451, 0.337255, 0.572549>
         fade_distance 3.2
         fade_power 50
         translate y*0.7
      }
      
      object {
         Bouclier
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      object {
         Bouclier
         scale 1
         rotate y*180
         translate <0, 0, 0>
      }
      
      union {
         //*PMName Epees
         
         object {
            Epee2
            scale 1
            rotate z*30
            translate <0.1, 0.5, -0.06>
         }
         
         object {
            Epee2
            scale 1
            rotate z*(-30)
            translate <-0.1, 0.5, 0.06>
         }
      }
      
      texture {
         pigment {
            color rgb <0.345098, 0.505882, 0.858824>
         }
         
         finish {
            ambient rgb <37.647, 47.059, 100>
         }
      }
      scale 1
      rotate z*(-9.4)
      translate <0, 0, 0>
   }
   scale 0.4
   rotate y*90
   translate <2.01816, 2.5361, -0.415103>
   no_shadow
}

#declare Spot = union {
   //*PMName LampeEns
   
   cylinder {
      //*PMName Barre
      <0, 0, 0>, <0, 0, -1.5>, 0.01
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      //*PMName AxeA
      <-0.01, 0, 0>, <0.01, 0, 0>, 0.017
      scale 1
      rotate <0, 0, 0>
      translate z*(-1.5)
   }
   
   cylinder {
      //*PMName AxeAB
      <-0.011, 0, 0>, <0.034, 0, 0>, 0.007
      scale 1
      rotate <0, 0, 0>
      translate z*(-1.5)
   }
   
   union {
      //*PMName Lampe
      
      cylinder {
         //*PMName AxeB
         <-0.01, 0, 0>, <0.01, 0, 0>, 0.017
         scale 1
         rotate <0, 0, 0>
      }
      
      box {
         //*PMName AxeAB
         <-0.01, 0, 0.017>, <0.01, -0.02, -0.017>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         //*PMName AxeBas
         <-0.01, 0, 0>, <0.2, 0, 0>, 0.02
         scale 1
         rotate <0, 0, 0>
         translate y*(-0.03)
      }
      
      box {
         //*PMName ParoiA
         <-0.01, -0.1, -0.01>, <0.2, 0, -0.017>
         scale 1
         rotate x*30
         translate y*(-0.02)
      }
      
      box {
         //*PMName ParoiB
         <-0.01, -0.1, 0.01>, <0.2, 0, 0.017>
         scale 1
         rotate x*(-30)
         translate y*(-0.02)
      }
      
      cone {
         <0, -0.02, 0>, 0.016,
         <0, -0.1, 0>, 0.064
         scale <0.1, 1, 1>
         rotate <0, 0, 0>
         translate x*(-0.01)
      }
      
      cone {
         <0, -0.02, 0>, 0.016,
         <0, -0.1, 0>, 0.064
         scale <0.1, 1, 1>
         rotate <0, 0, 0>
         translate x*0.2
      }
      
      light_source {
         <0, 0, 0>, rgb <0.482353, 0.482353, 0.45098>
         fade_distance 1
         fade_power 15
         rotate <0, -0, -0>
         translate <0.09, -0.07, 0>
      }
      scale 1
      rotate x*(-35)
      translate <0.023, 0, -1.5>
   }
   
   texture {
      pigment {
         color rgb <1, 1, 1>
      }
      
      finish {
         brilliance 0.5
      }
   }
   scale 1
   rotate x*15
   translate <4.5, 1.31, 0.1>
}

#declare Lettres = union {
   //*PMName Myth
   
   text {
      ttf "/home/tom/RayTrace/Fonts/Megadeth.ttf"
      "Myth' Take"
      0.1, <0, 0>
      scale <1.3, 1.2, 1>
      translate <0.68, -0.64, -0.09>
      rotate <0, 0, 0>
   }
   
   text {
      ttf "/home/tom/RayTrace/Fonts/Megadeth.ttf"
      "Publishing House"
      0.1, <0, 0>
      scale <0.7, 0.45, 1>
      translate <1.2767, -1.0562, -0.09>
      rotate <0, 0, 0>
   }
   
   texture {
      pigment {
         image_map {
            png
            "/home/tom/RayTrace/Textures/enseigne3notxtdark.png"
            map_type 0
         }
         scale <9, 1.3, 1>
         translate y*0.07
      }
      
      finish {
         phong 0.2
         phong_size 30
      }
   }
}

union {
   //*PMName Enseigne
   
   union {
      //*PMName Planches
      
      difference {
         //*PMName P1
         
         box {
            //*PMName Planche
            <0, -0.12, -0.015>, <9, 0.13, 0.015>
            rotate x*4
            translate <0, 0, 0>
         }
         
         object {
            Lettres
            rotate x*4
         }
      }
      
      difference {
         //*PMName P2
         
         box {
            //*PMName Planche
            <0, -0.12, -0.015>, <9, 0.13, 0.015>
            rotate x*(-6)
            translate y*(-0.26)
         }
         
         object {
            Lettres
            translate y*0.26
            rotate x*(-6)
            translate y*(-0.26)
         }
      }
      
      difference {
         //*PMName P3
         
         box {
            //*PMName Planche
            <0, -0.12, -0.015>, <9, 0.13, 0.015>
            rotate x*4
            translate y*(-0.52)
         }
         
         object {
            Lettres
            translate y*0.52
            rotate x*4
            translate y*(-0.52)
         }
      }
      
      difference {
         //*PMName P4
         
         box {
            //*PMName Planche
            <0, -0.12, -0.015>, <9, 0.13, 0.015>
            rotate x*4
            translate y*(-0.78)
         }
         
         object {
            Lettres
            translate y*0.78
            rotate x*7
            translate y*(-0.78)
         }
      }
      
      difference {
         //*PMName P5
         
         box {
            //*PMName Planche
            <0, -0.12, -0.015>, <9, 0.13, 0.015>
            rotate x*(-8)
            translate y*(-1.04)
         }
         
         object {
            Lettres
            translate y*1.04
            rotate x*(-8)
            translate y*(-1.04)
         }
      }
      translate y*1.17
      
      texture {
         pigment {
            image_map {
               png
               "/home/tom/RayTrace/Textures/enseigne3notxt.png"
               map_type 0
            }
            scale <9, 1.3, 1>
            translate y*0.07
         }
         
         finish {
            brilliance 0.5
            phong 0.2
            phong_size 30
         }
      }
   }
   
   object {
      Spot
      scale 1
      rotate <0, 0, 0>
      translate x*(-3)
   }
   
   object {
      Spot
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Spot
      scale 1
      rotate <0, 0, 0>
      translate x*3
   }
   scale 0.45
   translate <-2.3, 2.4, -0.025>
}

#declare VeloCadre = texture {
   pigment {
      color rgb <0.215686, 0.282353, 0.52549>
   }
   
   finish {
      phong 1
      phong_size 50
   }
}

#declare VeloMetal = texture {
   pigment {
      color rgb <0.811765, 0.811765, 0.827451>
   }
   
   finish {
      diffuse 0.2
      phong 7
      phong_size 8
   }
}

#declare VeloPneus = texture {
   pigment {
      image_map {
         png
         "/home/tom/RayTrace/Textures/pneu.png"
         map_type 5
      }
      scale <0.48, 1, 0.48>
   }
   
   finish {
      roughness 0.1
   }
}

#declare Rayon = union {
   //*PMName Rayon
   
   cylinder {
      <0, 0.03, -0.02>, <0, 0.46, 0>, 0.0015
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      <0, 0.03, 0.02>, <0, 0.46, 0>, 0.0015
      scale 1
      rotate z*5
      translate <0, 0, 0>
   }
   
   texture {
      pigment {
         color rgb <0.980392, 0.980392, 1>
      }
      
      finish {
         diffuse 0.2
         phong 4
         phong_size 30
      }
   }
}

#declare Rayons = union {
   //*PMName Quart
   
   object {
      Rayon
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Rayon
      scale 1
      rotate z*10
      translate <0, 0, 0>
   }
   
   object {
      Rayon
      scale 1
      rotate z*20
      translate <0, 0, 0>
   }
   
   object {
      Rayon
      scale 1
      rotate z*30
      translate <0, 0, 0>
   }
   
   object {
      Rayon
      scale 1
      rotate z*40
      translate <0, 0, 0>
   }
   
   object {
      Rayon
      scale 1
      rotate z*50
      translate <0, 0, 0>
   }
   
   object {
      Rayon
      scale 1
      rotate z*60
      translate <0, 0, 0>
   }
   
   object {
      Rayon
      scale 1
      rotate z*70
      translate <0, 0, 0>
   }
   
   object {
      Rayon
      scale 1
      rotate z*80
      translate <0, 0, 0>
   }
}

union {
   //*PMName velo
   
   union {
      //*PMName velo
      
      cylinder {
         //*PMName BarreHaute
         <-0.5, 0, 0>, <0.5, 0, 0>, 0.03
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         //*PMName BarreArr
         <0, 0, 0>, <0, -0.88, 0>, 0.035
         scale 1
         rotate z*23.6
         translate x*(-0.5)
      }
      
      cylinder {
         //*PMName BarreSelle
         <0, 0.2, 0>, <0, 0, 0>, 0.025
         
         texture {
            VeloMetal
         }
         scale 1
         rotate z*23.6
         translate x*(-0.5)
      }
      
      difference {
         //*PMName Selle
         
         intersection {
            union {
               sphere {
                  <0, 0, 0>, 0.5
                  scale 1
                  rotate <0, 0, 0>
                  translate z*(-0.15)
               }
               
               sphere {
                  <0, 0, 0>, 0.5
                  scale 1
                  rotate <0, 0, 0>
                  translate z*0.15
               }
               scale <1, 0.5, 0.7>
            }
            
            union {
               box {
                  <-0.5, -0.1, -0.4>, <0.5, 0.3, 0.4>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
            }
         }
         
         union {
            box {
               <-0.5, 0, -0.4>, <0.5, 0.3, 0.4>
               scale 1
               rotate z*6
               translate <-0.116629, 0.14773, 0>
            }
            
            box {
               <-0.5, -0.1, 0>, <0.5, 0.3, 0.4>
               scale 1
               rotate y*(-14.9)
               translate <-0.101078, -0.0855282, 0.248809>
            }
            
            box {
               <-0.5, -0.1, 0>, <0.5, 0.3, -0.4>
               scale 1
               rotate y*14.9
               translate <-0.10108, -0.085528, -0.24881>
            }
         }
         
         texture {
            pigment {
               color rgb <0.054902, 0.054902, 0.054902>
            }
            
            finish {
               phong 1
               phong_size 60
            }
         }
         scale 0.3
         rotate y*180
         translate <-0.524788, 0.193225, 0>
      }
      
      cylinder {
         //*PMName Collier
         <0, 0.01, 0>, <0, 0, 0>, 0.03
         
         texture {
            VeloMetal
         }
         scale 1
         rotate z*23.6
         translate x*(-0.5)
      }
      
      union {
         //*PMName Fourche
         
         union {
            //*PMName guidon
            
            cylinder {
               //*PMName BarreGuid
               <0, 0.07, 0>, <0, 0.18, 0>, 0.017
            }
            
            sphere {
               <0, 0, 0>, 0.02
               scale <0.9, 1, 1>
               rotate <0, 0, 0>
               translate y*0.18
            }
            
            union {
               //*PMName Guidon2
               
               cylinder {
                  //*PMName BarreAv
                  <0, 0, 0>, <0.1, 0, 0>, 0.02
               }
               
               cylinder {
                  <0.1, 0, -0.03>, <0.1, 0, 0.03>, 0.021
               }
               
               cylinder {
                  <0.1, 0, -0.06>, <0.1, 0, 0.06>, 0.018
               }
               
               union {
                  //*PMName Courbe
                  
                  cylinder {
                     <0.1, 0, -0.15>, <0.1, 0, 0.15>, 0.017
                     scale 1
                     rotate <-0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  intersection {
                     torus {
                        0.1, 0.017
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     box {
                        <0, -0.017, 0>, <0.12, 0.017, -0.12>
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     translate z*(-0.15)
                     
                     pigment {
                        color rgb <1, 1, 1>
                     }
                  }
                  
                  intersection {
                     torus {
                        0.1, 0.017
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     box {
                        <0, -0.017, 0>, <0.12, 0.017, 0.12>
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     translate z*0.15
                     
                     pigment {
                        color rgb <1, 1, 1>
                     }
                  }
                  
                  intersection {
                     torus {
                        0.1, 0.017
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     box {
                        <0, -0.017, 0>, <0.12, 0.017, 0.12>
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     rotate <-90, 0, 180>
                     translate <0, 0.1, 0.25>
                     
                     pigment {
                        color rgb <1, 1, 1>
                     }
                  }
                  
                  intersection {
                     torus {
                        0.1, 0.017
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     
                     box {
                        <0, -0.017, 0>, <0.12, 0.017, 0.12>
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     rotate <-90, 0, 180>
                     translate <0, 0.1, -0.25>
                     
                     pigment {
                        color rgb <1, 1, 1>
                     }
                  }
                  
                  cylinder {
                     <0, 0, 0>, <0, 0.01, 0>, 0.0175
                     
                     pigment {
                        color rgb <0, 0, 0>
                     }
                     scale 1
                     rotate <0, 0, 0>
                     translate <-0.1, 0.1, 0.25>
                  }
                  
                  cylinder {
                     <0, 0, 0>, <0, 0.01, 0>, 0.0175
                     
                     pigment {
                        color rgb <0, 0, 0>
                     }
                     scale 1
                     rotate <0, 0, 0>
                     translate <-0.1, 0.1, -0.25>
                  }
                  translate x*(-0.1)
                  rotate z*112.9
                  translate x*0.1
                  
                  texture {
                     VeloCadre
                  }
               }
               rotate z*(-7.4)
               translate y*0.18
            }
            
            cylinder {
               //*PMName collier
               <0, 0.07, 0>, <0, 0.074, 0>, 0.03
            }
            
            cylinder {
               //*PMName collier
               <0, 0.074, 0>, <0, 0.079, 0>, 0.033
            }
            
            texture {
               VeloMetal
            }
         }
         
         union {
            //*PMName Fourche1
            
            sphere {
               <0, 0, 0>, 0.02
               scale <1, 0.7, 0.7>
               rotate <0, 0, 0>
               translate <0, -0.17, 0.036>
            }
            
            cone {
               <0, 0.03, 0>, 0.02,
               <0, -0.4, 0>, 0.015
               scale <1, 1, 0.7>
               rotate <0, 0, 0>
               translate <0, -0.2, 0.036>
            }
            
            sphere {
               <0, -0.4, 0>, 0.015
               scale <1, 1, 0.7>
               rotate <0, 0, 0>
               translate <0, -0.2, 0.036>
            }
            
            sphere {
               <0, 0, 0>, 0.02
               scale <1, 0.7, 0.7>
               rotate <0, 0, 0>
               translate <0, -0.17, -0.036>
            }
            
            cone {
               <0, 0.03, 0>, 0.02,
               <0, -0.4, 0>, 0.015
               scale <1, 1, 0.7>
               rotate <0, 0, 0>
               translate <0, -0.2, -0.036>
            }
            
            sphere {
               <0, -0.4, 0>, 0.015
               scale <1, 1, 0.7>
               rotate <0, 0, 0>
               translate <0, -0.2, -0.036>
            }
            
            union {
               //*PMName Fourche2
               
               cone {
                  <0, 0, 0>, 0.015,
                  <0, -0.2, 0>, 0.01
                  scale <1, 1, 0.7>
                  rotate z*15
                  translate <0, -0.6, -0.035>
               }
               
               cone {
                  <0, 0, 0>, 0.015,
                  <0, -0.2, 0>, 0.01
                  scale <1, 1, 0.7>
                  rotate z*15
                  translate <0, -0.6, 0.035>
               }
            }
         }
         
         cylinder {
            //*PMName BarreGuid
            <0, 0.07, 0>, <0, -0.2, 0>, 0.035
         }
         
         union {
            //*PMName GardeBoue
            
            cylinder {
               <-0.5, 0.041, 0>, <0, 0.05, 0>, 0.004
               scale 1
               rotate y*40
               translate <0, 0, 0>
            }
            
            sphere {
               <-0.5, 0.041, 0>, 0.004
               scale 1
               rotate y*40
               translate <0, 0, 0>
            }
            
            cylinder {
               <-0.5, -0.041, 0>, <0, -0.05, 0>, 0.004
               scale 1
               rotate y*40
               translate <0, 0, 0>
            }
            
            sphere {
               <-0.5, -0.041, 0>, 0.004
               scale 1
               rotate y*40
               translate <0, 0, 0>
            }
            
            difference {
               //*PMName GardeBoue
               
               intersection {
                  torus {
                     0.5, 0.04
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  box {
                     <-0.55, -0.041, 0.2>, <0.55, 0.041, 0.55>
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
               }
               
               torus {
                  0.495, 0.04
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
            }
            
            texture {
               VeloMetal
            }
            rotate <-90, 0, 30>
            translate <0.048, -0.78, 0>
         }
         
         union {
            //*PMName RoueAv
            
            difference {
               //*PMName Jante
               
               torus {
                  0.48, 0.03
                  scale <1, 0.6, 1>
                  rotate x*90
               }
               
               torus {
                  0.485, 0.032
                  scale <1, 0.6, 1>
                  rotate x*90
               }
               
               texture {
                  VeloMetal
               }
            }
            
            torus {
               //*PMName Pneu
               0.481, 0.028
               
               texture {
                  VeloPneus
               }
               scale <1, 0.6, 1>
               rotate x*90
            }
            
            cylinder {
               <0, 0, 0.053>, <0, 0, -0.053>, 0.008
               
               texture {
                  VeloMetal
               }
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cone {
               <0, 0, 0>, 0.005,
               <0, 0, 0.005>, 0.03
               open
               
               texture {
                  VeloMetal
               }
               scale 1
               rotate <0, 0, 0>
               translate z*(-0.025)
            }
            
            cone {
               <0, 0, 0>, 0.005,
               <0, 0, -0.005>, 0.03
               open
               
               texture {
                  VeloMetal
               }
               scale 1
               rotate <0, 0, 0>
               translate z*0.025
            }
            
            torus {
               0.03, 0.001
               
               texture {
                  VeloMetal
               }
               scale 1
               rotate <90, 0, -4>
               translate z*0.02
            }
            
            torus {
               0.03, 0.001
               
               texture {
                  VeloMetal
               }
               scale 1
               rotate <90, 0, -4>
               translate z*(-0.02)
            }
            
            object {
               Rayons
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            object {
               Rayons
               scale 1
               rotate z*90
               translate <0, 0, 0>
            }
            
            object {
               Rayons
               scale 1
               rotate z*180
               translate <0, 0, 0>
            }
            
            object {
               Rayons
               scale 1
               rotate z*270
               translate <0, 0, 0>
            }
            translate <0.048, -0.78, 0>
         }
         scale 1
         rotate <0, 20, 15>
         translate x*0.5
      }
      
      cylinder {
         //*PMName BarreAv
         <0, -0.03, 0>, <0, -1, 0>, 0.035
         scale 1
         rotate z*(-45.7)
         translate <0.55, -0.111667, 0>
      }
      
      union {
         //*PMName Pdalier
         
         cylinder {
            //*PMName AxePed
            <0, 0, 0.044>, <0, 0, -0.044>, 0.045
            scale 1
            rotate <0, 0, 0>
         }
         
         cylinder {
            //*PMName AxePed
            <0, 0, 0.08>, <0, 0, -0.08>, 0.01
            
            texture {
               VeloMetal
            }
            scale 1
            rotate <0, 0, 0>
         }
         
         cylinder {
            <0, 0, -0.06>, <0, 0, -0.051>, 0.1
            
            texture {
               VeloMetal
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         union {
            //*PMName Pdales
            
            union {
               //*PMName Pdale1
               
               sphere {
                  <0, 0, 0>, 0.017
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, -0.25, 0>, 0.017
                  rotate <0, 0, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.017
                  scale 1
                  rotate <0, 0, 0>
                  translate y*(-0.25)
               }
               
               box {
                  <-0.04, -0.015, 0>, <0.04, 0.015, 0.1>
                  scale 1
                  rotate z*30
                  translate y*(-0.25)
               }
               scale <1, 1, 0.5>
               translate z*0.08
            }
            
            union {
               //*PMName Pdale2
               
               sphere {
                  <0, 0, 0>, 0.017
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <0, -0.25, 0>, 0.017
                  rotate <0, 0, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.017
                  scale 1
                  rotate <0, 0, 0>
                  translate y*(-0.25)
               }
               
               box {
                  <-0.04, -0.015, 0>, <0.04, 0.015, -0.1>
                  scale 1
                  rotate z*14.7
                  translate y*(-0.25)
               }
               scale <1, 1, 0.5>
               translate z*(-0.08)
               rotate z*180
            }
            
            texture {
               VeloMetal
            }
            rotate z*(-20)
         }
         translate <-0.15, -0.8, 0>
      }
      
      union {
         //*PMName RoueArr
         
         union {
            //*PMName GardeBoue
            
            cylinder {
               <-0.5, 0.041, 0>, <0, 0.057, 0>, 0.004
               scale 1
               rotate y*3
               translate <0, 0, 0>
            }
            
            sphere {
               <-0.5, 0.041, 0>, 0.004
               scale 1
               rotate y*3
               translate <0, 0, 0>
            }
            
            cylinder {
               <-0.5, -0.041, 0>, <0, -0.057, 0>, 0.004
               scale 1
               rotate y*3
               translate <0, 0, 0>
            }
            
            sphere {
               <-0.5, -0.041, 0>, 0.004
               scale 1
               rotate y*3
               translate <0, 0, 0>
            }
            
            difference {
               //*PMName GardeBoue
               
               intersection {
                  torus {
                     0.5, 0.04
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  box {
                     <-0.55, -0.041, -0.03>, <0.55, 0.041, 0.55>
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
               }
               
               torus {
                  0.495, 0.04
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
            }
            
            texture {
               VeloMetal
            }
            rotate <-90, 0, -1>
            translate <0, 0, 0>
         }
         
         union {
            //*PMName Roue
            
            difference {
               //*PMName Jante
               
               torus {
                  0.48, 0.03
                  scale <1, 0.6, 1>
                  rotate x*90
               }
               
               torus {
                  0.485, 0.032
                  scale <1, 0.6, 1>
                  rotate x*90
               }
               
               texture {
                  VeloMetal
               }
            }
            
            torus {
               //*PMName Pneu
               0.481, 0.028
               
               texture {
                  VeloPneus
               }
               scale <1, 0.6, 1>
               rotate x*90
            }
            
            cylinder {
               <0, 0, 0.08>, <0, 0, -0.08>, 0.008
               
               texture {
                  VeloMetal
               }
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cone {
               <0, 0, 0>, 0.005,
               <0, 0, 0.005>, 0.03
               open
               
               texture {
                  VeloMetal
               }
               scale 1
               rotate <0, 0, 0>
               translate z*(-0.025)
            }
            
            cone {
               <0, 0, 0>, 0.005,
               <0, 0, -0.005>, 0.03
               open
               
               texture {
                  VeloMetal
               }
               scale 1
               rotate <0, 0, 0>
               translate z*0.025
            }
            
            torus {
               0.03, 0.001
               
               texture {
                  VeloMetal
               }
               scale 1
               rotate <90, 0, -4>
               translate z*0.02
            }
            
            torus {
               0.03, 0.001
               
               texture {
                  VeloMetal
               }
               scale 1
               rotate <90, 0, -4>
               translate z*(-0.02)
            }
            
            object {
               Rayons
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            object {
               Rayons
               scale 1
               rotate z*90
               translate <0, 0, 0>
            }
            
            object {
               Rayons
               scale 1
               rotate z*180
               translate <0, 0, 0>
            }
            
            object {
               Rayons
               scale 1
               rotate z*270
               translate <0, 0, 0>
            }
         }
         translate <-0.85, -0.75, 0>
      }
      
      union {
         //*PMName FourcheAr
         
         cylinder {
            <0, 0, -0.04>, <0, 0, 0.04>, 0.02
            scale 1
            rotate <0, 0, 0>
            translate <-0.591272, -0.200172, 0>
         }
         
         cylinder {
            <-0.5, 0, 0>, <-0.84, -0.75, 0>, 0.02
            scale <1, 1, 0.7>
            rotate x*(-2.5)
            translate z*0.03
         }
         
         cylinder {
            <-0.5, 0, 0>, <-0.84, -0.75, 0>, 0.02
            scale <1, 1, 0.7>
            rotate x*2.5
            translate z*(-0.03)
         }
         
         cone {
            <0, 0, 0>, 0.017,
            <-0.7, 0, 0.046564>, 0.01
            scale <1, 1, 0.7>
            rotate z*(-4.6)
            translate <-0.15, -0.8, 0.03>
         }
         
         cone {
            <0, 0, 0>, 0.017,
            <-0.7, 0, -0.046564>, 0.01
            scale <1, 1, 0.7>
            rotate z*(-4.6)
            translate <-0.15, -0.8, -0.03>
         }
      }
      
      texture {
         VeloCadre
      }
      translate y*1.255
   }
   scale 0.9
   rotate <-9.8, 172, 0>
   translate <4, 0, -0.3>
}

#declare Cercle = difference {
   cylinder {
      <0, 0, 0>, <0, 0.01, 0>, 0.178
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      <0, 0, 0>, <0, 0.01, 0>, 0.17
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      <-0.2, 0.015, 0.015>, <0.2, -0.005, 0.2>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   translate z*0.005
}

#declare Clou = union {
   //*PMName Clou
   
   sphere {
      <0, 0.375, -0.023>, 0.015
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
}

#declare Clous = union {
   //*PMName Clous
   
   object {
      Clou
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      Clou
      scale 1
      rotate z*(-20)
      translate <0, 0, 0>
   }
   
   object {
      Clou
      scale 1
      rotate z*(-40)
      translate <0, 0, 0>
   }
   
   object {
      Clou
      scale 1
      rotate z*(-60)
      translate <0, 0, 0>
   }
   
   object {
      Clou
      scale 1
      rotate z*(-80)
      translate <0, 0, 0>
   }
   
   object {
      Clou
      scale 1
      rotate z*(-100)
      translate <0, 0, 0>
   }
   
   object {
      Clou
      scale 1
      rotate z*(-120)
      translate <0, 0, 0>
   }
   
   object {
      Clou
      scale 1
      rotate z*(-140)
      translate <0, 0, 0>
   }
   
   object {
      Clou
      scale 1
      rotate z*(-160)
      translate <0, 0, 0>
   }
}

#declare MetalArmure = texture {
   normal {
      agate
      agate_turb 0.5
      bump_size 0.1
   }
   
   pigment {
      color rgb <0.431373, 0.431373, 0.431373>
   }
   
   finish {
      metallic 1.1
      specular 2
      roughness 0.1
   }
}

#declare MetalJupe = texture {
   pigment {
      checker 
      
      pigment {
         color rgb <0.352941, 0.352941, 0.352941>
      }
      
      pigment {
         color rgbt <0.35294, 0.35294, 0.35294, 0.5>
      }
      scale 0.005
   }
   
   finish {
      phong 1
      phong_size 40
   }
}

#declare Maillon = union {
   //*PMName Maillon
   
   intersection {
      torus {
         0.5, 0.15
         scale 1
         rotate <0, 0, 0>
      }
      
      box {
         <-0.65, -0.15, 0>, <0.65, 0.15, 0.65>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      translate z*(-0.4)
   }
   
   cylinder {
      <0, 0, 0>, <0, 0, 0.55>, 0.15
      scale 1
      rotate <0, 0, 0>
      translate <0.5, 0, -0.95>
   }
   
   cylinder {
      <0, 0, 0>, <0, 0, 0.55>, 0.15
      scale 1
      rotate <0, 0, 0>
      translate <-0.5, 0, -0.95>
   }
   
   intersection {
      torus {
         0.5, 0.15
         scale 1
         rotate <0, 0, 0>
      }
      
      box {
         <-0.65, -0.15, 0>, <0.65, 0.15, 0.65>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      rotate x*180
      translate z*(-0.95)
   }
}

#declare EpeeC = union {
   triangle {
      <-0.5, 0, 0>, <0, 0, 0.1>, <0, 0.5, 0>
   }
   
   triangle {
      <-0.5, 0, 0>, <0, 0, 0.1>, <0, -3, 0.1>
   }
   
   triangle {
      <-0.5, 0, 0>, <-0.5, -3, 0>, <0, -3, 0.1>
   }
}

#declare EpeeC2 = union {
   triangle {
      <-0.5, 0, 0>, <0, 0, -0.1>, <0, 0.5, 0>
   }
   
   triangle {
      <-0.5, 0, 0>, <0, 0, -0.1>, <0, -3, -0.1>
   }
   
   triangle {
      <-0.5, 0, 0>, <-0.5, -3, 0>, <0, -3, -0.1>
   }
}

union {
   //*PMName Chevalier
   
   union {
      //*PMName Bouclier
      
      difference {
         sphere {
            <0, 0, 0>, 0.4
            scale <1, 1, 0.2>
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         sphere {
            <0, 0, 0>, 0.4
            scale <1, 1, 0.2>
            rotate <0, 0, 0>
            translate z*0.01
         }
      }
      
      torus {
         0.4, 0.01
         scale 1
         rotate x*90
         translate <0, 0, 0>
      }
      
      torus {
         0.35, 0.01
         scale <1, 0.5, 1>
         rotate x*90
         translate z*(-0.04)
      }
      
      union {
         //*PMName Clous
         
         object {
            Clous
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         object {
            Clous
            scale 1
            rotate z*(-180)
            translate <0, 0, 0>
         }
      }
      scale 1
      rotate <-97.3, 0, 180>
      translate <0.780571, -0.291717, 0.20538>
   }
   
   union {
      //*PMName Armure
      
      union {
         //*PMName Haut
         
         union {
            //*PMName Tte
            
            union {
               //*PMName Armet
               
               cylinder {
                  <0.01, 0, 0>, <-0.01, 0, 0>, 0.145
                  scale <1, 1.4, 1>
                  rotate <0, 0, 0>
                  translate <0, 1.75, -0.035908>
               }
               
               torus {
                  //*PMName Cou
                  0.2, 0.008
                  scale <1, 1, 0.7>
                  rotate <0, 0, 0>
                  translate y*1.5
               }
               
               difference {
                  //*PMName Crane
                  
                  union {
                     difference {
                        sphere {
                           <0, 0, 0>, 0.21
                           scale <1, 0.9, 1>
                        }
                        
                        sphere {
                           <0, 0, 0>, 0.2
                           scale <1, 0.9, 1>
                        }
                        
                        box {
                           <-0.22, 0, -0.22>, <0.22, -0.2, 0.22>
                        }
                        scale <1, 1, 0.7>
                        rotate <0, 0, 0>
                        translate y*1.75
                     }
                     
                     cone {
                        <0, 0, 0>, 0.2,
                        <0, 0.05, 0>, 0.15
                        scale <1, 1, 0.7>
                        rotate <0, 0, 0>
                        translate y*1.5
                     }
                     
                     cone {
                        <0, 0.05, 0>, 0.15,
                        <0, 0.15, 0>, 0.2
                        scale <1, 1, 0.7>
                        rotate <0, 0, 0>
                        translate y*1.5
                     }
                     
                     cone {
                        <0, 0.2, 0>, 0.21,
                        <0, 0.15, 0>, 0.2
                        scale <1, 1, 0.7>
                        rotate <0, 0, 0>
                        translate y*1.5
                     }
                     
                     cylinder {
                        <0, 0.05, 0>, <0, 0, 0>, 0.21
                        scale <1, 1, 0.7>
                        rotate <0, 0, 0>
                        translate y*1.7
                     }
                  }
                  
                  box {
                     //*PMName oeil
                     <0.12, -0.12, -0.0022329>, <-0.12, 0.035, -0.18525>
                     scale 1
                     rotate <0, 0, 0>
                     translate y*1.75
                  }
               }
               
               union {
                  //*PMName Cercles
                  
                  object {
                     Cercle
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  object {
                     Cercle
                     scale 1
                     rotate <0, 0, 0>
                     translate y*(-0.03)
                  }
                  
                  object {
                     Cercle
                     scale 1
                     rotate <0, 0, 0>
                     translate y*(-0.06)
                  }
                  
                  object {
                     Cercle
                     scale 1
                     rotate <0, 0, 0>
                     translate y*0.06
                  }
                  
                  object {
                     Cercle
                     scale 1
                     rotate <0, 0, 0>
                     translate y*0.03
                  }
                  scale <1, 1, 0.7>
                  translate <0, 1.7, -0.04>
               }
            }
            
            sphere {
               <0, 0, 0>, 0.2
               
               texture {
                  pigment {
                     color rgb <0, 0, 0>
                  }
               }
               scale <1, 0.9, 0.7>
               translate y*1.75
            }
            rotate y*(-80)
            scale <1, 1.2, 1>
            translate y*(-0.4)
         }
         
         union {
            //*PMName Bras
            
            difference {
               sphere {
                  <0, 0, 0>, 0.29
                  scale 1
                  rotate <0, 0, 0>
                  translate x*(-0.35)
               }
               
               sphere {
                  <0, 0, 0>, 0.29
                  scale 1
                  rotate <0, 0, 0>
                  translate <-0.31, -0.01, 0>
               }
               
               box {
                  <0, 0.04, -0.32>, <-0.7, -0.32, 0.32>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               scale <0.9, 1, 0.6>
               rotate <0, 0, 0>
               translate <0.031577, -0.11999, 0>
            }
            
            difference {
               sphere {
                  <0, 0, 0>, 0.29
                  scale 1
                  rotate <0, 0, 0>
                  translate x*0.35
               }
               
               sphere {
                  <0, 0, 0>, 0.29
                  scale 1
                  rotate <0, 0, 0>
                  translate <0.31, -0.01, 0>
               }
               
               box {
                  <0, 0.04, -0.32>, <0.7, -0.32, 0.32>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               scale <0.9, 1, 0.6>
               rotate x*17.3
               translate <-0.0346154, -0.113981, -0.0539974>
            }
            
            sphere {
               <0, 0, 0>, 0.2
               scale <2.5, 0.9, 0.8>
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            union {
               //*PMName Droit
               
               sor {
                  4,
                  <0, -0.82101>, <0.07, -0.49>, <0.12, 0>, <0.031577, 0.55882>
                  sturm
                  scale <0.8, 1, 1>
                  rotate <0, 0, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.09
                  scale 1
                  rotate <0, 0, 0>
                  translate y*(-0.49)
               }
               
               cone {
                  <0, -0.49, 0>, 0.07,
                  <0, -0.4, 0>, 0.12
                  open
                  scale <0.8, 1, 1>
                  rotate <0, 0, 0>
                  translate y*0.02
               }
               
               union {
                  //*PMName AvBras
                  
                  cone {
                     <0, 0, 0>, 0.07,
                     <0, -0.1, 0>, 0.11
                     open
                     scale <0.8, 1, 1>
                     rotate <0, 0, 0>
                     translate y*(-0.05)
                  }
                  
                  sor {
                     4,
                     <0, -0.82101>, <0.06, -0.48>, <0.07, 0>, <0.031577, 0.55882>
                     sturm
                     scale <0.8, 1, 1>
                     rotate <0, 0, 0>
                  }
                  
                  union {
                     //*PMName Main
                     
                     union {
                        //*PMName Doigts
                        
                        sphere {
                           <0, 0, 0>, 0.2
                           scale <0.4, 0.5, 0.3>
                           rotate <0, 0, 0>
                           translate <0.0237449, -0.0270751, -0.0744565>
                        }
                        
                        union {
                           //*PMName TiDoigt
                           
                           sphere {
                              <0, 0, 0>, 0.1
                              scale 1
                              rotate <0, 0, 0>
                              translate <0, 0, 0>
                           }
                           
                           cylinder {
                              <0, 0, 0>, <0, -0.4, 0>, 0.1
                              scale 1
                              rotate <0, 0, 0>
                              translate <0, 0, 0>
                           }
                           
                           union {
                              //*PMName D2
                              
                              sphere {
                                 <0, 0, 0>, 0.1
                                 scale 1
                                 rotate <0, 0, 0>
                                 translate <0, 0, 0>
                              }
                              
                              cylinder {
                                 <0, 0, 0>, <0, -0.3, 0>, 0.1
                                 scale 1
                                 rotate <0, 0, 0>
                                 translate <0, 0, 0>
                              }
                              
                              union {
                                 //*PMName D3
                                 
                                 sphere {
                                    <0, 0, 0>, 0.1
                                    scale 1
                                    rotate <0, 0, 0>
                                    translate <0, 0, 0>
                                 }
                                 
                                 cylinder {
                                    <0, 0, 0>, <0, -0.1, 0>, 0.1
                                    scale 1
                                    rotate <0, 0, 0>
                                    translate <0, 0, 0>
                                 }
                                 rotate <0.7, -3.8, 43.4>
                                 translate y*(-0.3)
                              }
                              rotate <1.6, -0.4, 36.7>
                              translate y*(-0.4)
                           }
                           scale <0.4, 0.3, 0.4>
                           rotate <-4.5, -7, 20.3>
                           translate <0, -0.131592, 0.0996585>
                        }
                        
                        union {
                           //*PMName Ori
                           
                           sphere {
                              <0, 0, 0>, 0.1
                              scale 1
                              rotate <0, 0, 0>
                              translate <0, 0, 0>
                           }
                           
                           cylinder {
                              <0, 0, 0>, <0, -0.4, 0>, 0.1
                              scale 1
                              rotate <0, 0, 0>
                              translate <0, 0, 0>
                           }
                           
                           union {
                              //*PMName D2
                              
                              sphere {
                                 <0, 0, 0>, 0.1
                                 scale 1
                                 rotate <0, 0, 0>
                                 translate <0, 0, 0>
                              }
                              
                              cylinder {
                                 <0, 0, 0>, <0, -0.3, 0>, 0.1
                                 scale 1
                                 rotate <0, 0, 0>
                                 translate <0, 0, 0>
                              }
                              
                              union {
                                 //*PMName D3
                                 
                                 sphere {
                                    <0, 0, 0>, 0.1
                                    scale 1
                                    rotate <0, 0, 0>
                                    translate <0, 0, 0>
                                 }
                                 
                                 cylinder {
                                    <0, 0, 0>, <0, -0.1, 0>, 0.1
                                    scale 1
                                    rotate <0, 0, 0>
                                    translate <0, 0, 0>
                                 }
                                 rotate z*25
                                 translate y*(-0.3)
                              }
                              rotate <0.1, -0, 70.5>
                              translate y*(-0.4)
                           }
                           scale 0.4
                           rotate z*31
                           translate <0, -0.158386, 0.0505357>
                        }
                        
                        union {
                           //*PMName Majeur
                           
                           sphere {
                              <0, 0, 0>, 0.1
                              scale 1
                              rotate <0, 0, 0>
                              translate <0, 0, 0>
                           }
                           
                           cylinder {
                              <0, 0, 0>, <0, -0.4, 0>, 0.1
                              scale 1
                              rotate <0, 0, 0>
                              translate <0, 0, 0>
                           }
                           
                           union {
                              //*PMName D2
                              
                              sphere {
                                 <0, 0, 0>, 0.1
                                 scale 1
                                 rotate <0, 0, 0>
                                 translate <0, 0, 0>
                              }
                              
                              cylinder {
                                 <0, 0, 0>, <0, -0.3, 0>, 0.1
                                 scale 1
                                 rotate <0, 0, 0>
                                 translate <0, 0, 0>
                              }
                              
                              union {
                                 //*PMName D3
                                 
                                 sphere {
                                    <0, 0, 0>, 0.1
                                    scale 1
                                    rotate <0, 0, 0>
                                    translate <0, 0, 0>
                                 }
                                 
                                 cylinder {
                                    <0, 0, 0>, <0, -0.1, 0>, 0.1
                                    scale 1
                                    rotate <0, 0, 0>
                                    translate <0, 0, 0>
                                 }
                                 rotate <0.1, 0.9, 30.3>
                                 translate y*(-0.3)
                              }
                              rotate <0.2, 1.7, 61.8>
                              translate y*(-0.4)
                           }
                           scale <0.4, 0.42, 0.4>
                           rotate <1.9, 1.4, 37.8>
                           translate <0, -0.174017, 0.00141276>
                        }
                        
                        union {
                           //*PMName Index
                           
                           sphere {
                              <0, 0, 0>, 0.1
                              scale 1
                              rotate <0, 0, 0>
                              translate <0, 0, 0>
                           }
                           
                           cylinder {
                              <0, 0, 0>, <0, -0.4, 0>, 0.1
                              scale 1
                              rotate <0, 0, 0>
                              translate <0, 0, 0>
                           }
                           
                           union {
                              //*PMName D2
                              
                              sphere {
                                 <0, 0, 0>, 0.1
                                 scale 1
                                 rotate <0, 0, 0>
                                 translate <0, 0, 0>
                              }
                              
                              cylinder {
                                 <0, 0, 0>, <0, -0.3, 0>, 0.1
                                 scale 1
                                 rotate <0, 0, 0>
                                 translate <0, 0, 0>
                              }
                              
                              union {
                                 //*PMName D3
                                 
                                 sphere {
                                    <0, 0, 0>, 0.1
                                    scale 1
                                    rotate <0, 0, 0>
                                    translate <0, 0, 0>
                                 }
                                 
                                 cylinder {
                                    <0, 0, 0>, <0, -0.1, 0>, 0.1
                                    scale 1
                                    rotate <0, 0, 0>
                                    translate <0, 0, 0>
                                 }
                                 rotate <-0.5, 2.9, 34.4>
                                 translate y*(-0.3)
                              }
                              rotate <-7.7, 3, 50.7>
                              translate y*(-0.4)
                           }
                           scale <0.4, 0.36, 0.4>
                           rotate <9.1, 10.9, 29.1>
                           translate <0, -0.167318, -0.0454773>
                        }
                        
                        union {
                           //*PMName Pouce
                           
                           sphere {
                              <0, 0, 0>, 0.1
                              scale 1
                              rotate <0, 0, 0>
                              translate <0, 0, 0>
                           }
                           
                           cylinder {
                              <0, 0, 0>, <0, -0.4, 0>, 0.1
                              scale 1
                              rotate <0, 0, 0>
                              translate <0, 0, 0>
                           }
                           
                           union {
                              //*PMName D2
                              
                              sphere {
                                 <0, 0, 0>, 0.1
                                 scale 1
                                 rotate <0, 0, 0>
                                 translate <0, 0, 0>
                              }
                              
                              cylinder {
                                 <0, 0, 0>, <0, -0.2, 0>, 0.1
                                 scale 1
                                 rotate <0, 0, 0>
                                 translate <0, 0, 0>
                              }
                              
                              union {
                                 //*PMName D3
                                 
                                 sphere {
                                    <0, 0, 0>, 0.1
                                    scale 1
                                    rotate <0, 0, 0>
                                    translate <0, 0, 0>
                                 }
                                 
                                 cylinder {
                                    <0, 0, 0>, <0, -0.1, 0>, 0.1
                                    scale 1
                                    rotate <0, 0, 0>
                                    translate <0, 0, 0>
                                 }
                                 rotate <-14.8, 6.8, -33.6>
                                 translate y*(-0.2)
                              }
                              rotate <-13.5, -4.4, -0.4>
                              translate y*(-0.4)
                           }
                           scale <0.5, 0.34, 0.5>
                           rotate z*59.8
                           translate <0.10954, -0.0460572, -0.100902>
                        }
                        scale 0.4
                        translate <0.00485955, -0.0398483, 0>
                        
                        texture {
                           MetalJupe
                        }
                     }
                     
                     sphere {
                        <0, 0, 0>, 0.09
                        scale <0.5, 1.4, 0.8>
                        rotate <0, 0, 0>
                        translate y*0.01
                     }
                     
                     cone {
                        <0, -0.05, 0>, 0.1,
                        <0, 0.12, 0>, 0.16
                        open
                        scale <0.4, 1, 0.6>
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     translate <-0.00685187, -0.430439, -0.00391542>
                  }
                  rotate x*50.4
                  translate y*(-0.49)
               }
               rotate <20, 5, -23.3>
               translate <-0.404167, -0.0485823, -0.0329877>
            }
            
            union {
               //*PMName Gauche
               
               sor {
                  4,
                  <0, -0.82101>, <0.07, -0.49>, <0.12, 0>, <0.031577, 0.55882>
                  sturm
                  scale <0.8, 1, 1>
                  rotate <0, 0, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.09
                  scale 1
                  rotate <0, 0, 0>
                  translate y*(-0.49)
               }
               
               cone {
                  <0, -0.49, 0>, 0.07,
                  <0, -0.4, 0>, 0.12
                  open
                  scale <0.8, 1, 1>
                  rotate <0, 0, 0>
                  translate y*0.02
               }
               
               union {
                  //*PMName AvBras
                  
                  union {
                     //*PMName Main
                     
                     union {
                        //*PMName Chaine
                        
                        union {
                           //*PMName 1
                           
                           object {
                              Maillon
                              rotate <0, 0, 0>
                           }
                           
                           union {
                              //*PMName 2
                              
                              object {
                                 Maillon
                                 scale 1
                                 rotate z*90
                                 translate <0, 0, 0>
                              }
                              
                              union {
                                 //*PMName 3
                                 
                                 object {
                                    Maillon
                                    scale 1
                                    rotate <0, 0, 0>
                                    translate <0, 0, 0>
                                 }
                                 
                                 union {
                                    //*PMName 4
                                    
                                    object {
                                       Maillon
                                       scale 1
                                       rotate z*90
                                       translate <0, 0, 0>
                                    }
                                    
                                    union {
                                       //*PMName 5
                                       
                                       object {
                                          Maillon
                                          scale 1
                                          rotate <0, 0, 0>
                                          translate <0, 0, 0>
                                       }
                                       
                                       union {
                                          //*PMName 6
                                          
                                          object {
                                             Maillon
                                             scale 1
                                             rotate z*90
                                             translate <0, 0, 0>
                                          }
                                          
                                          union {
                                             //*PMName 7
                                             
                                             object {
                                                Maillon
                                                scale 1
                                                rotate <0, 0, 0>
                                                translate <0, 0, 0>
                                             }
                                             
                                             union {
                                                //*PMName 8
                                                
                                                object {
                                                   Maillon
                                                   scale 1
                                                   rotate z*90
                                                   translate <0, 0, 0>
                                                }
                                                
                                                union {
                                                   //*PMName 9
                                                   
                                                   object {
                                                      Maillon
                                                      scale 1
                                                      rotate <0, 0, 0>
                                                      translate <0, 0, 0>
                                                   }
                                                   
                                                   union {
                                                      //*PMName 10
                                                      
                                                      object {
                                                         Maillon
                                                         scale 1
                                                         rotate z*90
                                                         translate <0, 0, 0>
                                                      }
                                                      
                                                      union {
                                                         //*PMName 11
                                                         
                                                         object {
                                                            Maillon
                                                            scale 1
                                                            rotate <0, 0, 0>
                                                            translate <0, 0, 0>
                                                         }
                                                         
                                                         union {
                                                            //*PMName 12
                                                            
                                                            object {
                                                               Maillon
                                                               scale 1
                                                               rotate z*90
                                                               translate <0, 0, 0>
                                                            }
                                                            
                                                            union {
                                                               //*PMName 13
                                                               
                                                               object {
                                                                  Maillon
                                                                  scale 1
                                                                  rotate <0, 0, 0>
                                                                  translate <0, 0, 0>
                                                               }
                                                               rotate <0.2, 0.3, -1.4>
                                                               translate z*(-1.3)
                                                            }
                                                            rotate <-10.2, -48.2, 4.8>
                                                            translate z*(-1.3)
                                                         }
                                                         rotate <-0.4, -4.9, 0.1>
                                                         translate z*(-1.3)
                                                      }
                                                      rotate <-8.3, -30.5, 3.1>
                                                      translate z*(-1.3)
                                                   }
                                                   rotate <0, 0, 0>
                                                   translate z*(-1.3)
                                                }
                                                rotate <0, 0, 0>
                                                translate z*(-1.3)
                                             }
                                             rotate <0, 0, 0>
                                             translate z*(-1.3)
                                          }
                                          rotate <0, 0, 0>
                                          translate z*(-1.3)
                                       }
                                       rotate <0, 0, 0>
                                       translate z*(-1.3)
                                    }
                                    rotate <0, 0, 0>
                                    translate z*(-1.3)
                                 }
                                 rotate <0, 0, 0>
                                 translate z*(-1.3)
                              }
                              rotate <0, 0, 0>
                              translate z*(-1.3)
                           }
                           rotate <0, -0, 0>
                        }
                        
                        union {
                           //*PMName 1bis
                           
                           object {
                              Maillon
                              rotate <0, 0, 0>
                           }
                           
                           union {
                              //*PMName 2
                              
                              object {
                                 Maillon
                                 scale 1
                                 rotate z*90
                                 translate <0, 0, 0>
                              }
                              
                              union {
                                 //*PMName 3
                                 
                                 object {
                                    Maillon
                                    scale 1
                                    rotate <0, 0, 0>
                                    translate <0, 0, 0>
                                 }
                                 
                                 union {
                                    //*PMName 4
                                    
                                    object {
                                       Maillon
                                       scale 1
                                       rotate z*90
                                       translate <0, 0, 0>
                                    }
                                    
                                    union {
                                       //*PMName 5
                                       
                                       object {
                                          Maillon
                                          scale 1
                                          rotate <0, 0, 0>
                                          translate <0, 0, 0>
                                       }
                                       
                                       union {
                                          //*PMName 6
                                          
                                          object {
                                             Maillon
                                             scale 1
                                             rotate z*90
                                             translate <0, 0, 0>
                                          }
                                          
                                          union {
                                             //*PMName 7
                                             
                                             object {
                                                Maillon
                                                scale 1
                                                rotate <0, 0, 0>
                                                translate <0, 0, 0>
                                             }
                                             
                                             union {
                                                //*PMName 8
                                                
                                                object {
                                                   Maillon
                                                   scale 1
                                                   rotate z*90
                                                   translate <0, 0, 0>
                                                }
                                                
                                                union {
                                                   //*PMName 9
                                                   
                                                   object {
                                                      Maillon
                                                      scale 1
                                                      rotate <0, 0, 0>
                                                      translate <0, 0, 0>
                                                   }
                                                   
                                                   union {
                                                      //*PMName 10
                                                      
                                                      object {
                                                         Maillon
                                                         scale 1
                                                         rotate z*90
                                                         translate <0, 0, 0>
                                                      }
                                                      
                                                      union {
                                                         //*PMName 11
                                                         
                                                         object {
                                                            Maillon
                                                            scale 1
                                                            rotate <0, 0, 0>
                                                            translate <0, 0, 0>
                                                         }
                                                         
                                                         union {
                                                            //*PMName 12
                                                            
                                                            object {
                                                               Maillon
                                                               scale 1
                                                               rotate z*90
                                                               translate <0, 0, 0>
                                                            }
                                                            
                                                            union {
                                                               //*PMName 13
                                                               
                                                               object {
                                                                  Maillon
                                                                  scale 1
                                                                  rotate <0, 0, 0>
                                                                  translate <0, 0, 0>
                                                               }
                                                               rotate <0, 0, 0>
                                                               translate z*(-1.3)
                                                            }
                                                            rotate <0, 0, 0>
                                                            translate z*(-1.3)
                                                         }
                                                         rotate <0, 0, 0>
                                                         translate z*(-1.3)
                                                      }
                                                      rotate <0, 0, 0>
                                                      translate z*(-1.3)
                                                   }
                                                   rotate <0, 0, 0>
                                                   translate z*(-1.3)
                                                }
                                                rotate <0, 0, 0>
                                                translate z*(-1.3)
                                             }
                                             rotate <0, 0, 0>
                                             translate z*(-1.3)
                                          }
                                          rotate <10.8, -1.2, -1.9>
                                          translate z*(-1.3)
                                       }
                                       rotate <10.3, 3.7, 0.8>
                                       translate z*(-1.3)
                                    }
                                    rotate <13.8, 0.3, 0.2>
                                    translate z*(-1.3)
                                 }
                                 rotate <6.6, 1.3, 4.6>
                                 translate z*(-1.3)
                              }
                              rotate <73.3, 2, -4.2>
                              translate z*(-1.3)
                           }
                           rotate <-113.1, -1.4, -90.5>
                           translate <-0.2, 0, -0.15>
                        }
                        scale 0.4
                        rotate <40.3, -0.7, 101.7>
                        translate <-1.19104, -0.000351397, 1.24629>
                        
                        texture {
                           MetalBrillant
                        }
                     }
                     
                     superellipsoid {
                        <0.5, 0.7>
                        scale <0.75, 0.25, 0.9>
                        rotate <0, 0, 0>
                        translate x*(-0.6)
                     }
                     
                     superellipsoid {
                        <0.7, 0.7>
                        scale <0.3, 0.23, 0.8>
                        rotate z*34.2
                        translate <-1.2392, -0.063155, 0>
                     }
                     
                     sphere {
                        <0, 0, 0>, 0.5
                        scale <1, 0.5, 0.6>
                        rotate <-89.4, 11.6, 9.1>
                        translate <-0.44182, -0.23252, 0.73463>
                     }
                     
                     union {
                        //*PMName Doigts
                        
                        union {
                           //*PMName Index
                           
                           sphere {
                              <0, 0, 0>, 0.2
                              scale 1
                              rotate <0, 0, 0>
                              translate <0, 0, 0>
                           }
                           
                           cylinder {
                              <-0.5, 0, 0>, <0, 0, 0>, 0.19
                           }
                           
                           union {
                              sphere {
                                 <0, 0, 0>, 0.2
                                 scale 1
                                 rotate <0, 0, 0>
                                 translate <0, 0, 0>
                              }
                              
                              cylinder {
                                 <-0.45, 0, 0>, <0, 0, 0>, 0.19
                              }
                              
                              union {
                                 sphere {
                                    <0, 0, 0>, 0.2
                                    scale 1
                                    rotate <0, 0, 0>
                                    translate <0, 0, 0>
                                 }
                                 
                                 cylinder {
                                    <-0.45, 0, 0>, <0, 0, 0>, 0.19
                                 }
                                 
                                 sphere {
                                    <0, 0, 0>, 0.19
                                    scale <0.8, 1, 1>
                                    rotate <0, 0, 0>
                                    translate x*(-0.45)
                                 }
                                 rotate z*5.2
                                 translate x*(-0.45)
                              }
                              rotate z*25.8
                              translate x*(-0.5)
                           }
                           scale <0.85, 1, 1>
                           rotate <8.7, -7.2, 42.9>
                           translate <-1.4, -0.24, 0.55>
                        }
                        
                        union {
                           //*PMName Majeur
                           
                           sphere {
                              <0, 0, 0>, 0.2
                              scale 1
                              rotate <0, 0, 0>
                              translate <0, 0, 0>
                           }
                           
                           cylinder {
                              <-0.5, 0, 0>, <0, 0, 0>, 0.19
                           }
                           
                           union {
                              sphere {
                                 <0, 0, 0>, 0.2
                                 scale 1
                                 rotate <0, 0, 0>
                                 translate <0, 0, 0>
                              }
                              
                              cylinder {
                                 <-0.45, 0, 0>, <0, 0, 0>, 0.19
                              }
                              
                              union {
                                 sphere {
                                    <0, 0, 0>, 0.2
                                    scale 1
                                    rotate <0, 0, 0>
                                    translate <0, 0, 0>
                                 }
                                 
                                 cylinder {
                                    <-0.45, 0, 0>, <0, 0, 0>, 0.19
                                 }
                                 
                                 sphere {
                                    <0, 0, 0>, 0.19
                                    scale <0.8, 1, 1>
                                    rotate <0, 0, 0>
                                    translate x*(-0.45)
                                 }
                                 rotate z*10.9
                                 translate x*(-0.45)
                              }
                              rotate z*25.4
                              translate x*(-0.5)
                           }
                           rotate z*26
                           translate <-1.4, -0.24, 0.15>
                        }
                        
                        union {
                           //*PMName Anul
                           
                           sphere {
                              <0, 0, 0>, 0.2
                              scale 1
                              rotate <0, 0, 0>
                              translate <0, 0, 0>
                           }
                           
                           cylinder {
                              <-0.5, 0, 0>, <0, 0, 0>, 0.19
                           }
                           
                           union {
                              sphere {
                                 <0, 0, 0>, 0.2
                                 scale 1
                                 rotate <0, 0, 0>
                                 translate <0, 0, 0>
                              }
                              
                              cylinder {
                                 <-0.45, 0, 0>, <0, 0, 0>, 0.19
                              }
                              
                              union {
                                 sphere {
                                    <0, 0, 0>, 0.2
                                    scale 1
                                    rotate <0, 0, 0>
                                    translate <0, 0, 0>
                                 }
                                 
                                 cylinder {
                                    <-0.45, 0, 0>, <0, 0, 0>, 0.19
                                 }
                                 
                                 sphere {
                                    <0, 0, 0>, 0.19
                                    scale <0.8, 1, 1>
                                    rotate <0, 0, 0>
                                    translate x*(-0.45)
                                 }
                                 rotate z*3.8
                                 translate x*(-0.45)
                              }
                              rotate z*27.6
                              translate x*(-0.5)
                           }
                           scale <0.92, 1, 1>
                           rotate z*26.2
                           translate <-1.4, -0.24, -0.25>
                        }
                        
                        union {
                           //*PMName Oric
                           
                           sphere {
                              <0, 0, 0>, 0.2
                              scale 1
                              rotate <0, 0, 0>
                              translate <0, 0, 0>
                           }
                           
                           cylinder {
                              <-0.5, 0, 0>, <0, 0, 0>, 0.19
                           }
                           
                           union {
                              sphere {
                                 <0, 0, 0>, 0.2
                                 scale 1
                                 rotate <0, 0, 0>
                                 translate <0, 0, 0>
                              }
                              
                              cylinder {
                                 <-0.45, 0, 0>, <0, 0, 0>, 0.19
                              }
                              
                              union {
                                 sphere {
                                    <0, 0, 0>, 0.2
                                    scale 1
                                    rotate <0, 0, 0>
                                    translate <0, 0, 0>
                                 }
                                 
                                 cylinder {
                                    <-0.45, 0, 0>, <0, 0, 0>, 0.19
                                 }
                                 
                                 sphere {
                                    <0, 0, 0>, 0.19
                                    scale 1
                                    rotate <0, 0, 0>
                                    translate x*(-0.45)
                                 }
                                 rotate z*9.9
                                 translate x*(-0.45)
                              }
                              rotate z*20.6
                              translate x*(-0.5)
                           }
                           scale <0.66, 1, 1>
                           rotate <-1.1, 1.4, 36.5>
                           translate <-1.4, -0.24, -0.65>
                        }
                        
                        union {
                           //*PMName Pouce
                           
                           sphere {
                              <0, 0, 0>, 0.22
                              scale 1
                              rotate <0, 0, 0>
                              translate <0, 0, 0>
                           }
                           
                           cylinder {
                              <-0.5, 0, 0>, <0, 0, 0>, 0.21
                           }
                           
                           union {
                              sphere {
                                 <0, 0, 0>, 0.22
                                 scale 1
                                 rotate <0, 0, 0>
                                 translate <0, 0, 0>
                              }
                              
                              cylinder {
                                 <-0.45, 0, 0>, <0, 0, 0>, 0.21
                              }
                              
                              union {
                                 sphere {
                                    <0, 0, 0>, 0.22
                                    scale 1
                                    rotate <0, 0, 0>
                                    translate <0, 0, 0>
                                 }
                                 
                                 cylinder {
                                    <-0.45, 0, 0>, <0, 0, 0>, 0.21
                                 }
                                 
                                 sphere {
                                    <0, 0, 0>, 0.2
                                    scale <1.3, 1, 1>
                                    rotate <0, 0, 0>
                                    translate x*(-0.45)
                                 }
                                 rotate z*(-18.1)
                                 translate x*(-0.45)
                              }
                              rotate z*(-1.9)
                              translate x*(-0.5)
                           }
                           scale <0.7, 1, 1>
                           rotate <-97.1, -15.3, 25.4>
                           translate <-0.50433, -0.41678, 0.71707>
                        }
                        translate <0, -0.0574349, 0.0589256>
                     }
                     scale 0.1
                     rotate <180, 0, 90>
                     translate <-0.000173352, -0.48124, 0.0022947>
                     
                     texture {
                        MetalJupe
                     }
                  }
                  
                  cone {
                     <0, 0, 0>, 0.07,
                     <0, -0.1, 0>, 0.11
                     open
                     scale <0.8, 1, 1>
                     rotate <0, 0, 0>
                     translate y*(-0.05)
                  }
                  
                  cone {
                     <0, 0, 0>, 0.06,
                     <0, -0.1, 0>, 0.1
                     open
                     scale <0.8, 1, 1>
                     rotate <0, 0, 0>
                     translate y*(-0.41)
                  }
                  
                  sor {
                     4,
                     <0, -0.82101>, <0.06, -0.48>, <0.07, 0>, <0.031577, 0.55882>
                     sturm
                     scale <0.8, 1, 1>
                     rotate <0, 0, 0>
                  }
                  rotate <41.2, 1.7, -3.1>
                  translate y*(-0.49)
               }
               rotate <23.8, 1.3, 7>
               translate <0.40417, -0.048582, -0.032988>
            }
            rotate <0, 0, 0>
            translate y*1.2
         }
         
         union {
            //*PMName Pansire
            
            sor {
               4,
               <0, 1.0228>, <0.35, 0>, <0.2, 0.1>, <0, 1.73>
               sturm
               scale <1, 1, 0.6>
               rotate <0, 0, 0>
               translate y*1.3
               hollow false
            }
            
            sphere {
               <0, 0, 0>, 0.18
               scale <1, 1.2, 0.3>
               rotate <-2.3, 18, 0>
               translate <-0.16, 1.06, -0.156>
            }
            
            sphere {
               <0, 0, 0>, 0.18
               scale <1, 1.2, 0.3>
               rotate <-2.3, -18, 0>
               translate <0.16, 1.06, -0.156>
            }
            
            sor {
               4,
               <0, -0.38>, <0.28, 0.6>, <0.35, 1.3>, <0, 1.36>
               sturm
               scale <1, 1, 0.6>
               rotate <0, 0, 0>
               translate <0, 0, 0>
               hollow false
            }
            
            intersection {
               //*PMName Ceinturon
               
               union {
                  sor {
                     4,
                     <0, 1.0228>, <0.37, 0>, <0.225, 0.1>, <0, 1.73>
                     sturm
                     scale <1, 1, 0.6>
                     rotate <0, 0, 0>
                     translate y*1.3
                     hollow false
                  }
                  
                  sor {
                     4,
                     <0, -0.38>, <0.295, 0.6>, <0.365, 1.3>, <0, 1.36>
                     sturm
                     scale <1, 1, 0.6>
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                     hollow false
                  }
               }
               
               cylinder {
                  <0.015, 0, 0>, <-0.015, 0, 0>, 0.55
                  scale 1
                  rotate z*39.6
                  translate <0.0544419, 1.03435, 0.00971909>
               }
               
               texture {
                  pigment {
                     color rgb <0.439216, 0.270588, 0.270588>
                  }
                  
                  normal {
                     bumps
                     0.5
                     turbulence <0.5, 0.5, 0.5>
                     scale 0.001
                  }
               }
               translate x*(-0.004)
            }
         }
         
         union {
            //*PMName EpeeDos
            
            union {
               //*PMName Foureau
               
               cone {
                  <0, 0, 0>, 0.06,
                  <1, 0, 0>, 0.03
                  
                  pigment {
                     color rgb <0.164706, 0.164706, 0.164706>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cone {
                  <0, 0, 0>, 0.06,
                  <-0.03, 0, 0>, 0.061
                  
                  texture {
                     MetalArmure
                     scale 0.5
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cone {
                  <1, 0, 0>, 0.03,
                  <1.03, 0, 0>, 0.025
                  
                  texture {
                     MetalArmure
                     scale 0.5
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.025
                  
                  texture {
                     MetalArmure
                     scale 0.5
                  }
                  scale <0.5, 1, 1>
                  rotate <0, 0, 0>
                  translate x*1.03
               }
               scale <1, 1, 0.5>
            }
            
            union {
               //*PMName Poigne
               
               cylinder {
                  <0, 0, 0>, <-0.01, 0, 0>, 0.09
                  scale <1, 1, 0.5>
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               box {
                  <0, 0.11, 0.025>, <-0.01, -0.11, -0.025>
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               cylinder {
                  <0, 0, 0>, <-0.01, 0, 0>, 0.025
                  scale 1
                  rotate <0, 0, 0>
                  translate y*0.11
               }
               
               cylinder {
                  <0, 0, 0>, <-0.01, 0, 0>, 0.025
                  scale 1
                  rotate <0, 0, 0>
                  translate y*(-0.11)
               }
               
               union {
                  //*PMName Main
                  
                  sphere {
                     <0, 0, 0>, 0.04
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  sphere {
                     <0, 0, 0>, 0.04
                     scale 1
                     rotate <0, 0, 0>
                     translate x*(-0.05)
                  }
                  
                  sphere {
                     <0, 0, 0>, 0.04
                     scale 1
                     rotate <0, 0, 0>
                     translate x*(-0.1)
                  }
                  
                  union {
                     sphere {
                        <0, 0, 0>, 0.036
                        scale 1
                        rotate <0, 0, 0>
                        translate x*(-0.05)
                     }
                     
                     sphere {
                        <0, 0, 0>, 0.032
                        
                        texture {
                           MetalBrillant
                        }
                        scale 1
                        rotate <0, 0, 0>
                        translate x*(-0.09)
                     }
                     translate x*(-0.1)
                  }
                  
                  texture {
                     pigment {
                        color rgb <0, 0, 0>
                     }
                     
                     finish {
                        brilliance 0.5
                        phong 20
                        phong_size 30
                        roughness 0.05
                        reflection rgb <0.494118, 0.494118, 0.494118>
                     }
                  }
                  scale <1, 1, 0.8>
                  translate x*(-0.01)
               }
               
               texture {
                  MetalBrillant
               }
               translate x*(-0.03)
            }
            rotate <-6.9, 4.3, -62>
            translate <0, 1.16853, 0.278703>
         }
         rotate x*(-13)
         translate <0, -0.068657, 0.12794>
      }
      
      union {
         //*PMName Jupe
         
         cone {
            <0, -0.05, 0>, 0.28,
            <0, -0.4, 0>, 0.4
            scale <1, 1, 0.6>
            rotate x*6.7
            translate y*0.6
         }
         
         texture {
            MetalJupe
         }
      }
      
      difference {
         //*PMName Braconnire
         
         union {
            cylinder {
               <0, 0.61, 0>, <0, 0.59, 0>, 0.3
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            cone {
               <0, 0.6, 0>, 0.28,
               <0, 0.25, 0>, 0.48
               open
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
               hollow
            }
         }
         
         cylinder {
            <0, 0, -0.55>, <0, 0, 0.55>, 0.15
            
            pigment {
               color rgbt <0, 0, 0, 1>
            }
            scale 1
            rotate <0, 0, 0>
            translate y*0.35
         }
         
         cylinder {
            <0, 0, -0.55>, <0, 0, 0.55>, 0.4
            
            pigment {
               color rgbt <0, 0, 0, 1>
            }
            scale <1, 0.5, 1>
            rotate <0, 0, 0>
            translate y*0.2
         }
         scale <1, 1, 0.6>
      }
      
      union {
         //*PMName Jambes
         
         union {
            //*PMName Droite
            
            sor {
               //*PMName Haut
               4,
               <0, -1.1274>, <0.1, -0.6>, <0.14, 0>, <0, 0.90119>
               sturm
               scale 1
               rotate <0, 0, 0>
            }
            
            sphere {
               <0, -0.6, 0>, 0.1
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            union {
               //*PMName Bas
               
               union {
                  //*PMName Articule
                  
                  cone {
                     <0, 0.02, 0>, 0.115,
                     <0, -0.02, 0>, 0.105
                     open
                     scale 1
                     rotate x*6
                     translate <0, 0, 0>
                  }
                  
                  cone {
                     <0, 0.02, 0>, 0.114,
                     <0, -0.02, 0>, 0.104
                     open
                     scale 1
                     rotate x*4
                     translate y*(-0.02)
                  }
                  
                  cone {
                     <0, 0.02, 0>, 0.113,
                     <0, -0.02, 0>, 0.103
                     open
                     scale 1
                     rotate x*2
                     translate y*(-0.04)
                  }
                  
                  cone {
                     <0, 0.02, 0>, 0.112,
                     <0, -0.02, 0>, 0.102
                     open
                     scale 1
                     rotate <0, -0, -0>
                     translate y*(-0.06)
                  }
               }
               
               sor {
                  //*PMName Bas
                  4,
                  <0, -2.0656>, <0.06, -0.6>, <0.1, 0>, <0, 1.6617>
                  sturm
                  scale 1
                  rotate <0, 0, 0>
               }
               
               sphere {
                  <0, -0.6, 0>, 0.06
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               union {
                  //*PMName Pied
                  
                  sor {
                     4,
                     <0.0353413, -0.0832575>, <0.0610686, -0.0522329>, <0.06, 0>, <0.049059, 0.088204>
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  intersection {
                     union {
                        sphere {
                           <0, 0, 0>, 0.08
                           scale 1
                           rotate <0, 0, 0>
                           translate y*(-0.05)
                        }
                        
                        cone {
                           <0, 0, 0>, 0,
                           <0, 0, 0.05>, 0.05
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, -0.046, -0.1>
                        }
                     }
                     
                     box {
                        <-0.1, -0.05, -0.1>, <0.1, 0.05, 0>
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     scale <1, 1, 4.5>
                     translate y*(-0.045)
                  }
                  
                  intersection {
                     sphere {
                        <0, 0, 0>, 0.08
                        scale 1
                        rotate <0, 0, 0>
                        translate y*(-0.05)
                     }
                     
                     box {
                        <-0.1, -0.05, 0.1>, <0.1, 0.05, 0>
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     scale <1, 1, 1.5>
                     translate y*(-0.045)
                  }
                  scale 1
                  rotate x*(-65)
                  translate y*(-0.6)
               }
               rotate x*(-100)
               translate y*(-0.6)
            }
            scale 1
            rotate x*10
            translate <0.17, 0.4, 0>
         }
         
         union {
            //*PMName Gauche
            
            sphere {
               <0, -0.6, 0>, 0.1
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            sor {
               //*PMName Haut
               4,
               <0, -1.1274>, <0.1, -0.6>, <0.14, 0>, <0, 0.90119>
               sturm
               scale 1
               rotate <0, 0, 0>
            }
            
            union {
               //*PMName Bas
               
               union {
                  //*PMName Articule
                  
                  cone {
                     <0, 0.02, 0>, 0.115,
                     <0, -0.02, 0>, 0.105
                     open
                     scale 1
                     rotate x*14.3
                     translate <0, 0, 0>
                  }
                  
                  cone {
                     <0, 0.02, 0>, 0.114,
                     <0, -0.02, 0>, 0.104
                     open
                     scale 1
                     rotate x*9.5
                     translate y*(-0.02)
                  }
                  
                  cone {
                     <0, 0.02, 0>, 0.113,
                     <0, -0.02, 0>, 0.103
                     open
                     scale 1
                     rotate x*4.7
                     translate y*(-0.04)
                  }
                  
                  cone {
                     <0, 0.02, 0>, 0.112,
                     <0, -0.02, 0>, 0.102
                     open
                     scale 1
                     rotate x*2.6
                     translate y*(-0.06)
                  }
               }
               
               sor {
                  //*PMName Bas
                  4,
                  <0, -2.0656>, <0.06, -0.6>, <0.1, 0>, <0, 1.6617>
                  sturm
                  scale 1
                  rotate <0, 0, 0>
               }
               
               sphere {
                  <0, -0.6, 0>, 0.06
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               union {
                  //*PMName Pied
                  
                  sor {
                     4,
                     <0.0353413, -0.0832575>, <0.0610686, -0.0522329>, <0.06, 0>, <0.049059, 0.088204>
                     scale 1
                     rotate <0, 0, 0>
                     translate <0, 0, 0>
                  }
                  
                  intersection {
                     union {
                        sphere {
                           <0, 0, 0>, 0.08
                           scale 1
                           rotate <0, 0, 0>
                           translate y*(-0.05)
                        }
                        
                        cone {
                           <0, 0, 0>, 0,
                           <0, 0, 0.05>, 0.05
                           scale 1
                           rotate <0, 0, 0>
                           translate <0, -0.046, -0.1>
                        }
                     }
                     
                     box {
                        <-0.1, -0.05, -0.1>, <0.1, 0.05, 0>
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     scale <1, 1, 4.5>
                     translate y*(-0.045)
                  }
                  
                  intersection {
                     sphere {
                        <0, 0, 0>, 0.08
                        scale 1
                        rotate <0, 0, 0>
                        translate y*(-0.05)
                     }
                     
                     box {
                        <-0.1, -0.05, 0.1>, <0.1, 0.05, 0>
                        scale 1
                        rotate <0, 0, 0>
                        translate <0, 0, 0>
                     }
                     scale <1, 1, 1.5>
                     translate y*(-0.045)
                  }
                  scale 1
                  rotate x*(-70)
                  translate y*(-0.6)
               }
               rotate x*(-100)
               translate y*(-0.6)
            }
            scale 1
            rotate x*10
            translate <-0.17, 0.4, 0>
         }
      }
      translate y*(-0.017181)
   }
   
   texture {
      MetalArmure
   }
   scale 0.8
   rotate y*(-180)
   translate <3.01467, 0.256809, -0.953669>
}

light_source {
   <-3.7826, 2.4806, -5.3413>, rgb <1.01, 1, 1>
   spotlight
   radius 40
   falloff 70
   point_at <-1.61964, 2.1202, -0.24663>
   fade_distance 5
   fade_power 20
}

camera {
   perspective
   location <-4.4294, 1.3202, -4.4837>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <-0.21515, 1.6306, 0.15325>
}