// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Photon Scene Template
// Date: mm/dd/yy
// Auth: ?
//
#version 3.5;    
#include "colors.inc"
#include "mur.inc" 
#include "stones.inc"
#include "skies.inc"
#include "gems.inc"
#include "textures.inc"   
#include "woods.inc" 
#include "metals.inc"


#declare Photons=on;

global_settings {
  assumed_gamma 1.0
  max_trace_level 5
  #if (Photons)          // global photon block
    photons {
      spacing 0.02                 // specify the density of photons
      //count 100000               // alternatively use a total number of photons

      //gather min, max            // amount of photons gathered during render [20, 100]
      //media max_steps [,factor]  // media photons
      //jitter 1.0                 // jitter phor photon rays
      //max_trace_level 5          // optional separate max_trace_level
      //adc_bailout 1/255          // see global adc_bailout
      //save_file "filename"       // save photons to file
      //load_file "filename"       // load photons from file
      //autostop 0                 // photon autostop option
      //radius 10                  // manually specified search radius
      // (---Adaptive Search Radius---)
      //steps 1
      //expand_thresholds 0.2, 40
    }

  #end
}



// atmospheric media can be generated by adding a media statement
// to the scene not attached to any specific object

// atmospheric media can be generated by adding a media statement
// to the scene not attached to any specific object

/*
media {    // atmospheric media sample
  intervals 10
  scattering { 1, rgb 0.02 }
  
  samples 1, 10
  confidence 0.9999
  variance 1/1000
  ratio 0.9

  }
*/

fog {
  fog_type 1
  distance 120
  color Gray55 transmit 0.2
           // can also have 'filter' and 'transmit'
  // (---turbulence---)
  turbulence <0.5, 0.5, 1.0>
  turb_depth 0.5
  omega 0.5
  lambda 2.0
  octaves 6
  // (---ground fog---)
  //fog_offset 0.5         // height of constant fog
  //fog_alt 0.5            // at fog_offset+fog_alt: density=25%
}
 




// create a point "spotlight" (conical directed) light source
light_source {
  0*x                     // light's position (translated below)
  color White       // light's color
  spotlight               // this kind of light source
  translate <-200,90,35> // <x y z> position of light
  point_at <-15, 2, 0>      // direction of spotlight
  radius 5                // hotspot (inner, in degrees)
  tightness 5            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 8               // intensity falloff radius (outer, in degrees)
  media_attenuation on
  media_interaction on
}


// create a point "spotlight" (conical directed) light source
light_source {
  0*x                     // light's position (translated below)
  color DimGray       // light's color
  spotlight               // this kind of light source
  translate <-200,90,40> // <x y z> position of light
  point_at <-16, 2, 0>      // direction of spotlight
  radius 5                // hotspot (inner, in degrees)
  tightness 5            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 30               // intensity falloff radius (outer, in degrees)
    media_attenuation on
  media_interaction on
}
// create a point "spotlight" (conical directed) light source
light_source {
  0*x                     // light's position (translated below)
  color rgb Gold       // light's color
  spotlight               // this kind of light source
  translate <-200, 30, 145> // <x y z> position of light
  point_at <-17, 2, 0>      // direction of spotlight
  radius 5                // hotspot (inner, in degrees)
  tightness 5            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 30               // intensity falloff radius (outer, in degrees)
    media_attenuation on
  media_interaction on
}
// create a point "spotlight" (conical directed) light source
light_source {
  0*x                     // light's position (translated below)
  color CadetBlue       // light's color
  spotlight               // this kind of light source
  translate <-200, 30, 0> // <x y z> position of light
  point_at <-17, 2, 0>      // direction of spotlight
  radius 10                // hotspot (inner, in degrees)
  tightness 5            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 30               // intensity falloff radius (outer, in degrees)
    media_attenuation on
  media_interaction on
}



// Create an infinite sphere around scene and allow any pigment on it
sky_sphere {
 S_Cloud5
}





// ----------------------------------------

camera {
  right x*image_width/image_height
  location  <-24,5,1>
  look_at   <-16,3,2>
  }






  #declare Texture1 = texture {
    pigment { LightSteelBlue transmit 0.1}
    finish { reflection 0.1 specular 0.4 }
    // texture component
    normal {
    dents 1         // any pattern optionally followed by an intensity value [0.5]
    //bump_size 2.0   // optional
    //accuracy 0.02   // changes the scale for normal calculation [0.02]
    scale 0.3       // any transformations
  }

    // texture component

  }
  #declare Texture2 = texture {

  pigment {          // (---surface color---)
    dents           // some pattern
    color_map {      // color map
      [0.1 color Gray30 ]
      [0.5 color Gray10 ]
      [0.8 color Black ]
    }
    turbulence 0.5   // some turbulence
    scale .5
  }
  normal {           // (---surface bumpiness---)
    dents 4       // some pattern (and intensity)
    turbulence 0.5   // some turbulence
    scale <1,2,1>    // transformations
  }
  finish {           // (---surface finish---)
    ambient 0.2
    specular 0.1     // shiny
  }
}

  #declare Texture3 = texture {
    pigment { White transmit 1.0}
    finish { reflection 0.0 specular 0.5 }
    // texture component
    normal {
    dents 1         // any pattern optionally followed by an intensity value [0.5]
    //bump_size 2.0   // optional
    //accuracy 0.02   // changes the scale for normal calculation [0.02]
    scale 0.3       // any transformations
  }
}

  #declare Texture4 = texture {
    pigment { Aquamarine transmit 0.3}
    finish { reflection 0.0 specular 0.5 }
    // texture component
    normal {
    dents 1         // any pattern optionally followed by an intensity value [0.5]
    //bump_size 2.0   // optional
    //accuracy 0.02   // changes the scale for normal calculation [0.02]
    scale 0.3       // any transformations
  }

    // texture component

  }


#declare T_default =
    texture {
      spotted 
      texture_map {
        [ 0.0 Texture2 ]
        [ 0.1 Texture1 ]
        [ 0.3 Texture1 ]
        [ 0.7 Texture2 ]
      }
      scale 2

    }  





#declare T_DEFAULT =
    texture {
      // texture component
  pigment {
    color rgb <0.2,0.7,0.3>     // solid color pigment
    /*
    agate                       // patterned pigment
    color_map {
      [0.0 color Green ]
      [1.0 color Blue ]
    } */
  }

    }

#declare T_Blossom =
    texture {       spotted 
      texture_map {
        [ 0.0 Texture4 ]
        [ 0.4 Texture3 ]
        [ 0.5 Texture4 ]
        [ 0.8 Texture3 ]
        
      }scale 2  }

    
#include "mountain_o.inc" 
#include "scion.inc"
#include "txttree.inc"
#include "maketree.pov" // tree & leaf macro
#include "bloom_o.inc"


#default {
  texture {
    pigment {rgb 0.5}
  }
}








  
//-------------------------------------------------------
//objects    


#declare berg =
object {P_grid1}



  




//=========================================
// Tree macro Parameters
//-----------------------------------------
// These parameters must be declared before calling the tree macro
//-----------------------------------------
#declare dofile=false;    // true creates a tree file ; false otherwise
#declare dotexture=true;  // true creates a textured tree (with the texture following the branch); false otherwise
#declare ftname="gttree3.inc" // file name for tree
#declare fvname="gtfoliage3.inc" // file name for foliage
#declare ffname="gtleaf3.inc" // file name for leaf
#declare txtTree=texture{txtTree_3} // Bark texture

//-----------------------------------------
// Random streams
// one stream for branches and another one for leaves
// so that the leafed tree has the same structure as the leafless one
//-----------------------------------------
#declare rsd=211;      // random seed
//#declare rsd=212;      // random seed
//#declare rsd=213;      // random seed
#declare rd=seed(rsd);  // random stream for branches
#declare rdl=seed(rsd); // separate random stream for leaves

//-----------------------------------------
// Tree structure parameters        
// test with low level0 and nseg0 (3 or 4)
// High (>=6) recursion levels [level0] gives more complex trees
// High (>=6) segment numbers [nseg0] gives smoother trees
//-----------------------------------------
#declare level0=5;      // recursion level
//#declare level0=2;      // recursion level
#declare nseg0=7;       // initial number of branch segments (decreases of one at each level)
#declare nb=3;          // max number of branches per level         5
#declare dotop=true;   // if true, generates an extra branch on top of trunk (sometimes necessary to give more verticality)

#declare lb0=20;        // initial branch length
#declare rb0=1;         // initial branch radius
#declare ab0=20;        // initial branch angle (x angle between the trunk and the first branch)      25
#declare qlb=0.7;       // branch length decrease ratio (1=constant length)
#declare qrb=0.6;       // branch radius decrease ratio (1=constant radius)
#declare qab=1;       // branch angle decrease ratio (1=constant angle)
#declare stdax=10;      // stdev of x angle (angle x = ax+(0.5-rand)*stdax)
#declare stday=10;      // stdev of y angle (angle y = ay+(0.5-rand)*stday)

#declare branchproba=0.7; // probability of branch apparition                   0.9
#declare jb=0.4;        // secondary branches start after this ratio of branch length

#declare fgnarl=0.1;    // gnarledness factor - keep it low <0.8          0.3
#declare stdlseg=0.3;     // stddev of branch segment length (0...1) (adds more randomness to branch length)

#declare twigproba=0; // probability to have a twig on a trunk segment

#declare v0=<0,1,0>;    // initial direction - change to give an initial orientation
#declare pos0=<0,0,0>;  // initial trunk position (no need to change this one)

//-----------------------------------------
// constraints parameters
//-----------------------------------------
#declare vpush=<0,-0.1,0.0>;// direction of push (wind, gravity...) <0,-1,0> = gravity ; <0,1,0> = antigravity             -0.2
#declare fpush=0.3;       // force of push
#declare aboveground=8; // constrains the branches above this level 
#declare belowsky=1000;  // constrains the branches below this level 

//-----------------------------------------
// root parameters
//-----------------------------------------
#declare rootproba=1;   // probability of root 0=no root ; 1=all [nb] roots             0
#declare nroot=5;      // number of main roots;
#declare vroot=<1,-0.4,0>; // initial direction of root 
#declare yroot=<0,0.5,0>;   // initial position of root above ground

//-----------------------------------------
// leaf position parameters
//-----------------------------------------
#declare leafproba=1;   // probability of leaf 0=no leaf ; 1=leaf on each segment
#declare leaflevel=4;   // level where the leaves start to appear
#declare alz0=30;       // max z angle for leaf
#declare alx0=0;      // start x angle for leaf
#declare stdalx=20;     // std x angle for leaf
#declare stdlsize=0.1;  // stddev of leaf size 0=constant size; size = leafsize*(1+stdlsize*rand)

//-----------------------------------------
// leaf structure parameters
//-----------------------------------------
#declare txtLeaf=texture{txtLeaf_3} // Leaf texture
#declare lsize=0.9;     // leaf size
#declare seg=10;        // nb of leaf segments and stalk segments : increase to smooth
#declare ll=6;          // leaf length
#declare wl=1;          // leaf width 
#declare fl=0.8;        // depth of leaf fold
#declare lpow=3;        // modifies the leaf shape : lpow=3 makes heart-shaped leaf
#declare al=60;        // leaf bending angle : the leaf bends backward until this angle
#declare apow=1;        // curve power, how slow the leaf bends
#declare ndents=4;      // dents in the leaf (8 = "oak" leaf). May require a high seg >20
#declare nlobes=3;      // number of lobes (individual leaves)
#declare alobes=0;    // angle made by all the lobes
#declare qlobes=1;    // size of the farest lobe (0.9 = size will be 0.9*leaf length)                               
#declare ls=1;          // stalk length (0=no stalk)
#declare ws=0.1;        // width of stalk
#declare as=10;         // stalk bending angle : the stalk bends forward
//-----------------------------------------
// end of parameters
//=========================================

//=========================================
// Make the tree now !
//-----------------------------------------

object{
        #if (leafproba>0)
        #declare Leaf=object{MakeLeaf(lsize,seg,ll,wl,fl,lpow,al,apow,
                 ndents,nlobes,alobes,qlobes,ls,ws,as,dofile,ffname)
                 #if (dotexture=false)  // no texture applied to tree segments, so the leaf texture must be used for the individual leaf
                        texture{txtLeaf}
                 #end
        } 
        
        #end              
        MakeTree()
        
        #if (dotexture = true) // texture is already applied to tree so that we can safely apply the leaf texture to the leaves
                texture {txtLeaf}
        #else

                texture {txtTree} // apply tree texture  regardless of the tree structure
        #end  
        scale 0.06
        translate <-15,2,0>
}      



// create a regular point light source
#declare blossom = light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1.5>    // light's color
    
  // light_source { ...
  // put this inside a light_source to give it a visible appearance
  looks_like { 
  object {P_blossom_default} scale 0.1 rotate <45,0,90>}
  // light_source { ...
  // put this inside a light_source to add light fading
  fade_distance .5
  fade_power 30

}

object { blossom   translate <-15.5, 4.85, 1>    }     

object { berg
        translate <-2,1,0>
        rotate <0,10,0>
        scale 1
  // etc...
} // material_map       

object { berg
        translate <30,1,0>
        rotate <0,25,0>
        scale <10,15,10>
  // etc...
} // material_map 
 
// uses image color index as height, extends along X-Z axes
// from <0 0 0> to <1 1 1>
height_field {
  png               // the file type to read (tga/pot/pgm/ppm/png/sys)
  "berg_top.png"     // the file name to read
  smooth        // smooth surface normal
//  [water_level N] // truncate/clip below N (0.0 ... 1.0)
  texture {T_Stone14}
//  translate VECTOR | rotate VECTOR | scale VECTOR 
scale <100,7,40>
translate <-25,1.3,-10>
}









