// Date: 23/06/2003
// Auth: Jean-Charles Marteau
#include "functions.inc"

// ----------------------------------------
#declare Terre_Col=<220, 145, 90>/255;

#declare Sol=height_field {
  png               // the file type to read (tga/pot/pgm/ppm/png/sys)
  "sol_hf.png"     // the file name to read
  smooth        // smooth surface normal
  scale <10.0,0.9,10.0>
  translate <-5.0,0.0,-5.0>
  texture {
    pigment {
      granite
      color_map {
        [0.0 color rgb Terre_Col]
        [1.0 color rgb Terre_Col*0.6]
      }
      scale 10.0
    }
    normal { granite bump_size 0.1 scale 0.1 }
    finish { ambient 0.2 }
  }
}

#declare Fun_Sphere = function {x*x + y*y +z*z}

#declare Crumb =
isosurface {
   function {Fun_Sphere(x,y,z) + f_noise3d(x*2,y*2,z*2)*1}
   threshold 1
   max_gradient 3.9
   //max_gradient 15
   accuracy 0.01
   contained_by {box {-1,1}}
   scale 0.5
}

#macro Poser_Cailloux (Nb_Cailloux)
  #declare r1 = seed(2);
  #declare Norm=<0.0,0.0,0.0>;
  #declare I = 0;
  #while (I < Nb_Cailloux)
    #local XPos=10.0*rand(r1) - 5.0;
    #local ZPos=10.0*rand(r1) - 5.0;
    #local Pos=trace (Sol, <XPos, 1.0, ZPos>, <XPos,-1.0, ZPos>, Norm);
    #if (vlength (<-3.3,0.565,-5.8+5.0>-Pos) > 0.5)
      object {
        Crumb
        rotate <rand(r1), rand(r1), rand(r1)>*360
        scale (0.1+rand(r1)*0.15)*0.3
        translate Pos
        texture {
          pigment {color rgb <0.98, 0.83, 0.58>}
          normal {granite scale 0.01}
          finish {phong 0 brilliance 0.7}
        }
      }
    #end
    #declare I = I+0.03;
  #end
#end
