// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Orthographic Scene Example
//       useful for generating image_maps, heightfields, etc.
// Date: 23/06/2003
// Auth: Jean-Charles Marteau
//

#version 3.5;

global_settings {
  assumed_gamma 1.0
  // used in global_settings, sets image output to use grayscale only (TGA, PNG)
  hf_gray_16 // [on/off]
}

// ----------------------------------------

camera {
  orthographic
  location <0,0,1>     // position & direction of view
  look_at  <0,0,0>
  right 1*x            // horizontal size of view  \___ to be rendered at square size
  up 1*y               // vertical size of view    /
}

// ----------------------------------------
                      
#declare Pig1=pigment {
      granite
      color_map {
        [0.0 color rgb 0.0 ]
        [1.0 color rgb 1.0 ]
      }
}

#declare Pig2=pigment {
      dents
      color_map {
        [0.0 color rgb 0.0 ]
        [1.0 color rgb 1.0 ]
      }
      scale 0.1
}
                      
box {                  // this box fits exactly in view
  <-0.5, -0.5, 0>, <0.5, 0.5, 0>
  texture {
      pigment {
        average
        pigment_map {
          [1.0 Pig1 ]
          [0.0 Pig2 ]
        }
      scale 5.0
    }
    finish {
      ambient 1.0
      diffuse 0.0
    }
  }
}

