// Date: 23/06/2003
// Auth: Jean-Charles Marteau

#declare Tex_Photo=texture {
    pigment {
      image_map {
	jpeg "champignon_atomique.jpg" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
	map_type 0        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
	interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
	//once           // for no repetitive tiling
      } // image_map
      translate <-1,0,-1>
    }
    finish {
      phong 0.6
      phong_size 20
      reflection 0.01
      ambient 0.7
    }
    normal {
      dents scale 0.1
    }
  }


#declare B11=<0,0.1,3>; #declare B12=<1,0,3>; //
#declare B13=<2,0,3>; #declare B14=<3,0,3>; // row 1

#declare B21=<0,0,2>; #declare B22=<1,0,2>; //
#declare B23=<2,0,2>; #declare B24=<3,0,2>; // row 2

#declare B31=<0,0,1>; #declare B32=<1,0,1>; //
#declare B33=<2,0,1>; #declare B34=<3,0,1>; // row 3

#declare B41=<0,0.1,0>; #declare B42=<1,0,0>; //
#declare B43=<2,0,0>; #declare B44=<3,0.2,0>; // row 4

#declare photo_bic=bicubic_patch {
  type 1 flatness 0.001
  u_steps 4 v_steps 4
  uv_vectors
  <0,0> <1,0> <1,1> <0,1>
  B11, B12, B13, B14
  B21, B22, B23, B24
  B31, B32, B33, B34
  B41, B42, B43, B44
  uv_mapping
  texture { Tex_Photo }
  translate <-1.5,0.0,-1.5>
  rotate 180*y
}

#declare photo_cub=box {
  <0.0,0.0,0.0>, <1.0,0.01,1.0>
  texture { Tex_Photo rotate 90*x }
  translate <-0.5,0.0,-0.5>
  scale 3
}
