// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Orthographic Scene Example
//       useful for generating image_maps, heightfields, etc.
// Date: 23/06/2003
// Auth: Jean-Charles Marteau
//

#version 3.5;

// Standard pre-defined colors
//
#include "colors.inc"

#include "hf_tex.inc"

#local fn=3;//frame_number;

// used in global_settings, sets image output to use grayscale only (TGA, PNG)
global_settings {
  assumed_gamma 1.0
#switch (fn)
  #range (1,2)
  hf_gray_16 on
  #break
#end
}

#switch (fn)
  #range (1, 4)
    #default {
      finish {
        ambient 1.0
        diffuse 0.0
      }
  }

  camera {
    orthographic
    location <0,0,1>     // position & direction of view
    look_at  <0,0,0>
    right 1*x            // horizontal size of view  \___ to be rendered at square size
    up 1*y               // vertical size of view    /
  }
  #break
  #case (5)
  
#declare Radiosity=off;

global_settings {
  assumed_gamma 1.0
  //max_trace_level 25
  #if (Radiosity)
    radiosity {
      pretrace_start 0.08           // start pretrace at this size
      pretrace_end   0.04           // end pretrace at this size
      count 35                      // higher -> higher quality (1..1600) [35]
      nearest_count 5               // higher -> higher quality (1..10) [5]
      error_bound 1.8               // higher -> smoother, less accurate [1.8]
      recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
      low_error_factor .5           // reduce error_bound during last pretrace step
      gray_threshold 0.0            // increase for weakening colors (0..1) [0]
      minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
      brightness 1                  // brightness of radiosity effects (0..1) [1]

      adc_bailout 0.01/2
      //normal on                   // take surface normals into account [off]
      //media on                    // take media into account [off]
      //save_file "file_name"       // save radiosity data
      //load_file "file_name"       // load saved radiosity data
      //always_sample off           // turn sampling in final trace off [on]
      //max_sample 1.0              // maximum brightness of samples
    }
  #end
}

#default {
  texture {
    pigment {rgb 1}
    #if (Radiosity)
      finish {
        ambient 0.0
        diffuse 0.6
        specular 0.3
      }
    #else
      finish {
        ambient 0.1
        diffuse 0.6
        specular 0.3
      }
    #end
  }
}

// ----------------------------------------

camera {
  right x*image_width/image_height
  location  <0,1.5,-5>
  look_at   <0,1.5,0>
//  angle 29.0
}

light_source {
  <3,4,-10>       // light's position
  color rgb <1, 1, 1>  // light's color
}

light_source {
  <3,4,10>       // light's position
  color rgb <1, 1, 1>  // light's color
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

// ----------------------------------------

plane {
  y, 0
  texture {
    pigment {
      checker
      color rgb <1.0, 0.8, 0.6>
      color rgb <1.0, 0.0, 0.0>
      scale 0.5
    }
  }
}
  
  #break
#end
    
// ----------------------------------------
#switch (fn)
  #range (1, 2)
    box {
      <-0.5, -0.5, 0>, <0.5, 0.5, 0>
      texture {
        pigment {
          function { FMaxHF (x, y, z) }
          color_map {
            [0.0 Black]
            [1.0 White]
          }
        }
        translate x*(fn-1)
      }
    }
  #break
  #range (3, 4)
    box {
      <-0.5, -0.5, 0>, <0.5, 0.5, 0>
      texture {
/*
        pigment {
          function { max (0, F_Moss (x,y,z))/5 }
          color_map {
            [0.00 rgb 0.0]
            [0.58 rgb <0.1,0.0,0.0>]
            [0.58 rgb <0.0,0.0,1.0>]
            [1.00 rgb <0.0,0.0,1.0>]
          }
        }
*/
        function { FHF_Bricks(x, y, z).grey < FHF_Cover(x, y, z).grey }
        texture_map {
          [0.0 Pig_Bricks]
          [1.0 Pig_Cover]
        }
        translate x*(fn-3)

      }
    }
  #break
  #case (5)
    union {
      height_field {
        png "essai_adv_texture1.png"
        smooth
        texture {
          pigment {
            image_map { png "essai_adv_texture3.png" map_type 0 interpolate 2 once }
            rotate x*90
          }
        }
        scale <3.0, 0.035, 3.0>
        rotate -90*x
        translate <-3.0, 0.0, 0.025>
        rotate -45*y
      }
      height_field {
        png "essai_adv_texture2.png"
        smooth
        texture {
          pigment {
            image_map { png "essai_adv_texture4.png" map_type 0 interpolate 2 once }
            rotate x*90
          }
        }
        scale <3.0, 0.035, 3.0>
        rotate -90*x
        translate <0.0, 0.0, 0.025>
        rotate 45*y
      }
    }
  #break
#end
