// Persistence of Vision Ray Tracer Scene Description File
// File: puzzled.pov
// Vers: 3.5
// Desc:
// Date: 5/28/03
// Auth: J Moore

#include "metals.inc"
#include "golds.inc"
#include "shapes.inc"
#include "rand.inc"

#declare rad=no;
global_settings {
	max_trace_level 10
	#if (rad)
		radiosity {
			count 50
			nearest_count 9
		   	distance_maximum 0.1
    		error_bound 1.8
	    	minimum_reuse 0.01
		   	pretrace_start 0.08
    		pretrace_end   0.01
	    	brightness 1
		   	normal on
    		media on
		}
	#end
}

camera {
	up y
	right x*image_width/image_height
	angle 47
	//location <0.5, 2.5, -3>
	location <0.4, 2, -3>
	look_at <0, 0.45, 0>
}

//-----------------------------------------------------
// puzzle

#declare t_puz_im=
texture {
	pigment {
		image_map {jpeg "n8_l2.jpg" interpolate 2 once}
		rotate x*90
		translate <-0.5, 0, -0.5>
		rotate y*180
	}
	finish {
		reflection 1
		conserve_energy
	}
}

#declare t_puz_w=
texture {
	pigment {
		wrinkles
		color_map {
			[0 rgb <1, 0.95, 0.9>]
			[1 rgb 0.99]
		}
		scale 0.1
	}
	normal {granite 0.1 scale 0.2}
	finish {specular 0.5 roughness 0.01}
}

#declare t_puz_g=
texture {
	pigment {rgb <0.6, 0.5, 0.35>}
	normal {granite 0.1 scale 0.2}
	finish {specular 0.5 roughness 0.01}
}

#declare t_puz1=
texture {
	planar
	texture_map {
		[0 t_puz_im]
		[0.991 t_puz_im]
		[0.991 t_puz_g]
	}
}

#declare t_puz2=
texture {
	planar
	texture_map {
		[0 t_puz_w]
		[0.991 t_puz_w]
		[0.991 t_puz_g]
	}
}

#declare puzzle1=
height_field {
	png "puzzle1.png" smooth
	water_level 0.99
	translate <-0.5, -0.99, -0.5>
	texture {t_puz1}
	scale <1.5, 1, 1.2>
	rotate y*10
}

#declare puzzle2=
height_field {
	png "puzzle2.png" smooth
	water_level 0.99
	translate <-0.5, -0.99, -0.5>
	texture {t_puz2}
	scale <1.5, 1, 1.2>
	rotate y*8
	translate <-0.15, 0, 0.8>
}

#declare puzzle3=
height_field {
	png "puzzle3.png" smooth
	water_level 0.99
	translate <-0.5, -0.99, -0.5>
	texture {t_puz2}
	scale <1.5, 1, 1.2>
	rotate y*10
	translate <0.5, 0, 0.3>
}

#declare puzzle4=
height_field {
	png "puzzle4.png" smooth
	water_level 0.99
	translate <-0.5, -0.99, -0.5>
	texture {t_puz2}
	scale <1.5, 1, 1.2>
	rotate y*-10
	translate <0.13, 0.01, 0.28>
}

#declare puzzle5=
intersection {
	height_field {
		png "puzzle5.png" smooth
		translate <-0.5, -0.99, -0.5>
		texture {t_puz2}
		scale <1.5, 1, 1.2>
	}
	plane {-y, 0 texture {t_puz_g}}
}

#declare puzzles=
union {
	object {puzzle1}
	object {puzzle2}
	object {puzzle3}
	object {puzzle4}
}

//-----------------------------------------------------
// candle

#declare t_met=
texture {
	pigment {rgb <1, 0.95, 0.9>}
	normal {granite 0.05 scale 0.08}
	finish {diffuse .4 specular 1.2 roughness 0.02 reflection {.5 metallic} brilliance 4 metallic}
}

#declare t_dec=
texture {
	pigment {rgb <1, 0.95, 0.9>*0.1}
	normal {granite 0.05 scale 0.08}
	finish {diffuse .4 specular 1.2 roughness 0.02 reflection {.5 metallic} brilliance 4 metallic}
}

#declare t_ch=
texture {
	gradient y
	texture_map {
		[0 t_met]
		[0.012 t_met]
		[0.012 t_dec]
		[0.035 t_dec]
		[0.035 t_met]
		[0.43 t_met]
		[0.43 t_dec]
		[0.51 t_dec]
		[0.51 t_met]
		[1 t_met]
	}
}

#declare dec1=
union {
	#local ang=10;
	#local c1=0;
	#local c2=1;
	#while (c1<360)
		union {
			difference {
				torus {0.03, 0.007 rotate x*90}
				#if (odd(c2))
					plane {y, 0}
				#else
					plane {-y, 0}
				#end
			}
			sphere {<-0.03, 0, 0>, 0.008}
			sphere {<0.03, 0, 0>, 0.008}
			scale <1, 0.5, 0.25>
			rotate z*15
			#if (odd(c2))
				translate <0, 0.48, 0.2>
			#else
				translate <0, 0.46, 0.201>
			#end
			rotate y*c1
		}
		#local c1=c1+ang;
		#local c2=c2+1;
	#end
	texture {t_met}
}

#declare dec2=
union {
	#local ang=10;
	#local c1=0;
	#local c2=1;
	#while (c1<360)
		union {
			difference {
				torus {0.03, 0.01 rotate x*45}
				#if (odd(c2))
					plane {z, 0}
				#else
					plane {-z, 0}
				#end
			}
			sphere {<-0.03, 0, 0>, 0.011}
			sphere {<0.03, 0, 0>, 0.011}
			scale <1, 0.25, 0.5>
			rotate y*15
			#if (odd(c2))
				translate <0, 0.025, 0.29>
			#else
				translate <0, 0.025, 0.29>
			#end
			rotate y*c1
		}
		#local c1=c1+ang;
		#local c2=c2+1;
	#end
	texture {t_met}
}

#declare ch=
union {
	difference {
		union {
			lathe {
				cubic_spline
				11,
				<0, 0>, <0.3, 0>, <0.3, 0.02>, <0.1, 0.1>, <0.1, 0.2>, <0.2, 0.3>,
				<0.2, 0.5>, <0.225, 0.55>, <0.225, 0.56>, <0, 0.55>, <0, 0.55>
				hollow
			}
			torus {0.2025, 0.045 scale <1, 0.25, 1> translate y*0.555}
		}
		cylinder {y*0.4, y*0.57, 0.18 texture {t_met}}
	}
	object {dec1}
	object {dec2}
	texture {t_ch}
}

#declare drip=
lathe {
	cubic_spline
	8
	<0.02, 0.01>,
	<0, 0>,
	<0.02, 0.01>,
	<0.02, 0.02>,
	<0.01, 0.05>,
	<0.005, 0.09>,
	<0, 0.1>,
	<0.005, 0.09>
	sturm
	translate y*-0.1
}

#declare cshape=
merge {
	difference {
		cone {y*-1, 0.175, y*0.8, 0.15}
		sphere {0, 0.135 scale <1, 0.1, 1> translate y*0.8}
	}
	torus {0.13, 0.02 scale <1, 0.4, 1> translate y*0.8}
	#local sd=seed(11);
	#local step=5;
	#local ang=0;
	#while (ang<360)
		sphere {0, RRand(0.01, 0.02, sd)
			scale <RRand(0.9, 1.2, sd), RRand(0.8, 1, sd), RRand(0.7, 1, sd)>
			translate <0, 0.8, 0.131>
			rotate y*ang
		}
		#declare ang=ang+step;
	#end
	object {drip scale <0.5, 2, 0.5> translate <0, 0.79, -0.152>}
	object {drip scale <0.65, 3, 0.55> translate <0, 0.8, -0.152> rotate y*8}
	object {drip scale <1, 3, 0.7> translate <0, 0.8, -0.152> rotate y*-50}
	object {drip scale <0.65, 1.5, 0.5> translate <0, 0.79, -0.152> rotate y*200}
	object {drip scale <0.65, 1, 0.5> translate <0, 0.79, -0.152> rotate y*130}
	object {drip scale <0.65, 3, 0.55> translate <0, 0.8, -0.152> rotate y*180}
	object {drip scale <1, 3.5, 0.7> translate <0, 0.8, -0.152> rotate y*-185}
	hollow
}

#declare csh=
object {
	cshape
	no_shadow
	double_illuminate
	scale 0.99
	translate y*1.3
	texture {
		pigment {rgb <1, 0.95, 0.9>}
		finish {specular 0.2 roughness 0.3}
	}
}

#declare csi=
object {
	cshape
	hollow
	texture {
		pigment {rgbf <1, 0.95, 0.9, 1>}
	}
	interior {
		ior 1.4
		media {
			method 3
			samples 3, 3
			scattering {2, 0.35}
			absorption <0.5, 0.7, 0.9>
		}
	}
	translate y*1.3
}

#declare cf=
cylinder {y*-1, y*1, 1
	hollow
	pigment {rgbt 1}
	interior {
		media {
			method 1
			intervals 5
			samples 5, 5
			emission rgb 65
			density {
				spherical turbulence 0.3 lambda 8 omega 0.6
				density_map {
					[0 rgb 0]
					[0.1 rgb 0]
					[0.8 rgb 1]
					[1 blue 1]
				}
			}
			density {
				planar
				turbulence 0.1
				scale 1.1
				translate y*-0.6
				density_map {
					[0 rgb <0.9, 0.6, 0.3>]
					[0.3 rgb <1, 0.8, 0.4>]
					[0.55 blue 1]
				}
			}
		}
	}
	clipped_by {plane {-y, 0.1}}
	scale <0.07, 0.5, 0.07>
}

#declare wick=
sphere_sweep {
	linear_spline
	6,
	<0, 2.09, 0>, 0.01,
	<0, 2.09, 0>, 0.01,
	<0, 2.1, 0>, 0.01,
	<-0.01, 2.16, -0.005>, 0.01,
	<0.005, 2.25, 0>, 0.01,
	<0.01, 2.25, -0.005>, 0.01
	no_shadow
	pigment {
		gradient y
		color_map {
			[0 rgb 0.1]
			[0.93 rgb 0.1]
			[1 rgb <1, 0.5, 0.2>*5]
		}
		translate y*1.24
	}
}

#declare candle=
union {
	object {ch}
	object {csh}
	object {csi}
	object {wick}
	light_source {<0, 2.18, 0> rgb <1, 1, 0.75>*0.45
		looks_like {cf}
		fade_distance 7
		fade_power 2
		media_interaction on
		media_attenuation on
	}
}

//-----------------------------------------------------
//paint

#declare jar=
lathe {
	cubic_spline
	15,
	<0, 0>,
	<0, 0>,
	<0.15, 0>,
	<0.2, 0.05>,
	<0.25, 0.1>,
	<0.25, 0.2>,
	<0.2, 0.25>,
	<0.2, 0.3>,
	
	<0.18, 0.3>,
	<0.18, 0.25>,
	<0.24, 0.2>,
	<0.24, 0.1>,
	<0.19, 0.07>,
	<0, 0.05>,
	<0, 0.05>
	sturm
	pigment {rgbf <0.97, 0.99, 0.98, 0.99>}
	finish {
		ambient 0
		diffuse 0
		specular 0.9
		roughness 0.001
		reflection 0.3
	}
	interior {
		ior 1.5
		fade_distance 1
		fade_power 2
	}
}

#declare jarshape=
lathe {
	cubic_spline
	7,
	<0.18, 0.3>,
	<0.18, 0.25>,
	<0.24, 0.2>,
	<0.24, 0.1>,
	<0.19, 0.07>,
	<0, 0.05>,
	<0, 0.05>
	sturm
}

#declare t_paint_r=
texture {
	pigment {rgb <0.3, 0, 0>}
	normal {ripples 0.05}
	finish {specular 0.1 roughness 0.01}
}
#declare t_paint_b=
texture {
	pigment {rgb <0, 0, 0.3>}
	normal {ripples 0.05}
	finish {specular 0.1 roughness 0.01}
}
#declare t_paint_y=
texture {
	pigment {rgb <0.3, 0.3, 0>}
	normal {ripples 0.05}
	finish {specular 0.1 roughness 0.01}
}

#macro paint (txt)
	difference {
		cylinder {y*0.01, y*0.18, 0.3}
		object {jarshape inverse}
		scale 0.99
		texture {txt}
	}
#end

//-----------------------------------------------------
//brush

#macro brush (t_bpaint)

	#local t_brush=
	texture {
		pigment {rgb 0.1}
		normal {granite 0.5 scale <0.01, 1, 0.01>}
		finish {specular 0.1 roughness 0.5}
	}
	
	union {
		union {
			Round_Cone3_Union(<0, 0.7, 0>, 0.008, <0, 0.4, 0>, 0.012)
			cylinder {<0, 0.4, 0>, <0, 0, 0>, 0.012}
			pigment {
				wood
				turbulence 0.2 omega 0.9
				scale <0.02, 0.1, 0.02>
				color_map {
					[0 rgb <0.8, 0.6, 0.3>*0.7]
					[0.5 rgb <0.8, 0.6, 0.3>*0.6]
					[1 rgb <0.8, 0.6, 0.3>*0.5]
				}
			}
			normal {wood 0.1 turbulence 0.2 omega 0.9 scale <0.02, 0.1, 0.02>}
			finish {specular 0.2 roughness 0.2}
		}
		difference {
			cone {<0, 0, 0>, 0.013, <0, -0.1, 0>, 0.01}
			torus {0.013, 0.002 translate y*0.09}
			torus {0.013, 0.002 translate y*0.08}
			torus {0.013, 0.002 translate y*0.07}
			texture {T_Chrome_5C}
		}
		object {
			Round_Cone2_Union(<0, 0, 0>, 0.0099, <0, -0.05, 0>, 0.005)
			texture {
				planar
				scale 0.05
				turbulence 0.6 omega 0.8
				texture_map {
					[0 t_bpaint]
					[0.2 t_bpaint]
					[0.4 t_brush]
				}
			}
			scale <1, 1.5, 1>
			translate y*-0.08
		}
	}
#end

//-----------------------------------------------------
//dice

#declare t_die=
texture {
	pigment {rgb 1}
	finish {
		specular 0.5
		roughness 0.05
		reflection 0.1
	}
}

#declare t_dot=
texture {
	pigment {rgb 0.1}
	finish {
		specular 0.5
		roughness 0.05
		reflection 0.1
	}
}

#declare die=
difference {
	object {Round_Box_Merge(<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>, 0.1)
		pigment {rgb 1.2}
		finish {
			specular 0.5
			roughness 0.05
			reflection 0.1
		}
	}

	//1
	sphere {<0, 0, -0.5>, 0.07 texture {t_dot}}
		
	//2
	union {
		sphere {<-0.25, -0.5, -0.25>, 0.07}
		sphere {<0.25, -0.5, 0.25>, 0.07}
		texture {t_dot}
	}
		
	//3
	union {
		sphere {<-0.5, 0.25, 0.25>, 0.07}
		sphere {<-0.5, 0, 0>, 0.07}
		sphere {<-0.5, -0.25, -0.25>, 0.07}
		texture {t_dot}
	}
		
	//4
	union {
		sphere {<0.5, 0.25, -0.25>, 0.07}
		sphere {<0.5, -0.25, -0.25>, 0.07}
		sphere {<0.5, 0.25, 0.25>, 0.07}
		sphere {<0.5, -0.25, 0.25>, 0.07}
		texture {t_dot}
	}
		
	//5
	union {
		sphere {<-0.25, 0.5, -0.25>, 0.07}
		sphere {<-0.25, 0.5, 0.25>, 0.07}
		sphere {<0, 0.5, 0>, 0.07}
		sphere {<0.25, 0.5, -0.25>, 0.07}
		sphere {<0.25, 0.5, 0.25>, 0.07}
		texture {t_dot}
	}
		
	//6
	union {
		sphere {<-0.25, -0.25, 0.5>, 0.07}
		sphere {<-0.25, 0, 0.5>, 0.07}
		sphere {<-0.25, 0.25, 0.5>, 0.07}
		sphere {<0.25, -0.25, 0.5>, 0.07}
		sphere {<0.25, 0, 0.5>, 0.07}
		sphere {<0.25, 0.25, 0.5>, 0.07}
		texture {t_dot}
	}
}

//-----------------------------------------------------
//scissors

#declare scissors=
union {
	union {
		prism {
			linear_spline
			0, 0.005, 6
			<-0.25, 0.02>,
			<0.07, 0.02>,
			<0.09, 0>,
			<0.07, -0.01>,
			<-0.2, 0.01>,
			<-0.25, 0.02>
			translate z*-0.01
		}
		difference {
			cylinder {y*0, y*0.005, 0.05}
			cylinder {y*-1, y*1, 0.04}
			scale <1, 1, 0.6>
			translate <0.17, 0, 0.04>
		}
		difference {
			prism {
				cubic_spline
				0, 0.005, 11
				<0.07, 0.02>,
				<0.07, 0.02>,
				
				<0.11, 0.04>,
				<0.13, 0.06>,
				<0.14, 0.07>,
				<0.15, 0.03>,
				<0.12, 0.025>,
				
				<0.1, 0.005>,
				<0.083, 0>,
				<0.07, 0.02>,
				<0.07, 0.02>
				translate z*-0.01
			}
			cylinder {y*-1, y*1, 0.05 scale <1, 1, 0.6> translate <0.17, 0, 0.04>}
		}
	}
	union {
		prism {
			linear_spline
			0, 0.005, 6
			<-0.25, 0.02>,
			<0.07, 0.02>,
			<0.09, 0>,
			<0.07, -0.01>,
			<-0.2, 0.01>,
			<-0.25, 0.02>
			translate z*-0.01
		}
		union {
			difference {
				cylinder {y*0, y*0.005, 0.05}
				cylinder {y*-1, y*1, 0.04}
			}
			intersection {
				cylinder {y*0, y*0.005, 0.05}
				cylinder {y*-1, y*1, 0.04 inverse}
				object {Wedge(60) rotate x*180}
				translate <0.05, 0, 0.05>
				rotate y*-10
			}
			scale <1, 1, 0.6>
			translate <0.17, 0, 0.04>
		}
		difference {
			prism {
				cubic_spline
				0, 0.005, 10
				<0.07, 0.02>,
				<0.07, 0.02>,
				
				<0.11, 0.04>,
				<0.14, 0.07>,
				<0.15, 0.03>,
				<0.12, 0.025>,
				
				<0.1, 0.005>,
				<0.083, 0>,
				<0.07, 0.02>,
				<0.07, 0.02>
				translate z*-0.01
			}
			cylinder {y*-1, y*1, 0.05 scale <1, 1, 0.6> translate <0.17, 0, 0.04>}
		}
		rotate x*180
		rotate y*25
	}
	torus {0.005, 0.002 scale <1, 0.5, 1> translate y*0.005}
	translate y*0.005
	texture {T_Chrome_5E}
}

//-----------------------------------------------------
//table

#declare t_wood=
texture {
	pigment {
		wood turbulence 0.3 omega 0.7 lambda 8
		color_map {
			/*[0 rgb <0.45, 0.2, 0.15>*0.45]
			[0.5 rgb <0.45, 0.2, 0.1>*0.5]
			[0.95 rgb <0.45, 0.2, 0.1>*0.475]
			[1 rgb <0.45, 0.2, 0.1>*0.4]*/
			[0 rgb <0.45, 0.2, 0.15>*0.9*2]
			[0.5 rgb <0.45, 0.2, 0.1>*1*2]
			[0.95 rgb <0.45, 0.2, 0.1>*0.95*2]
			[1 rgb <0.45, 0.2, 0.1>*0.8*2]
		}
		scale <0.2, 0.1, 0.2>
		rotate y*85
		translate y*0.125
	}
	finish {specular 0.3 roughness 0.2}
	normal {dents 0.2 scale <0.1, 0.05, 0.05> turbulence 0.2}
}

#declare t_clear=
texture {
	pigment {rgbf <0.8, 0.9, 0.85, 0.85>}
	finish {specular 0.8 roughness 0.001}
}

#declare table=
union {
	difference {
		Round_Box_Merge (<-2, -0.2, -1.2>, <1.35, 0, 1.2>, 0.02)
		box {<-0.5, -0.01, -0.5>, <0.5, 1, 0.5> scale <1.65, 1, 1.15>*1.865 translate x*-0.325}	
		texture {t_wood scale <1, 1, 0.5>}
	}
	box {<-0.5, -0.011, -0.5>, <0.5, 0, 0.5>
		texture {
			image_pattern {png "equations.png" interpolate 2 once}
			rotate x*90
			translate <-0.5, 0, -0.5>
			texture_map {
				[0 T_Gold_2B]
				[0.7 T_Gold_2B]
				[0.7 t_clear]
			}
		}
		interior {ior 1.2}
		scale <1.65, 1, 1.15>*1.85
		translate x*-0.325
	}
	rotate y*12
	//translate y*-0.01
}

//-----------------------------------------------------
// haze

#declare haze=yes;
#declare ref=no;

#declare bg=
sphere {0, 1
	hollow
	texture {
		pigment {
			agate
			turbulence 0.2 lambda 8 omega 0.2
			color_map {
				[0 rgb <0.85, 0.85, 1>*0.2]
				[1 rgb 1.1*0.2]
			}
		}
		normal {
			wrinkles 0.05
			turbulence 0.8
			omega 0.2
			lambda 8
		}
		finish {
			ambient 0.2
			#if (ref) reflection {0.2, 0.6} #end
			conserve_energy
		}
	}
	#if (haze)
		interior {
			media {
				method 3
				intervals 1
				samples 20, 20
				scattering {3, 0.04}
				absorption <0.8, 0.5, 0.2>*0.1
				density {
					spherical
					density_map {
						[0 rgb 5]
						[0.6 rgb 1]
						[0.75 rgb 0.2]
						[1 rgb 0.1]
					}
				}
				density {wrinkles turbulence 0.8 omega 0.2 lambda 8 scale 0.01}
			}
		}
	#end
	scale 10
}

//-----------------------------------------------------
//person

#declare per=yes;
union {
	#if (per)
		#include "./temp/person.inc"
		object {
			person
			rotate y*180
			scale 7
		}
	#end
	object {
		puzzle5
		rotate x*25
		rotate y*45
		rotate z*25
		translate <0.16, 3.482, -1.075>
	}
	object {
		brush (t_paint_b)
		scale <1, 0.8, 1>
		rotate z*50
		translate <0, 3.597, -1.08>
	}
	rotate y*10
	translate <-0.3, -3.1, 2.1>
}

//-----------------------------------------------------
//-----------------------------------------------------

light_source {<0, 0, -9.9> rgb <0.25, 0.25, 0.3>
	rotate x*60
	shadowless
	parallel point_at y*0
	media_interaction off
	media_attenuation off
}

object {bg}
object {table}

object {jar scale 0.5 translate <-1.05, 0, 0.45>}
object {paint(t_paint_r) scale 0.5 translate <-1.05, 0, 0.45>}
object {jar scale 0.5 translate <-1.1, 0, 0.8>}
object {paint(t_paint_b) scale 0.5 translate <-1.1, 0, 0.8>}
object {jar scale 0.5 translate <-1.4, 0, 0.65>}
object {paint(t_paint_y) scale 0.5 translate <-1.4, 0, 0.65>}
object {brush(t_paint_r) rotate x*90 rotate y*-10 translate <-1.22, 0.012, 0.35>}

object {scissors scale <1.2, 1.5, 1.2> rotate y*-30 translate <-1.15, 0, 0.1>}

object {
	die
	scale 0.05
	rotate y*-30
	translate <0.28, 0.036, 0.3>
}
object {
	die
	rotate x*180
	scale 0.05
	rotate y*22
	translate <0.31, 0.036, 0.2>
}

object {puzzles translate z*-0.1}
object {candle scale 0.3 rotate y*165 translate <-1, 0, -0.4>}
object {candle scale 0.3 rotate y*35 translate <0.9, 0, -0.5>}

