
#version 3.5  ;

#include "colors.inc"
#include "functions.inc" 
#include "stones.inc"
#include "woods.inc"  
#include "skies.inc"     
#include "metals.inc"


// Gallery by chano 2003
//
// This image is best rendered with an aspect ratio of 3x2 - [1200x800,AA 0.2] recommended.
// 





//----------------------------Gallery Variables Section-----------------------------  
  
#declare sections = 6;  
#declare max_sculptors = 3;  
#declare ceil_thick = 3;
#declare bloxize = 5;  
#declare gallery_height = 18;
#declare gallery_length = 18;
#declare gap_factor = 0.45;  
#declare column_rad = 0.75;
#declare gap_count = 6;
#declare stick_size = 0.8; 
#declare column_position = 1.5; 
#declare block_height = 2;
#declare mid_block  = 1.5;
  
  
  

//----------------------------Global Settings Section----------------------------


 #declare T = true;
 #declare F = false;
 #declare R = seed(1);     
 #declare radiosityOn = T;
 #declare photonsOn = T;    
 #declare isonoise = F;   
 #declare sunlight = T;  

 
 #declare global_diffuse = 0.6;  
 #declare global_ambient = 0;
 #declare global_gradient = 3.5;
 #declare global_accuracy = 0.0001; 
 
 #declare sun_location = <-10, 100, 35>;    
 #declare sun_point_at = <20,20,14>;     
  
  
 #declare cam_location =  <-5,7,8+gallery_length>  ; 
 #declare cam_look_at = <2.5,3.5,2*gallery_length>  ; 
 
 global_settings { 
  number_of_waves 10 
  assumed_gamma 1.2
  #if(photonsOn)
   max_trace_level 5
   photons {
      spacing 0.004  // higher value than 0.001 means 'lower' quality, faster parsing.
      autostop 0
      jitter 0.5
      max_trace_level 15 
      load_file "gallery.map"
      
  } 
  
 #end
  
  #if(radiosityOn)
    radiosity {  
    
      //settings for a very fast but smooth shading, without "dirty" spots ! 
      
      pretrace_start 0.08  // 3 pretrace subdivisions 
      pretrace_end   0.02  // max and min level :: 0.08 - 0.02
      count 500            // 500 min for good results 

      nearest_count 15   // 12  , increase if necessary
      error_bound 0.6    // 0.5 , less makes slow but more detailed edges and more dirty spots !
      recursion_limit 1  // 1   , higher slows down immensly, better leave it for caustics and photons 
      
      // leave this values 
      low_error_factor 0.2
      gray_threshold 0.0
      minimum_reuse 0.015
      brightness 1

      adc_bailout 0.01/2


  } #end


}  

 
//------------------------Texture Declaration Section----------------------------------------
 
#declare T_Chroma = texture {
   
   pigment{ color rgb 1 } 
   
   finish {
            ambient 0.0
            brilliance 6
            diffuse 0.2
            metallic
            specular 0.80
            roughness 1/120
            reflection 0.8
       }

}



#declare plastic = texture{
   
   pigment { color rgb <0.4,0.35,0.3> } 
   finish { phong 0.4 specular 0.3  diffuse 0.2+global_diffuse ambient global_ambient } 
 
   
   
}   
    


#declare marsh_mellow = texture {
 
 pigment { color rgb <0.93,0.9,0.6> }
 
 finish { diffuse 0.8 ambient global_ambient  phong 0}


}


 
#declare wall_color = texture {
 
 pigment { color rgb <1,1,0.92> }
 
 finish { diffuse global_diffuse+0.4 ambient global_ambient crand 0.01 }


}   
    




 
#declare T_Anthrazit = texture{
   
   pigment { color rgb <0.3,0.35,0.4> } 
   finish {  specular 0.3 roughness 20 diffuse 0.8 ambient global_ambient } 
 
   
   
}


   
   
 #declare T_Floor = texture{
 
  
  pigment{granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbt <0.500, 0.551, 0.857, 0.000>
                    color rgbt <0.696, 0.735, 0.937, 0.000>]
    [0.154, 0.308   color rgbt <0.696, 0.735, 0.937, 0.000>
                    color rgbt <0.500, 0.551, 0.757, 0.000>]
    [0.308, 0.444   color rgbt <0.500, 0.551, 0.757, 0.000>
                    color rgbt <0.494, 0.524, 0.804, 0.000>]
    [0.444, 0.615   color rgbt <0.394, 0.524, 0.804, 0.000>
                    color rgbt <0.500, 0.551, 0.757, 0.000>]
    [0.615, 0.812   color rgbt <0.500, 0.551, 0.757, 0.000>
                    color rgbt <0.325, 0.555, 0.851, 0.000>]
    [0.812, 1.001   color rgbt <0.425, 0.555, 0.851, 0.000>
                    color rgbt <0.500, 0.551, 0.957, 0.000>]
   }
 }  
 
 
 finish{ ambient global_ambient diffuse 0.5 specular 0.2 roughness 20 reflection 0.07 }
 
                                                                                      
 
                                                                                               
                                                                                               
 }  

//------------------------Material Declaration Section----------------------------------------

#declare M_Water=    // Water material
material {
  texture {
    pigment {rgbt 0.9}
    finish {
      ambient 0.0
      diffuse 0.0
      specular 0.4
      roughness 0.004
      reflection {
        0.05, 1.0
        fresnel on
      }
      conserve_energy
    }
  }
  interior {
    ior 1.35
    fade_power 1000
    fade_distance 0.2
    fade_color <0.93,0.95,0.95>
  }
}

//standard glass material 
#declare M_Glass=    // Glass material
material {
  texture {
    pigment {rgbt <0.9,0.4,0.2,0.7>}
    finish {
      ambient 0.0
      diffuse 0.0
      specular 0.6
      roughness 0.005
      reflection {
        0.1, 0.7
        fresnel on
        }
      conserve_energy
    }
  }
  interior {
    ior 1.4
    fade_power 1001
    fade_distance 1.6
    fade_color <0.85,0.8,0.4>
  }
} 
                                                                            
                                                                            
                                                                            
                                                                            
                                                                            
                                                                            
//------------------Object Declaration Section------------------------------  



#declare sculptor = isosurface {

       
        #declare f1 = 2; 
        
        function {     
              
                f_sphere(x,y,z,1)+(cos(z*y)-1)
                
        }  
        
        max_gradient global_gradient
        accuracy global_accuracy                       
        threshold 0
                                                                                                
                                                    
        contained_by { sphere { <0,0,0>,3.5 } }  
        rotate x*45
        translate 2.7*y
        

}  




#declare sculptor_plate = difference{
     
     superellipsoid{  
         
         <0.05,0.05>
         texture{ T_Chroma }   
         scale <0.2,0.5,1>
         
     }

     
     text { ttf "tycho.ttf" "chano"
	     .28,0  
	     rotate -y*90
	     scale 0.4
             translate <-0.1,0,-0.8>
                 
             pigment{ color rgb 0}   
            
            
            }   
            
     text { ttf "arial.ttf" "2003"
	     .5,0  
	     rotate -y*90
	     scale 0.4
             translate <-0.1,-0.4,-0.5>
                 
             pigment{ color rgb 0}   
            
            
            }    
    scale 0.8 
}

#declare picture = union{

   box{ <-3,-2,0>,<3,2,-0.1>        
   
   pigment { image_map { tga "gallery" }  rotate y*180  scale <6,4,1>  translate <3,2,0>}
 
   finish {  diffuse 1  ambient .3 reflection 0.2 phong 0.4}  
   
   }  
   
   box{ <-1,-2.5,0>,<-2.8,-3.7,-0.05>        
   
   pigment { image_map { tga "picture_txt" }  rotate y*180  scale <1.8,1.2,1>  translate <-2.8,-3.7,0>}
 
   finish {  diffuse 1  ambient .1}  
   
   } 
   
   difference{
    
    box{ <-3.1,-2.1,-.1>,<3.1,2.1,.1> }
    box{ <-3,-2,-1>,<3,2,1> }

   
    texture{ T_Anthrazit }
   } 
   
   scale 1.2
   translate y*2
}


#declare gallery_section = union {

      
        //floor  
        box{ <-gallery_length,0,-gallery_length>,<gallery_length,-1,gallery_length> texture{ T_Floor } }  
        
        //blox
        box{ <-gallery_length,0,-gallery_length>,<-gallery_length+2*bloxize,gallery_height,-gallery_length+bloxize> texture{ wall_color } }    
        box{ <gallery_length,0,-gallery_length>,<gallery_length-2*bloxize,gallery_height,-gallery_length+bloxize> texture{ wall_color } } 
        box{ <-gallery_length,0,gallery_length>,<-gallery_length+2*bloxize,gallery_height,gallery_length-bloxize> texture{ wall_color } } 
        box{ <gallery_length,0,gallery_length>,<gallery_length-2*bloxize,gallery_height,gallery_length-bloxize> texture{ wall_color } } 
        
        //walls 
        box{ <-gallery_length,0,-gallery_length>,<-1-gallery_length,gallery_height+ceil_thick,gallery_length> texture{ wall_color } }   
        box{ <gallery_length,0,gallery_length>,<1+gallery_length,gallery_height+ceil_thick,-gallery_length> texture{ wall_color } }   
       
        
        //ceiling
        box{ <-1-gallery_length,gallery_height,-1-gallery_length>,<-gallery_length*gap_factor,gallery_height+ceil_thick,1+gallery_length> texture{ wall_color } }   
        box{ <1+gallery_length,gallery_height,-1-gallery_length>,<gallery_length*gap_factor,gallery_height+ceil_thick,1+gallery_length> texture{ wall_color } }   
      
        //colums
        cylinder { <-column_position*bloxize,0,0>,<-column_position*bloxize,gallery_height,0>,column_rad texture{ wall_color } }   
        cylinder { <column_position*bloxize,0,0>,<column_position*bloxize,gallery_height,0>,column_rad texture{ wall_color } }   
        
        //sculture
        box{ <-mid_block,0,-mid_block>,<mid_block,block_height,mid_block> texture{ plastic } }   
        // object{ sculptor scale 0.8 rotate <0,90,0>  translate <0,block_height,0> }  
        object{ sculptor_plate scale mid_block/2 rotate -y*90 translate<0,block_height*0.5,-mid_block+0.04> }

        //pictures 
        object{ picture rotate y*0 translate <gallery_length-bloxize,0.3*gallery_height,gallery_length-bloxize>     }   
        //object{ picture rotate y*180 translate <gallery_length-bloxize,0.3*gallery_height,-gallery_length+bloxize>     }
        object{ picture rotate y*90 translate <gallery_length,0.3*gallery_height,0>} 
        //object{ picture rotate -y*90 translate <-gallery_length,0.3*gallery_height,0>}
      
        
        //gap sticks
        #declare stick_step = 2*gallery_length/gap_count;
        #declare gap = 1;
        #while(gap < gap_count)  
        box{ <-gallery_length*gap_factor,gallery_height,gap*stick_step-gallery_length-stick_size>,<gallery_length*gap_factor,gallery_height+ceil_thick,gap*stick_step+stick_size-gallery_length> texture{ wall_color } }   
        #declare gap = gap+1;
        #end 
 


} 
#declare gallery = union {
     
       
       //end walls
       box{ <-gallery_length,0,gallery_length>,<gallery_length,gallery_height+1,-1+gallery_length> texture{ wall_color } }    
       box{ <-gallery_length,0,(2*sections+1)*gallery_length>,<gallery_length,gallery_height+1,1+(2*sections+1)*gallery_length> texture{ wall_color } }   
       #declare section = 1;
       
       #while(section <= sections)
        object{ gallery_section translate <0,0,section*gallery_length*2> }
        #if(section <= max_sculptors)
        object{ sculptor scale 0.8 rotate <0,90,0>  translate <0,block_height,section*gallery_length*2> material{ M_Glass } photons{ target 1 refraction on reflection off } }  
        #end
       #declare section = section+1;
       #end 
       
       
} 


//--------------------Object Placement Section-------------------------- 


object{ gallery }


//----------------background------------------------




sky_sphere {   pigment { color rgb <0.6,0.6,1> }  } 
        
       

#if (sunlight)     
light_source {

 sun_location  
 color rgb <0.98,0.95,0.8>  
 parallel
 point_at sun_point_at
 
 
}
#else
light_source {

 <0,gallery_height/2, 4*gallery_length>   
 color rgb <0.98,0.95,0.8>  



}
#end


camera {

location cam_location 
       
        

look_at cam_look_at  
     
       
up <1,0,0>
right <1.5,0,0>
sky <0.1,1,0>  

angle 70

}     
  
  