// =========================================
// Rapa nui mystery
// -----------------------------------------
// The Cloud macro and Grass macro are Copyright Gilles Tran May 2003 http://www.oyonale.com
// Everything else is Copyright Antoine Allain June 2003
// -----------------------------------------
// Feel free to use and modify
// -----------------------------------------
// Render this image with a 2 ratio such as 1200*600
// -----------------------------------------
// Render stats on a Pentium III 1 Gz, 320 Mb Ram
// 1600 * 800 +A0.3
// Render time 11h50mn
// ----------------------------------------- 
// This image was created for the May June 2003 Round of IRTC : Mystery
// =========================================

#version 3.5;

#include "colors.inc"
#include "functions.inc"

//---------------------------------------
// Switches
//---------------------------------------
#declare RadOK=1; // radiosity off=0/on=1
#declare CloudOK=1; // clouds on=1
#declare CloudTest=0; // Red Clouds =1
#declare GrassOK=1; // Grass on =1
#declare ColumnOK=1; // Column of Light=1
#declare FogOK=1;    // Fog on =1
#declare MoaiOK=1;   //Moais and colline =1
#declare StonesOK=1;

#declare Intervals=4; // cloud media intervals 1 for tests and higher values (2-5) for smoother results
#declare Turbulence=0.15; // cloud turbulence
#declare Lambda=2.1; // cloud lambda
#declare Omega=0.8; // cloud omega


//---------------------------------------
// Settings
//---------------------------------------
global_settings {
    assumed_gamma 1 // use a higher value if necessary
    max_trace_level 250
    #if (RadOK=1)
        radiosity {
            count 10
            recursion_limit 1
            low_error_factor .5 
            gray_threshold 0.0  
            minimum_reuse 0.015 
            brightness 0.8
            adc_bailout 0.01/2
        }
    #end
}

//---------------------------------------
// Camera
//---------------------------------------
camera {
  location  <0, 0, 0>
  direction z
  sky y+x*0.02 
  right     image_width/image_height*x
  look_at   z*1000
  angle 70
  rotate -x*3.5
  translate y*251.65
}

//---------------------------------------
// Common stuff
//---------------------------------------

#declare C_SkyTop=rgb <153,172*1.06,190*1.06>/255;
#declare C_SkyBottom=rgb <123/1.06,132*1.06,139*1.06>/209;
#declare C_Sun=C_SkyBottom/2;
#declare C_Cloud=White*0.7;

#declare C_Sun2=color (White*0.5+0.4*Yellow+0.4*Red)/6;

#declare T_Clear=texture{pigment{Clear}finish{ambient 0 diffuse 0}}

#macro GammaColor(Color,Gamma)
    rgb <pow(Color.red,Gamma),pow(Color.green,Gamma),pow(Color.blue,Gamma)>
#end

//---------------------------------------
// Sun and sky
//---------------------------------------
#declare Transform_Sun=transform{
    rotate x*20
    rotate y*104
}


sky_sphere {
    pigment {
        function {min(1,max(0,y))}
        poly_wave 0.2
        color_map{
            [0 color C_SkyBottom]
            [0.2 color C_SkyBottom*4]
            [0.8 color C_SkyTop*1]
        }
    }
} 

plane{y,0 
    pigment{
        bozo 
        poly_wave 1
        turbulence 1
        lambda 4
        color_map{
            [0 C_SkyBottom]
            [0.2 color C_SkyBottom*2]
            [1 color C_SkyTop*0.5]
        }
    }
    finish{ambient 1 diffuse 0}
    hollow
    no_shadow
    scale <1,1,1>*4
    translate y
    scale 200000
}    

#if (FogOK =1)
  fog { C_SkyBottom fog_type 2 distance 4000 fog_alt 800 }
#end


//---------------------------------------
// Clouds
//---------------------------------------
#declare rd=seed(10);
#declare C_Scattering=C_Cloud*0.004;
#declare C_Absorption=(1-C_Cloud)*0.0005;
#if (CloudOK=1)
#debug "Clouds\n"
    #declare Cloud1=box{-0.5,0.5
       #if ( CloudTest = 1 ) 
        texture{pigment{Red}finish{ambient 0 diffuse 1}}
       #else
        texture{pigment{Clear}finish{ambient 0 diffuse 0}}
        hollow
        interior{
            media{
                scattering{1,C_Scattering extinction 0.3}
                absorption C_Absorption
                intervals Intervals
                density{
                    density_file df3 "cloud2_1.df3"
                    turbulence Turbulence
                    lambda Lambda
                    omega Omega
                    interpolate 1
                    translate -0.5
                    scale <1,-1,1>
                }
            }
        }
        #end
        scale <4/3,1,1>
    }

    #declare Cloud2=box{-0.5,0.5
       #if ( CloudTest = 1 ) 
        texture{pigment{Red}finish{ambient 0 diffuse 1}}
       #else
        texture{pigment{Clear}finish{ambient 0 diffuse 0}}
        hollow
        interior{
            media{
                scattering{1,C_Scattering extinction 0.3}
                absorption C_Absorption
                intervals Intervals
                density{
                    density_file df3 "cloud2_5.df3"
                    turbulence Turbulence
                    lambda Lambda
                    omega Omega
                    interpolate 1
                    translate -0.5
                    scale <1,-1,1>
                }
            }
        }
        #end
        scale <4/3,1,1>
    }

    #declare Cloud3=box{-0.5,0.5
       #if ( CloudTest = 1 ) 
        texture{pigment{Red}finish{ambient 0 diffuse 1}}
       #else
        texture{pigment{Clear}finish{ambient 0 diffuse 0}}
        hollow
        interior{
            media{
                scattering{1,C_Scattering extinction 0.3}
                absorption C_Absorption
                intervals Intervals
                density{
                    density_file df3 "cloud2_3.df3"
                    turbulence Turbulence
                    lambda Lambda
                    omega Omega
                    interpolate 1
                    translate -0.5
                    scale <1,-1,1>
                }
            }
        }
        #end
        scale <4/3,1,1>
    }
    #declare Cloud4=box{-0.5,0.5
       #if ( CloudTest = 1 ) 
        texture{pigment{Red}finish{ambient 0 diffuse 1}}
       #else
        texture{pigment{Clear}finish{ambient 0 diffuse 0}}
        hollow
        interior{
            media{
                scattering{1,C_Scattering extinction 0.3}
                absorption C_Absorption
                intervals Intervals
                density{
                    density_file df3 "cloud2_4.df3"
                    turbulence Turbulence
                    lambda Lambda
                    omega Omega
                    interpolate 1
                    translate -0.5
                    scale <1,-1,1>
                }
            }
        }
        #end
        scale <4/3,1,1>
    }

//---------------------------------------------
// Cloudscape
//---------------------------------------
light_group{
    light_source {
        -z*100000
        color C_Sun2
        transform{Transform_Sun}
    }
    union{
        
        object{Cloud2 scale <-1,1,1> scale 7000 translate <2500,500,7000>}
        
        object{Cloud2 scale <1,1,1> scale 7000 translate <-6000,0,17000>}
        object{Cloud2 scale <-1,1,1> scale 7000 translate <-13000,0,25000>}
        object{Cloud2 scale <-1,-1,1> translate -y*0.23 scale 7000 translate <8000,0,22000>}
        union{
            object{Cloud3 scale <-1,1,-1> scale 7000 translate <-20000,0,-2000>}
            object{Cloud4 scale <1,1,1> scale 8000 translate <-1000,0,-1000>}
            object{Cloud1 scale <1,1,1> scale 16700 translate <8000,0,3660>}
            object{Cloud3 scale <-1,1,1> scale 6300 translate <19500,0,3200>}
            translate z*45000
            scale <-1,1,1>
        }
        
        union{
            object{Cloud2 scale <-1,1,-1> scale 7000 translate <-30000,0,-2000>}
            object{Cloud3 scale <1,1,1> scale 8000 translate <-10000,0,-1000>}
            object{Cloud4 scale <1,-1,-1> scale 8000 translate <2000,0,1000>}
            object{Cloud1 scale <1,1,1> scale 16700 translate <18000,0,3660>}
            object{Cloud4 scale <-1,1,1> scale 6300 translate <38000,0,-3200>}
            translate z*65000
            scale <1,1,1>
        }
        translate y*4000
    }
    global_lights on
}    
#end


//---------------------------------------------
// Ground Pigment
//---------------------------------------------

#macro Pig02(Bright)
  bozo
  color_map {
    [0.39 color rgb <0.537, 0.416, 0.325>*Bright ]
    [0.42 color rgb <0.608, 0.345, 0.169>*Bright ]
    [0.61 color rgb <0.608, 0.345, 0.169>*Bright ]
    [0.64 color rgb <0.537, 0.416, 0.325>*0.3*Bright ]
  }
  turbulence 0.4
  scale 0.6
#end

#macro Pig01(Bright)
  granite
  pigment_map {
    [0.35 color rgb <0.32, 0.35, 0.34>*0.6*Bright ]
    [0.42 color rgb <0.65, 0.33, 0.15>*0.8*Bright ]
    [0.61 color rgb <0.65, 0.33, 0.15>*0.8*Bright ]
    [0.65 Pig02(Bright)  ]
  }
  turbulence 0.6
  scale 2
#end


#macro Ground_Pig_01(Bright)
    bozo
    pigment_map {
      [0.41 Pig01(Bright)  ]
      [0.43 Pig02(Bright)  ]
      [0.62 Pig02(Bright)  ]
      [0.64 color rgb <0.88, 0.87, 0.65>*Bright ]
    }
    turbulence 0.25
    scale 0.3
    scale 1/20
#end

//---------------------------------------------
// Ground Object                                
//---------------------------------------------

#declare Ground=
  plane {
    y, 0
  texture{
    pigment {
      spherical
      pigment_map {
        [0.1 Ground_Pig_01(0.2) ]
        [0.8 Ground_Pig_01(0.6) ]
      }
      scale 20
    }
    finish {
      ambient 0
      diffuse 0.6
    }
    normal {
      wrinkles 0.9
      scale 0.3
    }
  }
}

object { Ground }

//---------------------------------------------
// Water
//---------------------------------------------

#declare carre = height_field {
  function 800,800 { (sin(y*pi*5)+1)/3+f_ridged_mf(x*14, y*30,z, 1.2,3,6,1.18,5,1)*0.55/3}
  smooth
  translate <-0.5,-0.5,-0.5>
  scale <1000,10,1000>
  translate <0,0,0>
  pigment {
   slope y
    color_map { 
     [0 White]
     [0.3 SteelBlue*0.1]
     [0.35 White*2]
     [0.65 Gray60]
     [0.7 White*1.5]
     [1 rgbf <0.055, 0.185, 0.21, 1>/2 ]
  }
  }
}

#declare rr1=seed(10);
#declare rr2=seed(35);       

#declare NX=20;
#declare NZ=10;
#declare SeaSurface=union{
    #declare i=0;
    #while (i<NZ)
        #declare j=0;
        #while (j<NX)
            object{ carre  translate <-10500+j*900+(rand(rr1)-0.5)*100,200,650+i*900+(rand(rr2)-0.5)*100> }
            #declare j=j+1;
        #end
        #declare i=i+1;
    #end
}

plane { y, 165 pigment { rgb <0.055, 0.185, 0.21>/2 } }

light_group{
    light_source {
        -z*100000
        color C_Sun2
        transform{Transform_Sun}
    }
    
    object { SeaSurface }
          
    global_lights on
}    

//---------------------------------------------
// Moais
//---------------------------------------------

#declare Pupils_Material= material { texture {  
    pigment {
      granite  
      color_map {
        [0.5 color rgb <0, 0, 0> ]
        [0.8 color rgb <0.05, 0.05, 0.1> ]
      }
      turbulence 2
      scale 1
    }
    finish {
      ambient 0.5
      diffuse .5
      brilliance .2
      specular 0.2
      }
    }
}

#declare Eyes_Material= material { texture {  
    pigment {
      granite  
      color_map {
        [0.5 color rgb <1, 1, 1> ]
        [0.8 color rgb <0.7, 0.4, 0.7> ]
      }
      turbulence 2
      scale 1
    }
    finish {
      ambient 0.5
      diffuse .5
      brilliance .2
      specular 0.2
      }
    }
}


#declare T_Stones1= material { texture {
    pigment {
      granite  
      color_map {
        [0.1 color rgb <0.75, 0.3, 0.2>*0.40 ]
        [0.7 color rgb <0.70, 0.46, 0.2>*0.25 ]
        [1.0 color rgb <0.10, 0.10, 0.10> ]
      }
      turbulence 5
      scale .8
    }

    finish {
      ambient 0.7
      diffuse 0.9
      brilliance .02
      specular 0.2
      roughness 0.11                    
      }
    normal { granite 0.14 scale .09 }
    }
}

#declare T_Stones2= material { texture {
    pigment {
      granite  
      color_map {
        [0.1 color rgb <0.55, 0.5, 0.5>*1.20 ]
        [0.7 color rgb <0.42, 0.40, 0.25>*0.8 ]
      }
      turbulence 4
      scale .2
    }
    finish {
      ambient 0.0
      diffuse 0.4
      brilliance .20
      specular 0.8
      roughness 0.4                    
      }
    normal { granite 0.1 scale .09 }
    }
}

// Corps
#declare Object1 = object {
   #include "rapa2_1.inc"
}

// Pupil
#declare Object2 = object {
   #include "rapa2_2.inc"
}

// Eye
#declare Object3 = object {
   #include "rapa2_3.inc"
}

// Eye
#declare Object4 = object {
   #include "rapa2_4.inc"
}

// Pupil
#declare Object5 = object {
   #include "rapa2_5.inc"
}

// Hat1
#declare Object6 = object {
   #include "rapa2_6.inc"
}

// Hat2
#declare Object7 = object {
   #include "rapa2_7.inc"
}



#declare Moai= union {
        object { Object1 material { T_Stones2 }}
        object { Object2 material { Pupils_Material }}
        object { Object3 material { Eyes_Material }}
        object { Object4 material { Eyes_Material }}
        object { Object5 material { Pupils_Material }}
        object { Object6 material { T_Stones1 }}
        object { Object7 material { T_Stones1 }}
        rotate < 0, 0, -2>                      }

//---------------------------------------------
// Colline
//---------------------------------------------
    
#declare Colline=    
bicubic_patch {
  type 1
   flatness 0.1 
  u_steps 3 
  v_steps 3 
  <0, 0, 0> <1, 0, 0> <2, 0, 0> <3, 0, 0>
  <0, -12/80, 1> <1, 0, 1> <2, 0, 1> <3, 0, 1>
  <0, -18/80, 2> <1, 0, 2> <2, 0, 2> <3, 0, 2>
  <0, -36/80, 3> <1, -18/80, 3> <2, -3/80, 3> <3, -3/80, 3>
  translate < -1.5, 0, -1.5>
  scale 1/3
  scale 80
  translate < 0, 251.5, 0>
  texture{
    pigment {
        bozo  
        color_map {
         [0.1 color rgb < 0.667, 0.502, 0.345>*1.6 ]
         [0.5 color rgb < 0.667, 0.502, 0.345>*1.5 ]
         [0.8 color rgb < 0.667, 0.502, 0.345>*1.3 ]
         }
         turbulence 2
         scale 0.2 
    }
    finish {
      ambient 0
      diffuse 0.2
      crand 0.3
    }
    normal {
      wrinkles 5
      scale 5
    }
  }
}

//----------------------------------------
// Placement Moais et Colline
//----------------------------------------
#if (MoaiOK=1)
light_group{
    light_source {
        -z*100000
        color C_Sun2
        transform{Transform_Sun}
    }
    
    object { Colline  }       
       
    object { Moai  rotate < 0, -40, -1> translate < 0, 250, 6> }   

    object { Moai  rotate < 0, -35, -1> scale < 1, 1, 1> translate < 5.5, 250.2, 10> }

    object { Moai  rotate < 0, -50, -2> translate < -7, 248.7, 16> }  
          
}
#end    


// --------------------------------------
// Grass texture
// --------------------------------------

#declare Blanc1=rgb<0.90,0.81,0.81>;

#declare Green1=rgb<230,170,50>/255;
#declare Green2=rgb<110,160,8>/255;


#declare pigSpotted =pigment {
spotted
    color_map {
        [0.0, 0.2   color Tan*0.1 color Tan*0.4]
        [0.2, 0.3   color Tan*0.4 color Green1]
        [0.3, 1.01   color Green1 color Green1*1.2]
    }
}

#declare pigEarth =pigment {
    spotted
    color_map {
        [0 color Tan*0.3]
        [0.6 color Tan*0.3]
        [0.6 color Green1*0.4]
        [1   color Green1*0.4]
    }
}
#declare pigGreen=pigment{Green2*1.3}
#declare txtGrass=texture {                  

                pigment {
                        gradient y
                        turbulence 0.2
                                pigment_map {                                
                                    [0.0 pigEarth]
                                    [0.1 pigGreen]
                                    [0.2 pigSpotted]
                                    [1.00 pigEarth]
                                }
                        }

        finish{ambient 0.01 diffuse 0.7 specular 0.2 roughness 0.015}
        scale <0.001,1,0.001>
 
} 

//---------------------------------------
// Placement sur la colline
//---------------------------------------

#if ( GrassOK =1  )

#declare Normale_du_Point = <0,0,0>;
#declare r1=seed(0);
#declare r2=seed(21);
#declare r3=seed(109);
#declare r4=seed(134);
#declare r5=seed(32);

#declare Grass_patch=#include "fgrass1.inc"

#declare Grass = union { 
#declare Max=20;
#declare I=0;
#while (I < Max)
 #declare J=0;
 #while (J < Max)                                                       
  #declare Point_Depart = <-18+I*28+rand(r4)*0.4,252,2+J*20+rand(r5)*0.4>;
  #declare Orientation = <0,-1,0>;     
  #declare Point_Intersection = 
    trace (Colline, Point_Depart, Orientation, Normale_du_Point);
  
  #if (Normale_du_Point.x = 0 & Normale_du_Point.y = 0 & Normale_du_Point.z = 0  ) 
  #else #if ( Point_Intersection.x < 3 | Point_Intersection.x > 5)
     object {  Grass_patch  
         texture{txtGrass scale 10}
         rotate < 0, 90+10*(rand(r3)-0.5), 0> 
         matrix < 1, 0, 0,
         Normale_du_Point.x, Normale_du_Point.y, Normale_du_Point.z,
         0, 0, 1,
         0, 0, 0 >
         scale <0.03*rand(r2), 0.015,0.03*rand(r2)> translate Point_Intersection 
         } #end
    #end
 #declare J=J+(1/Max);
 #end  
#declare I=I+(1/Max);
#end                    
}

light_group{
    light_source {
        -z*100000
        color C_Sun2
        transform{Transform_Sun}
    }
    
    object { Grass }
          
    global_lights on
}    

#end

//---------------------------------------
// Pierres sur la colline
//---------------------------------------

#if ( StonesOK =1  )

#declare Normale_du_Point = <0,0,0>;
#declare r1=seed(0);
#declare r2=seed(21);
#declare r3=seed(109);
#declare r4=seed(134);
#declare r5=seed(32);

#declare Stone=box {<-1,-1,-1>,<1,1,1> scale 0.05} 

#declare Stones = union { 
#declare Max=20;
#declare I=0;
#while (I < Max)
 #declare J=0;
 #while (J < Max)                                                       
  #declare Point_Depart = <-10+I*20/Max+rand(r4),252,2+J*20+rand(r5)>;
  #declare Orientation = <0,-1,0>;     
  #declare Point_Intersection = 
    trace (Colline, Point_Depart, Orientation, Normale_du_Point);
  
  #if (Normale_du_Point.x = 0 & Normale_du_Point.y = 0 & Normale_du_Point.z = 0  ) 
  #else #if ( Point_Intersection.x > 3 | Point_Intersection.x < 5)
     object {  Stone  
         material{ T_Stones2}
         rotate < 90*(rand(r3)-0.5), 90*(rand(r3)-0.5), 90*(rand(r3)-0.5)> 
         matrix < 1, 0, 0,
         Normale_du_Point.x, Normale_du_Point.y, Normale_du_Point.z,
         0, 0, 1,
         0, 0, 0 >
         scale <rand(r2), rand(r2),rand(r2)> translate Point_Intersection 
         } #end
    #end
 #declare J=J+(1/Max);
 #end  
#declare I=I+(1/Max);
#end                    
}

light_group{
    light_source {
        -z*100000
        color C_Sun2
        transform{Transform_Sun}
    }
    
    object { Stones }
          
    global_lights on
}    

#end

//----------------------------------------
// Column of Light
//----------------------------------------

#if ( ColumnOK = 1)

declare Container = union {isosurface {
  function { f_helix1(x,y,z,1,30,0.04,0.12,1.2,1,45) }
        max_gradient 3
        contained_by{ box { <-1,0,-1> ,<1,1,1> }}}
  cone {0, 0.15, < 0, 1, 0> ,0.11 }
        no_shadow hollow
}


#declare Th1 = 0.0;
#declare Th2 = 0.05;

object {Container pigment { White transmit 1}
 interior {
     media {
         emission color rgb < 0.5, 1, 0.1>*1.75
         intervals 5
         emission   rgb White*.2 
         density { agate 
                   scale .1 
                   color_map {
                        [0 rgb 0]
                        [Th1 rgb 0]
                        [Th1 rgb Yellow]
                        [Th2 rgb Green]
                        [Th2 rgb 0]
                        [1 rgb 0]
                   } 
                  }
         density { cylindrical
                   scale .2
                   color_map {
                        [0 rgb 0]
                        [0.4 rgb 1]
                        [1 rgb 1]
                   }
                 }  
           }
     media {
         emission color rgb < 1, 0.5, 0.1>*1.75
         intervals 2 samples 32
         method 3
         aa_threshold 0.1 aa_level 5
         density { agate
                   scale 0.03
                   color_map {
                        [0 rgb 0]
                        [Th1 rgb 0]
                        [Th1 rgb Yellow]
                        [Th2 rgb Green]
                        [Th2 rgb 0]
                        [1 rgb 0]
                   }
                 }
         density { agate
                   scale 0.1
                   color_map {
                        [0 rgb 0]
                        [0.4 rgb Yellow]
                        [1 rgb 1]
                   }
                 }
           }
      }
rotate < 0.5, 0, 6>
scale <8,12,8>
translate < -6.4, 248.6, 16>
}

#end
