
#local RenderThisFile = 0; // change to 1 to test render this file only


// POV-Ray Object File - Small Items
// created 2-Oct-01
// last update 28-Oct-01
// 2001 Glenn McCarter
// This file does not render.  #include "SmallItems.inc" in another .pov file
// Required #include files: "GIncludeRH.inc", "Rifle.inc", 'MapScroll1.pov", "Helmet.pov", MilFlashlight.inc"
//
// Objects:
// 
// FieldTable
// Map
// AmmoBox
// SCigarettePack // simple version
// CigarettePack // detailed version
// DogTag
// DogTagGroup
// MilShovel
// SHelmet // simple version combat helmet
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)

#if (RenderThisFile = 1)
	#include "GIncludeRH.inc" // uncomment for testing only
	#include "Shapes.inc" // uncomment for testing only
	#include "Rifle.inc" // uncomment for testing only
	#declare GS = 1; // uncomment for testing only 
	//#include "GRuler.inc" // for testing only
#end

//===============================================
//             Includes
//===============================================

#include "MapShape.pov"
#include "Helmet.pov"
#include "MilFlashlight.inc"

//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================


#declare AmmoBoxCol = rgb<.222,.316,.204>;
#if (GS != 1) #declare AmmoBoxCol = DS(AmmoBoxCol); #end
#declare AmmoBoxTex =
	texture {
		pigment { AmmoBoxCol }
	}

#declare FieldTableCol = rgb<.20,.216,.20>;
#if (GS != 1) #declare FieldTableCol = DS(FieldTableCol); #end
#declare FieldTableTex =
	texture {
		pigment { FieldTableCol }
		finish { ambient 0.1 diffuse 0.6 specular 0.06 roughness 0.11 }
	}

#declare FlashLightSwitchCol = rgb<.080,.067,.065>;
#if (GS != 1) #declare FlashLightSwitchCol = DS(FlashLightSwitchCol); #end

#declare FlashLightCol = rgb<0.41,0.47,0.43>;
#if (GS != 1) #declare FlashLightCol = DS(FlashLightCol); #end
#declare FlashLightTex =
	texture {
		pigment { FlashLightCol }
		finish { specular 0.3 diffuse 0.38 }
	}


//===============================================
//             Objects
//===============================================

#declare FieldTable =
	object {
		RoundedBox2(40,24,18,1.1)
//		scale <18,18,18>
			translate <0,0,-18>
//		translate <0,0,-18/2-0.2>
		texture { FieldTableTex }
	}

#declare Map =
	object {
		MapShape
		translate <0,0,-0.03>
		scale 24
		texture {
			pigment { color rgb<.904,.926,.920> }
			pigment { color rgbt<1,1,1,1> }
			finish { ambient 0.1 diffuse 0.6 specular 0.16 roughness 0.11 }
		}
		texture {
			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
					png "Map.png"
					once
				}
				rotate <0,0,180> // orient upside-down to map
				translate <1,1,0> // puts upper left at <1,0,0>
				scale <28,21,1> // scale it up
				translate <-2.7,-0.5,0> // position on map surface
			}
			normal { crackle 0.5 scale 5 turbulence 0.2 }
		}
	}

#declare AmmoBoxHandle =
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
		png "AmmoBoxHandle.png"
		water_level .01
		scale <1,-1,1> // extrude into -Y
		scale <3,1,1> // scale it up
	texture { AmmoBoxTex }
	}
#declare AmmoBoxEnd =
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
		png "AmmoBox.png"
		water_level .35
		scale <1,-1,1> // extrude into -Y
		scale <8,1,11-.58> // scale it up
		translate <0,0.7,0> // align to base box
	texture { AmmoBoxTex }
	}
#declare AmmoBoxFront =
	difference {
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "AmmoBox.png"
			water_level .06
			scale <1,-1,1> // extrude into -Y
			scale <8,0.9,11-.58> // scale it up
		}
		box { // cut off top rung
			<-1,-1,0>,<10,1,1>
			texture { pigment { rgbt<1,1,1,1> } }
			translate <0,0,11-0.9>
		}
		translate <-0.3,0.6,0.2> // align to base box
		texture { AmmoBoxTex }
	} // end difference

#declare AmmoBoxLid =
	difference {
		object {
			RoundedBox2(7.8,17.6,0.38,0.1)
			translate <0,0,10.4>
		}
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "AmmoBoxLidEnd.png"
			scale <8,1.5,0.5>
			translate <0,0,10.4>
		}
		texture { AmmoBoxTex }
	} // end difference
#declare AmmoBoxBase =
	difference {
		object {
			RoundedBox2(7.8,17.6,0.38,0.1)
			translate <0,-0.10,5.8>
		}
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "AmmoBoxBaseEnd.png"
			scale <8,0.25,0.5>
			translate <0,-0.10,5.8>
		}
		texture { AmmoBoxTex }
	} // end difference

#declare AmmoBox =
	union { // add bottom

		difference { // cut off lower part
			union {
				object { AmmoBoxEnd translate <0,0,0.1> }
				object { AmmoBoxEnd translate <0,17.5,0.1> }
				object { AmmoBoxHandle translate <(8-3)/2,0,8> }
				object { AmmoBoxFront rotate z*90 translate <7.7,0.15,0.1> } // front side near
				object { AmmoBoxFront rotate z*90 translate <7.7,7.15,0.1> } // front side far
				object { AmmoBoxFront scale <1,-1,1> rotate z*90 translate <0.0,0.15,0.1> } // back side
				object { AmmoBoxFront scale <1,-1,1> rotate z*90 translate <0.0,7.15,0.1> } // back side far
			} // end union
			box { // cut off lower part
				<-2,-2,-10>,<10,20,6.1>
				texture { pigment { rgbt<1,1,1,1> } }
			}
		} // end difference

		object { AmmoBoxLid }
		object { AmmoBoxBase }
		rotate z*-90 translate <0,8,0> // align to origin
		texture { AmmoBoxTex }
	} // end union
#declare SCigarettePack =
	box {
		<0,0,0>,<2,4,0.6>
		texture {
			pigment { color rgb<.6,.6,.6> }
		}
	}

#declare CigarettePack =
	object { RoundedBox(.1)
		scale <2,4,0.6>
		translate <1,2,0.3>
		texture { pigment { color rgb<1,1,1> } }
		texture {
			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
					png "LuckyStrike.png"
					once
				}
//				rotate <0,90,0> // orient upside-down to map
//				translate <1,0,0> // puts upper left at <0,0,0>
				scale <2.2,4.1,1> // scale it up
				translate <-0.1,-0.2,0> // position on map surface
			}
			normal { crackle 0.5 scale 1 turbulence 0.2 }
		}
	}

#declare DogTag =
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
		png "DogTag.png"
		water_level .02
		scale <1,-1,1> // extrude temporarily into -Y
		scale <1.4,.04,0.75> // scale it up
		translate <-1.3,0,-0.35> // center on hole
		rotate y*-90 // hanging down
//scale 2 // test
		texture {
			pigment { color rgb<.940,.931,.902> }
			finish { ambient 0.25 brilliance 4 diffuse 0.5 metallic specular 0.80 roughness 0.013 reflection 0.7 }
		}
	}
#declare Chain1Seg1 = // left top end
	spline {
		quadratic_spline
		0,<2.4,1.9,0>,
		1,<1.0,2.7,0>,
		2,<0,1.5,0>
	}
#declare Chain1Seg2 = // left end
	spline {
		quadratic_spline
		0,<0,1.5,0>,
		1,<0,0.7,-0.9>,
		2,<0,0,-1.5>
	}
#declare Chain1Seg3 = // main loop
	spline {
		quadratic_spline
		0,<0,0,-1.5>,
		1,<1,-0.4,-3>,
		2,<2,0,0>
	}
#declare Chain1Seg4 = // right top end
	spline {
		quadratic_spline
		0,<2,0,0>,
		1,<2.5,1.3,0>,
		2,<2,1.9,0>
	}
#declare RS=seed(37540);
#declare Chain1 =
	union {
		#declare c=0;
		#while (c<2.05) // even links
			torus { 0.08,0.008
				scale <.55,1,1>
				rotate <90,rand(RS)*36,0>
				translate Chain1Seg1(c)
			}
			torus { 0.08,0.008
				scale <.55,1,1>
				rotate <rand(RS)*36,0,0>
				translate Chain1Seg3(c)
			}

			torus { 0.08,0.008
				scale <.55,1,1>
				rotate <90,rand(RS)*36,0>
				translate Chain1Seg4(c)
			}
		#declare c=c+0.06;
		#end
		#declare c=0;
		#while (c<2.05) // odd links
			torus { 0.08,0.008
				scale <.55,1,1>
				rotate <90,rand(RS)*36+90,0>
				translate Chain1Seg1(c+0.03)
			}
			torus { 0.08,0.008
				scale <0.75,1.0,.51>
				rotate <90,rand(RS)*36+90,0>
				translate Chain1Seg3(c+0.03)
			}
			torus { 0.08,0.008
				scale <.55,1,1>
				rotate <90,rand(RS)*36+90,0>
				translate Chain1Seg4(c+0.03)
			}
		#declare c=c+0.06;
		#end
		texture {
			pigment { rgb<.78,.82,.88> }
			finish { specular 0.77 roughness 0.014 metallic brilliance 4 }
		}
	} // end union


#declare Chain2 =
	union {
		#declare c=0;
		#while (c<2.05) // even links
			torus { 0.08,0.008
				scale <.55,1,1>
				rotate <-40,rand(RS)*36,0>
				translate Chain1Seg2(c)
			}
		#declare c=c+0.16;
		#end
		#declare c=0;
		#while (c<2.05) // odd links
			torus { 0.08,0.008
				scale <.55,1,1>
				rotate <90,rand(RS)*36+90,0>
				translate <0.0,0.05,0.05>
				translate Chain1Seg2(c+0.03)
			}
		#declare c=c+0.16;
		#end
		texture {
			pigment { rgb<.78,.82,.88> }
			finish { specular 0.77 roughness 0.014 metallic brilliance 4 }
		}
	} // end union

#declare DogTagGroup =
	union {
//		object { DogTag rotate <3,-8,-88> translate <0.1,-0.1,0.0> }
		object { Chain1 rotate <0,0,0> translate <-0.1,-0.0,0.1> }
		object { Chain2 rotate <0,0,0> translate <-0.1,-0.0,0.1> }
		object { DogTag rotate <0,-8,-68> translate <0.7,-0.4,-2.93> }
//		object { Chain2 rotate <90,0,-90> translate <-0.5,3,2.0> } 
	} // end union



#declare MilShovel = // faces -Y, handle into +Z
	union {
		box { // blade
			<-3,0,-8>,<3,0.1,0>
		}
		cylinder { // handle
			<0,0,-0.5>,<0,0,19>,0.56
			translate <0,-00.5,0>
		}
		sphere { // handle end
			<0,0,0>,0.56
			scale <1,1,1.4>
			translate <0,0,19>
		}
		cylinder { // knurl
			<0,0,-1>,<0,0,2>,0.76
			translate <0,-00.5,0>
		}
		texture {
			pigment { color rgb<.303,.306,.309> }
		}
	} // end union


#declare SHelmet =
	difference {
		sphere {
			<0,0,0>,5
		}
		box {
			<-10,-10,-10>,<10,10,-1.5>
		}
		texture {
			pigment { color rgb<.451,.489,.492> }
		}
	} // end difference


#declare Helmet =
	union {
		object { HelmetShape }
		object { ChinStrapShape }
		scale 2.25
		rotate <0,0,0>
	}


//===============================================
//             Groups
//===============================================

#declare AmmoBoxGroup =
	union {
		object { AmmoBox translate <0,0,-4> }
		object { CigarettePack rotate <0,0,-12> translate <1,1,11-4.3+0.07> }
		object { DogTagGroup rotate <0,0,0>  translate <-0.08,0,11-4.3> }
	} // end union
#declare FieldTableGroup =
	light_group {
		object { FieldTable rotate z*-19 translate <-23.0,0.0,0> } // left side
		object { Map rotate <0,0,-12> translate <-18,0,0> }
		object { MilitaryFlashLight rotate <90,-5,-68> translate <-13,14,1.5> }
		object { AmmoBoxGroup rotate z*-28 translate <0,0,0> }
		object { CigarettePack rotate z*93 translate <-1,-1,1.2> }
//		object { FieldTable rotate z*-19 translate < 9.0,10.0,0> } // right side
//		object { AmmoBoxGroup rotate z*-20 translate <0,0,0> } // old, ignore
//		object { CigarettePack rotate z*-123 translate <-4,5,0> } // old, ignore
	global_lights on
	} // end light_group

#declare RifleGroup =
	union {
		object { M1RifleSlack rotate <0,98,0> translate <0,0,0> }
		object { Helmet scale <1.1-1.1,1.1> rotate <5,-12,0> translate <-4.8,0,-2.5> }
		translate <0,0,36>
	} // end union


//===============================================
//             For Testing Only
//===============================================

#if (RenderThisFile = 1)

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 24
//		location  <1, -48*Feet, 8*Feet>
//		look_at <7*Feet,0,15*Feet>
		location  <3, -1.3*Feet, 6> // chain closeup
		look_at <-1,0,5>
//		location  <-3, -3.3*Feet, 16> // box top
//		look_at <5,4,9>
	}


light_source
{ <40*Feet,-35*Feet,40*Feet>, .5
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}

light_source
{ <-40*Feet,-35*Feet,1*Feet>, <1.13,0.93,.76>*1.8
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}

plane { z,-0 pigment { checker rgb 1, rgb .5 } scale 12 }

//object { MilitaryFlashLight rotate <90,0,-115> translate <0,0,2> }
//object { DogTagGroup2 translate <0,0,4> }
object { AmmoBoxGroup rotate z*40 translate <0,0,0> }
//object { RifleGroup rotate z*-180 translate <0,0,-20> }
//object { FieldTableGroup rotate z*40 translate <4,0,6> }

#end
