
#include "Tires.inc"

// Glenn's PackardCar POV-Ray Scene File
// This file does not render.  #include "PackardCar.inc" in another .pov file
// first concept: 23-May-97 last update: 7-Oct-01
// copyright Glenn McCarter 1997
// Intended scale is English system (inches)
// Car sits on Z=0 plane, origin at ground level, between front wheels
// +X is towards the rear of the car
// Uses RH coordinate reference system
//
// Required #include files: "Shapes.inc", "Tires.inc"
// Required switches: "HeadlampOn"
//
// A 1939 Packard
//

//===============================================
//             Variable Declarations
//===============================================

// set user defaults
#ifndef ( SteeringAngle )
	#declare SteeringAngle = 0; // positive = to the right
#end
#ifndef ( LFJounce )
	#declare LFJounce = 0; // Left Front wheel elevation
#end
#ifndef ( RFJounce )
	#declare RFJounce = 0;
#end
#ifndef ( LRJounce )
	#declare LRJounce = 0;
#end
#ifndef ( RRJounce )
	#declare RRJounce = 0;
#end
#ifndef ( RimColor )
	#declare RimColor = color rgb<.68,.09,.09>; // default is red
#end

#switch ( HeadlampOn )
#case (1)
	#declare HeadlampTex =
		texture {
			pigment { color rgb<1,1,1> }
			finish { ambient 1.0 }
		}
#break
#else
	#declare HeadlampTex =
		texture {
			pigment { color rgb<.3,.3,.3> }
			finish { ambient 0.02 reflection 0.3 }
		}
#end
// set vehicle main variables
#declare Wheelbase = 98;
#declare FrontTread = 27; // to the inside of the tire
#declare RearTread = 27; // to the inside of the tire

//===============================================
//             Transformations
//===============================================

#declare InverseY = // forms a mirror image
	transform {
  	matrix < 1, 0, 0,
             0, -1, 0,
             0, 0, 1,
             0, 0, 0 >
	}

#declare ShearXZ03 =
	transform {
  	matrix < 1, 0, 0, // shear along x-axis, dependent on Z
             0, 1, 0,
            .3, 0, 1,
             0, 0, 0 >
	}
#declare ShearXZ05 =
	transform {
  	matrix < 1, 0, 0, // shear along x-axis, dependent on Z
             0, 1, 0,
            .5, 0, 1,
             0, 0, 0 >
	}
#declare ShearYX03 =
	transform {
  	matrix < 1, .3, 0, // shear along y-axis, dependent on x
             0, 1, 0,
             0, 0, 1,
             0, 0, 0 >
	}


//===============================================
//             Textures
//===============================================

#declare TestTex =
	texture {
		pigment { color rgb<1,1,1> }
		finish { ambient .4 }
	}

#declare SteelTex =
	texture {
		pigment { color rgb<.9,.9,.9> }
		finish {
			ambient .1
			brilliance 6
			diffuse .7
			metallic
			specular .9
			roughness .02
//			reflection .3
		}
	}


#declare GChrome =
	texture {
		pigment { color rgb <0.39, 0.41, 0.43> }
		finish {
			ambient 0.1
			brilliance 6
			diffuse 0.7
			metallic
			specular 0.80
			roughness .01
			reflection 0.8
		}
	}


#declare HubCapTex = texture { GChrome }
//#declare WheelTexture = texture { pigment {White}}
#declare ChromeTex = texture { GChrome }

#declare RimTex =
	texture {
		pigment { RimColor }
		finish { specular .7 roughness .02 }
	}

#declare BrightWhitePaint =
	texture {
		pigment { color rgb<1.0,1.0,1.0> }
		finish { ambient .4 specular .7 roughness .02 }
	}
#declare BlackPaint =
	texture {
		pigment { color rgb<0.0,0.0,0.0> }
		finish { specular .7 roughness .02 }
	}

#declare BodyTex =
	texture {
		pigment { color <0.04,0.05,0.09> }
//		finish { specular .8 roughness .02 reflection 0.24 } // for best appearance
		finish { specular .4 roughness .02 } // for fast render
		normal { bumps .2 scale 5 } // add some waviness
	}

/*
#declare BodyTex = // for test renders only. COMMENT OUT for final render
	texture {
		pigment { color <.7,.6,0> }
		finish { specular .8 roughness .02 } // for fast render
	}
*/


#declare BodyInsideTex =
//    texture { pigment { color <1,1,1> }}
    texture { pigment { color <.5,.5,.5> }}

#declare WindshieldTexture =
    texture { GBlueGlass } // for best appearance
//    texture { pigment { color Blue }} // for fast render

#declare SeatTexture = // leather
  texture {
    pigment { color <.36,.16,.07> }
    finish { specular .4 roughness .08 }
    normal {crackle .5 scale .5}
  }

#declare ClearPlastic =
	texture {
		pigment { color rgbt<.65,.54,.78,.9> }
		finish { specular .8 roughness .003 }
	}
#declare RedTintPlastic =
	texture {
		pigment { color rgbf<.95,.04,.08,.8> }
		finish { specular .8 roughness .003 }
	}
#declare BrightChrome =
	texture {
		pigment { color rgb <0.69, 0.61, 0.63> }
		finish {
			ambient 0.1
			brilliance 6
			diffuse 0.7
			metallic
			specular 0.80
			roughness .002
			reflection 0.95
		}
	}

//===============================================
//             Wheels
//===============================================

#declare RimHoles = // four rounded slots
	difference {
			cylinder { // outer
				<0,-.05,0>,<0,6,0>,6.5
				texture { RimTex }
			}
			cylinder { // inner hole
				<0,-.1,0>,<0,6.1,0>,6.1
				texture { RimTex }
			}
			box { // cuts two slots
				<-2,-.2,-8>,<2,6.2,8>
				texture { RimTex }
			}
			box { // cuts two slots
				<-2,-.3,-8>,<2,6.3,8>
				texture { RimTex }
				rotate y*90
			}
	} // end of difference

#declare WRim =
	difference {
		lathe { // spun around Y-axis
			cubic_spline
			24,
			<1.0,3.8>,<1.2,3.5>,<1.5,3.3>, // near spindle
			<6.5,3.3>,<7.0,3.0>,<7.3,2.7>, // hubcap mount
			<7.6,2.0>,<7.7,1.7>,<7.8,1.4>,<8.0,1.2>, // outer rim
			<8.4,1.2>,<8.7,1.0>,<8.9,1.2>,<8.7,1.4>, // bead area
			<7.5,3.5>,<6.5,4.0>, // backside
			<1.6,4.0>,<1.4,4.2>,<1.3,4.3>,<1.2,4.4>,<1.0,4.3>, // backside spindle
			<1.0,3.8>,<1.2,3.5>,<1.5,3.3> // three duplicate points
			texture { RimTex }
		}
		object { RimHoles }
	}

#declare HubCap =
	union {
		sphere {
			<0,6.5,0>,6
			texture { HubCapTex }
			clipped_by {
			box { <-5,0,-5>,<5,3,5> } }
		}
		torus { // hubcap rim
			4.3,.4
			texture { HubCapTex }
			translate <0,3,0>
		}
	}

#declare WheelAssy =
	union {
		object { Tire translate <0,0,0> }
		object { WRim  translate <0,0,0> }
		object { HubCap translate <0,-.5,0> }
	}
#declare LeftFrontWheelAssy =
  object { WheelAssy
		translate <0,-4,0> // move to steering pivot
    rotate <0,0,-SteeringAngle> // steer it
		translate <0,4,0> // move back
    translate <0,-10,13> // raise it above ground, origin at inside of tire
    translate <0,-FrontTread,0>
  }
#declare RightFrontWheelAssy =
  object { WheelAssy
		translate <0,4,0> // move to steering pivot
    rotate <0,0,180-SteeringAngle>
		translate <0,-4,0> // move back
    translate <0,10,13>
    translate <0,FrontTread,0>
  }
#declare LeftRearWheelAssy =
  object { WheelAssy
    rotate <0,0,0>
    translate <0,-10,13>
    translate <Wheelbase,-RearTread,0>
  }
#declare RightRearWheelAssy =
  object { WheelAssy
    rotate <0,0,180>
    translate <0,10,13>
    translate <Wheelbase,RearTread,0>
  }


//===============================================
//             Front End
//===============================================

#declare Hood =
	union {
		superellipsoid { // RH side
			<.3,.3>
			texture { BodyTex }
			transform ShearYX03
			scale <29,12,16>
			translate <0,6,0>
		}
		superellipsoid { // LH side
			<.3,.3>
			texture { BodyTex }
			transform ShearYX03
			rotate x*180
			scale <29,12,16>
			translate <0,-6,0>
		}
/*
		superellipsoid { // front end
			<.6,.3>
			texture { BodyTex }
			transform ShearXZ05
			scale <8,12,14>
			translate <-25,0,-.3>
		}
*/
		translate <16,0,18> // origin at front base
	}

#declare GrilleShape =
		superellipsoid { // front end
			<.6,.4>
			transform ShearXZ05
			scale <8,12,14>
			translate <0,0,0>
		}

#declare Grille =
	union {
		difference {
			object { GrilleShape
				texture { ChromeTex }
				clipped_by {
//					box { <-8,-20,-26>,<1,20,26> rotate y*12 }
					box { <-48,-420,-426>,<0,420,426> transform ShearXZ05 }
				}
			}
			object { GrilleShape texture { ChromeTex }scale <2,.75,.85> translate <-2,0,0> }
		} // end difference
		intersection {
			object { GrilleShape texture { ChromeTex }scale <4,.75,.9> }
			union {
				cylinder { // center
					<0,0,-10>,<0,0,14>,.3
					scale <5,1,1>
					rotate y*12
					texture { ChromeTex }
				}
				cylinder {
					<0,-2,-10>,<0,-2,14>,.3
					scale <5,1,1>
					rotate y*12
					translate <.4,0,0>
					texture { ChromeTex }
				}
				cylinder {
					<0,2,-10>,<0,2,14>,.3
					scale <5,1,1>
					rotate y*12
					translate <.4,0,0>
					texture { ChromeTex }
				}
				cylinder {
					<0,-4,-10>,<0,-4,14>,.3
					scale <5,1,1>
					rotate y*12
					translate <.6,0,0>
					texture { ChromeTex }
				}
				cylinder {
					<0,4,-10>,<0,4,14>,.3
					scale <5,1,1>
					rotate y*12
					translate <.6,0,0>
					texture { ChromeTex }
				}
				cylinder {
					<0,-6,-10>,<0,-6,14>,.3
					scale <5,1,1>
					rotate y*12
					translate <1.0,0,0>
					texture { ChromeTex }
				}
				cylinder {
					<0,6,-10>,<0,6,14>,.3
					scale <5,1,1>
					rotate y*12
					translate <1.0,0,0>
					texture { ChromeTex }
				}
				cylinder {
					<0,-8,-10>,<0,-8,14>,.3
					scale <5,1,1>
					rotate y*12
					translate <1.3,0,0>
					texture { ChromeTex }
				}
				cylinder {
					<0,8,-10>,<0,8,14>,.3
					scale <5,1,1>
					rotate y*12
					translate <1.3,0,0>
					texture { ChromeTex }
				}
				translate <-5,0,0>
			} // end union of bars
		} // end intersection
		translate <0,0,23> // raise it all up
	}

#declare InnerFenderRH = // connects fenders to hood
	cylinder {
		<0,-8,0>,<0,0,0>,13
		texture { BodyTex }
		clipped_by { box { <-16,-16,-3>,<16,16,16> } }
		translate <0,FrontTread,13>
	}
#declare InnerFenderLH = // connects fenders to hood
	object { InnerFenderRH transform InverseY }

#declare FrontPanel = // underlies front end
	superellipsoid {
		<.2,.2>
		texture { BodyTex }
		scale <36,20,2>
//		clipped_by { box { <-16,-16,-3>,<16,16,16> } }
		translate <-4,0,10>
	}

#declare BumperOuter =
		blob {
			threshold .7 // high = close to center
			cylinder { <0,-FrontTread,0>,<0,FrontTread,0>,6,4.6 }
			sphere { <0,0,0>,20,.8 scale <2.0,2.0,1.2> translate <2,-FrontTread,0> } // outboard end cap
			sphere { <0,0,0>,20,.8 scale <2.0,2.0,1.2> translate <2,FrontTread,0> } // outboard end cap
			sphere { <0,0,0>,22,1 scale <.6,.2,.6> translate <0,12,3> } // center attach
			sphere { <0,0,0>,22,1 scale <.6,.2,.6> translate <0,-12,3> } // center attach
		scale <1,1,.8>
		texture { HubCapTex }
	}

#declare BumperInner =
	union {
		cylinder {
			<0,-FrontTread-2,0>,<0,FrontTread+2,0>,8
		}
		sphere {
			<0,0,0>,8
			scale <1,1,1>
			translate <0,-FrontTread-2,0>
		}
		sphere {
			<0,0,0>,8
			scale <1,1,1>
			translate <0,FrontTread+2,0>
		}
		texture { SteelTex }
	}

#declare FBumper =
	difference {
		object { BumperOuter }
		object { BumperInner translate <8,0,0> }
//		object { BumperOuter scale <1,.99,1> translate <.2,0,0> }
		scale <.8,1,.9>
	}

#declare FenderShape =
	blob {
		threshold .3
//		sphere { <0,0,0>,42,0.6 scale <1,.4,1> }
//		sphere { <0,0,0>,26,0.1 scale <1,.8,1> translate <26,0,6> }
		sphere { <0,0,0>,42,0.6 scale <1,.4,1> }
		sphere { <0,0,0>,33,0.18 scale <1,.6,1> translate <36,0,6> }
		scale <.85,1,1> rotate <0,20,0>
	}
#declare Fender =
	difference {
		object { FenderShape texture { BodyTex } }
		object { FenderShape scale .97 texture { BodyTex } }
		cylinder { // wheel cutout
			<0,-18,0>,<0,18,0>,13
			texture { BodyTex }
		}
		clipped_by { // cut off bottom edge
			box {	<-26,-12,-3>,<70,12,26> } }
	}

#declare Fenders =
	union {
		object { Fender // left front
			translate <0,-FrontTread-5,13>
		}
		object { Fender // left rear
			translate <Wheelbase,-FrontTread-5,13>
		}
		object { Fender // right front
			translate <0,FrontTread+5,13>
		}
		object { Fender // right rear
			translate <Wheelbase,FrontTread+5,13>
		}
	}

#declare RockerPanelRH =
	box {
		<0,0,0>,<56,9,1>
		texture { BodyTex }
	}
#declare RockerPanelLH =
	object { RockerPanelRH transform InverseY }

//===============================================
//             Main Body
//===============================================

#declare OuterShellShape =
	union {
		superellipsoid { // front
			<.3,.3>
//			texture { BodyTex }
			transform ShearXZ05
			scale <26,28,25>
			translate <-13,0,0>
		}
		superellipsoid { // middle
			<.3,.3>
//			texture { BodyTex }
			scale <22,28,25>
		}
		superellipsoid { // rear
			<.3,.3>
//			texture { BodyTex }
			transform ShearXZ05
			rotate z*180
			scale <26,28,25>
			translate <13,0,0>
		}
	}

#declare OuterShell =
	object { OuterShellShape texture { BodyTex } }
#declare InnerShell =
	object { OuterShell scale .95 }

#declare FrontWindowCutout =
	union {
		superellipsoid {
			<.2,.2>
			texture { BodyTex }
			scale <12,4,6>
		}
		superellipsoid {
			<.5,.5>
			texture { BodyTex }
			transform ShearXZ05
			scale <10,4,6>
			translate <-6,0,0>
		}
	}
#declare RearWindowCutout =
	union {
		superellipsoid {
			<.3,.3>
			texture { BodyTex }
			scale <5,4,6>
		}
		superellipsoid {
			<.6,.6>
			texture { BodyTex }
			transform ShearXZ05
			rotate z*180
			scale <6,4,6>
			translate <3,0,0>
		}
	}
#declare WindshieldCutout =
	superellipsoid {
		<.2,.2>
		texture { BodyTex }
		scale <10,23,6>
	}
#declare BacklightCutout =
	superellipsoid {
		<.4,.4>
		texture { BodyTex }
		scale <8,16,4.5>
	}
#declare Antenna =
	union {
		cylinder { // base
			<0,0,0>,<0,0,2>,.6
			texture { pigment { color rgb<1,1,1> } }
		}
		cone {
			<0,0,0>,.1,<0,0,28>,.05
			texture { pigment { color rgb<1,1,1> } }
		}
		sphere { // tip
			<0,0,28>,.1
			texture { pigment { color rgb<1,1,1> } }
		}
	}
#declare CockpitAssy = // origin at firewall floor center
	union {
		difference {
			object { OuterShell translate <24,0,24> }
			object { InnerShell translate <24.5,0,23.5> }
			object { FrontWindowCutout translate <14,26,38> }
			object { FrontWindowCutout translate <14,-26,38> }
			object { RearWindowCutout translate <34,26,38> }
			object { RearWindowCutout translate <34,-26,38> }
			object { WindshieldCutout translate <-8,0,39> }
			object { BacklightCutout translate <50,0,40> }
		}
		object { Antenna translate <-9,-22,30> }
	}


//===============================================
//             Rear End
//===============================================

#declare TrunkAssy =
	superellipsoid {
		<.4,.4>
		texture { BodyTex }
		transform ShearXZ05
		rotate z*180
		scale <20,20,18>
		translate <0,0,16> // origin at front base
		clipped_by { box { <0,-30,9>,<60,30,60> } } // cut off front and bottom
	}

#declare RBumper =
	object { FBumper
		rotate z*180
		translate <Wheelbase+36,0,2>
	}

//===============================================
//       Interior
//===============================================

#declare DomeLightColor =
     rgb <.12, .05, .4>;
#declare DomeLight =
    light_source {
      <0,0,0>
      color DomeLightColor
      looks_like {
        cylinder {
          <0,0,0>, <9,0,0>, .3
          scale <1,1,3> rotate <0,16,0>
          texture {
            pigment { color DomeLightColor*2 }
            finish { ambient .99 diffuse .2 }
          }
        }
      }
    }

#declare Seat = // center is at hinge point
  union {
    superellipsoid { // seat back
       <.8,.2>
       scale <3,10,11> translate <2,0,12>
       texture { SeatTexture }
    }
    superellipsoid { // seat bottom
       <.8,.2>
       scale <6,10,3> rotate <0,5,0> translate <-4,0,1>
       texture { SeatTexture }
    }
    scale <1,1,1> rotate <0,15,0> translate <0,0,0>
  }

#declare RearSeat = // center is at hinge point
	object { Seat
    scale <1,2.3,1>
  }

#declare InstrumentPod =
	difference {
		cylinder { // main outer pod
			<0,0,0>,<-3,0,0>,7
			texture { pigment { color <.10,.07,.14> }}
			scale <1,1,.25> rotate <0,-6,0>
		}
		cylinder {
			<-.5,3,0>,<.3,3,0>,1.3
			texture { pigment { color <.20,.22,.24> }
				finish { ambient .15 } }
			scale <1,1,1> rotate <0,-6,0>
		}
		cylinder {
			<-.5,-3,0>,<.3,-3,0>,1.3
			texture { pigment { color <.20,.22,.24> }
				finish { ambient .15 } }
			scale <1,1,1> rotate <0,-6,0>
		}
	}

#declare SteeringWheel =
	union {
		torus {
			8,.4
			texture {
				pigment { color rgb<.52,.33,.12> }
			}
		}
		cylinder {
			<0,0,0>,<-12,0,0>,1.5
			texture {
				pigment { color rgb<.1,.1,.1> }
				finish { specular .8 roughness .01 }
			}
		}
		rotate z*90 rotate y*-15
	}

//===============================================
//       Decoration
//===============================================

#declare StarPart =
	prism { // extruded along y-axis
		linear_sweep
		linear_spline
		-10,        // height 1
		-44,        // height 2
		4,          // number of points
		// the <u,v> points
		< -0.3, 0.0>,
		<  0.0, 1.0>,
		<  0.3, 0.0>,
		< -0.3, 0.0>
		texture {
			pigment { color rgb<.9,.9,.2> }
			finish { specular .8 roughness .01 reflection .3 }
		}
	}
#declare StarShape =
	union {
		object { StarPart rotate <0,0,0> }
		object { StarPart rotate <0,360/5,0> }
		object { StarPart rotate <0,360/5*2,0> }
		object { StarPart rotate <0,360/5*3,0> }
		object { StarPart rotate <0,360/5*4,0> }
	}
#declare StarPaint =
	intersection {
		object { StarShape scale <8,1,8> translate <16,0,20> }
		object { OuterShellShape
			texture {pigment{color rgb<.9,.9,.2>}} translate <24,0,24> }
		object { OuterShellShape inverse scale .96
			texture {pigment{color rgb<.9,.9,.2>}} translate <24,0,24> }
	}

#declare LoneStarTextShape =
	intersection {
    text { // extruded into +Z
      ttf "c:\Windows\Fonts\ARIALBD.TTF",
      "Lone     Star",
      50,  0
      texture { BrightWhitePaint }
      scale <3,3,3>
      rotate <90,0,0> // extruded into -Y
      translate <7,0,23.5>
    }
		object { OuterShellShape texture { BrightWhitePaint }
			translate <24,0,24> }
		object { OuterShellShape texture { BrightWhitePaint }
			inverse scale .96 translate <24,0,24> }
	}
#declare LoneStarText =
	object { LoneStarTextShape texture { WhitePaint }	}

#declare CrimefightersTextShape =
	intersection {
    text { // extruded into +Z
      ttf "c:\Windows\Fonts\ARIALBD.TTF",
      "Crimefighters",
      10,  0
      scale <3,3,3>
      rotate <90,0,0> // extruded into -Y
      translate <6,0,12>
    }
		object { OuterShellShape texture { BrightWhitePaint }
			translate <24,0,24> }
		object { OuterShellShape texture { BrightWhitePaint }
			inverse scale .96 translate <24,0,24> }
	}
#declare CrimefightersText =
	union {
		object { CrimefightersTextShape texture { WhitePaint } }
		object { CrimefightersTextShape texture { BlackPaint } translate <.2,.01,-.2> }
	}

#declare BodyPaint =
	union {
		object { StarPaint translate <0,-.05,0> }
		object { StarPaint transform InverseY translate <0,.05,0> }
		object { LoneStarText translate <0,-.06,0> }
		object { CrimefightersText translate <0,-.05,0> }
	}

//===============================================
//       Objects
//===============================================

#declare Headlamp =
	union {
		torus {
			4.5,.4
			texture { BrightChrome }
			rotate z*90
			scale <2.5,1,1>
		}
		sphere { // outer shell
			<0,0,0>, 4.5
			texture {	BodyTex }
			scale <2.5,1,1>
			clipped_by { box { <0,-6,-6>,<14,6,6> } }
		}
		sphere { // lens
			<0,0,0>, 4.5
			texture {
				HeadlampTex
			}
			scale <.3,1,1>
			translate <-.4,0,0>
		}
	}
#declare Taillamp =
	union {
		superellipsoid { // black housing
			<.3,.3>
			scale <2,2,2>
			texture {
				pigment { color rgb<.02,.02,.08> }
				finish { phong .8 phong_size 100 }
			}
			clipped_by { box { <-3,-3,-3>,<.51,3,3> } }
		}
		superellipsoid { // lens
			<.3,.3>
			scale <2,2,2>
			texture {
				pigment { color rgbt<.8,.1,.1,.5> }
				finish { phong .8 phong_size 100 }
			}
			clipped_by { box { <.5,-3,-3>,<3,3,3> } }
		}
		box { // support
			<-6,-.6,-1>,<0,.6,1>
			texture {
				pigment { color rgb<.02,.02,.08> }
				finish { phong .8 phong_size 100 }
			}
		}
	}

#declare DoorHandleLH =
	union {
		torus {
			2.5,.2
			rotate x*90
			scale <1,.25,1>
			clipped_by { box { <-4,.3,-1>,<4,-3,1> } }
		}
		cylinder { // lock cyl
			<0,.3,0>,<0,-.8,0>,.3
			translate <2.5,0,0>
		}
		torus { // lock cyl ring
			.26,.04
			translate <2.5,-.8,0>
		}
		texture { BrightChrome }
	}
#declare DoorHandleRH =
	object { DoorHandleLH transform InverseY }

#declare SSlot =
	union {
		box {
			<-1,-.1,-.5>,<1,.1,.5>
			texture { pigment { color rgb<0,0,0> } }
		}
		cylinder {
			<-1,0,-.5>,<1,0,-.5>,.1
			texture { pigment { color rgb<0,0,0> } }
		}
		cylinder {
			<-1,0,.5>,<1,0,.5>,.1
			texture { pigment { color rgb<0,0,0> } }
		}
	}
#declare Siren =
	union {
		cylinder { // main body
			<0,0,0>,<3,0,0>,2.2
			texture { BrightChrome }
		}
		cylinder { // rear body
			<2.8,0,0>,<6,0,0>,1.2
			texture { BrightChrome }
		}
		difference { // subtract slots
			sphere { // front cap
				<0,0,0>,2.2
				scale <.2,1,1>
				texture { BrightChrome }
			}
			object { SSlot scale <1,1,1.0> translate <0,-1.5,0> }
			object { SSlot scale <1,1,1.3> translate <0,-1.0,0> }
			object { SSlot scale <1,1,1.55> translate <0,-0.5,0> }
			object { SSlot scale <1,1,1.8> translate <0, 0.0,0> }
			object { SSlot scale <1,1,1.55> translate <0, 0.5,0> }
			object { SSlot scale <1,1,1.3> translate <0, 1.0,0> }
			object { SSlot scale <1,1,1.0> translate <0, 1.5,0> }
		}
	}

// --------------- Cherry Top ------------------
#declare Reflector =
	difference {
		object { Paraboloid_X
			texture { BrightChrome }
		}
		object { Paraboloid_X
			texture { BrightChrome }
			translate <.2,0,0>
		}
		clipped_by {
			box { <0,-6,-6>,<1,6,6> } // 4
		}
		scale <2,2,2>
	}
#declare RefLight =
	union {
		object { Reflector }
		sphere {
			<0,0,0>,1
			texture {
				pigment { color rgb<1,.2,0> }
				finish { ambient 1 }
			}
		}
	}


#declare FlareTri =
		triangle {
			<0,.2,0>,<0,-.2,0>,<1,0,0>
			texture {
				pigment {
					gradient x
					color_map {
						[ 0.0 color rgbt<3,3,3,.2> ]
						[ 0.2 color rgbt<3,3,1,.2> ]
						[ 1.0 color rgbt<3,.5,.2,1> ]
					}
				}
			}
		}
#declare FlareTri2 =
		triangle {
			<0,.2,0>,<0,-.2,0>,<1,0,0>
			texture {
				pigment {
					gradient x
					color_map {
						[ 0.0 color rgbt<2,1,1,.2> ]
						[ 0.2 color rgbt<2,.7,.3,.2> ]
						[ 1.0 color rgbt<2,.3,.2,1> ]
					}
				}
			}
		}
#declare FS = seed(23091); // random number seed
#declare SmallFlare =
	union {
		#declare FDeg = 0;
		#while ( FDeg < 360 )
			object { FlareTri scale <rand(FS)*2+2,1,1> rotate <0,0,FDeg> }
			#declare FDeg = FDeg + 45;
		#end
		rotate <0,90,0> //set it upright
		translate <-5,0,0> // move it outside of glass
	}
#declare MedFlare =
	union {
		#declare FDeg = 0;
		#while ( FDeg < 360 )
			object { FlareTri2 scale <rand(FS)*2+2,1,1> rotate <0,0,FDeg> }
			#declare FDeg = FDeg + 45;
		#end
		rotate <0,90,0> //set it upright
		translate <-5,0,0> // move it outside of glass
	}

#declare BigBeam =
	cone {
		<4,0,0>,2,<30*Feet,0,0>,16
		texture {
			pigment {
				gradient x
					color_map {
						[ 0.0 color rgbt<1,1,0,1.0> ]
						[ 0.1 color rgbft<1,.7,0,0.5,0.2> ]
						[ 0.8 color rgbt<1,0,0,1.0> ]
						[ 1.0 color rgbt<1,1,0,1.0> ]
					}
					scale <30*Feet,1,1>
			}
		}
	}


#declare CherryTop =
	union {
		sphere { // outer glass
			<0,0,0>,4
			texture { RedTintPlastic }
			clipped_by {
				box { <-5,-5,0>,<5,5,5> }
			}
			translate <0,0,6>
		}
		cylinder { // outer glass
			<0,0,0>,<0,0,6>,4
			texture { RedTintPlastic }
		}
		cylinder { // inner support
			<0,0,0>,<0,0,4>,1
			texture { BrightChrome }
		}
		torus { // bottom rim
			4.2,.5 // around y-axis
			texture { BrightChrome }
			rotate <90,0,0>
			scale <1,1,4>
			clipped_by {
				box { <-6,-6,0>,<6,6,2> }
			}
		}
		object { RefLight translate <0,0,6> }
		object { RefLight rotate z*120 translate <0,0,6> }
		object { RefLight rotate z*240 translate <0,0,6> }
//		object { SmallFlare rotate z*90 translate <0,0,6> } // inset
		object { MedFlare scale 3 rotate z*20 translate <0,0,5.5> } // render
//		object { BigBeam rotate z*36 translate <0,0,6> }
//		object { BigBeam rotate z*(36+180) translate <0,0,6> }
	}

// --------------- Motion Blur ------------------
/*
// Fender
#declare BColor = color rgb<.12,.12,.22>;  // color of filter
#declare BFX = 50;         // blurred area X scale
#declare BFY = 29;         // blurred area Y scale
#declare BStrength = .6;  // 0=clear, 1=opaque at center
#declare BXMax = .3;      // Percentage of distance along X-axis
                         // where color reaches max intensity
#declare BYSpread = .8;   // Spread of the color in the Y-direction
                         // 0=soft fade, 1=full color throughout Y
#include "BlurFilt.inc"
#declare FenderBlur =
	object { FadeBlurFilter rotate x*90  }

// UpperBody
#declare BColor = color rgb<.12,.12,.22>;  // color of filter
#declare BFX = 50;         // blurred area X scale
#declare BFY = 30;         // blurred area Y scale
#declare BStrength = .8;  // 0=clear, 1=opaque at center
#declare BXMax = .3;      // Percentage of distance along X-axis
                         // where color reaches max intensity
#declare BYSpread = .6;   // Spread of the color in the Y-direction
                         // 0=soft fade, 1=full color throughout Y
#include "BlurFilt.inc"
#declare UpperBodyBlur =
	object { FadeBlurFilter rotate x*90  }

// HubCapUpper
#declare BColor = color rgb<.5,.5,.7>;  // color of filter
#declare BFX = 24;         // blurred area X scale
#declare BFY = 6;         // blurred area Y scale
#declare BStrength = .20;  // 0=clear, 1=opaque at center
#declare BXMax = .4;      // Percentage of distance along X-axis
                         // where color reaches max intensity
#declare BYSpread = .7;   // Spread of the color in the Y-direction
                         // 0=soft fade, 1=full color throughout Y
#include "BlurFilt.inc"
#declare HubCapUpperBlur =
	object { FadeBlurFilter rotate x*90 }

// HubCapLower
#declare BColor = color rgb<.8,.7,.3>;  // color of filter
#declare BFX = 24;         // blurred area X scale
#declare BFY = 7;         // blurred area Y scale
#declare BStrength = .3;  // 0=clear, 1=opaque at center
#declare BXMax = .4;      // Percentage of distance along X-axis
                         // where color reaches max intensity
#declare BYSpread = .7;   // Spread of the color in the Y-direction
                         // 0=soft fade, 1=full color throughout Y
#include "BlurFilt.inc"
#declare HubCapLowerBlur =
	object { FadeBlurFilter rotate x*90 }

// Rear Lamp
#declare BColor = color rgb<.90,.15,.05>;  // color of filter
#declare BFX = 12;         // blurred area X scale
#declare BFY = 4.5;         // blurred area Y scale
#declare BStrength = .4;  // 0=clear, 1=opaque at center
#declare BXMax = .4;      // Percentage of distance along X-axis
                         // where color reaches max intensity
#declare BYSpread = .7;   // Spread of the color in the Y-direction
                         // 0=soft fade, 1=full color throughout Y
#include "BlurFilt.inc"
#declare RearLampBlur =
	object { FadeBlurFilter rotate x*90 }

// BumperUpper
#declare BColor = color rgb<.4,.4,.8>;  // color of filter
#declare BFX = 20;         // blurred area X scale
#declare BFY = 5;         // blurred area Y scale
#declare BStrength = .2;  // 0=clear, 1=opaque at center
#declare BXMax = .4;      // Percentage of distance along X-axis
                         // where color reaches max intensity
#declare BYSpread = .7;   // Spread of the color in the Y-direction
                         // 0=soft fade, 1=full color throughout Y
#include "BlurFilt.inc"
#declare BumperUpperBlur =
	object { FadeBlurFilter rotate x*90 }

// BumperLower
#declare BColor = color rgb<.8,.7,.3>;  // color of filter
#declare BFX = 20;         // blurred area X scale
#declare BFY = 5;         // blurred area Y scale
#declare BStrength = .2;  // 0=clear, 1=opaque at center
#declare BXMax = .4;      // Percentage of distance along X-axis
                         // where color reaches max intensity
#declare BYSpread = .7;   // Spread of the color in the Y-direction
                         // 0=soft fade, 1=full color throughout Y
#include "BlurFilt.inc"
#declare BumperLowerBlur =
	object { FadeBlurFilter rotate x*90 }

// Overall Big Blur ( for a faraway car )
#declare BColor = color rgb<.12,.12,.22>;  // color of filter
#declare BFX = 18*Feet;         // blurred area X scale
#declare BFY = 4.5*Feet;         // blurred area Y scale
#declare BStrength = .6;  // 0=clear, 1=opaque at center
#declare BXMax = .4;      // Percentage of distance along X-axis
                         // where color reaches max intensity
#declare BYSpread = .7;   // Spread of the color in the Y-direction
                         // 0=soft fade, 1=full color throughout Y
#include "BlurFilt.inc"
#declare BigBlur =
	object { FadeBlurFilter rotate x*90 }

#declare MotionBlurPanels =
	union {
		object { FenderBlur translate <Wheelbase,-28,10> }
		object { UpperBodyBlur translate <Wheelbase-12,-28,30> }
		object { RearLampBlur translate <Wheelbase+20,-RearTread-8,21.5> }
		object { HubCapUpperBlur translate <Wheelbase-4,-RearTread-15,12> }
		object { HubCapLowerBlur translate <Wheelbase-4,-RearTread-15,7> }
		object { BumperUpperBlur translate <Wheelbase+30,-RearTread-12,11> }
		object { BumperLowerBlur translate <Wheelbase+30,-RearTread-12,7> }
	}
*/
//===============================================
//       Assemblies
//===============================================

#declare Wheels =
	union {
		object { RightFrontWheelAssy translate <0,0,RFJounce> }
		object { LeftFrontWheelAssy translate <0,0,LFJounce> }
		object { RightRearWheelAssy translate <0,0,RRJounce> }
		object { LeftRearWheelAssy translate <0,0,LRJounce> }
	}

#declare InteriorStuff =
  union {
    object { Seat translate <42,16,12> }
    object { Seat translate <42,-16,12> }
    object { RearSeat translate <64,0,12> }
//    object { DomeLight translate <54,0,42> }
    object { InstrumentPod translate <21,16,30> }
    object { InstrumentPod translate <21,0,30> }
    object { InstrumentPod translate <21,-16,30> }
		object { SteeringWheel translate <26,-16,28> }
  }

#declare Body =
	union {
		object { Hood translate <0,0,8> }
		object { Grille translate <-13,0,4> }
		object { InnerFenderRH translate <0,0,0> }
		object { InnerFenderLH translate <0,0,0> }
		object { FrontPanel translate <14,0,0> }
		object { CockpitAssy translate <50,0,8> }
		object { TrunkAssy translate <Wheelbase+10,0,8> }
		object { Fenders }
		object { RockerPanelRH translate <20,24,9> }
		object { RockerPanelLH translate <20,-24,9> }
		object { FBumper translate <-30,0,10> }
		object { RBumper translate <0,0,10> }
	}

#declare BodyAssy =
	union {
		object { Body }
		object { InteriorStuff translate <30,0,8> }
		object { Headlamp translate <-7,-19,32> }
		object { Headlamp translate <-7,19,32> }
		object { Taillamp translate <Wheelbase+22,-RearTread-6,24> } //
		object { Taillamp translate <Wheelbase+22,RearTread+6,24> } //
		object { DoorHandleRH translate <66,26.5,38> }
		object { DoorHandleLH translate <66,-26.5,38> }
	}

//===============================================
//       Complete Vehicles
//===============================================

#declare PackardCar =
  union {
    object { BodyAssy translate <0,0,0>}
    object { Wheels }
  }

#declare CopCar =
  union {
    object { BodyAssy }
    object { Wheels }
		object { BodyPaint translate <50,0,8> }
		object { Siren translate <0,-FrontTread-2,37> }
    object { CherryTop translate <70,0,56>}
  }

#declare SPackardCar = // "Speeding" sheared along x-axis
	union {
	  object { PackardCar }
//		object { MotionBlurPanels }
   	 matrix < 1, 0, 0, // then shear everything along x-axis
   	          0, 1, 0,
   	          -.8, 0, 1,
   	          0, 0, 0 >
	}

#declare SCopCar = // "Speeding" sheared along x-axis
	union {
	  object {
 	   CopCar
   	 matrix < 1, 0, 0, // then shear everything along x-axis
   	          0, 1, 0,
   	          -.8, 0, 1,
   	          0, 0, 0 >
  	}
//		object { MotionBlurPanels }
	}

#declare BCopCar = // Big blur
	union {
	  object { CopCar }
//		object { BigBlur translate <10*Feet,0,8> }
	}
