
// POV-Ray Object File - Bridge: a single-span, wrought iron, pin-connected Pratt-type truss bridge supported by stone abutments
// created 19-Oct-01
// last update 29-Oct-01
// 2001 Glenn McCarter
// This file does not render.  #include "Bridge.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// Bridge 
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)


//#include "GIncludeRH.inc" // uncomment for testing only

//===============================================
//             Variables
//===============================================

#declare BW = 18*Feet; // width
#declare BH = 17*Feet; // height


//===============================================
//             Textures
//===============================================

#declare WhitePaint =
	texture {
		pigment {
			rgb<1,1,1>
		}
//		normal { bumps .08 scale 5 }
		finish { ambient .1 diffuse .45 specular .68 roughness .067 }
	}
#declare RustyIron =
	texture {
		pigment {
			gradient z
			color_map {
				[ 0.2 rgb<0.608,0.275,0.110> ]
				[ 0.7 rgb<0.698,0.647,0.624> ]
			}
			turbulence .2
			translate <0,0,-2*Feet>
			scale <1,1,20*Feet>
		}
//		normal { bumps .08 scale 5 }
		finish { ambient .1 diffuse .45 specular .68 roughness .067 }
	}

#declare BSnowTex = // snow test
	texture {
		pigment { rgb<1,1,1>*.5 }
		finish { ambient 0.1 specular .8 roughness .082 }
	}


//===============================================
//             Macros
//===============================================

#declare Rivet =
	union {
		sphere {
			<0,0,0>,0.85
			scale <1,.6,1>
			texture { pigment { rgb<0.808,0.722,0.714> } }
		}
		box { // streak
			<-0.78,-0.1,0>,<0.78,0.1,-4>
			texture {
//	WhitePaint

				pigment {
					gradient z
					color_map {
//						[ 0.1 rgb <0.416,0.227,0.173> ]
						[ 0.1 rgb <0.0,0,0> ]
						[ 0.9 rgbt<0.416,0.227,0.173,1> ]
					}
					scale <1,1,-4>
				}

			}
		}
	} // end union
#macro RivetGroup(Spacing)
	union {
		object { Rivet }
		object { Rivet translate <Spacing,0,0> }
		object { Rivet translate <0,0,-Spacing> }
		object { Rivet translate <Spacing,0,-Spacing> }
	} // end union
#end

#macro Ibeam(Xlength,Ywidth,Zheight) // symmetrical along X-axis, I into +/=Z
	union {
		box { // I
			<0,-0.2,-Zheight/2+0.2>,<Xlength,0.2,Zheight/2-0.2>
		}
		box { // Bottom plate
			<0,-Ywidth/2,0>,<Xlength,Ywidth/2,0.4>
			translate <0,0,-Zheight/2>
		}
		box { // Bottom plate
			<0,-Ywidth/2,-0.4>,<Xlength,Ywidth/2,0>
			translate <0,0,Zheight/2>
		}
	} // end union
#end


//===============================================
//             Objects
//===============================================

#declare EndIron =
	union {
		box {
			<0,-5,-28*Feet><12,5,0>
		}
		object { RivetGroup(6) rotate z*-90 translate <-0.2,4,-8> }
	} // end union
#declare SideCell =
	union {
		object { Ibeam(BH+2*Feet,10,16) // support
			rotate y*90
			translate <8,0,BH-12>
		}
		object { RivetGroup(8) translate <0,5,BH-6> } // for top rail
		object { Ibeam(BH+4*Feet,6,10) // diag
			translate <-BH-5*Feet,0,5>
			rotate y*(-90-40)
			translate <16,0,BH-12>
		}
		cylinder { // brace
			<0,0,-BH-5*Feet>,<0,0,0>,1.1
			rotate y*40
			translate <0,0,BH-12>
		}
	} // end union
#declare TopRail =
	union {
		box { // top rail
			<0,-5,-16>,<160*Feet,5,0>
		}
		object { RivetGroup(8) translate <4,5,-8> }
	} // end union
#declare TopConnector =
	object { Ibeam(BW,6,10)
		rotate z*90
		translate <0,-BW/2,-5>
	}
#declare SuperStructure =
	union {
		object { EndIron rotate y*40 translate <16*Feet,BW/2,BH> }
		object { EndIron rotate y*40 translate <16*Feet,-BW/2,BH> }
		object { TopRail translate <16*Feet,BW/2,BH> }
		object { TopRail scale <1,-1,1> translate <16*Feet,-BW/2,BH> }
		box { // first connector
			<0,-BW/2,-16>,<10,BW/2,0>
			rotate y*30
			translate <16*Feet,0,BH>
		}
		#declare SN = 0;
		#while ( SN < 160*Feet )
			object { SideCell translate <16*Feet+SN,BW/2,0> }
			object { SideCell scale <1,-1,1> translate <16*Feet+SN,-BW/2,0> }
			object { TopConnector translate <16*Feet+SN,0,BH> }
			#declare SN = SN + 18*Feet;
		#end
	} // end union
#declare SideRailL =
	union {
		cylinder { // top rail
			<0,0,0>,<160*Feet,0,0>,2
			translate <0,0,44>
		}
		box { // Bottom rail
			<-2,-2,0>,<160*Feet,2,0.7>
			translate <0,0,6>
		}
		#declare PN = 0;
		#while ( PN < 160*Feet )
			cylinder { // main supports
				<0,0,0>,<0,0,54>,2.1
				translate <PN,0,0>
			}
			sphere {
				<0,0,0>,3.2
				translate <PN,0,54>
			}
			#declare PN = PN + 12*Feet;
		#end
		#declare PN2 = 0;
		#while ( PN2 < 160*Feet )
			cylinder { // many small uprights
				<0,0,0>,<0,0,44>,0.9
				translate <PN2,0,0>
			}
			#declare PN2 = PN2 + 0.7*Feet;
		#end
		texture { RustyIron translate <0,0,-5*Feet> }
	} // end union
#declare SideRailR = object { SideRailL scale <1,-1,1> }
#declare Roadway =
	union {
		box { // roadway
			<-4*Feet,-BW/2-12,-10>,<200*Feet,BW/2+12,0>
		}
		box { // roadway edge bottom
			<0,-BW/2-17,-10>,<200*Feet,BW/2+17,-9.5>
		}
		box { // roadway edge top
			<0,-BW/2-17,-0.5>,<200*Feet,BW/2+17,-0.05>
		}
		object { Ibeam(200*Feet,8,20) // bottom support
			translate <0,-BW/2,-10-10>
		}
		object { Ibeam(200*Feet,8,20) // bottom support
			translate <0,BW/2,-10-10>
		}
	} // end union

#declare BWSign =
	union {
		object { RoundedBox(.3) // sign
			scale <.05,8,24>
			texture {
				pigment {
					gradient z
					color_map {
						[ 0.5 rgb<0,0,0> ]
						[ 0.5 rgb<1,1,1> ]
					}
					rotate x*30
					scale 5
				}
				finish { ambient 2 }
			}
			translate <-1.2,0,42>
		}
		object { Ibeam(48,2,2)
			rotate <0,-90,-90>
			texture { RustyIron scale <1,1,.5> translate <0,0,-2*Feet> }
		}
	} // end union

#declare SnowTireTracks =
	union {
		height_field { // starts extruded into +Y, with image upper left corner at <0,0,1>
			png "BridgeTireTracks.png"
			water_level .01
			scale <1,-1,1> // extrude temporarily into -Y
			rotate x*-90 // flip down so that image upper left at <0,1,z>, extruded into +Z
			scale <BW*1.1,BW*1.1*4,6> // scale it up
 			translate <0,0,0> // set ground level
			texture { BSnowTex }
			rotate z*-90 translate <-6*Feet,BW*1.1/2,-1.3> // align to bridge
		}
	} // end union

#declare Bridge =
	union {
		object { Roadway }
		object { SnowTireTracks }
		object { SuperStructure translate <0*Feet, 0*Feet,0> }
		object { SideRailL translate <0,BW/2+0.7*Feet,0> }
		object { SideRailR translate <0,-BW/2-0.7*Feet,0> }
		object { BWSign translate <-1*Feet,BW/2,0> }
		object { BWSign scale <1,-1,1> translate <-1*Feet,-BW/2,0> }
		texture { RustyIron }
	} // end union


//===============================================
//             For Testing Only
//===============================================

/*
#include "GIncludeRH.inc"
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 50
		location  <1, -48*Feet, 35*Feet>
		look_at <7*Feet,0,15*Feet>
	}


light_source
{ <40*Feet,-55*Feet,60*Feet>, 2
  spotlight point_at <0,0,2*Feet> radius 30 falloff 46
}
light_source
{ <-40*Feet,-35*Feet,10*Feet>, <1.13,0.93,.76>
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
background { color rgb <0.46, 0.45, 0.73> }
plane { z,-0 pigment { checker rgb 1, rgb .5 } scale 12 }
/*
plane {
  z,0
  texture {
    pigment { crackle solid
    scale 20
    turbulence 0.5
    color_map {
    	[ 0.0 rgb<0.01,0.11,0.01> ]
    	[ 1.0 rgb<0.86,0.92,0.82> ]
    }
   	}
  }
}
*/
//object { TestSphere scale 20 translate <0,0,20> }
//object { BrickWall rotate z*0 translate <0,0,0> }
object { Bridge rotate z*50 translate <0,0*Feet,4*Feet> }
*/
