#include "colors.inc"
#include "textures.inc"
#declare time = 1;

/*    Contents
  Organic (Texture)
  CPGlass (Texture)
  Bone (Textuer)
  HAlienGun (Object)
  VAlienGun (Object)
  AlienTurret (Object)
  BlueGlow (Media)
  OrangeGlow (Media)
  AlienEngine (Macro)
  HumanEngine (Macro)
  GreenGlow (Interior)
  PlasmaShot (Macro)
  NormalStars (Pigment)
  BlueStars (Pigment)
  RedStars (Pigment)
  Bright_Star (Macro)
  Starfield (Macro)
*/

// Texture for Organic Alien Ships

#declare Organic = texture {
  pigment {
    bozo
    colour_map {
      [ 0.0 colour rgb <0.72, 0.48, 0.0> ]
      [ 0.3 colour rgb <0.6, 0.4, 0.0> ]
      [ 0.5 colour rgb <0.6, 0.4, 0.0> ]
      [ 0.8 colour rgb <0.72, 0.48, 0.0> ]
      [ 1.0 colour rgb <0.3, 0.3, 0.3> ]
    }
    scale .75
  }
  normal { bumps scale .1 }
  finish {
    ambient 0.2
    diffuse 0.5
    phong 0.1
    phong_size 100
  }
}

// Reflective Glass for Fighter Cockpits

#declare CPGlass = texture {
  pigment { colour White }
  finish { Glass_Finish reflection 1.0 }
}

// Bone-like Texture for Hard Parts on Alien Ships

#declare Bone = texture {
  pigment {
    bozo
    turbulence 0.2
    colour_map {
      [0.00 colour rgb <1.0, 1.0, 0.8>]
      [0.80 colour rgb <1.0, 1.0, 0.8>]
      [1.00 colour rgb <0.8, 0.8, 0.48>]
    }
  }
  finish {
    ambient 0.2
    phong 0.2
    phong_size 100
  }
  normal { bumps 0.1 scale 0.01 }
  scale .25
}

// Fang for Alien Ships

#declare Fang = union { // BezPtch001
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.000072, -0.640893, -0.080799>, <0.000072, -0.640893, -0.080895>, <-0.000072, -0.640893, -0.080895>, <-0.000072, -0.640893, -0.080799>, 
      <-0.858958, -0.640785, -0.080565>, <-0.858958, -0.640741, 1.064711>, <0.858958, -0.640741, 1.064711>, <0.858958, -0.640785, -0.080567>, 
      <-0.858958, 1.080942, 0.490992>, <-0.858958, 1.077175, 1.064645>, <0.858958, 1.077175, 1.064645>, <0.858958, 1.080942, 0.490990>, 
      <-0.001660, 2.988792, -1.496458>, <-0.001660, 2.988792, -1.494245>, <0.001660, 2.988792, -1.494245>, <0.001660, 2.988792, -1.496458>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <-0.000072, -0.640893, -0.080799>, <-0.000072, -0.640893, -0.080703>, <0.000072, -0.640893, -0.080703>, <0.000072, -0.640893, -0.080799>, 
      <0.858958, -0.640785, -0.080567>, <0.858958, -0.640829, -1.225845>, <-0.858958, -0.640829, -1.225842>, <-0.858958, -0.640785, -0.080565>, 
      <0.858958, 1.080942, 0.490990>, <0.858958, 1.084709, -0.082665>, <-0.858958, 1.084709, -0.082662>, <-0.858958, 1.080942, 0.490992>, 
      <0.001660, 2.988792, -1.496458>, <0.001660, 2.988792, -1.498670>, <-0.001660, 2.988792, -1.498670>, <-0.001660, 2.988792, -1.496458>
    }
  }
  rotate x*-90
  texture {
    gradient z
    texture_map {
      [0.00 Organic]
      [0.15 Organic]
      [0.30 Bone]
      [1.00 Bone]
    }
    scale 3.1
    translate z*.1
  }
}

// Non-Rotating Alien Gun Mounted at the Rear of the Gun

#declare HAlienGun = difference {
  blob {
    threshold 0.75
    cylinder { <0, 0, 0>, <-1, 0, 0>, 4, .8                 // gun cylinder
      scale <1, 0.5, 1>
    }
    sphere { <2.5, 0, 0>, 2, .4
      scale <0.5, 0.25, .5>
    }
  }
  cylinder { <0, 0, 0>, <-2, 0, 0> 0.4                      // hole in gun
    scale <1, 0.5, 1>
    pigment { colour rgb <0.6, 0.4, 0.0> }
    finish { ambient 0.2 }
  }
  rotate y*-90
}

// Non-Rotating Alien Gun Mounted at the "Bottom" of the Gun

#declare VAlienGun = difference {
  blob {
    threshold 0.75
    cylinder { <0, 0, 0>, <-1, 0, 0>, 4, .8                 // gun cylinder
      scale <1, 0.5, 1>
    }
    cylinder { <.25, -2, 0>, <-0.25, -2, 0>, 2, .4        // gun mount
      scale <.6, .25, .5>
    }
  }
  cylinder { <0, 0, 0>, <-2, 0, 0>, 0.4                     // hole in gun
    scale <1, 0.5, 1>
    pigment { colour rgb <0.6, 0.4, 0.0> }
    finish { ambient 0.2 }
  }
  rotate y*-90
}

// Rotating Alien Turret

#declare AlienTurret = difference {
  blob {
    threshold 0.75
    cylinder { <0.5, -0.5, 0>, <0.5, 0.5, 0>, 1, .6 
    }
    cylinder { <0, 2.5, 0>, <-1, 2.5, 0>, 4, .8
      scale <1, 0.5, 1>
    }
    cylinder { <1.0, 0.2, 0>, <1.0, 0.6, 0>, 1, -.6 }
    sphere { <-.5, -0.3, 0>, 1, .8 }
    sphere { <0.8, -0.3, -0.65>, 1, .8 }
    sphere { <0.8, -0.3, 0.65>, 1, .8 }
  }
  cylinder { <0, 2.5, 0>, <-2, 2.5, 0> 0.4
    scale <1, 0.5, 1>
    pigment { colour rgb <0.6, 0.4, 0.0> }
    finish { ambient 0.2 }
  }
  rotate y*-90
}

//  Blue Glow for Alien Engines

#declare BlueGlow = interior {
  media {
    emission 1
    intervals 20
    density {
      average
      density_map {
        [gradient x
        turbulence .891
        colour_map {
          [0.00 colour rgb <0.5, 0.5, 1.0>]
          [0.20 colour rgb <0.2, 0.2, 0.8>]
          [0.70 colour rgb <0, 0, 0>]
          [1.00 colour rgb <0, 0, 0>]
        }
        scale <4, 1, 1>]
        [gradient x
        turbulence .891
        colour_map {
          [0.00 colour rgb <0.5, 0.5, 1.0>]
          [0.20 colour rgb <0.2, 0.2, 0.8>]
          [0.70 colour rgb <0, 0, 0>]
          [1.00 colour rgb <0, 0, 0>]
        }
        scale <4, 1, 1>
        rotate x*60]
        [gradient x
        turbulence .891
        colour_map {
          [0.00 colour rgb <0.5, 0.5, 1.0>]
          [0.20 colour rgb <0.2, 0.2, 0.8>]
          [0.70 colour rgb <0, 0, 0>]
          [1.00 colour rgb <0, 0, 0>]
        }
        scale <4, 1, 1>
        rotate x*120]
        [gradient x
        turbulence .891
        colour_map {
          [0.00 colour rgb <0.5, 0.5, 1.0>]
          [0.20 colour rgb <0.2, 0.2, 0.8>]
          [0.70 colour rgb <0, 0, 0>]
          [1.00 colour rgb <0, 0, 0>]
        }
        scale <4, 1, 1>
        rotate x*180]
        [gradient x
        turbulence .891
        colour_map {
          [0.00 colour rgb <0.5, 0.5, 1.0>]
          [0.20 colour rgb <0.2, 0.2, 0.8>]
          [0.70 colour rgb <0, 0, 0>]
          [1.00 colour rgb <0, 0, 0>]
        }
        scale <4, 1, 1>
        rotate x*240]
        [gradient x
        turbulence .891
        colour_map {
          [0.00 colour rgb <0.5, 0.5, 1.0>]
          [0.20 colour rgb <0.2, 0.2, 0.8>]
          [0.70 colour rgb <0, 0, 0>]
          [1.00 colour rgb <0, 0, 0>]
        }
        scale <4, 1, 1>
        rotate x*300]
      }
      rotate x*60*time*clock
    }
  }
}

//  Orange Glow for Human Engines

#declare OrangeGlow = interior {
  media {
    emission 1
    intervals 20
    density {
      average
      density_map {
        [gradient x
        turbulence .891
        colour_map {
          [0.00 colour rgb 10*<1.0, 0.75, 0.25>]
          [0.20 colour rgb 10*<0.8, 0.4, 0.0>]
          [0.70 colour rgb <0, 0, 0>]
          [1.00 colour rgb <0, 0, 0>]
        }
        scale <4, 1, 1>]
        [gradient x
        turbulence .891
        colour_map {
          [0.00 colour rgb 10*<1.0, 0.75, 0.25>]
          [0.20 colour rgb 10*<0.8, 0.4, 0.0>]
          [0.70 colour rgb <0, 0, 0>]
          [1.00 colour rgb <0, 0, 0>]
        }
        scale <4, 1, 1>
        rotate x*60]
        [gradient x
        turbulence .891
        colour_map {
          [0.00 colour rgb 10*<1.0, 0.75, 0.25>]
          [0.20 colour rgb 10*<0.8, 0.4, 0.0>]
          [0.70 colour rgb <0, 0, 0>]
          [1.00 colour rgb <0, 0, 0>]
        }
        scale <4, 1, 1>
        rotate x*120]
        [gradient x
        turbulence .891
        colour_map {
          [0.00 colour rgb 10*<1.0, 0.75, 0.25>]
          [0.20 colour rgb 10*<0.8, 0.4, 0.0>]
          [0.70 colour rgb <0, 0, 0>]
          [1.00 colour rgb <0, 0, 0>]
        }
        scale <4, 1, 1>
        rotate x*180]
        [gradient x
        turbulence .891
        colour_map {
          [0.00 colour rgb 10*<1.0, 0.75, 0.25>]
          [0.20 colour rgb 10*<0.8, 0.4, 0.0>]
          [0.70 colour rgb <0, 0, 0>]
          [1.00 colour rgb <0, 0, 0>]
        }
        scale <4, 1, 1>
        rotate x*240]
        [gradient x
        turbulence .891
        colour_map {
          [0.00 colour rgb 10*<1.0, 0.75, 0.25>]
          [0.20 colour rgb 10*<0.8, 0.4, 0.0>]
          [0.70 colour rgb <0, 0, 0>]
          [1.00 colour rgb <0, 0, 0>]
        }
        scale <4, 1, 1>
        rotate x*300]
      }
      rotate x*60*time*clock
    }
  }
}

// Engine for Alien Ships

#macro AlienEngine (xscale, yscale, zscale, translation, power)
  union {
    light_source {
    <1, 0, 0>
    colour rgb <0.0, 0.0, 4.0>
    fade_distance 1.25*((xscale+yscale+zscale)/3)
    fade_power 3
    }
    merge {
      merge {
        cone { <0, 0, 0>, 1, <4, 0, 0>, 0.5 }
        sphere { <0, 0, 0>, 1 }
        hollow
        pigment { colour rgbt <1,1,1,1> }
        interior {
          media {
            emission 1
            intervals 20
            density {
              average
              density_map {
                [gradient x
                turbulence .891
                colour_map {
                  [0.00 colour rgb power*<0.5, 0.5, 1.0>]
                  [0.20 colour rgb power*<0.2, 0.2, 0.8>]
                  [0.70 colour rgb <0, 0, 0>]
                  [1.00 colour rgb <0, 0, 0>]
                }
                scale <4, 1, 1>]
                [gradient x
                turbulence .891
                colour_map {
                  [0.00 colour rgb power*<0.5, 0.5, 1.0>]
                  [0.20 colour rgb power*<0.2, 0.2, 0.8>]
                  [0.70 colour rgb <0, 0, 0>]
                  [1.00 colour rgb <0, 0, 0>]
                }
                scale <4, 1, 1>
                rotate x*60]
                [gradient x
                turbulence .891
                colour_map {
                  [0.00 colour rgb power*<0.5, 0.5, 1.0>]
                  [0.20 colour rgb power*<0.2, 0.2, 0.8>]
                  [0.70 colour rgb <0, 0, 0>]
                  [1.00 colour rgb <0, 0, 0>]
                }
                scale <4, 1, 1>
                rotate x*120]
                [gradient x
                turbulence .891
                colour_map {
                  [0.00 colour rgb power*<0.5, 0.5, 1.0>]
                  [0.20 colour rgb power*<0.2, 0.2, 0.8>]
                  [0.70 colour rgb <0, 0, 0>]
                  [1.00 colour rgb <0, 0, 0>]
                }
                scale <4, 1, 1>
                rotate x*180]
                [gradient x
                turbulence .891
                colour_map {
                  [0.00 colour rgb power*<0.5, 0.5, 1.0>]
                  [0.20 colour rgb power*<0.2, 0.2, 0.8>]
                  [0.70 colour rgb <0, 0, 0>]
                  [1.00 colour rgb <0, 0, 0>]
                }
                scale <4, 1, 1>
                rotate x*240]
                [gradient x
                turbulence .891
                colour_map {
                  [0.00 colour rgb power*<0.5, 0.5, 1.0>]
                  [0.20 colour rgb power*<0.2, 0.2, 0.8>]
                  [0.70 colour rgb <0, 0, 0>]
                  [1.00 colour rgb <0, 0, 0>]
                }
                scale <4, 1, 1>
                rotate x*300]
              }
              rotate x*60*time*clock
            }
          }
        }
      }
      difference {
        difference {
          sphere { <0, 0, 0>, 1.01
            no_shadow
            texture { Organic }
          }
          sphere { <0, 0, 0>, 1
            pigment { colour Black }
          }
        }
        box { <0, 1.1, 1.1>, <1.1, -1.1, -1.1>
          pigment { colour Black }
        }
      }
      rotate y*-90
      scale <xscale, yscale, zscale>
    }
    translate translation
  }
#end

// Engine for Human Ships

#macro HumanEngine (xscale, yscale, zscale, translation, rotation, power)
  union {
    light_source {
    <1, 0, 0>
    colour rgb <2.25, 1.75, 0.0>
    fade_distance 1.25*((xscale+yscale+zscale)/3)*power+0.0000001
    fade_power 3
    }
    merge {
      merge {
        cone { <0, 0, 0>, 1, <4, 0, 0>, 0.5 }
        sphere { <0, 0, 0>, 1 }
        hollow
        pigment { colour rgbt <1,1,1,1> }
        interior {
          media {
            emission 1
            intervals 20
            density {
              average
              density_map {
                [gradient x
                turbulence .891
                colour_map {
                  [0.00 colour rgb power*<1.0, 0.75, 0.25>]
                  [0.20 colour rgb power*<0.8, 0.4, 0.0>]
                  [0.70 colour rgb <0, 0, 0>]
                  [1.00 colour rgb <0, 0, 0>]
                }
                scale <4, 1, 1>]
                [gradient x
                turbulence .891
                colour_map {
                  [0.00 colour rgb power*<1.0, 0.75, 0.25>]
                  [0.20 colour rgb power*<0.8, 0.4, 0.0>]
                  [0.70 colour rgb <0, 0, 0>]
                  [1.00 colour rgb <0, 0, 0>]
                }
                scale <4, 1, 1>
                rotate x*60]
                [gradient x
                turbulence .891
                  colour_map {
                  [0.00 colour rgb power*<1.0, 0.75, 0.25>]
                  [0.20 colour rgb power*<0.8, 0.4, 0.0>]
                  [0.70 colour rgb <0, 0, 0>]
                  [1.00 colour rgb <0, 0, 0>]
                }
                scale <4, 1, 1>
                rotate x*120]
                [gradient x
                turbulence .891
                colour_map {
                  [0.00 colour rgb power*<1.0, 0.75, 0.25>]
                  [0.20 colour rgb power*<0.8, 0.4, 0.0>]
                  [0.70 colour rgb <0, 0, 0>]
                  [1.00 colour rgb <0, 0, 0>]
                }
                scale <4, 1, 1>
                rotate x*180]
                [gradient x
                turbulence .891
                colour_map {
                  [0.00 colour rgb power*<1.0, 0.75, 0.25>]
                  [0.20 colour rgb power*<0.8, 0.4, 0.0>]
                  [0.70 colour rgb <0, 0, 0>]
                  [1.00 colour rgb <0, 0, 0>]
                }
                scale <4, 1, 1>
                rotate x*240]
                [gradient x
                turbulence .891
                colour_map {
                  [0.00 colour rgb power*<1.0, 0.75, 0.25>]
                  [0.20 colour rgb power*<0.8, 0.4, 0.0>]
                  [0.70 colour rgb <0, 0, 0>]
                  [1.00 colour rgb <0, 0, 0>]
                }
                scale <4, 1, 1>
                rotate x*300]
              }
              rotate x*60*time*clock
            }
          }
        }
      }
      difference {
        difference {
          sphere { <0, 0, 0>, 1.01
            no_shadow
            pigment { colour Gray75 }
            finish { Metal }
          }
          sphere { <0, 0, 0>, 1
            pigment { colour Black }
          }
        }
        box { <0, 1.1, 1.1>, <1.1, -1.1, -1.1>
          pigment { colour Black }
        }
      }
      rotate y*-90
      scale <xscale, yscale, zscale>
    }
    rotate rotation
    translate translation
  }
#end

// Green Glow for Plasma Weapons

#declare GreenGlow = interior {
  media {
    emission 1
    intervals 20
    density {
      spherical
      turbulence 1
      colour_map {
        [0.00 colour rgb <0.4, 0.8, 0.4>]
        [0.20 colour rgb <0.1, 0.4, 0.1>]
        [0.70 colour rgb <0, 0, 0>]
        [1.00 colour rgb <0, 0, 0>]
      }
      translate <3.5, 0, 0>
    }
  }
}

// Shot for Plasma Weapons

#macro PlasmaShot (xscale, yscale, zscale, translation)
  union {
    light_source {
      <.25, 0, 0>
      colour rgb <0.5, 1.0, 0.5>
      fade_distance 1*((xscale+yscale+zscale)/3)
      fade_power 3
    }
    merge {
      cone { <0, 0, 0>, 1, <4, 0, 0>, 0.25 }
      sphere { <0, 0, 0>, 1 }
      hollow
      pigment { colour rgbt <1,1,1,1> }
      interior { GreenGlow }
      rotate y*-90
      scale <xscale, yscale, zscale>
    }
    translate translation
  }
#end

// Pigments for a Starfield

#declare NormalStars = pigment {
   leopard
   turbulence 0.5
   colour_map {
      [0.00 colour rgbt <0, 0, 0, 1>]
      [0.97 colour rgbt <0, 0, 0, 1>]
      [0.99 colour rgb <1, 1, 1>]
      [1.00 colour rgb <1, 1, 1>]
   }
   translate <41.76, 38.78, 1.438>
   rotate <190.44, 61.2, 331.92>
}

#declare BlueStars = pigment {
  leopard
  turbulence 0.5
  colour_map {
    [0.00 colour rgbt <0, 0, 0, 1>]
    [0.96 colour rgbt <0, 0, 0, 1>]
    [0.99 colour rgb <.8, .8, 1> ]
    [1.00 colour rgb <.8, .8, 1> ]
  }
  translate <4.77, 83.2, 48.1>
  rotate <18, 57.96, 260.28>
}

#declare RedStars = pigment {
  leopard
  turbulence 0.5
  colour_map {
    [0.00 colour rgbt <0, 0, 0, 1>]
    [0.96 colour rgbt <0, 0, 0, 1>]
    [0.99 colour rgb <1, .9, .9>]
    [1.00 colour rgb <1, .9, .9>]
  }
  translate <13.78, 3.889, 171.1>
  rotate <233.28, 331.56, 71.64>
}

// Bright_Star for Starfield
#macro Bright_Star ( translation, z_rotate, tint_select )
   #if ( tint_select < 0.333 )
      #local tint = <0.0, -0.45, -0.45>;
   #end
   #if ( tint_select > 0.667 )
      #local tint = <-0.5, -0.5, 0.0>;
   #end
   #ifndef ( tint )
      #local tint = <-0.2, -0.2, -0.2>;
   #end
   merge {
      sphere { <0.00, 0.00, 0.00>, 5.00
         pigment { colour rgbt <1.00, 1.00, 1.00, 1.00> }
         hollow
         interior {
            media {
               emission 1
               intervals 20
               density {
                  spherical
                  colour_map {
                     [ 0.00 colour rgb <0.50, 0.50, 0.50>*0.11 + tint*0.11 ]
                     [ 0.40 colour rgb <1.00, 1.00, 1.00>*0.20 + tint*0.2 ]
                     [ 1.00 colour rgb <1.00, 1.00, 1.00>*0.20 + tint*0.2 ]
                  }
                  scale 5.00
                  //translate translation
               }
            }
         }                  
      }
      #local i = 0;
      #while ( i < 350 )
         cone { <-4.00, 0.00, 0.00>, 2.00, <-14.0, 0.00, 0.00>, 0.00
            scale <1.00, 1.00, 1.50>
            rotate z*i
         }            
         #local i = i + 60;
      #end
      pigment { colour rgbt <1.00, 1.00, 1.00, 1.00> }
      hollow
      interior {
         media {
            emission 1
            intervals 20
            density {
               spherical
               colour_map {
                  [ 0.00 colour rgb <0.25, 0.25, 0.25>*0.1 + tint*0.25 ]
                  [ 0.20 colour rgb <1.00, 1.00, 1.00>*0.1 + tint*0.1 ]
                  [ 1.00 colour rgb <1.00, 1.00, 1.00>*0.1 ]
               }
               scale 14.00
               //translate translation
            }
         }
      }
      rotate z*z_rotate
      translate translation
   }
#end


// The Starfield

#macro Stars ( )
   sky_sphere {
      pigment { NormalStars }
      pigment { BlueStars }
      pigment { RedStars }
      scale 0.0075
   }
#end