#version unofficial megapov 0.7;

#declare LIGHT_FINAL=1;

#declare SUNSET_FINAL=1;
#declare SKY_FINAL=0;

#declare REUSE_RAD=0;

global_settings
{
  assumed_gamma 1
  ambient_light <1 1 1>*.2
  radiosity {
    recursion_limit 1
//    normal on
//    media on

#if (REUSE_RAD)
    load_file "normandy2.rad"
    always_sample no
#else
    save_file "normandy2.rad"
#end
  }
  max_trace_level 6
}

#include "sky-final.inc"

#include "concrete.inc"

plane {
  <0, 1, 0>, 0
  texture {
    pigment {
      color rgbt <1,1,1,1>
    }
    finish {
      reflection_type 1
      reflection_min .1
      reflection_max 2
      reflection_falloff 2
    }
    normal {
      ripples
      scale 4
      turbulence .5
      slope_map {
	[0, <0,0>]
	[.5, <1,0>]
	[1, <0,0>]
      }
    }
  }
  interior {
    fade_distance 1
    fade_power 1000
    ior 1.3
  }
}

// Now lights for the non-sky:
#declare L2 = <-3000, 600, -500>;
#declare L2size = 300;
light_source {
  L2-<L2size/2, 0, L2size/2>
  color rgb <1, 1, .5>*2
#if (LIGHT_FINAL)
  area_light <L2size, 0, 0>, <0, 0, L2size>, 8, 4
#end
  adaptive 0
}
// and we need something to block that light from the clouds
box {
  L2-<L2size, -.01, L2size>,
  L2+<L2size, 1, L2size>
}

fog {
  fog_type 2
  fog_offset 3
  fog_alt 3
  distance 100
//  color rgb <.08,.05,.1>
//  color rgb <.05,.04,.06>
  color rgbt <.08,.07,.09,.1>
}

/*
plane {
  <0,1,0>, 100
  hollow
  pigment {color transmit 1}
  interior {
    media {
      scattering {
	4, rgb <1,1,1>/1000
      }
      method 2
    }
  }
}
*/

camera
{
  up <0,1,0>
  right <2,0,0>
  location <-2.8, 2.8, -2>
//  location <-2.8, 8, -2>
  look_at  <10, 2.8, 40>
//  look_at  <-10, 2.8, 40>
//  look_at  L1
//  angle 30
}

// vi:sts=2
