#version unofficial megapov 0.7;

#declare SKY=1;
#declare WATER=1;

#include "concrete.inc"

#if (SKY)
  #declare SUNSET_FINAL=0;
  #declare SKY_FINAL=0;
  #include "sky-final.inc"
#else
/*
plane {
  <0, 1, 0>, 1000
  hollow
  texture {
    pigment {
      color rgb <0,0,.7>
    }
    finish {
      ambient 6
    }
  }
}
*/
#end

global_settings
{
  assumed_gamma 1
  ambient_light <1 1 1>*.2
  radiosity {
    recursion_limit 1
//    load_file "pool.rad"
  }
  max_trace_level 10
}

plane {
  <0, 1, 0>, 0
  texture {
    pigment {
      checker
      color rgb <0 0 0>
      color rgb <1 1 1>
    }
    finish {
      reflection 0
    }
  }
}

cylinder {
  <0, 0, 15>, <0, 10, 15>, 1
  texture {
    pigment {
      color rgb <1,0,0>
    }
  }
}

difference {
  box  { <-10, 0, -6>, <10, 2, 11> }
  box  { <-9, .5, -5>, <9, 3, 10> }

  texture{concrete}
}

#if (WATER)
// now the water
box {
  <-9, .5, -5>, <9, 1.8, 10> 
  texture {
    pigment {
      color rgbt <1,1,1,1>
    }
    finish {
      reflection_type 1
      reflection_min .1
      reflection_max .8
      reflection_falloff 2
    }
    normal {
/*
      gradient z
      turbulence .3
      slope_map {
	[0, <0, 0>]
	[.5, <1, 0>]
	[1, <0, 0>]
      }
*/
      ripples .3
    }
  }
  interior {
    fade_distance 2
    fade_power 1000
    ior 1.3
  }
}
#end

light_source {
  <-800, 300, -300>
  color rgb <1, 1, 1>*2
}

camera
{
  location <0, 8, -12>
  look_at  <0, 3, 0>
//  angle 1
}

