#version unofficial megapov 0.7;

#include "grass.inc"

#declare ALL_MOW=1;

global_settings
{
  assumed_gamma 1
  ambient_light <1 1 1>*.2
  radiosity {
    recursion_limit 2
  }
}

plane {
  <0, 1, 0>, 0
  texture {
    pigment {
      color rgb <.4 .3 0>
    }
    finish {
      reflection 0
    }
  }
}

fog {
  fog_type 2
  fog_offset 1
  fog_alt 3
  distance 50
  color rgb <.08,0,.2>
}


#if(ALL_MOW)
  #declare gp=grasspatch_mowed(5,5)
#else
  #declare gp=grasspatch2(5,5)
#end

#declare gpm=grasspatch_mowed(5,5)

#local mx=0;
#while (mx < 80)
  #local mz=-25;
  #while (mz < 500)
    object {
      gp
      translate <mx,0,mz>
    }
    #local mz=mz+5;
  #end
  #local mx=mx+5;
#end
#local mx=-80;
#while (mx < 0)
  #local mz=-25;
  #while (mz < 500)
    object {
      gpm
      translate <mx,0,mz>
    }
    #local mz=mz+5;
  #end
  #local mx=mx+5;
#end

/*
#include "treetexture.inc"
#include "tree.inc"


#local GR=seed(5);
#local mx=-150;
#while (mx < 150)
  object {
    tree[rand(GR)*4]
    rotate <0, 360*rand(GR), 0>
    pigment {
      color rgb <.3 .2 0>
    }
    translate <mx, 0, 180+100*rand(GR)>
  }
  #local mx=mx+5+8*rand(GR);
#end
*/


light_source {
  <-300, 300, -300>
  color rgb <1, 1, .8>*2
}

camera
{
  location <0, 8, -30>
  look_at  <0, 0, 0>
//  angle 2
}

