#version unofficial megapov 0.7;

global_settings
{
  assumed_gamma 1
  ambient_light <1 1 1>*.2
  radiosity {
    recursion_limit 2
  }
}

#declare CROSS_FINAL=1;
#declare LIGHT_FINAL=0;
#declare TEXT_FINAL=0;

#include "cross-final.inc"

plane {
  <0, 1, 0>, 0
  texture {
    pigment {
      color rgb <.3,1,.3>*.5
    }
    finish {
      reflection 0
    }
  }
}

plane {
  <0, -1, 0>, -100
  texture {
    pigment {
      color rgb <0,0,.6>
    }
  }
}

#local GR=seed(2)
#local xi=-8*4;
#while (xi<60)
  #local zi=0;
  #while (zi<100)
    makecross(<xi,0,zi>, floor(GR*3),0,0)
    #local zi=zi+10;
  #end
  #local xi=xi+8;
#end

light_source {
  <-30, 30, -5>
  color rgb <1, 1, .8>*2
#if (LIGHT_FINAL)
  area_light <0,0,-1>, <0,1,0>, 4, 4
#end
}

camera
{
  up <0,1,0>
  right <2,0,0>
  location <-2.8, 2.8, -2>
  look_at  <10, 2.8, 40>
//  angle 3
}
