#version unofficial megapov 0.7;

#declare CROSS_FINAL=0;
#declare LIGHT_FINAL=0;
#declare TEXT_FINAL=0;

#include "cross-final.inc"

global_settings
{
  assumed_gamma 1
  ambient_light <1 1 1>*.2
  radiosity {
    recursion_limit 2
  }
}

// for comparison
makecross(<-3,0,0>,-1,0)
makecross(<3,0,0>,-1,1)

difference {
  union {
    box { <-.3125, 0, 0>, <.3125, 2.5, -.4> }
    prism {
      linear_spline
      0, .5, 3
      <-.5, 0>, <.5, 0>, <0, .866>
      rotate <-90,0,0>
      scale <1.5,1.5,1>
      translate <0,2,0>
    }
    prism {
      linear_spline
      0, .5, 3
      <-.5, .866>, <.5, .866>, <0, 0>
      rotate <-90,0,0>
      scale <1.5,1.5,1>
      translate <0,2-.866/2,0>
    }
  }
  cylinder {
    <0, 2.5, -.6>, <0, 2.3, -.3>, .2
  }

  texture {
    pigment {
      granite
      scale <1,4,1>
      rotate <0,0,-40>
      color_map {
#if (CROSS_FINAL)
  #local filt=.5;
  #local dimm=1;
#else
  #local filt=0;
  #local dimm=.7;
#end
	[0, rgbf <.7, .8, .8, filt>*dimm]
	[.5, rgbf <1, 1, .8, filt>*dimm]
	[1, rgbf <1, 1, 1, filt>*dimm]
      }
    }
    finish {
      reflection 0
    }
    normal {
      granite
      scale .05
      bump_size .05
    }
  }
  hollow
#if (CROSS_FINAL)
  interior {
    stone_int
  }
#end

  rotate <0, 30, 0>
}

plane {
  <0, 1, 0>, 0
  texture {
    pigment {
      color rgb <.3,1,.3>*.5
    }
    finish {
      reflection 0
    }
  }
}

  light_source {
    <-800, 300, -300>
    color rgb <1, 1, .8>*2
#if (LIGHT_FINAL)
    area_light <0,0,-1>, <0,1,0>, 4, 4
#end
  }

camera
{
  location <0, 5, -10>
  look_at  <0, 2, 0>
//  angle 3
}

