#version unofficial megapov 0.7;

//#include "/tmp/miracle/sky2.inc"

#declare SKY_FINAL=0;

global_settings
{
  assumed_gamma 1
  ambient_light <1 1 1>*.2
  radiosity {
    recursion_limit 2
  }
  max_trace_level 10
}

/*
sphere {
  <0, 0, 0>, 1000
  pigment {color rgb <1, 1, 1>}
  hollow
}
*/

plane {
  <0, 1, 0>, 0
  texture {
    pigment {
      checker
      color rgb <.5 .5 .5>
      color rgb <1 1 1>
    }
    finish {
      reflection .2
    }
  }
}

// These are the clouds already out of the sun - they're just dark
plane {
  < 0, -1, 0>, -2001
  hollow
  texture {
    pigment {
      spotted
      scale 2000
      turbulence .6
      omega .7
      pigment_map{
	[0 rgb <.1 .1 .6>]
	[.4 rgb <.1 .1 .6>]
	[1 rgb <.3 .3 .5>]
      }
  /*
      color rgb <.1, .1, .6>
  */
    }
    finish {
      ambient 3
      diffuse 0
    }
  }
  no_shadow
}

intersection {
  plane { < 0, -1, 0>, -1000}
  plane { < 0, 1, 0>, 2000}

  hollow
  texture {
    pigment {
      color rgbf <1, 1, 1, 1>
    }
  }

  interior {
    media {
      scattering {
      // If you make this too low, you won't get the desired
      // effect of back layers of clouds being darker.  However, if you
      // make it too *high*, you have the problem of unacceptable graininess.
      // try 300 to 1000 as the divisor
	2 rgb <1, 1, 1>/500
      }
#switch (SKY_FINAL)
  #case (0)
  #case (1)
	method 1
  #break
  #case (2)
	method 1
	samples 5
  #break
#end
      density {
	spotted
	turbulence .3
	omega .7
	scale 500
	density_map {
	  // Due to the "noise bug fix", these values are slightly
	  // different in the unofficial version.  Use .6 and .8 in the
	  // official version to get about the same result.
	  [0, rgb 0]
	  [.55, rgb 0]
	  [.75, rgb .6]
	  [1, rgb .6]
	}
      }
    }
  }
}

cylinder {
  <0, 0, 0>, <0, 4, 0>, 4
  texture {
    pigment {
      color rgb <1, 1, 1>
    }
  }
}

//fake light, sky only
light_source {
  <3000, 1000, -20>
  color rgb <1, 1, 1>*.2
}
sphere {
  <0, 0, 0>, 1
  clipped_by {
    plane { <0, 1, 0>, 0 }
  }
  texture {
    pigment {
      color rgb 0
    }
  }
  hollow
  translate <3000, 1000, -20>
}

#declare L1 = <-3000, 600, -20>;

// sun
light_source {
  L1
  color rgb <1, 1, 1>*2
}
sphere {
  <0, 0, 0>, 1
  clipped_by {
    plane { <0, 1, 0>, 0 }
  }
  texture {
    pigment {
      color rgbf <1,1,0,1>
    }
  }
  hollow
  translate L1
}
sphere {
  <0, 0, 0>, 1
  clipped_by {
    plane { <0, -1, 0>, 0 }
  }
  texture {
    pigment {
      radial
      color_map {
	[0 rgbf <0 1 0 1>]
	[.5 rgbf <0 1 0 1>]
	[.5 rgbf <1 1 0 1>]
	[.7 rgbf <1 1 0 1>]
	[.9 rgbf <1 0 0 1>]
	[1 rgbf <1 0 0 1>]
      }
    }
  }
  hollow
  translate L1
}

/*
sphere {
  <0, 0, 0>, 1
  hollow
  texture {
    pigment {
      gradient y
      scale 2
      translate <0, -1, 0>
      color_map {
	[0 rgbf <1 1 0 1>]
	[.5 rgbf <1 1 0 1>]
	[.5 rgbf <1 0 0 1>]
	[1 rgbf <1 0 0 1>]
      }
    }
  }
//  translate <0 4 0>
  translate <-3000, 800, -20>
}
*/


camera
{
  location <0, 8, -50>
  look_at  <0, 0,0>
//  angle 10

}

