/////////////////////////////////////////////////////////////////////

// This implementation makes the whole patch one big mesh

#version unofficial MegaPov .7;

#local GR=seed(1);
#declare grasstexture=array[10]
#local i=0;
#while (i<10)
  #declare grasstexture[i]=
  texture {
    pigment {
//      color <.2*rand(GR), .3+.2*rand(GR), .1*rand(GR)>
      color <.2*rand(GR), .3+.2*rand(GR), .1*rand(GR)>/2
//      color <.08*rand(GR), .1+.1*rand(GR), .02*rand(GR)>
    }
    finish {
      reflection_min .0
      reflection_max .3
      reflection_falloff 2
    }
  }
  #local i=i+1;
#end

#macro grassblade2(trans, sc, rot)
  #local p=array[4]
  #local p[0]=<0,0,0>;
  #local p[1]=<.3,0,-.2>;
  #local p[2]=<-.3,0,-.2>;
  #local p[3]=<0,3,0>;

  #local i=0;
  #while (i<4)
    #local p[i]=vrotate(p[i],rot);
    #local p[i]=p[i]*sc/12;
    #local p[i]=p[i]+trans;

    #local i=i+1;
  #end

  #local textnum=floor(rand(GR)*10);

  triangle {
    p[0], p[1], p[3]
    texture {
      grasstexture[textnum]
    }
  }
  triangle {
    p[0], p[2], p[3]
    texture {
      grasstexture[textnum]
    }
  }
#end

// Here's for mowed grass - it's directional, and less varying in height
#macro grasspatch_mowed(wid, dep)
mesh
{
  #debug "Making mowed grass patch\n"
  #local space=.06;
  #local GR=seed(1);

  #local zi=0;
  #while (zi <= dep)
    #if (mod(floor(zi/space),10)=0)
      #debug concat("\ngrasspatch_mowed ",str(100*zi/dep,3,1), "%% done\n")
    #end
    #local xi=0;
    #while (xi <= wid)
      #if (zi < dep/2)
	#local rotangle = 60+60*rand(GR);
      #else
	#local rotangle = -60-60*rand(GR);
      #end

      // skip a hole
      #if (((zi<dep-.7) & (zi>.1)) | ((xi>.4) & (xi<wid-.4)))

	grassblade2(<xi+.1*rand(GR), 0, zi+.1*rand(GR)>, .95+.1*rand(GR),
	  <10-30*rand(GR),rotangle,0>)

      #end

      #local xi=xi+space;
    #end
    #local zi=zi+space;
  #end
}
#end
